/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.axis;

import net.imagej.axis.Axes;
import net.imagej.axis.AxisType;
import net.imagej.axis.VariableAxis;

public class PolynomialAxis
extends VariableAxis {
    private static final String[] VARS = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "z"};

    public PolynomialAxis() {
        this(Axes.unknown(), null, 0.0, 0.0, 1.0);
    }

    public PolynomialAxis(AxisType type, String unit, double ... coeffs) {
        super(type);
        this.setUnit(unit);
        for (int i = 0; i < coeffs.length; ++i) {
            this.setCoeff(i, coeffs[i]);
        }
        if (coeffs.length > VARS.length) {
            throw new IllegalArgumentException("polynomial axis limited to " + VARS.length + " coefficients");
        }
    }

    public int degree() {
        int degree = -1;
        for (int i = 0; i < VARS.length; ++i) {
            if (this.coeff(i) == 0.0) continue;
            degree = i;
        }
        return degree;
    }

    public double coeff(int i) {
        Double value = i < VARS.length ? this.get(VARS[i]) : null;
        return value == null ? 0.0 : value;
    }

    public void setCoeff(int i, double v) {
        if (i >= VARS.length) {
            throw new IllegalArgumentException("polynomial axis limited to " + VARS.length + " coefficients");
        }
        this.set(VARS[i], v);
    }

    @Override
    public double calibratedValue(double rawValue) {
        double term = rawValue;
        double result = this.coeff(0);
        for (int i = 1; i <= this.degree(); ++i) {
            result += this.coeff(i) * term;
            term *= rawValue;
        }
        return result;
    }

    @Override
    public double rawValue(double calibratedValue) {
        return Double.NaN;
    }

    @Override
    public String generalEquation() {
        int v = 0;
        StringBuilder builder = new StringBuilder();
        builder.append("y = ");
        for (int i = 0; i <= this.degree(); ++i) {
            if (this.coeff(i) == 0.0) continue;
            if (i != 0) {
                builder.append(" + ");
            }
            builder.append(VARS[v++]);
            if (i == 0) continue;
            builder.append("*x");
            if (i <= 1) continue;
            builder.append("^");
            builder.append(i);
        }
        return builder.toString();
    }

    @Override
    public PolynomialAxis copy() {
        PolynomialAxis axis = new PolynomialAxis(this.type(), this.unit(), new double[0]);
        for (int i = 0; i <= this.degree(); ++i) {
            axis.setCoeff(i, this.coeff(i));
        }
        return axis;
    }
}

