/*
 * Decompiled with CFR 0.152.
 */
package io.scif.formats.tiff;

import io.scif.enumeration.CodedEnum;
import io.scif.enumeration.EnumException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum ResolutionUnit implements CodedEnum
{
    NONE(1, "None"),
    INCH(2, "Inch"),
    CENTIMETER(3, "Centimeter");

    private int code;
    private String name;
    private static final Map<Integer, ResolutionUnit> lookup;

    private ResolutionUnit(int code, String name) {
        this.code = code;
        this.name = name;
    }

    public static ResolutionUnit get(int code) {
        ResolutionUnit toReturn = lookup.get(code);
        if (toReturn == null) {
            throw new EnumException("Unable to find ResolutionUnit with code: " + code);
        }
        return toReturn;
    }

    @Override
    public int getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    static {
        lookup = new HashMap<Integer, ResolutionUnit>();
        for (ResolutionUnit v : EnumSet.allOf(ResolutionUnit.class)) {
            lookup.put(v.getCode(), v);
        }
    }
}

