/*
 * Decompiled with CFR 0.152.
 */
package bdv.ij;

import bdv.export.ExportMipmapInfo;
import bdv.export.ProgressWriter;
import bdv.export.ProposeMipmaps;
import bdv.export.SubTaskProgressWriter;
import bdv.export.WriteSequenceToHdf5;
import bdv.ij.export.SpimRegistrationSequence;
import bdv.ij.util.PluginHelper;
import bdv.ij.util.ProgressWriterIJ;
import bdv.img.hdf5.Hdf5ImageLoader;
import bdv.img.hdf5.Partition;
import bdv.spimdata.SequenceDescriptionMinimal;
import bdv.spimdata.SpimDataMinimal;
import bdv.spimdata.XmlIoSpimDataMinimal;
import fiji.plugin.Bead_Registration;
import fiji.plugin.Multi_View_Fusion;
import fiji.util.gui.GenericDialogPlus;
import ij.IJ;
import ij.Prefs;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import java.awt.AWTEvent;
import java.awt.Checkbox;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mpicbg.spim.data.generic.AbstractSpimData;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.generic.sequence.BasicImgLoader;
import mpicbg.spim.data.generic.sequence.BasicViewSetup;
import mpicbg.spim.io.ConfigurationParserException;
import mpicbg.spim.io.IOFunctions;
import mpicbg.spim.io.SPIMConfiguration;
import mpicbg.spim.io.TextFileAccess;
import org.scijava.command.Command;
import org.scijava.plugin.Plugin;
import spimopener.SPIMExperiment;

@Deprecated
@Plugin(type=Command.class, menuPath="Plugins>BigDataViewer>Deprecated>Export Spim Sequence as XML/HDF5")
public class ExportSpimSequencePlugIn
implements Command {
    static boolean lastSetMipmapManual = false;
    static String lastSubsampling = "{1,1,1}, {2,2,1}, {4,4,2}";
    static String lastChunkSizes = "{16,16,16}, {16,16,16}, {16,16,16}";
    static boolean lastSplit = false;
    static int lastTimepointsPerPartition = 0;
    static int lastSetupsPerPartition = 0;
    static boolean lastDeflate = true;
    public static String[] fusionType = new String[]{"Single-channel", "Multi-channel"};
    public static String allChannels = "0, 1";

    public void run() {
        ArrayList partitions;
        HashMap<Integer, ExportMipmapInfo> perSetupExportMipmapInfo;
        Parameters params;
        if (Prefs.setIJMenuBar) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
        }
        if ((params = this.getParameters()) == null) {
            return;
        }
        ProgressWriterIJ progress = new ProgressWriterIJ();
        progress.out().println("starting export...");
        SpimRegistrationSequence sequence = new SpimRegistrationSequence(params.conf);
        SequenceDescriptionMinimal desc = sequence.getSequenceDescription();
        if (params.setMipmapManual) {
            perSetupExportMipmapInfo = new HashMap<Integer, ExportMipmapInfo>();
            ExportMipmapInfo mipmapInfo = new ExportMipmapInfo(params.resolutions, params.subdivisions);
            for (BasicViewSetup setup : desc.getViewSetupsOrdered()) {
                perSetupExportMipmapInfo.put(setup.getId(), mipmapInfo);
            }
        } else {
            perSetupExportMipmapInfo = ProposeMipmaps.proposeMipmaps((AbstractSequenceDescription)desc);
        }
        int numCellCreatorThreads = Math.max(1, PluginHelper.numThreads() - 1);
        if (params.split) {
            String xmlFilename = params.seqFile.getAbsolutePath();
            String basename = xmlFilename.endsWith(".xml") ? xmlFilename.substring(0, xmlFilename.length() - 4) : xmlFilename;
            List timepoints = desc.getTimePoints().getTimePointsOrdered();
            List setups = desc.getViewSetupsOrdered();
            partitions = Partition.split((List)timepoints, (List)setups, (int)params.timepointsPerPartition, (int)params.setupsPerPartition, (String)basename);
            for (int i = 0; i < partitions.size(); ++i) {
                Partition partition = (Partition)partitions.get(i);
                SubTaskProgressWriter p = new SubTaskProgressWriter((ProgressWriter)progress, 0.0, 0.95 * (double)i / (double)partitions.size());
                WriteSequenceToHdf5.writeHdf5PartitionFile((AbstractSequenceDescription)desc, perSetupExportMipmapInfo, (boolean)params.deflate, (Partition)partition, null, null, (int)numCellCreatorThreads, (ProgressWriter)p);
            }
            WriteSequenceToHdf5.writeHdf5PartitionLinkFile((AbstractSequenceDescription)desc, perSetupExportMipmapInfo, (ArrayList)partitions, (File)params.hdf5File);
        } else {
            partitions = null;
            WriteSequenceToHdf5.writeHdf5File((AbstractSequenceDescription)desc, perSetupExportMipmapInfo, (boolean)params.deflate, (File)params.hdf5File, null, null, (int)numCellCreatorThreads, (ProgressWriter)new SubTaskProgressWriter((ProgressWriter)progress, 0.0, 0.95));
        }
        Hdf5ImageLoader loader = new Hdf5ImageLoader(params.hdf5File, partitions, null, false);
        SequenceDescriptionMinimal sequenceDescription = new SequenceDescriptionMinimal(desc, (BasicImgLoader)loader);
        File basePath = params.seqFile.getParentFile();
        SpimDataMinimal spimData = new SpimDataMinimal(basePath, sequenceDescription, sequence.getViewRegistrations());
        try {
            new XmlIoSpimDataMinimal().save((AbstractSpimData)spimData, params.seqFile.getAbsolutePath());
            progress.setProgress(1.0);
        }
        catch (Exception e) {
            progress.err().println("Failed to write xml file " + params.seqFile);
            e.printStackTrace(progress.err());
        }
        progress.out().println("done");
    }

    protected Parameters getParameters() {
        File seqFile;
        File parent;
        int c;
        int c2;
        int c3;
        ArrayList channels;
        TextField tfChannels;
        int channelChoice;
        GenericDialogPlus gd0 = new GenericDialogPlus("Export for BigDataViewer");
        gd0.addChoice("Select_channel type", fusionType, fusionType[Multi_View_Fusion.defaultFusionType]);
        gd0.showDialog();
        if (gd0.wasCanceled()) {
            return null;
        }
        Multi_View_Fusion.defaultFusionType = channelChoice = gd0.getNextChoiceIndex();
        final boolean multichannel = channelChoice == 1;
        GenericDialogPlus gd = new GenericDialogPlus("Export for BigDataViewer");
        gd.addDirectoryOrFileField("SPIM_data_directory", Bead_Registration.spimDataDirectory);
        final TextField tfSpimDataDirectory = (TextField)gd.getStringFields().lastElement();
        gd.addStringField("Pattern_of_SPIM files", Bead_Registration.fileNamePattern, 25);
        final TextField tfFilePattern = (TextField)gd.getStringFields().lastElement();
        gd.addStringField("Timepoints_to_process", Bead_Registration.timepoints);
        final TextField tfTimepoints = (TextField)gd.getStringFields().lastElement();
        gd.addStringField("Angles to process", Bead_Registration.angles);
        final TextField tfAngles = (TextField)gd.getStringFields().lastElement();
        if (multichannel) {
            gd.addStringField("Channels to process", allChannels);
            tfChannels = (TextField)gd.getStringFields().lastElement();
        } else {
            tfChannels = null;
        }
        gd.addDialogListener(new DialogListener(){

            public boolean dialogItemChanged(GenericDialog dialog, AWTEvent e) {
                if (e instanceof TextEvent && e.getID() == 900 && e.getSource() == tfSpimDataDirectory) {
                    TextField tf = (TextField)e.getSource();
                    String spimDataDirectory = tf.getText();
                    File f = new File(spimDataDirectory);
                    if (f.exists() && f.isFile() && f.getName().endsWith(".xml")) {
                        SPIMExperiment exp = new SPIMExperiment(f.getAbsolutePath());
                        tfFilePattern.setEnabled(false);
                        String expTimepoints = "";
                        expTimepoints = exp.timepointStart == exp.timepointEnd ? "" + exp.timepointStart : "" + exp.timepointStart + "-" + exp.timepointEnd;
                        tfTimepoints.setText(expTimepoints);
                        String expAngles = "";
                        for (String angle : exp.angles) {
                            int a = Integer.parseInt(angle.substring(1, angle.length()));
                            if (!expAngles.equals("")) {
                                expAngles = expAngles + ",";
                            }
                            expAngles = expAngles + a;
                        }
                        tfAngles.setText(expAngles);
                        if (multichannel) {
                            String expChannels = "";
                            for (String channel : exp.channels) {
                                int c = Integer.parseInt(channel.substring(1, channel.length()));
                                if (!expChannels.equals("")) {
                                    expChannels = expChannels + ",";
                                }
                                expChannels = expChannels + c;
                            }
                            tfChannels.setText(expChannels);
                        }
                    } else {
                        tfFilePattern.setEnabled(true);
                    }
                }
                return true;
            }
        });
        File f = new File(tfSpimDataDirectory.getText());
        if (f.exists() && f.isFile() && f.getName().endsWith(".xml")) {
            tfFilePattern.setEnabled(false);
            if (multichannel) {
                SPIMExperiment exp = new SPIMExperiment(f.getAbsolutePath());
                String expChannels = "";
                for (String channel : exp.channels) {
                    int c4 = Integer.parseInt(channel.substring(1, channel.length()));
                    if (!expChannels.equals("")) {
                        expChannels = expChannels + ",";
                    }
                    expChannels = expChannels + c4;
                }
                tfChannels.setText(expChannels);
            }
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            return null;
        }
        Bead_Registration.spimDataDirectory = gd.getNextString();
        Bead_Registration.fileNamePattern = gd.getNextString();
        Bead_Registration.timepoints = gd.getNextString();
        Bead_Registration.angles = gd.getNextString();
        int numChannels = 0;
        if (multichannel) {
            allChannels = gd.getNextString();
            try {
                channels = SPIMConfiguration.parseIntegerString((String)allChannels);
                numChannels = channels.size();
            }
            catch (ConfigurationParserException e) {
                IOFunctions.printErr((String)("Cannot understand/parse the channels: " + allChannels));
                return null;
            }
            if (numChannels < 1) {
                IOFunctions.printErr((String)("There are no channels given: " + allChannels));
                return null;
            }
        } else {
            numChannels = 1;
            channels = new ArrayList();
            channels.add(0);
        }
        SPIMConfiguration conf = new SPIMConfiguration();
        conf.timepointPattern = Bead_Registration.timepoints;
        conf.anglePattern = Bead_Registration.angles;
        if (multichannel) {
            conf.channelPattern = allChannels;
            conf.channelsToRegister = allChannels;
            conf.channelsToFuse = allChannels;
        } else {
            conf.channelPattern = "";
            conf.channelsToRegister = "";
            conf.channelsToFuse = "";
        }
        conf.inputFilePattern = Bead_Registration.fileNamePattern;
        f = new File(Bead_Registration.spimDataDirectory);
        if (f.exists() && f.isFile() && f.getName().endsWith(".xml")) {
            conf.spimExperiment = new SPIMExperiment(f.getAbsolutePath());
            conf.inputdirectory = f.getAbsolutePath().substring(0, f.getAbsolutePath().length() - 4);
            System.out.println("inputdirectory : " + conf.inputdirectory);
        } else {
            conf.inputdirectory = Bead_Registration.spimDataDirectory;
        }
        conf.fuseOnly = true;
        if (!ExportSpimSequencePlugIn.init(conf)) {
            return null;
        }
        ArrayList timepoints = new ArrayList();
        int numChoices = 0;
        conf.zStretching = -1.0;
        for (c3 = 0; c3 < channels.size(); ++c3) {
            String[] entries;
            timepoints.add(new ArrayList());
            final String name = conf.file[0][c3][0][0].getName();
            File regDir = new File(conf.registrationFiledirectory);
            IOFunctions.println((String)("name: " + name));
            IOFunctions.println((String)("dir: " + regDir.getAbsolutePath()));
            if (!regDir.isDirectory()) {
                IOFunctions.println((String)(conf.registrationFiledirectory + " is not a directory. "));
                return null;
            }
            for (String e : entries = regDir.list(new FilenameFilter(){

                @Override
                public boolean accept(File directory, String filename) {
                    return filename.contains(name) && filename.contains(".registration");
                }
            })) {
                IOFunctions.println((String)e);
            }
            for (String s : entries) {
                if (s.endsWith(".registration")) {
                    if (!((ArrayList)timepoints.get(c3)).contains(-1)) {
                        ((ArrayList)timepoints.get(c3)).add(-1);
                        ++numChoices;
                    }
                } else {
                    int timepoint = Integer.parseInt(s.substring(s.indexOf(".registration.to_") + 17, s.length()));
                    if (!((ArrayList)timepoints.get(c3)).contains(timepoint)) {
                        ((ArrayList)timepoints.get(c3)).add(timepoint);
                        ++numChoices;
                    }
                }
                if (!(conf.zStretching < 0.0)) continue;
                conf.zStretching = ExportSpimSequencePlugIn.loadZStretching(conf.registrationFiledirectory + s);
                conf.overrideImageZStretching = true;
                IOFunctions.println((String)("Z-stretching = " + conf.zStretching));
            }
        }
        if (numChoices == 0) {
            IOFunctions.println((String)"No registration files available.");
            return null;
        }
        for (c3 = 0; c3 < channels.size(); ++c3) {
            Iterator name = ((ArrayList)timepoints.get(c3)).iterator();
            while (name.hasNext()) {
                int i = (Integer)name.next();
                IOFunctions.println((String)(c3 + ": " + i));
            }
        }
        GenericDialogPlus gd2 = new GenericDialogPlus("Export for BigDataViewer");
        String[] choices = new String[numChoices];
        int[] suggest = new int[channels.size()];
        int firstSuggestion = -1;
        int index = 0;
        for (c2 = 0; c2 < channels.size(); ++c2) {
            ArrayList tps = (ArrayList)timepoints.get(c2);
            suggest[c2] = -1;
            for (int i = 0; i < tps.size(); ++i) {
                choices[index] = (Integer)tps.get(i) == -1 ? "Individual registration of channel " + channels.get(c2) : "Time-point registration (reference=" + tps.get(i) + ") of channel " + channels.get(c2);
                if (suggest[c2] < 1) {
                    suggest[c2] = index;
                    if (firstSuggestion < 1) {
                        firstSuggestion = index;
                    }
                }
                ++index;
            }
        }
        for (c2 = 0; c2 < channels.size(); ++c2) {
            if (suggest[c2] != -1) continue;
            suggest[c2] = firstSuggestion;
        }
        for (c2 = 0; c2 < channels.size(); ++c2) {
            gd2.addChoice("Registration for channel " + channels.get(c2), choices, choices[suggest[c2]]);
        }
        gd2.addMessage("");
        SequenceDescriptionMinimal desc = new SpimRegistrationSequence(conf).getSequenceDescription();
        Map proposedPerSetupExportMipmapInfo = ProposeMipmaps.proposeMipmaps((AbstractSequenceDescription)desc);
        ExportMipmapInfo autoMipmapSettings = (ExportMipmapInfo)proposedPerSetupExportMipmapInfo.get(((BasicViewSetup)desc.getViewSetupsOrdered().get(0)).getId());
        gd2.addCheckbox("manual mipmap setup", lastSetMipmapManual);
        final Checkbox cManualMipmap = (Checkbox)gd2.getCheckboxes().lastElement();
        gd2.addStringField("Subsampling factors", lastSubsampling, 25);
        final TextField tfSubsampling = (TextField)gd2.getStringFields().lastElement();
        gd2.addStringField("Hdf5 chunk sizes", lastChunkSizes, 25);
        final TextField tfChunkSizes = (TextField)gd2.getStringFields().lastElement();
        gd2.addMessage("");
        gd2.addCheckbox("split hdf5", lastSplit);
        final Checkbox cSplit = (Checkbox)gd2.getCheckboxes().lastElement();
        gd2.addNumericField("timepoints per partition", (double)lastTimepointsPerPartition, 0, 25, "");
        final TextField tfSplitTimepoints = (TextField)gd2.getNumericFields().lastElement();
        gd2.addNumericField("setups per partition", (double)lastSetupsPerPartition, 0, 25, "");
        final TextField tfSplitSetups = (TextField)gd2.getNumericFields().lastElement();
        gd2.addMessage("");
        gd2.addCheckbox("use deflate compression", lastDeflate);
        gd2.addMessage("");
        PluginHelper.addSaveAsFileField(gd2, "Export path", conf.inputdirectory + "export.xml", 25);
        final String autoSubsampling = ProposeMipmaps.getArrayString((int[][])autoMipmapSettings.getExportResolutions());
        final String autoChunkSizes = ProposeMipmaps.getArrayString((int[][])autoMipmapSettings.getSubdivisions());
        cManualMipmap.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                boolean useManual = cManualMipmap.getState();
                tfSubsampling.setEnabled(useManual);
                tfChunkSizes.setEnabled(useManual);
                if (!useManual) {
                    tfSubsampling.setText(autoSubsampling);
                    tfChunkSizes.setText(autoChunkSizes);
                }
            }
        });
        tfSubsampling.setEnabled(lastSetMipmapManual);
        tfChunkSizes.setEnabled(lastSetMipmapManual);
        if (!lastSetMipmapManual) {
            tfSubsampling.setText(autoSubsampling);
            tfChunkSizes.setText(autoChunkSizes);
        }
        cSplit.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                boolean split = cSplit.getState();
                tfSplitTimepoints.setEnabled(split);
                tfSplitSetups.setEnabled(split);
            }
        });
        tfSplitTimepoints.setEnabled(lastSplit);
        tfSplitSetups.setEnabled(lastSplit);
        gd2.showDialog();
        if (gd2.wasCanceled()) {
            return null;
        }
        int[][] registrationAssignment = new int[channels.size()][2];
        for (int c5 = 0; c5 < channels.size(); ++c5) {
            int choice = gd2.getNextChoiceIndex();
            index = 0;
            for (int c22 = 0; c22 < channels.size(); ++c22) {
                ArrayList tps = (ArrayList)timepoints.get(c22);
                for (int i = 0; i < tps.size(); ++i) {
                    if (index == choice) {
                        registrationAssignment[c5][0] = (Integer)tps.get(i);
                        registrationAssignment[c5][1] = c22;
                    }
                    ++index;
                }
            }
        }
        int tp = registrationAssignment[0][0];
        for (c = 1; c < channels.size(); ++c) {
            if (tp == registrationAssignment[c][0]) continue;
            IOFunctions.println((String)"Inconsistent choice of reference timeseries, only same reference timepoints or individual registration are allowed.");
            return null;
        }
        conf.registrationAssignmentForFusion = new int[channels.size()];
        for (c = 0; c < channels.size(); ++c) {
            IOFunctions.println((String)("channel " + c + " takes it from channel " + registrationAssignment[c][1]));
            conf.registrationAssignmentForFusion[c] = registrationAssignment[c][1];
        }
        conf.timeLapseRegistration = tp >= 0;
        conf.referenceTimePoint = tp;
        IOFunctions.println((String)("tp " + tp));
        lastSetMipmapManual = gd2.getNextBoolean();
        lastSubsampling = gd2.getNextString();
        lastChunkSizes = gd2.getNextString();
        int[][] resolutions = PluginHelper.parseResolutionsString(lastSubsampling);
        int[][] subdivisions = PluginHelper.parseResolutionsString(lastChunkSizes);
        if (resolutions.length == 0) {
            IOFunctions.println((String)("Cannot parse subsampling factors " + lastSubsampling));
            return null;
        }
        if (subdivisions.length == 0) {
            IOFunctions.println((String)("Cannot parse hdf5 chunk sizes " + lastChunkSizes));
            return null;
        }
        if (resolutions.length != subdivisions.length) {
            IOFunctions.println((String)"subsampling factors and hdf5 chunk sizes must have the same number of elements");
            return null;
        }
        lastSplit = gd2.getNextBoolean();
        lastTimepointsPerPartition = (int)gd2.getNextNumber();
        lastSetupsPerPartition = (int)gd2.getNextNumber();
        lastDeflate = gd2.getNextBoolean();
        String seqFilename = gd2.getNextString();
        if (!seqFilename.endsWith(".xml")) {
            seqFilename = seqFilename + ".xml";
        }
        if ((parent = (seqFile = new File(seqFilename)).getParentFile()) == null || !parent.exists() || !parent.isDirectory()) {
            IOFunctions.println((String)("Invalid export filename " + seqFilename));
            return null;
        }
        String hdf5Filename = seqFilename.substring(0, seqFilename.length() - 4) + ".h5";
        File hdf5File = new File(hdf5Filename);
        return new Parameters(conf, lastSetMipmapManual, resolutions, subdivisions, seqFile, hdf5File, lastDeflate, lastSplit, lastTimepointsPerPartition, lastSetupsPerPartition);
    }

    protected static double loadZStretching(String file) {
        BufferedReader in = TextFileAccess.openFileRead((String)file);
        double z = -1.0;
        try {
            while (in.ready()) {
                String line = in.readLine();
                if (!line.contains("z-scaling:")) continue;
                z = Double.parseDouble(line.substring(line.indexOf("ing") + 4, line.length()).trim());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return z;
    }

    protected static boolean init(SPIMConfiguration conf) {
        conf.inputdirectory = conf.inputdirectory.replace('\\', '/');
        conf.inputdirectory = conf.inputdirectory.replaceAll("//", "/");
        conf.inputdirectory = conf.inputdirectory.trim();
        if (conf.inputdirectory.length() > 0 && !conf.inputdirectory.endsWith("/")) {
            conf.inputdirectory = conf.inputdirectory + "/";
        }
        conf.outputdirectory = conf.inputdirectory + "output/";
        conf.registrationFiledirectory = conf.inputdirectory + "registration/";
        try {
            if (conf.isHuiskenFormat()) {
                conf.getFilenamesHuisken();
            } else {
                conf.getFileNames();
            }
        }
        catch (ConfigurationParserException e) {
            IJ.error((String)("Cannot parse input: " + (Object)((Object)e)));
            return false;
        }
        conf.interpolatorFactorOutput.setOutOfBoundsStrategyFactory(conf.strategyFactoryOutput);
        return true;
    }

    public static void main(String[] args) {
        Bead_Registration.spimDataDirectory = "/Users/pietzsch/workspace/data/openspim";
        Bead_Registration.fileNamePattern = "spim_TL{tt}_Angle{a}.tif";
        Bead_Registration.timepoints = "0";
        Bead_Registration.angles = "0";
        new ExportSpimSequencePlugIn().run();
    }

    protected static class Parameters {
        final SPIMConfiguration conf;
        final boolean setMipmapManual;
        final int[][] resolutions;
        final int[][] subdivisions;
        final File seqFile;
        final File hdf5File;
        final boolean deflate;
        final boolean split;
        final int timepointsPerPartition;
        final int setupsPerPartition;

        public Parameters(SPIMConfiguration conf, boolean setMipmapManual, int[][] resolutions, int[][] subdivisions, File seqFile, File hdf5File, boolean deflate, boolean split, int timepointsPerPartition, int setupsPerPartition) {
            this.conf = conf;
            this.setMipmapManual = setMipmapManual;
            this.resolutions = resolutions;
            this.subdivisions = subdivisions;
            this.seqFile = seqFile;
            this.hdf5File = hdf5File;
            this.deflate = deflate;
            this.split = split;
            this.timepointsPerPartition = timepointsPerPartition;
            this.setupsPerPartition = setupsPerPartition;
        }
    }
}

