/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.ui.brush;

import bdv.viewer.OverlayRenderer;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import sc.fiji.labkit.ui.labeling.Label;
import sc.fiji.labkit.ui.models.LabelingModel;

public class BrushCursor
implements OverlayRenderer {
    private final LabelingModel model;
    private int x;
    private int y;
    private int radius = 5;
    private boolean visible = false;
    private boolean fontVisible = true;

    public BrushCursor(LabelingModel model) {
        this.model = model;
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setRadius(double radius) {
        this.radius = (int)Math.round(radius);
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void setFontVisible(boolean visible) {
        this.fontVisible = visible;
    }

    public void drawOverlays(Graphics g) {
        if (this.visible) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setComposite(AlphaComposite.SrcOver);
            Label label = this.model.selectedLabel().get();
            if (label != null) {
                Color color = new Color(label.color().get());
                String title = label.name();
                if (this.fontVisible) {
                    this.drawTitle(g2d, color, title);
                }
                this.drawCircle(g2d, color);
            }
        }
    }

    public void setCanvasSize(int width, int height) {
    }

    private void drawCircle(Graphics2D g2d, Color color) {
        g2d.setColor(color);
        g2d.setStroke(new BasicStroke(1.0f));
        g2d.drawOval(this.x - this.radius, this.y - this.radius, 2 * this.radius + 1, 2 * this.radius + 1);
    }

    private void drawTitle(Graphics2D g2d, Color color, String title) {
        g2d.setColor(color);
        g2d.drawString(title, this.x + this.radius + 20, this.y + this.radius + 20);
    }
}

