/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.stitching;

import fiji.stacks.Hyperstack_rearranger;
import ij.ImagePlus;
import ij.gui.Roi;
import java.util.ArrayList;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import mpicbg.imglib.algorithm.fft.PhaseCorrelation;
import mpicbg.imglib.algorithm.fft.PhaseCorrelationPeak;
import mpicbg.imglib.algorithm.scalespace.SubpixelLocalization;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.image.display.imagej.ImageJFunctions;
import mpicbg.imglib.multithreading.Chunk;
import mpicbg.imglib.multithreading.SimpleMultiThreading;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.numeric.RealType;
import mpicbg.imglib.type.numeric.integer.UnsignedByteType;
import mpicbg.imglib.type.numeric.integer.UnsignedShortType;
import mpicbg.imglib.type.numeric.real.FloatType;
import mpicbg.stitching.PairWiseStitchingResult;
import mpicbg.stitching.Peak;
import mpicbg.stitching.StitchingParameters;
import stitching.utils.Log;

public class PairWiseStitchingImgLib {
    public static PairWiseStitchingResult stitchPairwise(ImagePlus imp1, ImagePlus imp2, Roi roi1, Roi roi2, int timepoint1, int timepoint2, StitchingParameters params) {
        boolean canWrap;
        PairWiseStitchingResult result = null;
        roi1 = PairWiseStitchingImgLib.getOnlyRectangularRoi(roi1);
        roi2 = PairWiseStitchingImgLib.getOnlyRectangularRoi(roi2);
        boolean bl = canWrap = !StitchingParameters.alwaysCopy && PairWiseStitchingImgLib.canWrapIntoImgLib(imp1, roi1, params.channel1) && PairWiseStitchingImgLib.canWrapIntoImgLib(imp2, roi2, params.channel2);
        if (canWrap) {
            if (imp1.getType() == 2) {
                Image<FloatType> image1 = PairWiseStitchingImgLib.getWrappedImageFloat(imp1, params.channel1, timepoint1);
                if (imp2.getType() == 2) {
                    result = PairWiseStitchingImgLib.performStitching(image1, PairWiseStitchingImgLib.getWrappedImageFloat(imp2, params.channel2, timepoint2), params);
                } else if (imp2.getType() == 1) {
                    result = PairWiseStitchingImgLib.performStitching(image1, PairWiseStitchingImgLib.getWrappedImageUnsignedShort(imp2, params.channel2, timepoint2), params);
                } else if (imp2.getType() == 0) {
                    result = PairWiseStitchingImgLib.performStitching(image1, PairWiseStitchingImgLib.getWrappedImageUnsignedByte(imp2, params.channel2, timepoint2), params);
                } else {
                    Log.error("Unknown image type: " + imp2.getType());
                }
                image1.close();
            } else if (imp1.getType() == 1) {
                Image<UnsignedShortType> image1 = PairWiseStitchingImgLib.getWrappedImageUnsignedShort(imp1, params.channel1, timepoint1);
                if (imp2.getType() == 2) {
                    result = PairWiseStitchingImgLib.performStitching(image1, PairWiseStitchingImgLib.getWrappedImageFloat(imp2, params.channel2, timepoint2), params);
                } else if (imp2.getType() == 1) {
                    result = PairWiseStitchingImgLib.performStitching(image1, PairWiseStitchingImgLib.getWrappedImageUnsignedShort(imp2, params.channel2, timepoint2), params);
                } else if (imp2.getType() == 0) {
                    result = PairWiseStitchingImgLib.performStitching(image1, PairWiseStitchingImgLib.getWrappedImageUnsignedByte(imp2, params.channel2, timepoint2), params);
                } else {
                    Log.error("Unknown image type: " + imp2.getType());
                }
                image1.close();
            } else if (imp1.getType() == 0) {
                Image<UnsignedByteType> image1 = PairWiseStitchingImgLib.getWrappedImageUnsignedByte(imp1, params.channel1, timepoint1);
                if (imp2.getType() == 2) {
                    result = PairWiseStitchingImgLib.performStitching(image1, PairWiseStitchingImgLib.getWrappedImageFloat(imp2, params.channel2, timepoint2), params);
                } else if (imp2.getType() == 1) {
                    result = PairWiseStitchingImgLib.performStitching(image1, PairWiseStitchingImgLib.getWrappedImageUnsignedShort(imp2, params.channel2, timepoint2), params);
                } else if (imp2.getType() == 0) {
                    result = PairWiseStitchingImgLib.performStitching(image1, PairWiseStitchingImgLib.getWrappedImageUnsignedByte(imp2, params.channel2, timepoint2), params);
                } else {
                    Log.error("Unknown image type: " + imp2.getType());
                }
                image1.close();
            } else {
                Log.error("Unknown image type: " + imp1.getType());
            }
        } else {
            ImageFactory imgFactoryByte = new ImageFactory((Type)new UnsignedByteType(), StitchingParameters.phaseCorrelationFactory);
            ImageFactory imgFactoryShort = new ImageFactory((Type)new UnsignedShortType(), StitchingParameters.phaseCorrelationFactory);
            ImageFactory imgFactoryFloat = new ImageFactory((Type)new FloatType(), StitchingParameters.phaseCorrelationFactory);
            if (imp1.getType() == 2) {
                Image image1 = PairWiseStitchingImgLib.getImage(imp1, roi1, imgFactoryFloat, params.channel1, timepoint1);
                if (imp2.getType() == 2) {
                    result = PairWiseStitchingImgLib.performStitching(image1, PairWiseStitchingImgLib.getImage(imp2, roi2, imgFactoryFloat, params.channel2, timepoint2), params);
                } else if (imp2.getType() == 1) {
                    result = PairWiseStitchingImgLib.performStitching(image1, PairWiseStitchingImgLib.getImage(imp2, roi2, imgFactoryShort, params.channel2, timepoint2), params);
                } else if (imp2.getType() == 0) {
                    result = PairWiseStitchingImgLib.performStitching(image1, PairWiseStitchingImgLib.getImage(imp2, roi2, imgFactoryByte, params.channel2, timepoint2), params);
                } else {
                    Log.error("Unknown image type: " + imp2.getType());
                }
            } else if (imp1.getType() == 1) {
                Image image1 = PairWiseStitchingImgLib.getImage(imp1, roi1, imgFactoryShort, params.channel1, timepoint1);
                if (imp2.getType() == 2) {
                    result = PairWiseStitchingImgLib.performStitching(image1, PairWiseStitchingImgLib.getImage(imp2, roi2, imgFactoryFloat, params.channel2, timepoint2), params);
                } else if (imp2.getType() == 1) {
                    result = PairWiseStitchingImgLib.performStitching(image1, PairWiseStitchingImgLib.getImage(imp2, roi2, imgFactoryShort, params.channel2, timepoint2), params);
                } else if (imp2.getType() == 0) {
                    result = PairWiseStitchingImgLib.performStitching(image1, PairWiseStitchingImgLib.getImage(imp2, roi2, imgFactoryByte, params.channel2, timepoint2), params);
                } else {
                    Log.error("Unknown image type: " + imp2.getType());
                }
            } else if (imp1.getType() == 0) {
                Image image1 = PairWiseStitchingImgLib.getImage(imp1, roi1, imgFactoryByte, params.channel1, timepoint1);
                if (imp2.getType() == 2) {
                    result = PairWiseStitchingImgLib.performStitching(image1, PairWiseStitchingImgLib.getImage(imp2, roi2, imgFactoryFloat, params.channel2, timepoint2), params);
                } else if (imp2.getType() == 1) {
                    result = PairWiseStitchingImgLib.performStitching(image1, PairWiseStitchingImgLib.getImage(imp2, roi2, imgFactoryShort, params.channel2, timepoint2), params);
                } else if (imp2.getType() == 0) {
                    result = PairWiseStitchingImgLib.performStitching(image1, PairWiseStitchingImgLib.getImage(imp2, roi2, imgFactoryByte, params.channel2, timepoint2), params);
                } else {
                    Log.error("Unknown image type: " + imp2.getType());
                }
            } else {
                Log.error("Unknown image type: " + imp1.getType());
            }
        }
        if (result == null) {
            Log.error("Pairwise stitching failed.");
            return null;
        }
        if (roi2 != null) {
            result.offset[0] = result.offset[0] - (float)roi2.getBounds().x;
            result.offset[1] = result.offset[1] - (float)roi2.getBounds().y;
        }
        if (roi1 != null) {
            result.offset[0] = result.offset[0] + (float)roi1.getBounds().x;
            result.offset[1] = result.offset[1] + (float)roi1.getBounds().y;
        }
        return result;
    }

    public static <T extends RealType<T>, S extends RealType<S>> PairWiseStitchingResult performStitching(Image<T> img1, Image<S> img2, StitchingParameters params) {
        if (img1 == null) {
            Log.error("Image 1 could not be wrapped.");
            return null;
        }
        if (img2 == null) {
            Log.error("Image 2 could not be wrapped.");
            return null;
        }
        if (params == null) {
            Log.error("Parameters are null.");
            return null;
        }
        PairWiseStitchingResult result = PairWiseStitchingImgLib.computePhaseCorrelation(img1, img2, params.checkPeaks, params.subpixelAccuracy);
        return result;
    }

    public static <T extends RealType<T>, S extends RealType<S>> PairWiseStitchingResult computePhaseCorrelation(Image<T> img1, Image<S> img2, int numPeaks, boolean subpixelAccuracy) {
        PairWiseStitchingResult result;
        PhaseCorrelation phaseCorr = new PhaseCorrelation(img1, img2);
        phaseCorr.setInvestigateNumPeaks(numPeaks);
        if (subpixelAccuracy) {
            phaseCorr.setKeepPhaseCorrelationMatrix(true);
        }
        phaseCorr.setComputeFFTinParalell(true);
        if (!phaseCorr.process()) {
            Log.error("Could not compute phase correlation: " + phaseCorr.getErrorMessage());
            return null;
        }
        PhaseCorrelationPeak pcp = phaseCorr.getShift();
        float[] shift = new float[img1.getNumDimensions()];
        if (subpixelAccuracy) {
            Image pcm = phaseCorr.getPhaseCorrelationMatrix();
            ArrayList<Peak> list = new ArrayList<Peak>();
            Peak p = new Peak(pcp);
            list.add(p);
            SubpixelLocalization spl = new SubpixelLocalization(pcm, list);
            boolean[] move = new boolean[pcm.getNumDimensions()];
            for (int i = 0; i < pcm.getNumDimensions(); ++i) {
                move[i] = false;
            }
            spl.setCanMoveOutside(true);
            spl.setAllowedToMoveInDim(move);
            spl.setMaxNumMoves(0);
            spl.setAllowMaximaTolerance(false);
            spl.process();
            Peak peak = (Peak)((Object)list.get(0));
            for (int d = 0; d < img1.getNumDimensions(); ++d) {
                shift[d] = (float)peak.getPCPeak().getPosition()[d] + peak.getSubPixelPositionOffset(d);
            }
            pcm.close();
            result = new PairWiseStitchingResult(shift, pcp.getCrossCorrelationPeak(), ((FloatType)p.getValue()).get());
        } else {
            for (int d = 0; d < img1.getNumDimensions(); ++d) {
                shift[d] = pcp.getPosition()[d];
            }
            result = new PairWiseStitchingResult(shift, pcp.getCrossCorrelationPeak(), pcp.getPhaseCorrelationPeak());
        }
        return result;
    }

    public static <T extends RealType<T>> Image<T> getImage(ImagePlus imp, Roi roi, ImageFactory<T> imgFactory, int channel, int timepoint) {
        roi = PairWiseStitchingImgLib.getOnlyRectangularRoi(roi);
        int numDimensions = imp.getNSlices() > 1 ? 3 : 2;
        int[] size = new int[numDimensions];
        int[] offset = new int[numDimensions];
        if (roi == null) {
            size[0] = imp.getWidth();
            size[1] = imp.getHeight();
            if (numDimensions == 3) {
                size[2] = imp.getNSlices();
            }
        } else {
            size[0] = roi.getBounds().width;
            size[1] = roi.getBounds().height;
            offset[0] = roi.getBounds().x;
            offset[1] = roi.getBounds().y;
            if (numDimensions == 3) {
                size[2] = imp.getNSlices();
            }
        }
        Image img = imgFactory.createImage(size);
        boolean success = channel == 0 ? PairWiseStitchingImgLib.averageAllChannels(img, offset, imp, timepoint) : PairWiseStitchingImgLib.fillInChannel(img, offset, imp, channel, timepoint);
        if (success) {
            return img;
        }
        img.close();
        return null;
    }

    public static <T extends RealType<T>> boolean averageAllChannels(Image<T> target, int[] offset, ImagePlus imp, int timepoint) {
        int numChannels = imp.getNChannels();
        if (imp.getType() == 0) {
            ArrayList images = new ArrayList();
            for (int c = 1; c <= numChannels; ++c) {
                images.add(PairWiseStitchingImgLib.getWrappedImageUnsignedByte(imp, c, timepoint));
            }
            PairWiseStitchingImgLib.averageAllChannels(target, images, offset);
            return true;
        }
        if (imp.getType() == 1) {
            ArrayList images = new ArrayList();
            for (int c = 1; c <= numChannels; ++c) {
                images.add(PairWiseStitchingImgLib.getWrappedImageUnsignedShort(imp, c, timepoint));
            }
            PairWiseStitchingImgLib.averageAllChannels(target, images, offset);
            return true;
        }
        if (imp.getType() == 2) {
            ArrayList images = new ArrayList();
            for (int c = 1; c <= numChannels; ++c) {
                images.add(PairWiseStitchingImgLib.getWrappedImageFloat(imp, c, timepoint));
            }
            PairWiseStitchingImgLib.averageAllChannels(target, images, offset);
            return true;
        }
        Log.error("Unknow image type: " + imp.getType());
        return false;
    }

    public static <T extends RealType<T>> boolean fillInChannel(Image<T> target, int[] offset, ImagePlus imp, int channel, int timepoint) {
        if (imp.getType() == 0) {
            ArrayList images = new ArrayList();
            images.add(PairWiseStitchingImgLib.getWrappedImageUnsignedByte(imp, channel, timepoint));
            PairWiseStitchingImgLib.averageAllChannels(target, images, offset);
            return true;
        }
        if (imp.getType() == 1) {
            ArrayList images = new ArrayList();
            images.add(PairWiseStitchingImgLib.getWrappedImageUnsignedShort(imp, channel, timepoint));
            PairWiseStitchingImgLib.averageAllChannels(target, images, offset);
            return true;
        }
        if (imp.getType() == 2) {
            ArrayList images = new ArrayList();
            images.add(PairWiseStitchingImgLib.getWrappedImageFloat(imp, channel, timepoint));
            PairWiseStitchingImgLib.averageAllChannels(target, images, offset);
            return true;
        }
        Log.error("Unknow image type: " + imp.getType());
        return false;
    }

    protected static <T extends RealType<T>, S extends RealType<S>> void averageAllChannels(final Image<T> target, final ArrayList<Image<S>> sources, final int[] offset) {
        final int numDimensions = target.getNumDimensions();
        final float numImages = sources.size();
        long imageSize = target.getDimension(0);
        for (int d = 1; d < target.getNumDimensions(); ++d) {
            imageSize *= (long)target.getDimension(d);
        }
        final AtomicInteger ai = new AtomicInteger(0);
        Thread[] threads = SimpleMultiThreading.newThreads();
        final Vector threadChunks = SimpleMultiThreading.divideIntoChunks((long)imageSize, (int)threads.length);
        for (int ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int myNumber = ai.getAndIncrement();
                    Chunk myChunk = (Chunk)threadChunks.get(myNumber);
                    long startPos = myChunk.getStartPosition();
                    long loopSize = myChunk.getLoopSize();
                    LocalizableCursor targetCursor = target.createLocalizableCursor();
                    ArrayList<LocalizableByDimCursor> sourceCursors = new ArrayList<LocalizableByDimCursor>();
                    for (Image source : sources) {
                        sourceCursors.add(source.createLocalizableByDimCursor());
                    }
                    int[] location = new int[numDimensions];
                    targetCursor.fwd(startPos);
                    for (long j = 0L; j < loopSize; ++j) {
                        targetCursor.fwd();
                        targetCursor.getPosition(location);
                        for (int d = 0; d < numDimensions; ++d) {
                            int n = d;
                            location[n] = location[n] + offset[d];
                        }
                        float sum = 0.0f;
                        for (LocalizableByDimCursor sourceCursor : sourceCursors) {
                            sourceCursor.setPosition(location);
                            sum += ((RealType)sourceCursor.getType()).getRealFloat();
                        }
                        ((RealType)targetCursor.getType()).setReal(sum / numImages);
                    }
                }
            });
        }
        SimpleMultiThreading.startAndJoin((Thread[])threads);
    }

    public static Image<UnsignedByteType> getWrappedImageUnsignedByte(ImagePlus imp, int channel, int timepoint) {
        if (channel == 0 || imp.getType() != 0) {
            return null;
        }
        return ImageJFunctions.wrapByte((ImagePlus)Hyperstack_rearranger.getImageChunk((ImagePlus)imp, (int)channel, (int)timepoint));
    }

    public static Image<UnsignedShortType> getWrappedImageUnsignedShort(ImagePlus imp, int channel, int timepoint) {
        if (channel == 0 || imp.getType() != 1) {
            return null;
        }
        return ImageJFunctions.wrapShort((ImagePlus)Hyperstack_rearranger.getImageChunk((ImagePlus)imp, (int)channel, (int)timepoint));
    }

    public static Image<FloatType> getWrappedImageFloat(ImagePlus imp, int channel, int timepoint) {
        if (channel == 0 || imp.getType() != 2) {
            return null;
        }
        return ImageJFunctions.wrapFloat((ImagePlus)Hyperstack_rearranger.getImageChunk((ImagePlus)imp, (int)channel, (int)timepoint));
    }

    public static boolean canWrapIntoImgLib(ImagePlus imp, Roi roi, int channel) {
        return (roi = PairWiseStitchingImgLib.getOnlyRectangularRoi(roi)) == null && channel > 0;
    }

    protected static Roi getOnlyRectangularRoi(Roi roi) {
        if (roi != null && roi.getType() != 0) {
            return null;
        }
        return roi;
    }
}

