/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import java.util.Collection;
import java.util.Iterator;

public final class StringMaker {
    private final StringBuilder builder;

    public StringMaker() {
        this.builder = new StringBuilder();
    }

    public StringMaker(String s) {
        this.builder = new StringBuilder(s);
    }

    public String toString() {
        return this.builder.toString();
    }

    public void append(String s) {
        if (this.builder.length() > 0) {
            this.builder.append(", ");
        }
        this.builder.append(s);
    }

    public void append(String key, Object value) {
        this.append(key, value, null);
    }

    public void append(String key, Object value, Object defaultValue) {
        if (value == null || value.equals(defaultValue)) {
            return;
        }
        String s = this.makeString(value);
        if (s == null) {
            return;
        }
        if (this.builder.length() > 0) {
            this.builder.append(", ");
        }
        this.builder.append(key + "=" + s);
    }

    private String makeString(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            String s = (String)value;
            if (s.isEmpty()) {
                return null;
            }
            return "'" + s + "'";
        }
        if (value instanceof Class) {
            Class c = (Class)value;
            return c.getSimpleName();
        }
        if (value instanceof Collection) {
            Collection c = (Collection)value;
            if (c.isEmpty()) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            Iterator iter = c.iterator();
            while (iter.hasNext()) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                Object o = iter.next();
                sb.append(this.makeString(o));
            }
            return "{" + sb.toString() + "}";
        }
        return value.toString();
    }
}

