/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.data.sequence;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mpicbg.spim.data.generic.base.Entity;
import mpicbg.spim.data.sequence.TimePoint;

public class TimePoints {
    private Map<Integer, TimePoint> timepoints;
    private List<TimePoint> timepointsOrdered;

    public TimePoints(Map<Integer, TimePoint> timepoints) {
        this.setTimePoints(timepoints);
    }

    public TimePoints(Collection<TimePoint> timepoints) {
        HashMap<Integer, TimePoint> map = new HashMap<Integer, TimePoint>();
        for (TimePoint tp : timepoints) {
            map.put(tp.getId(), tp);
        }
        this.setTimePoints(map);
    }

    public Map<Integer, TimePoint> getTimePoints() {
        return this.timepoints;
    }

    public List<TimePoint> getTimePointsOrdered() {
        return this.timepointsOrdered;
    }

    public int size() {
        return this.timepointsOrdered.size();
    }

    protected void setTimePoints(Collection<TimePoint> timepoints) {
        HashMap<Integer, TimePoint> map = new HashMap<Integer, TimePoint>();
        for (TimePoint tp : timepoints) {
            map.put(tp.getId(), tp);
        }
        this.timepoints = Collections.unmodifiableMap(map);
        ArrayList<TimePoint> tps = new ArrayList<TimePoint>(this.timepoints.values());
        this.timepointsOrdered = Collections.unmodifiableList(Entity.sortById(tps));
    }

    protected void setTimePoints(Map<Integer, TimePoint> timepoints) {
        this.timepoints = Collections.unmodifiableMap(new HashMap<Integer, TimePoint>(timepoints));
        ArrayList<TimePoint> tps = new ArrayList<TimePoint>(this.timepoints.values());
        this.timepointsOrdered = Collections.unmodifiableList(Entity.sortById(tps));
    }

    protected TimePoints() {
    }
}

