/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.teddy;

import javax.swing.JEditorPane;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.StyledEditorKit;

public class JEditorArea
extends JEditorPane {
    private boolean wrap;

    public JEditorArea() {
        this.setEditorKit(new StyledEditorKit());
        this.initComponents();
    }

    public StyledEditorKit getStyledEditorKit() {
        return (StyledEditorKit)this.getEditorKit();
    }

    public void setLineWrap(boolean newValue) {
        boolean oldValue = this.wrap;
        if (oldValue != newValue) {
            this.wrap = newValue;
            this.firePropertyChange("lineWrap", oldValue, newValue);
            this.rebuildView();
        }
    }

    public boolean getLineWrap() {
        return this.wrap;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return this.wrap;
    }

    public void rebuildView() {
        this.revalidate();
        this.repaint();
    }

    public void replaceRange(String str, int start, int end) {
        if (end < start) {
            throw new IllegalArgumentException("end before start");
        }
        Document doc = this.getDocument();
        if (doc != null) {
            try {
                if (doc instanceof AbstractDocument) {
                    ((AbstractDocument)doc).replace(start, end - start, str, null);
                } else {
                    doc.remove(start, end - start);
                    doc.insertString(start, str, null);
                }
            }
            catch (BadLocationException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    public int getLineOfOffset(int offset) throws BadLocationException {
        Document doc = this.getDocument();
        if (offset < 0) {
            throw new BadLocationException("Can't translate offset to line", -1);
        }
        if (offset > doc.getLength()) {
            throw new BadLocationException("Can't translate offset to line", doc.getLength() + 1);
        }
        Element map = this.getDocument().getDefaultRootElement();
        return map.getElementIndex(offset);
    }

    public int getLineStartOffset(int line) throws BadLocationException {
        Document doc = this.getDocument();
        Element map = doc.getDefaultRootElement();
        int lineCount = map.getElementCount();
        if (line < 0) {
            throw new BadLocationException("Negative line", -1);
        }
        if (line >= lineCount) {
            throw new BadLocationException("No such line", doc.getLength() + 1);
        }
        Element lineElem = map.getElement(line);
        return lineElem.getStartOffset();
    }

    private void initComponents() {
    }
}

