/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.OverlappingFileLockException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.AccessMode;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.stream.Stream;
import org.janelia.saalfeldlab.n5.KeyValueAccess;
import org.janelia.saalfeldlab.n5.LockedChannel;
import org.janelia.saalfeldlab.n5.N5Exception;

public class FileSystemKeyValueAccess
implements KeyValueAccess {
    protected final FileSystem fileSystem;

    public FileSystemKeyValueAccess(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    @Override
    public LockedFileChannel lockForReading(String normalPath) throws IOException {
        try {
            return new LockedFileChannel(normalPath, true);
        }
        catch (NoSuchFileException e) {
            throw new N5Exception.N5NoSuchKeyException("No such file", e);
        }
    }

    @Override
    public LockedFileChannel lockForWriting(String normalPath) throws IOException {
        return new LockedFileChannel(normalPath, false);
    }

    public LockedFileChannel lockForReading(Path path) throws IOException {
        try {
            return new LockedFileChannel(path, true);
        }
        catch (NoSuchFileException e) {
            throw new N5Exception.N5NoSuchKeyException("No such file", e);
        }
    }

    public LockedFileChannel lockForWriting(Path path) throws IOException {
        return new LockedFileChannel(path, false);
    }

    @Override
    public boolean isDirectory(String normalPath) {
        Path path = this.fileSystem.getPath(normalPath, new String[0]);
        return Files.isDirectory(path, new LinkOption[0]);
    }

    @Override
    public boolean isFile(String normalPath) {
        Path path = this.fileSystem.getPath(normalPath, new String[0]);
        return Files.isRegularFile(path, new LinkOption[0]);
    }

    @Override
    public boolean exists(String normalPath) {
        Path path = this.fileSystem.getPath(normalPath, new String[0]);
        return Files.exists(path, new LinkOption[0]);
    }

    @Override
    public String[] listDirectories(String normalPath) throws IOException {
        Path path = this.fileSystem.getPath(normalPath, new String[0]);
        try (Stream<Path> pathStream = Files.list(path);){
            String[] stringArray = (String[])pathStream.filter(a -> Files.isDirectory(a, new LinkOption[0])).map(a -> path.relativize((Path)a).toString()).toArray(String[]::new);
            return stringArray;
        }
    }

    @Override
    public String[] list(String normalPath) throws IOException {
        Path path = this.fileSystem.getPath(normalPath, new String[0]);
        try (Stream<Path> pathStream = Files.list(path);){
            String[] stringArray = (String[])pathStream.map(a -> path.relativize((Path)a).toString()).toArray(String[]::new);
            return stringArray;
        }
    }

    @Override
    public String[] components(String path) {
        int o;
        String[] components;
        Path fsPath = this.fileSystem.getPath(path, new String[0]);
        Path root = fsPath.getRoot();
        if (root == null) {
            components = new String[fsPath.getNameCount()];
            o = 0;
        } else {
            components = new String[fsPath.getNameCount() + 1];
            components[0] = root.toString();
            o = 1;
        }
        for (int i = o; i < components.length; ++i) {
            String name = fsPath.getName(i - o).toString();
            if (i == components.length - 1) {
                String separator = this.fileSystem.getSeparator();
                String trailingSeparator = path.endsWith(separator) ? separator : (path.endsWith("/") ? "/" : "");
                name = name + trailingSeparator;
            }
            components[i] = name;
        }
        return components;
    }

    @Override
    public String parent(String path) {
        Path parent = this.fileSystem.getPath(path, new String[0]).getParent();
        if (parent == null) {
            return null;
        }
        return parent.toString();
    }

    @Override
    public String relativize(String path, String base) {
        Path basePath = this.fileSystem.getPath(base, new String[0]);
        return basePath.relativize(this.fileSystem.getPath(path, new String[0])).toString();
    }

    @Override
    public String normalize(String path) {
        return this.fileSystem.getPath(path, new String[0]).normalize().toString();
    }

    @Override
    public URI uri(String normalPath) throws URISyntaxException {
        try {
            URI normalUri = URI.create(normalPath);
            if (normalUri.isAbsolute()) {
                return normalUri.normalize();
            }
        }
        catch (IllegalArgumentException e) {
            return new File(normalPath).toURI().normalize();
        }
        return new File(normalPath).toURI().normalize();
    }

    @Override
    public String compose(String ... components) {
        if (components == null || components.length == 0) {
            return null;
        }
        if (components.length == 1) {
            return this.fileSystem.getPath(components[0], new String[0]).toString();
        }
        return this.fileSystem.getPath(components[0], Arrays.copyOfRange(components, 1, components.length)).normalize().toString();
    }

    @Override
    public String compose(URI uri, String ... components) {
        Path composedPath = uri.isAbsolute() ? Paths.get(uri) : Paths.get(uri.toString(), new String[0]);
        for (String component : components) {
            composedPath = composedPath.resolve(component);
        }
        return composedPath.toAbsolutePath().toString();
    }

    @Override
    public void createDirectories(String normalPath) throws IOException {
        FileSystemKeyValueAccess.createDirectories(this.fileSystem.getPath(normalPath, new String[0]), new FileAttribute[0]);
    }

    @Override
    public void delete(String normalPath) throws IOException {
        Path path = this.fileSystem.getPath(normalPath, new String[0]);
        if (Files.isRegularFile(path, new LinkOption[0])) {
            try (LockedFileChannel channel = this.lockForWriting(path);){
                Files.delete(path);
            }
        }
        try (Stream<Path> pathStream = Files.walk(path, new FileVisitOption[0]);){
            Iterator i = pathStream.sorted(Comparator.reverseOrder()).iterator();
            while (i.hasNext()) {
                Path childPath = (Path)i.next();
                if (Files.isRegularFile(childPath, new LinkOption[0])) {
                    LockedFileChannel channel = this.lockForWriting(childPath);
                    Throwable throwable = null;
                    try {
                        Files.delete(childPath);
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (channel == null) continue;
                        if (throwable != null) {
                            try {
                                channel.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        channel.close();
                        continue;
                    }
                }
                FileSystemKeyValueAccess.tryDelete(childPath);
            }
        }
    }

    protected static void tryDelete(Path path) throws IOException {
        try {
            Files.delete(path);
        }
        catch (DirectoryNotEmptyException e) {
            try {
                Thread.sleep(100L);
                Files.delete(path);
            }
            catch (InterruptedException ex) {
                e.printStackTrace();
                Thread.currentThread().interrupt();
            }
        }
    }

    protected static Path createDirectories(Path dir, FileAttribute<?> ... attrs) throws IOException {
        try {
            FileSystemKeyValueAccess.createAndCheckIsDirectory(dir, attrs);
            return dir;
        }
        catch (FileAlreadyExistsException x) {
            throw x;
        }
        catch (IOException x) {
            Path parent;
            SecurityException se = null;
            try {
                dir = dir.toAbsolutePath();
            }
            catch (SecurityException x2) {
                se = x2;
            }
            for (parent = dir.getParent(); parent != null; parent = parent.getParent()) {
                try {
                    parent.getFileSystem().provider().checkAccess(parent, new AccessMode[0]);
                    break;
                }
                catch (NoSuchFileException noSuchFileException) {
                    continue;
                }
            }
            if (parent == null) {
                if (se == null) {
                    throw new FileSystemException(dir.toString(), null, "Unable to determine if root directory exists");
                }
                throw se;
            }
            Path child = parent;
            for (Path name : parent.relativize(dir)) {
                child = child.resolve(name);
                FileSystemKeyValueAccess.createAndCheckIsDirectory(child, attrs);
            }
            return dir;
        }
    }

    protected static void createAndCheckIsDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
        block2: {
            try {
                Files.createDirectory(dir, attrs);
            }
            catch (FileAlreadyExistsException x) {
                if (Files.isDirectory(dir, new LinkOption[0])) break block2;
                throw x;
            }
        }
    }

    protected class LockedFileChannel
    implements LockedChannel {
        protected final FileChannel channel;

        protected LockedFileChannel(String path, boolean readOnly) throws IOException {
            this(this$0.fileSystem.getPath(path, new String[0]), readOnly);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected LockedFileChannel(Path path, boolean readOnly) throws IOException {
            OpenOption[] options;
            if (readOnly) {
                options = new OpenOption[]{StandardOpenOption.READ};
                this.channel = FileChannel.open(path, options);
            } else {
                options = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE};
                FileChannel tryChannel = null;
                try {
                    tryChannel = FileChannel.open(path, options);
                }
                catch (NoSuchFileException e) {
                    FileSystemKeyValueAccess.createDirectories(path.getParent(), new FileAttribute[0]);
                    tryChannel = FileChannel.open(path, options);
                }
                finally {
                    this.channel = tryChannel;
                }
            }
            boolean waiting = true;
            while (waiting) {
                waiting = false;
                try {
                    this.channel.lock(0L, Long.MAX_VALUE, readOnly);
                }
                catch (OverlappingFileLockException e) {
                    waiting = true;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException f) {
                        waiting = false;
                        Thread.currentThread().interrupt();
                    }
                }
                catch (IOException iOException) {}
            }
        }

        @Override
        public Reader newReader() throws IOException {
            return Channels.newReader((ReadableByteChannel)this.channel, StandardCharsets.UTF_8.name());
        }

        @Override
        public Writer newWriter() throws IOException {
            this.channel.truncate(0L);
            return Channels.newWriter((WritableByteChannel)this.channel, StandardCharsets.UTF_8.name());
        }

        @Override
        public InputStream newInputStream() throws IOException {
            return Channels.newInputStream(this.channel);
        }

        @Override
        public OutputStream newOutputStream() throws IOException {
            this.channel.truncate(0L);
            return Channels.newOutputStream(this.channel);
        }

        @Override
        public void close() throws IOException {
            this.channel.close();
        }
    }
}

