/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.janelia.saalfeldlab.n5.LockedChannel;
import org.janelia.saalfeldlab.n5.N5Exception;
import org.janelia.saalfeldlab.n5.N5URI;

public interface KeyValueAccess {
    default public String[] components(String path) {
        String[] components = (String[])Arrays.stream(path.split("/")).filter(x -> !x.isEmpty()).toArray(String[]::new);
        if (components.length == 0) {
            String[] stringArray;
            if (path.startsWith("/")) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "/";
            } else {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = "";
            }
            return stringArray;
        }
        if (path.startsWith("/") && !components[0].equals("/")) {
            String[] prependRoot = new String[components.length + 1];
            prependRoot[0] = "/";
            System.arraycopy(components, 0, prependRoot, 1, components.length);
            components = prependRoot;
        }
        if (path.endsWith("/") && !components[components.length - 1].endsWith("/")) {
            components[components.length - 1] = components[components.length - 1] + "/";
        }
        return components;
    }

    default public String compose(URI uri, String ... components) {
        if (components.length == 0) {
            return uri.toString();
        }
        String[] allComponents = new String[components.length + 1];
        allComponents[0] = uri.getPath();
        System.arraycopy(components, 0, allComponents, 1, components.length);
        URI composedUri = uri;
        for (int i = 0; i < allComponents.length; ++i) {
            String component = allComponents[i];
            if (component == null || component.isEmpty()) continue;
            composedUri = component.endsWith("/") || i == allComponents.length - 1 ? composedUri.resolve(N5URI.encodeAsUriPath(component)) : composedUri.resolve(N5URI.encodeAsUriPath(component + "/"));
        }
        return composedUri.toString();
    }

    @Deprecated
    default public String compose(String ... components) {
        return this.normalize(Arrays.stream(components).filter(x -> !x.isEmpty()).collect(Collectors.joining("/")));
    }

    default public String parent(String path) {
        String removeTrailingSlash = path.replaceAll("/+$", "");
        return this.normalize(N5URI.getAsUri(removeTrailingSlash).resolve("").toString());
    }

    default public String relativize(String path, String base) {
        try {
            return this.normalize(this.uri("/" + base).relativize(this.uri("/" + path)).toString());
        }
        catch (URISyntaxException e) {
            throw new N5Exception("Cannot relativize path (" + path + ") with base (" + base + ")", e);
        }
    }

    public String normalize(String var1);

    default public URI uri(String uriString) throws URISyntaxException {
        try {
            return URI.create(uriString);
        }
        catch (Exception ignore) {
            return N5URI.encodeAsUri(uriString);
        }
    }

    public boolean exists(String var1);

    public boolean isDirectory(String var1);

    public boolean isFile(String var1);

    public LockedChannel lockForReading(String var1) throws IOException;

    public LockedChannel lockForWriting(String var1) throws IOException;

    public String[] listDirectories(String var1) throws IOException;

    public String[] list(String var1) throws IOException;

    public void createDirectories(String var1) throws IOException;

    public void delete(String var1) throws IOException;
}

