/*
 * Decompiled with CFR 0.152.
 */
package vib;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.plugin.filter.PlugInFilter;
import ij.plugin.filter.ThresholdToSelection;
import ij.process.ImageProcessor;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;

public class Local_Threshold
implements PlugInFilter {
    private ImagePlus image;
    private static ImageProcessor copy;
    private static int lastMinThreshold;
    private static int lastMaxThreshold;

    public void run(final ImageProcessor ip) {
        if (this.image.getRoi() == null) {
            IJ.error((String)"Selection required");
            return;
        }
        Roi roiCopy = (Roi)this.image.getRoi().clone();
        copy = ip.duplicate();
        GenericDialog gd = new GenericDialog("Adjust local threshold");
        gd.addSlider("min value", 0.0, 255.0, (double)lastMinThreshold);
        gd.addSlider("max value", 0.0, 255.0, (double)lastMaxThreshold);
        final Scrollbar minSlider = (Scrollbar)gd.getSliders().get(0);
        final Scrollbar maxSlider = (Scrollbar)gd.getSliders().get(1);
        AdjustmentListener listener = new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                Local_Threshold.applyThreshold(ip, Local_Threshold.this.image.getRoi(), minSlider.getValue(), maxSlider.getValue());
                lastMinThreshold = minSlider.getValue();
                lastMaxThreshold = maxSlider.getValue();
                Local_Threshold.this.image.updateAndDraw();
            }
        };
        minSlider.addAdjustmentListener(listener);
        maxSlider.addAdjustmentListener(listener);
        Local_Threshold.applyThreshold(ip, this.image.getRoi(), lastMinThreshold, lastMaxThreshold);
        this.image.updateAndDraw();
        gd.showDialog();
        ip.setRoi(this.image.getRoi());
        ImageProcessor newip = ip.crop();
        newip.setThreshold(255.0, 255.0, 2);
        ImagePlus tmp = new ImagePlus("", newip);
        ThresholdToSelection ts = new ThresholdToSelection();
        ts.setup("", tmp);
        ts.run(newip);
        newip.resetThreshold();
        ip.insert(copy, 0, 0);
        Rectangle roiCopyR = roiCopy.getBounds();
        if (tmp.getRoi() != null) {
            int yl;
            int xl;
            Rectangle roiTempR = tmp.getRoi().getBounds();
            int n = xl = roiCopyR.x > 0 ? roiCopyR.x : 0;
            if (roiTempR.x > 0) {
                xl += roiTempR.x;
            }
            int n2 = yl = roiCopyR.y > 0 ? roiCopyR.y : 0;
            if (roiTempR.y > 0) {
                yl += roiTempR.y;
            }
            tmp.getRoi().setLocation(xl, yl);
            this.image.setRoi(tmp.getRoi());
        }
    }

    public static void applyThreshold(ImageProcessor ip, Roi roi, int min, int max) {
        boolean mustCleanUp;
        if (roi == null) {
            IJ.error((String)"Selection required");
            return;
        }
        boolean bl = mustCleanUp = copy == null;
        if (copy == null) {
            copy = ip.duplicate();
        }
        byte[] p = (byte[])ip.getPixels();
        byte[] c = (byte[])copy.getPixels();
        int w = ip.getWidth();
        int h = ip.getHeight();
        Rectangle bounds = roi.getBounds();
        int x1 = bounds.x > 0 ? bounds.x : 0;
        int y1 = bounds.y > 0 ? bounds.y : 0;
        int x2 = x1 + bounds.width <= w ? x1 + bounds.width : w;
        int y2 = y1 + bounds.height <= h ? y1 + bounds.height : h;
        for (int y = y1; y < y2; ++y) {
            for (int x = x1; x < x2; ++x) {
                if (!roi.contains(x, y)) continue;
                int index = y * ip.getWidth() + x;
                p[index] = (c[index] & 0xFF) >= min && (c[index] & 0xFF) <= max ? -1 : c[index];
            }
        }
        if (mustCleanUp) {
            copy = null;
        }
    }

    public int setup(String args, ImagePlus imp) {
        this.image = imp;
        return 1;
    }

    static {
        lastMinThreshold = 10;
        lastMaxThreshold = 255;
    }
}

