/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.cellCounter;

import ij.IJ;
import java.awt.Color;
import java.awt.Point;
import java.util.ListIterator;
import java.util.Vector;
import org.scijava.Context;
import org.scijava.options.OptionsService;
import sc.fiji.cellCounter.CellCntrMarker;
import sc.fiji.cellCounter.CellCounterOptions;

public class CellCntrMarkerVector
extends Vector<CellCntrMarker> {
    private int type;
    private String name;

    public CellCntrMarkerVector(int type) {
        this(type, "<Unnamed>");
    }

    public CellCntrMarkerVector(int type, String name) {
        this.type = type;
        this.name = name;
    }

    public void addMarker(CellCntrMarker marker) {
        this.add(marker);
    }

    public CellCntrMarker getMarker(int n) {
        return (CellCntrMarker)this.get(n);
    }

    public int getVectorIndex(CellCntrMarker marker) {
        return this.indexOf(marker);
    }

    public void removeMarker(int n) {
        this.remove(n);
    }

    public void removeLastMarker() {
        super.removeElementAt(this.size() - 1);
    }

    public CellCntrMarker getMarkerFromPosition(Point p, int sliceIndex) {
        Vector<CellCntrMarker> v = new Vector<CellCntrMarker>();
        ListIterator it = this.listIterator();
        while (it.hasNext()) {
            CellCntrMarker m = (CellCntrMarker)it.next();
            if (m.getZ() != sliceIndex) continue;
            v.add(m);
        }
        CellCntrMarker currentsmallest = (CellCntrMarker)v.get(0);
        for (int i = 1; i < v.size(); ++i) {
            boolean closer;
            CellCntrMarker m2 = (CellCntrMarker)v.get(i);
            Point p1 = new Point(currentsmallest.getX(), currentsmallest.getY());
            Point p2 = new Point(m2.getX(), m2.getY());
            boolean bl = closer = Math.abs(p1.distance(p)) > Math.abs(p2.distance(p));
            if (!closer) continue;
            currentsmallest = m2;
        }
        return currentsmallest;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Color getColor() {
        Context c = (Context)IJ.runPlugIn((String)"org.scijava.Context", (String)"");
        OptionsService optionsService = (OptionsService)c.service(OptionsService.class);
        CellCounterOptions options = (CellCounterOptions)optionsService.getOptions(CellCounterOptions.class);
        return options.getColor(this.type);
    }
}

