/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.analyzeSkeleton;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import sc.fiji.analyzeSkeleton.Edge;
import sc.fiji.analyzeSkeleton.Point;

public class Vertex {
    private ArrayList<Point> points = new ArrayList();
    private ArrayList<Edge> branches = new ArrayList();
    private boolean visited = false;
    private Edge precedessor = null;
    private int visitOrder = -1;

    public void addPoint(Point p) {
        this.points.add(p);
    }

    public boolean isVertexPoint(Point p) {
        return this.points != null && this.points.contains(p);
    }

    public String pointsToString() {
        StringBuilder sb = new StringBuilder();
        for (Point p : this.points) {
            sb.append(p.toString()).append(" ");
        }
        return sb.toString();
    }

    public ArrayList<Point> getPoints() {
        return this.points;
    }

    public void setBranch(Edge e) {
        this.branches.add(e);
    }

    public ArrayList<Edge> getBranches() {
        return this.branches;
    }

    public void setVisited(boolean b) {
        this.visited = b;
    }

    public void setVisited(boolean b, int visitOrder) {
        this.visited = b;
        this.visitOrder = visitOrder;
    }

    public boolean isVisited() {
        return this.visited;
    }

    public void setPredecessor(Edge pred) {
        this.precedessor = pred;
    }

    public Edge getPredecessor() {
        return this.precedessor;
    }

    public int getVisitOrder() {
        return this.visitOrder;
    }

    public Vertex cloneUnconnected() {
        Vertex clone = new Vertex();
        clone.setVisited(this.visited, this.visitOrder);
        List clonedPoints = this.points.stream().map(Point::clone).collect(Collectors.toList());
        clone.points.addAll(clonedPoints);
        return clone;
    }
}

