/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.action.closegaps;

import fiji.plugin.trackmate.Logger;
import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.Settings;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.TrackMate;
import fiji.plugin.trackmate.TrackModel;
import fiji.plugin.trackmate.detection.DetectionUtils;
import fiji.plugin.trackmate.util.TMUtils;
import ij.gui.Roi;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import org.jgrapht.graph.DefaultWeightedEdge;

public interface GapClosingMethod {
    default public List<GapClosingParameter> getParameters() {
        return Collections.emptyList();
    }

    public String getInfoText();

    public void execute(TrackMate var1, Logger var2);

    public static List<DefaultWeightedEdge> getAllGaps(Model model) {
        ArrayList<DefaultWeightedEdge> gaps = new ArrayList<DefaultWeightedEdge>();
        TrackModel trackModel = model.getTrackModel();
        for (Integer trackID : trackModel.trackIDs(true)) {
            Set<DefaultWeightedEdge> edges = trackModel.trackEdges(trackID);
            for (DefaultWeightedEdge edge : edges) {
                Spot source = trackModel.getEdgeSource(edge);
                int st = source.getFeature("FRAME").intValue();
                Spot target = trackModel.getEdgeTarget(edge);
                int tt = target.getFeature("FRAME").intValue();
                if (Math.abs(tt - st) <= 1) continue;
                gaps.add(edge);
            }
        }
        return gaps;
    }

    public static List<Spot> interpolate(Model model, DefaultWeightedEdge edge) {
        TrackModel trackModel = model.getTrackModel();
        Spot source = trackModel.getEdgeSource(edge);
        double[] sPos = new double[3];
        source.localize(sPos);
        int st = source.getFeature("FRAME").intValue();
        Spot target = trackModel.getEdgeTarget(edge);
        double[] tPos = new double[3];
        target.localize(tPos);
        int tt = target.getFeature("FRAME").intValue();
        ArrayList<Spot> interpolatedSpots = new ArrayList<Spot>(Math.abs(tt - st) - 1);
        int presign = tt > st ? 1 : -1;
        for (int f = st + presign; f < tt && presign == 1 || f > tt && presign == -1; f += presign) {
            double weight = (double)(tt - f) / (double)(tt - st);
            double[] position = new double[3];
            for (int d = 0; d < 3; ++d) {
                position[d] = weight * sPos[d] + (1.0 - weight) * tPos[d];
            }
            RealPoint rp = new RealPoint(position);
            Spot newSpot = new Spot((RealLocalizable)rp, 0.0, 0.0);
            newSpot.putFeature("FRAME", Double.valueOf(f));
            GapClosingMethod.interpolateFeature(newSpot, source, target, weight, "RADIUS");
            GapClosingMethod.interpolateFeature(newSpot, source, target, weight, "QUALITY");
            GapClosingMethod.interpolateFeature(newSpot, source, target, weight, "POSITION_T");
            interpolatedSpots.add(newSpot);
        }
        return interpolatedSpots;
    }

    public static void interpolateFeature(Spot targetSpot, Spot spot1, Spot spot2, double weight, String feature) {
        if (targetSpot.getFeatures().containsKey(feature)) {
            targetSpot.getFeatures().remove(feature);
        }
        targetSpot.getFeatures().put(feature, weight * spot1.getFeature(feature) + (1.0 - weight) * spot2.getFeature(feature));
    }

    public static Settings makeSettingsForRoiAround(Spot spot, double neighborhoodFactor, Settings settings) {
        int t;
        double[] cal = TMUtils.getSpatialCalibration(settings.imp);
        double dx = cal[0];
        double dy = cal[1];
        double dz = cal[2];
        double[] location = new double[3];
        spot.localize(location);
        double radius = spot.getFeature("RADIUS");
        long x = Math.round(location[0] / dx);
        long y = Math.round(location[1] / dy);
        long z = Math.round(location[2] / dz);
        long r = (long)Math.ceil(neighborhoodFactor * radius / dx);
        long rz = (long)Math.abs(Math.ceil(neighborhoodFactor * radius / dz));
        long width = settings.imp.getWidth();
        long height = settings.imp.getHeight();
        long x0 = Math.max(0L, x - r);
        long y0 = Math.max(0L, y - r);
        long x1 = Math.min(width - 1L, x + r);
        long y1 = Math.min(height - 1L, y + r);
        Settings settingsCopy = settings.copyOn(settings.imp);
        settingsCopy.setRoi(new Roi((double)x0, (double)y0, (double)(x1 - x0), (double)(y1 - y0)));
        settingsCopy.tstart = t = spot.getFeature("FRAME").intValue();
        settingsCopy.tend = t;
        if (!DetectionUtils.is2D(settings.imp)) {
            long depth = settings.imp.getNSlices();
            long z0 = Math.max(0L, z - rz);
            long z1 = Math.min(depth - 1L, z + rz);
            settingsCopy.zstart = (int)z0;
            settingsCopy.zend = (int)z1;
        }
        return settingsCopy;
    }

    public static int countMissingSpots(Collection<DefaultWeightedEdge> gaps, Model model) {
        int nSpots = 0;
        for (DefaultWeightedEdge gap : gaps) {
            nSpots += GapClosingMethod.countMissingSpots(gap, model);
        }
        return nSpots;
    }

    public static int countMissingSpots(DefaultWeightedEdge gap, Model model) {
        TrackModel trackModel = model.getTrackModel();
        Spot source = trackModel.getEdgeSource(gap);
        int st = source.getFeature("FRAME").intValue();
        Spot target = trackModel.getEdgeTarget(gap);
        int tt = target.getFeature("FRAME").intValue();
        return Math.abs(tt - st) - 1;
    }

    public static class GapClosingParameter {
        public final String name;
        public double value;
        public final double minValue;
        public final double maxValue;

        public GapClosingParameter(String name, double value, double minValue, double maxValue) {
            this.name = name;
            this.value = value;
            this.minValue = minValue;
            this.maxValue = maxValue;
        }
    }
}

