/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.gui.components;

import fiji.plugin.trackmate.TrackMateModule;
import fiji.plugin.trackmate.gui.Fonts;
import fiji.plugin.trackmate.gui.GuiUtils;
import fiji.plugin.trackmate.providers.AbstractProvider;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;

public class ModuleChooserPanel<K extends TrackMateModule>
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final AbstractProvider<K> provider;
    private final JComboBox<String> cmbbox;

    public ModuleChooserPanel(AbstractProvider<K> provider, String typeName, String selectedKey) {
        this.provider = provider;
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{430, 0};
        gridBagLayout.rowHeights = new int[]{16, 27, 209, 0};
        gridBagLayout.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 1.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        JLabel lblHeader = new JLabel();
        GridBagConstraints gbcLblHeader = new GridBagConstraints();
        gbcLblHeader.fill = 1;
        gbcLblHeader.insets = new Insets(5, 5, 5, 5);
        gbcLblHeader.gridx = 0;
        gbcLblHeader.gridy = 0;
        this.add((Component)lblHeader, gbcLblHeader);
        lblHeader.setFont(Fonts.BIG_FONT);
        lblHeader.setText("<html>Select " + (ModuleChooserPanel.startWithVowel(typeName) ? "an " : "a ") + "<b>" + typeName + "</b></html>");
        this.cmbbox = new JComboBox();
        this.cmbbox.setModel(new DefaultComboBoxModel<String>(provider.getVisibleKeys().toArray(new String[0])));
        this.cmbbox.setRenderer(new MyListCellRenderer());
        GridBagConstraints gbcCmbbox = new GridBagConstraints();
        gbcCmbbox.fill = 1;
        gbcCmbbox.insets = new Insets(5, 5, 5, 5);
        gbcCmbbox.gridx = 0;
        gbcCmbbox.gridy = 1;
        this.add(this.cmbbox, gbcCmbbox);
        this.cmbbox.setFont(Fonts.FONT);
        JEditorPane info = GuiUtils.infoDisplay();
        GridBagConstraints gbcLblInfo = new GridBagConstraints();
        gbcLblInfo.insets = new Insets(5, 5, 5, 5);
        gbcLblInfo.fill = 1;
        gbcLblInfo.gridx = 0;
        gbcLblInfo.gridy = 2;
        this.add((Component)GuiUtils.textInScrollPanel(info), gbcLblInfo);
        this.cmbbox.addActionListener(e -> {
            Object factory = provider.getFactory((String)this.cmbbox.getSelectedItem());
            info.setText(factory.getInfoText());
        });
        this.cmbbox.setSelectedItem(selectedKey);
    }

    public void setSelectedModuleKey(String moduleKey) {
        this.cmbbox.setSelectedItem(moduleKey);
    }

    public String getSelectedModuleKey() {
        return (String)this.cmbbox.getSelectedItem();
    }

    private static final boolean startWithVowel(String word) {
        return "eaiouEAIOU".indexOf(word.charAt(0)) >= 0;
    }

    private final class MyListCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        private MyListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel lbl = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            String key = (String)value;
            Object factory = ModuleChooserPanel.this.provider.getFactory(key);
            lbl.setIcon(factory.getIcon());
            lbl.setText(factory.getName());
            return lbl;
        }
    }
}

