/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.gui.components.tracker;

import fiji.plugin.trackmate.gui.Fonts;
import fiji.plugin.trackmate.gui.GuiUtils;
import fiji.plugin.trackmate.gui.components.tracker.JPanelFeatureSelectionGui;
import fiji.plugin.trackmate.tracking.TrackerKeys;
import fiji.plugin.trackmate.tracking.jaqaman.LAPUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseWheelListener;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class JPanelAdvancedKalmanTrackerSettingsMain
extends JPanel {
    private static final long serialVersionUID = -1L;
    private final JLabel lblSplittingMaxDistanceUnit;
    private final JFormattedTextField txtfldSplittingMaxDistance;
    private final JCheckBox chkboxAllowSplitting;
    private final JPanelFeatureSelectionGui panelMergingFeatures;
    private final JPanelFeatureSelectionGui panelKalmanFeatures;
    private final JPanelFeatureSelectionGui panelSplittingFeatures;
    private final JScrollPane scrpneMergingFeatures;
    private final JLabel lblMergingMaxDistanceUnit;
    private final JFormattedTextField txtfldMergingMaxDistance;
    private final JCheckBox chkboxAllowMerging;
    private final JScrollPane scrpneSplittingFeatures;
    private final JLabel lblMaxFrameGapUnits;
    private final JLabel lblSearchRadiusUnits;
    private final JLabel lblInitialSearchRadiusUnits;
    private final JFormattedTextField txtfldMaxFrameGap;
    private final JFormattedTextField txtfldSearchRadius;
    private final JFormattedTextField txtfldInitialSearchRadius;
    private final JLabel lbl10;
    private final JLabel lbl15;
    private final JLabel lbl13;
    private final JLabel lbl16;

    public JPanelAdvancedKalmanTrackerSettingsMain(String trackerName, String spaceUnits, Collection<String> features, Map<String, String> featureNames) {
        DecimalFormat decimalFormat = new DecimalFormat("0.0");
        DecimalFormat integerFormat = new DecimalFormat("0");
        this.setPreferredSize(new Dimension(280, 1000));
        GridBagLayout thisLayout = new GridBagLayout();
        thisLayout.columnWidths = new int[]{180, 50, 50};
        thisLayout.columnWeights = new double[]{0.1, 0.8, 0.1};
        thisLayout.rowHeights = new int[]{10, 10, 10, 15, 15, 15, 15, 15, 95, 10, 15, 15, 15, 15, 95, 10, 15, 15, 15, 15, 95, 15};
        thisLayout.rowWeights = new double[]{0.0, 0.15, 0.1, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.1, 0.01, 0.01, 0.01, 0.01, 0.01, 0.1, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.6};
        this.setLayout(thisLayout);
        JLabel jLabel1 = new JLabel();
        this.add((Component)jLabel1, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 17, 2, new Insets(10, 10, 0, 0), 0, 0));
        jLabel1.setText("Settings for tracker:");
        jLabel1.setFont(Fonts.FONT);
        JLabel lblTrackerName = new JLabel();
        this.add((Component)lblTrackerName, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        lblTrackerName.setHorizontalTextPosition(0);
        lblTrackerName.setHorizontalAlignment(0);
        lblTrackerName.setFont(Fonts.BIG_FONT);
        lblTrackerName.setText(trackerName);
        int ycur = 2;
        JLabel lbl2 = new JLabel();
        this.add((Component)lbl2, new GridBagConstraints(0, ycur, 3, 1, 0.0, 0.0, 17, 2, new Insets(0, 10, 0, 10), 0, 0));
        lbl2.setText("Frame to frame linking:");
        lbl2.setFont(Fonts.BIG_FONT.deriveFont(1));
        JLabel lbl3 = new JLabel();
        this.add((Component)lbl3, new GridBagConstraints(0, ++ycur, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 10, 0, 10), 0, 0));
        lbl3.setText("Initial search radius:");
        lbl3.setFont(Fonts.SMALL_FONT);
        this.txtfldInitialSearchRadius = new JFormattedTextField(decimalFormat);
        this.add((Component)this.txtfldInitialSearchRadius, new GridBagConstraints(1, ycur, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.txtfldInitialSearchRadius.setFont(Fonts.SMALL_FONT);
        this.txtfldInitialSearchRadius.setSize(Fonts.TEXTFIELD_DIMENSION);
        this.txtfldInitialSearchRadius.setHorizontalAlignment(0);
        this.lblInitialSearchRadiusUnits = new JLabel();
        this.add((Component)this.lblInitialSearchRadiusUnits, new GridBagConstraints(2, ycur, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.lblInitialSearchRadiusUnits.setFont(Fonts.SMALL_FONT);
        this.lblInitialSearchRadiusUnits.setText(spaceUnits);
        JLabel lbl3b = new JLabel();
        this.add((Component)lbl3b, new GridBagConstraints(0, ++ycur, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 10, 0, 10), 0, 0));
        lbl3b.setText("Search radius:");
        lbl3b.setFont(Fonts.SMALL_FONT);
        this.txtfldSearchRadius = new JFormattedTextField(decimalFormat);
        this.add((Component)this.txtfldSearchRadius, new GridBagConstraints(1, ycur, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.txtfldSearchRadius.setFont(Fonts.SMALL_FONT);
        this.txtfldSearchRadius.setSize(Fonts.TEXTFIELD_DIMENSION);
        this.txtfldSearchRadius.setHorizontalAlignment(0);
        this.lblSearchRadiusUnits = new JLabel();
        this.add((Component)this.lblSearchRadiusUnits, new GridBagConstraints(2, ycur, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.lblSearchRadiusUnits.setFont(Fonts.SMALL_FONT);
        this.lblSearchRadiusUnits.setText(spaceUnits);
        JLabel lbl3c = new JLabel();
        this.add((Component)lbl3c, new GridBagConstraints(0, ++ycur, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 10, 0, 10), 0, 0));
        lbl3c.setText("Max Frame Gap:");
        lbl3c.setFont(Fonts.SMALL_FONT);
        this.txtfldMaxFrameGap = new JFormattedTextField(integerFormat);
        this.add((Component)this.txtfldMaxFrameGap, new GridBagConstraints(1, ycur, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.txtfldMaxFrameGap.setFont(Fonts.SMALL_FONT);
        this.txtfldMaxFrameGap.setSize(Fonts.TEXTFIELD_DIMENSION);
        this.txtfldMaxFrameGap.setHorizontalAlignment(0);
        this.lblMaxFrameGapUnits = new JLabel("frames");
        this.add((Component)this.lblMaxFrameGapUnits, new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.lblMaxFrameGapUnits.setFont(Fonts.SMALL_FONT);
        JLabel lbl4 = new JLabel();
        this.add((Component)lbl4, new GridBagConstraints(0, ycur += 2, 3, 1, 0.0, 0.0, 10, 2, new Insets(0, 10, 0, 10), 0, 0));
        lbl4.setText("Feature penalties:");
        lbl4.setFont(Fonts.SMALL_FONT);
        JScrollPane scrpneLinkingFeatures = new JScrollPane();
        MouseWheelListener[] l = scrpneLinkingFeatures.getMouseWheelListeners();
        scrpneLinkingFeatures.removeMouseWheelListener(l[0]);
        this.add((Component)scrpneLinkingFeatures, new GridBagConstraints(0, ++ycur, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        scrpneLinkingFeatures.setHorizontalScrollBarPolicy(31);
        scrpneLinkingFeatures.setVerticalScrollBarPolicy(22);
        this.panelKalmanFeatures = new JPanelFeatureSelectionGui();
        this.panelKalmanFeatures.setDisplayFeatures(features, featureNames);
        scrpneLinkingFeatures.setViewportView(this.panelKalmanFeatures);
        JLabel lbl9 = new JLabel();
        this.add((Component)lbl9, new GridBagConstraints(0, ++ycur, 3, 1, 0.0, 0.0, 10, 2, new Insets(20, 10, 0, 10), 0, 0));
        lbl9.setText("Track segment splitting:");
        lbl9.setFont(Fonts.BIG_FONT.deriveFont(1));
        this.chkboxAllowSplitting = new JCheckBox();
        this.add((Component)this.chkboxAllowSplitting, new GridBagConstraints(0, ++ycur, 3, 1, 0.0, 0.0, 10, 2, new Insets(0, 10, 0, 10), 0, 0));
        this.chkboxAllowSplitting.setText("Allow track segment splitting");
        this.chkboxAllowSplitting.setFont(Fonts.SMALL_FONT);
        this.lbl10 = new JLabel();
        this.add((Component)this.lbl10, new GridBagConstraints(0, ++ycur, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 10, 0, 0), 0, 0));
        this.lbl10.setText("Max distance:");
        this.lbl10.setFont(Fonts.SMALL_FONT);
        this.txtfldSplittingMaxDistance = new JFormattedTextField(decimalFormat);
        this.add((Component)this.txtfldSplittingMaxDistance, new GridBagConstraints(1, ycur, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.txtfldSplittingMaxDistance.setSize(Fonts.TEXTFIELD_DIMENSION);
        this.txtfldSplittingMaxDistance.setFont(Fonts.SMALL_FONT);
        this.txtfldSplittingMaxDistance.setHorizontalAlignment(0);
        this.lblSplittingMaxDistanceUnit = new JLabel();
        this.add((Component)this.lblSplittingMaxDistanceUnit, new GridBagConstraints(2, ycur, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.lblSplittingMaxDistanceUnit.setFont(Fonts.SMALL_FONT);
        this.lblSplittingMaxDistanceUnit.setText(spaceUnits);
        this.lbl15 = new JLabel();
        this.add((Component)this.lbl15, new GridBagConstraints(0, ycur += 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 10, 0, 10), 0, 0));
        this.lbl15.setText("Feature penalties:");
        this.lbl15.setFont(Fonts.SMALL_FONT);
        this.scrpneSplittingFeatures = new JScrollPane();
        MouseWheelListener[] l2 = this.scrpneSplittingFeatures.getMouseWheelListeners();
        this.scrpneSplittingFeatures.removeMouseWheelListener(l2[0]);
        this.add((Component)this.scrpneSplittingFeatures, new GridBagConstraints(0, ++ycur, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.scrpneSplittingFeatures.setHorizontalScrollBarPolicy(31);
        this.scrpneSplittingFeatures.setVerticalScrollBarPolicy(22);
        this.panelSplittingFeatures = new JPanelFeatureSelectionGui();
        this.panelSplittingFeatures.setDisplayFeatures(features, featureNames);
        this.scrpneSplittingFeatures.setViewportView(this.panelSplittingFeatures);
        JLabel lbl12 = new JLabel();
        this.add((Component)lbl12, new GridBagConstraints(0, ++ycur, 3, 1, 0.0, 0.0, 10, 2, new Insets(20, 10, 0, 10), 0, 0));
        lbl12.setText("Track segment merging:");
        lbl12.setFont(Fonts.BIG_FONT.deriveFont(1));
        this.chkboxAllowMerging = new JCheckBox();
        this.add((Component)this.chkboxAllowMerging, new GridBagConstraints(0, ++ycur, 3, 1, 0.0, 0.0, 10, 2, new Insets(0, 10, 0, 10), 0, 0));
        this.chkboxAllowMerging.setText("Allow track segment merging");
        this.chkboxAllowMerging.setFont(Fonts.SMALL_FONT);
        this.lbl13 = new JLabel();
        this.add((Component)this.lbl13, new GridBagConstraints(0, ++ycur, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 10, 0, 0), 0, 0));
        this.lbl13.setText("Max distance:");
        this.lbl13.setFont(Fonts.SMALL_FONT);
        this.txtfldMergingMaxDistance = new JFormattedTextField(decimalFormat);
        this.add((Component)this.txtfldMergingMaxDistance, new GridBagConstraints(1, ycur, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.txtfldMergingMaxDistance.setSize(Fonts.TEXTFIELD_DIMENSION);
        this.txtfldMergingMaxDistance.setFont(Fonts.SMALL_FONT);
        this.txtfldMergingMaxDistance.setHorizontalAlignment(0);
        this.lblMergingMaxDistanceUnit = new JLabel();
        this.add((Component)this.lblMergingMaxDistanceUnit, new GridBagConstraints(2, ycur, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.lblMergingMaxDistanceUnit.setFont(Fonts.SMALL_FONT);
        this.lblMergingMaxDistanceUnit.setText(spaceUnits);
        this.lbl16 = new JLabel();
        this.add((Component)this.lbl16, new GridBagConstraints(0, ycur += 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 10, 0, 10), 0, 0));
        this.lbl16.setText("Feature penalties:");
        this.lbl16.setFont(Fonts.SMALL_FONT);
        this.scrpneMergingFeatures = new JScrollPane();
        MouseWheelListener[] l3 = this.scrpneMergingFeatures.getMouseWheelListeners();
        this.scrpneMergingFeatures.removeMouseWheelListener(l3[0]);
        this.add((Component)this.scrpneMergingFeatures, new GridBagConstraints(0, ++ycur, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.scrpneMergingFeatures.setHorizontalScrollBarPolicy(31);
        this.scrpneMergingFeatures.setVerticalScrollBarPolicy(22);
        this.panelMergingFeatures = new JPanelFeatureSelectionGui();
        this.panelMergingFeatures.setDisplayFeatures(features, featureNames);
        this.scrpneMergingFeatures.setViewportView(this.panelMergingFeatures);
        GuiUtils.selectAllOnFocus(this.txtfldInitialSearchRadius);
        GuiUtils.selectAllOnFocus(this.txtfldMaxFrameGap);
        GuiUtils.selectAllOnFocus(this.txtfldSearchRadius);
        GuiUtils.selectAllOnFocus(this.txtfldMergingMaxDistance);
        GuiUtils.selectAllOnFocus(this.txtfldSplittingMaxDistance);
        this.chkboxAllowSplitting.addActionListener(e -> this.setEnabled(new Component[]{this.lbl10, this.txtfldSplittingMaxDistance, this.lblSplittingMaxDistanceUnit, this.lbl15, this.scrpneSplittingFeatures, this.panelSplittingFeatures}, this.chkboxAllowSplitting.isSelected()));
        this.chkboxAllowMerging.addActionListener(e -> this.setEnabled(new Component[]{this.lbl13, this.txtfldMergingMaxDistance, this.lblMergingMaxDistanceUnit, this.lbl16, this.scrpneMergingFeatures, this.panelMergingFeatures}, this.chkboxAllowMerging.isSelected()));
    }

    void echoSettings(Map<String, Object> settings) {
        this.txtfldInitialSearchRadius.setValue(settings.get("LINKING_MAX_DISTANCE"));
        if (settings.get("KALMAN_SEARCH_RADIUS") == null) {
            this.txtfldSearchRadius.setValue(20.0);
        } else {
            this.txtfldSearchRadius.setValue(settings.get("KALMAN_SEARCH_RADIUS"));
        }
        this.txtfldMaxFrameGap.setValue(settings.get("MAX_FRAME_GAP"));
        this.panelKalmanFeatures.setSelectedFeaturePenalties((Map)settings.get("LINKING_FEATURE_PENALTIES"));
        this.chkboxAllowSplitting.setSelected((Boolean)settings.get("ALLOW_TRACK_SPLITTING"));
        this.txtfldSplittingMaxDistance.setValue(settings.get("SPLITTING_MAX_DISTANCE"));
        this.panelSplittingFeatures.setSelectedFeaturePenalties((Map)settings.get("SPLITTING_FEATURE_PENALTIES"));
        this.chkboxAllowMerging.setSelected((Boolean)settings.get("ALLOW_TRACK_MERGING"));
        this.txtfldMergingMaxDistance.setValue(settings.get("MERGING_MAX_DISTANCE"));
        this.panelMergingFeatures.setSelectedFeaturePenalties((Map)settings.get("MERGING_FEATURE_PENALTIES"));
        this.setEnabled(new Component[]{this.lbl10, this.txtfldSplittingMaxDistance, this.lblSplittingMaxDistanceUnit, this.lbl15, this.scrpneSplittingFeatures, this.panelSplittingFeatures}, this.chkboxAllowSplitting.isSelected());
        this.setEnabled(new Component[]{this.lbl13, this.txtfldMergingMaxDistance, this.lblMergingMaxDistanceUnit, this.lbl16, this.scrpneMergingFeatures, this.panelMergingFeatures}, this.chkboxAllowMerging.isSelected());
    }

    public Map<String, Object> getSettings() {
        Map<String, Object> settings = JPanelAdvancedKalmanTrackerSettingsMain.getDefaultKalmanSettingsMap();
        settings.put("LINKING_MAX_DISTANCE", ((Number)this.txtfldInitialSearchRadius.getValue()).doubleValue());
        settings.put("KALMAN_SEARCH_RADIUS", ((Number)this.txtfldSearchRadius.getValue()).doubleValue());
        settings.put("MAX_FRAME_GAP", ((Number)this.txtfldMaxFrameGap.getValue()).intValue());
        settings.put("LINKING_FEATURE_PENALTIES", this.panelKalmanFeatures.getFeaturePenalties());
        settings.put("ALLOW_GAP_CLOSING", false);
        settings.put("ALLOW_TRACK_SPLITTING", this.chkboxAllowSplitting.isSelected());
        settings.put("SPLITTING_MAX_DISTANCE", ((Number)this.txtfldSplittingMaxDistance.getValue()).doubleValue());
        settings.put("SPLITTING_FEATURE_PENALTIES", this.panelSplittingFeatures.getFeaturePenalties());
        settings.put("ALLOW_TRACK_MERGING", this.chkboxAllowMerging.isSelected());
        settings.put("MERGING_MAX_DISTANCE", ((Number)this.txtfldMergingMaxDistance.getValue()).doubleValue());
        settings.put("MERGING_FEATURE_PENALTIES", this.panelMergingFeatures.getFeaturePenalties());
        return settings;
    }

    public static final Map<String, Object> getDefaultKalmanSettingsMap() {
        Map<String, Object> settings = LAPUtils.getDefaultSegmentSettingsMap();
        settings.put("LINKING_MAX_DISTANCE", 15.0);
        settings.put("KALMAN_SEARCH_RADIUS", 20.0);
        settings.put("LINKING_FEATURE_PENALTIES", new HashMap<String, Double>(TrackerKeys.DEFAULT_LINKING_FEATURE_PENALTIES));
        return settings;
    }

    private void setEnabled(Component[] components, boolean enable) {
        for (Component component : components) {
            component.setEnabled(enable);
        }
    }
}

