/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.gui.components.tracker;

import fiji.plugin.trackmate.gui.Fonts;
import fiji.plugin.trackmate.gui.GuiUtils;
import fiji.plugin.trackmate.gui.components.ConfigurationPanel;
import fiji.plugin.trackmate.tracking.TrackerKeys;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;

public class SimpleLAPTrackerSettingsPanel
extends ConfigurationPanel {
    private static final long serialVersionUID = -1L;
    private final JFormattedTextField txtfldGapClosingTimeCutoff;
    private final JFormattedTextField txtfldGapClosingDistanceCutoff;
    private final JFormattedTextField txtfldLinkingDistance;

    public SimpleLAPTrackerSettingsPanel(String trackerName, String infoText, String spaceUnits) {
        DecimalFormat decimalFormat = new DecimalFormat("0.0");
        this.setPreferredSize(new Dimension(300, 500));
        GridBagLayout thisLayout = new GridBagLayout();
        thisLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0};
        thisLayout.rowHeights = new int[]{31, 50, 119, 7, 50, 50, 50, 50};
        thisLayout.columnWeights = new double[]{0.0, 0.0, 0.1};
        thisLayout.columnWidths = new int[]{203, 42, 7};
        this.setLayout(thisLayout);
        JLabel lbl1 = new JLabel();
        this.add((Component)lbl1, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 17, 2, new Insets(0, 10, 0, 10), 0, 0));
        lbl1.setFont(Fonts.FONT);
        lbl1.setText("Settings for tracker:");
        JLabel lblTrackerName = new JLabel();
        this.add((Component)lblTrackerName, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 21, 0, new Insets(10, 20, 0, 0), 0, 0));
        lblTrackerName.setHorizontalTextPosition(0);
        lblTrackerName.setHorizontalAlignment(0);
        lblTrackerName.setFont(Fonts.BIG_FONT);
        lblTrackerName.setText(trackerName);
        JLabel lblTrackerDescription = new JLabel();
        this.add((Component)lblTrackerDescription, new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
        lblTrackerDescription.setFont(Fonts.FONT.deriveFont(2));
        lblTrackerDescription.setText(infoText.replace("<br>", "").replace("<p>", "<p align=\"justify\">").replace("<html>", "<html><p align=\"justify\">"));
        JLabel lbl2 = new JLabel();
        this.add((Component)lbl2, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 10, 0, 0), 0, 0));
        lbl2.setFont(Fonts.FONT);
        lbl2.setText("Linking max distance:");
        JLabel lbl3 = new JLabel();
        this.add((Component)lbl3, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 10, 0, 0), 0, 0));
        lbl3.setFont(Fonts.FONT);
        lbl3.setText("Gap-closing max distance:");
        JLabel lbl4 = new JLabel();
        this.add((Component)lbl4, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 10, 0, 0), 0, 0));
        lbl4.setFont(Fonts.FONT);
        lbl4.setText("Gap-closing max frame gap:");
        this.txtfldLinkingDistance = new JFormattedTextField(decimalFormat);
        this.txtfldLinkingDistance.setMinimumSize(Fonts.TEXTFIELD_DIMENSION);
        this.add((Component)this.txtfldLinkingDistance, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.txtfldLinkingDistance.setFont(Fonts.FONT);
        this.txtfldLinkingDistance.setHorizontalAlignment(0);
        this.txtfldGapClosingDistanceCutoff = new JFormattedTextField(decimalFormat);
        this.txtfldGapClosingDistanceCutoff.setMinimumSize(Fonts.TEXTFIELD_DIMENSION);
        this.add((Component)this.txtfldGapClosingDistanceCutoff, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.txtfldGapClosingDistanceCutoff.setFont(Fonts.FONT);
        this.txtfldGapClosingDistanceCutoff.setHorizontalAlignment(0);
        this.txtfldGapClosingTimeCutoff = new JFormattedTextField((Object)2);
        this.txtfldGapClosingTimeCutoff.setMinimumSize(Fonts.TEXTFIELD_DIMENSION);
        this.add((Component)this.txtfldGapClosingTimeCutoff, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.txtfldGapClosingTimeCutoff.setFont(Fonts.FONT);
        this.txtfldGapClosingTimeCutoff.setHorizontalAlignment(0);
        JLabel lblMaxDistanceUnit = new JLabel();
        this.add((Component)lblMaxDistanceUnit, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 0, 0, 10), 0, 0));
        lblMaxDistanceUnit.setFont(Fonts.FONT);
        lblMaxDistanceUnit.setText(" " + spaceUnits);
        JLabel lblGapClosingMaxDistanceUnit = new JLabel();
        this.add((Component)lblGapClosingMaxDistanceUnit, new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 0, 0, 10), 0, 0));
        lblGapClosingMaxDistanceUnit.setFont(Fonts.FONT);
        lblGapClosingMaxDistanceUnit.setText(" " + spaceUnits);
        JLabel lblGapClosingTimeCutoffUnit = new JLabel();
        this.add((Component)lblGapClosingTimeCutoffUnit, new GridBagConstraints(2, 6, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 0, 0, 10), 0, 0));
        lblGapClosingTimeCutoffUnit.setFont(Fonts.FONT);
        GuiUtils.selectAllOnFocus(this.txtfldLinkingDistance);
        GuiUtils.selectAllOnFocus(this.txtfldGapClosingDistanceCutoff);
        GuiUtils.selectAllOnFocus(this.txtfldGapClosingTimeCutoff);
    }

    @Override
    public void setSettings(Map<String, Object> settings) {
        this.echoSettings(settings);
    }

    @Override
    public Map<String, Object> getSettings() {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        settings.put("LINKING_FEATURE_PENALTIES", TrackerKeys.DEFAULT_LINKING_FEATURE_PENALTIES);
        settings.put("ALLOW_GAP_CLOSING", true);
        settings.put("GAP_CLOSING_FEATURE_PENALTIES", TrackerKeys.DEFAULT_GAP_CLOSING_FEATURE_PENALTIES);
        settings.put("ALLOW_TRACK_SPLITTING", false);
        settings.put("SPLITTING_MAX_DISTANCE", 15.0);
        settings.put("SPLITTING_FEATURE_PENALTIES", TrackerKeys.DEFAULT_SPLITTING_FEATURE_PENALTIES);
        settings.put("ALLOW_TRACK_MERGING", false);
        settings.put("MERGING_MAX_DISTANCE", 15.0);
        settings.put("MERGING_FEATURE_PENALTIES", TrackerKeys.DEFAULT_MERGING_FEATURE_PENALTIES);
        settings.put("BLOCKING_VALUE", Double.POSITIVE_INFINITY);
        settings.put("ALTERNATIVE_LINKING_COST_FACTOR", 1.05);
        settings.put("CUTOFF_PERCENTILE", 0.9);
        settings.put("LINKING_MAX_DISTANCE", ((Number)this.txtfldLinkingDistance.getValue()).doubleValue());
        settings.put("GAP_CLOSING_MAX_DISTANCE", ((Number)this.txtfldGapClosingDistanceCutoff.getValue()).doubleValue());
        settings.put("MAX_FRAME_GAP", ((Number)this.txtfldGapClosingTimeCutoff.getValue()).intValue());
        return settings;
    }

    private void echoSettings(Map<String, Object> settings) {
        this.txtfldLinkingDistance.setValue(settings.get("LINKING_MAX_DISTANCE"));
        this.txtfldGapClosingDistanceCutoff.setValue(settings.get("GAP_CLOSING_MAX_DISTANCE"));
        this.txtfldGapClosingTimeCutoff.setValue(settings.get("MAX_FRAME_GAP"));
    }

    @Override
    public void clean() {
    }
}

