/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.util.cli;

import fiji.plugin.trackmate.util.cli.CLIConfigurator;
import fiji.plugin.trackmate.util.cli.CLIUtils;
import ij.IJ;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class CondaCLIConfigurator
extends CLIConfigurator {
    public static final String KEY_CONDA_ENV = "CONDA_ENV";
    private final CondaEnvironmentCommand condaEnv;

    protected CondaCLIConfigurator() {
        List<String> envList = CLIUtils.getEnvList();
        this.condaEnv = new CondaEnvironmentCommand();
        envList.forEach(this.condaEnv::addEnvironment);
        this.condaEnv.key(KEY_CONDA_ENV);
        this.condaEnv.set(0);
        this.setTranslator(this.condaEnv, s -> {
            ArrayList<String> cmd = new ArrayList<String>();
            String condaPath = CLIUtils.getCondaPath();
            String envname = (String)s;
            if (IJ.isWindows()) {
                cmd.addAll(Arrays.asList("cmd.exe", "/c"));
                cmd.addAll(Arrays.asList(condaPath, "activate", envname));
                cmd.add("&");
            } else {
                try {
                    String pythonPath = CLIUtils.getEnvMap().get(envname);
                    cmd.add(pythonPath);
                    cmd.add("-m");
                }
                catch (IOException e) {
                    System.err.println("Could not find the conda executable or change the conda environment.\nPlease configure the path to your conda executable in Edit > Options > Configure TrackMate Conda path...");
                    e.printStackTrace();
                }
            }
            String executableCommand = this.getCommand();
            String[] split = executableCommand.split(" ");
            cmd.addAll(Arrays.asList(split));
            return cmd;
        });
    }

    public CondaEnvironmentCommand getCommandArg() {
        return this.condaEnv;
    }

    protected abstract String getCommand();

    public static class CondaEnvironmentCommand
    extends CLIConfigurator.AbstractStringArgument<CondaEnvironmentCommand> {
        private final List<String> envs = new ArrayList<String>();

        protected CondaEnvironmentCommand() {
            this.name("Conda environment");
            this.help("The conda environment in which the tool is configured.");
            this.key(CondaCLIConfigurator.KEY_CONDA_ENV);
        }

        protected CondaEnvironmentCommand addEnvironment(String env) {
            if (!this.envs.contains(env)) {
                this.envs.add(env);
            }
            return this;
        }

        @Override
        public void set(String env) {
            int sel = this.envs.indexOf(env);
            if (sel < 0) {
                super.set(this.envs.get(0));
                return;
            }
            super.set(env);
        }

        @Override
        public void set(int selected) {
            if (selected < 0 || selected >= this.envs.size()) {
                this.set(this.envs.get(0));
            } else {
                this.set(this.envs.get(selected));
            }
        }

        public List<String> getEnvironments() {
            return this.envs;
        }

        @Override
        public void accept(CLIConfigurator.ArgumentVisitor visitor) {
            visitor.visit(this);
        }
    }
}

