/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.visualization.trackscheme;

import fiji.plugin.trackmate.FeatureModel;
import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.SelectionChangeEvent;
import fiji.plugin.trackmate.SelectionChangeListener;
import fiji.plugin.trackmate.SelectionModel;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.gui.Fonts;
import fiji.plugin.trackmate.util.OnRequestUpdater;
import fiji.plugin.trackmate.util.TMUtils;
import fiji.plugin.trackmate.visualization.trackscheme.TrackScheme;
import ij.measure.ResultsTable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;

public class InfoPane
extends JPanel
implements SelectionChangeListener {
    private static final long serialVersionUID = -1L;
    private JTable table;
    private JScrollPane scrollTable;
    private final boolean doHighlightSelection = true;
    private final Model model;
    private final SelectionModel selectionModel;
    private Collection<Spot> spotSelection;
    private final OnRequestUpdater updater;
    private final String[] headers;

    public InfoPane(Model model, SelectionModel selectionModel) {
        this.model = model;
        this.selectionModel = selectionModel;
        ArrayList<String> features = new ArrayList<String>(model.getFeatureModel().getSpotFeatures());
        Map<String, String> featureNames = model.getFeatureModel().getSpotFeatureShortNames();
        List<String> headerList = TMUtils.getArrayFromMaping(features, featureNames);
        headerList.add(0, "Track ID");
        this.headers = headerList.toArray(new String[0]);
        this.updater = new OnRequestUpdater(new OnRequestUpdater.Refreshable(){

            @Override
            public void refresh() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        InfoPane.this.update();
                    }
                });
            }
        });
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                InfoPane.this.selectionModel.removeSelectionChangeListener(InfoPane.this);
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }

            @Override
            public void ancestorAdded(AncestorEvent event) {
            }
        });
        selectionModel.addSelectionChangeListener(this);
        this.init();
    }

    @Override
    public void selectionChanged(SelectionChangeEvent event) {
        SwingUtilities.invokeLater(() -> this.highlightSpots(this.selectionModel.getSpotSelection()));
    }

    private void highlightSpots(Collection<Spot> spots) {
        this.spotSelection = spots;
        if (spots.size() == 0) {
            DefaultTableModel tableModel = (DefaultTableModel)this.table.getModel();
            tableModel.setRowCount(0);
            tableModel.setColumnIdentifiers(new String[]{"\u00f8"});
            tableModel.setColumnCount(1);
            this.table.getColumnModel().getColumn(0).setPreferredWidth(10);
            return;
        }
        this.updater.doUpdate();
    }

    private void update() {
        int i;
        ArrayList<Spot> sortedSpots = new ArrayList<Spot>(this.spotSelection);
        Collections.sort(sortedSpots, Spot.frameComparator);
        DefaultTableModel dm = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        ArrayList<String> features = new ArrayList<String>(this.model.getFeatureModel().getSpotFeatures());
        for (Spot spot : sortedSpots) {
            if (null == spot) continue;
            Object[] columnData = new Object[features.size() + 1];
            columnData[0] = String.format("%d", this.model.getTrackModel().trackIDOf(spot));
            for (i = 1; i < columnData.length; ++i) {
                String feature = (String)features.get(i - 1);
                Double feat = spot.getFeature(feature);
                columnData[i] = null == feat ? "" : (this.model.getFeatureModel().getSpotFeatureIsInt().get(feature) != false ? "" + feat.intValue() : String.format("%.4g", (double)feat));
            }
            dm.addColumn((Object)spot.toString(), columnData);
        }
        this.table.setModel(dm);
        DefaultTableCellRenderer headerRenderer = new DefaultTableCellRenderer(){

            @Override
            public boolean isOpaque() {
                return false;
            }

            @Override
            public Color getBackground() {
                return Color.BLUE;
            }
        };
        headerRenderer.setBackground(Color.RED);
        headerRenderer.setFont(Fonts.FONT);
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setOpaque(false);
        renderer.setHorizontalAlignment(4);
        renderer.setFont(Fonts.SMALL_FONT);
        FontMetrics fm = this.table.getGraphics().getFontMetrics(Fonts.FONT);
        for (i = 0; i < this.table.getColumnCount(); ++i) {
            this.table.setDefaultRenderer(this.table.getColumnClass(i), renderer);
            this.table.getColumnModel().getColumn(i).setMinWidth((int)(1.4 * (double)fm.stringWidth(dm.getColumnName(i))));
        }
        for (Component c : this.scrollTable.getColumnHeader().getComponents()) {
            c.setBackground(this.getBackground());
        }
        this.scrollTable.getColumnHeader().setOpaque(false);
        this.scrollTable.setVisible(true);
        this.validate();
    }

    private void displayPopupMenu(Point point) {
        JPopupMenu menu = new JPopupMenu("Selection table");
        JMenuItem exportItem = menu.add("Export to ImageJ table");
        exportItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                InfoPane.this.exportTableToImageJ();
            }
        });
        menu.show(this.table, (int)point.getX(), (int)point.getY());
    }

    private void exportTableToImageJ() {
        ResultsTable lTable = new ResultsTable();
        FeatureModel fm = this.model.getFeatureModel();
        ArrayList<String> features = new ArrayList<String>(fm.getSpotFeatures());
        int ncols = this.spotSelection.size();
        int nrows = this.headers.length;
        Spot[] spotArray = this.spotSelection.toArray(new Spot[0]);
        lTable.incrementCounter();
        lTable.setLabel("TRACK_ID", 0);
        for (int i = 0; i < ncols; ++i) {
            Spot spot = spotArray[i];
            Integer trackID = this.model.getTrackModel().trackIDOf(spot);
            if (null == trackID) {
                lTable.addValue(spot.getName(), "None");
                continue;
            }
            lTable.addValue(spot.getName(), "" + trackID);
        }
        for (int j = 0; j < nrows - 1; ++j) {
            lTable.incrementCounter();
            String feature = (String)features.get(j);
            lTable.setLabel(feature, j + 1);
            for (int i = 0; i < ncols; ++i) {
                Spot spot = spotArray[i];
                Double val = spot.getFeature(feature);
                if (val == null) {
                    lTable.addValue(spot.getName(), "None");
                    continue;
                }
                if (fm.getSpotFeatureIsInt().get(feature).booleanValue()) {
                    lTable.addValue(spot.getName(), "" + val.intValue());
                    continue;
                }
                lTable.addValue(spot.getName(), val.doubleValue());
            }
        }
        lTable.show("TrackMate Selection");
    }

    private void init() {
        AbstractListModel<String> lm = new AbstractListModel<String>(){

            @Override
            public int getSize() {
                return InfoPane.this.headers.length;
            }

            @Override
            public String getElementAt(int index) {
                return InfoPane.this.headers[index];
            }
        };
        this.table = new JTable();
        this.table.setAutoResizeMode(0);
        this.table.setOpaque(false);
        this.table.setFont(Fonts.SMALL_FONT);
        this.table.setPreferredScrollableViewportSize(new Dimension(120, 400));
        this.table.getTableHeader().setOpaque(false);
        this.table.setSelectionForeground(Color.YELLOW.darker().darker());
        this.table.setGridColor(TrackScheme.GRID_COLOR);
        DefaultTableModel tableModel = (DefaultTableModel)this.table.getModel();
        tableModel.setColumnIdentifiers(new String[]{"\u00f8"});
        tableModel.setColumnCount(1);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(10);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    InfoPane.this.displayPopupMenu(e.getPoint());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    InfoPane.this.displayPopupMenu(e.getPoint());
                }
            }
        });
        JList<String> rowHeader = new JList<String>(lm);
        rowHeader.setFixedCellHeight(this.table.getRowHeight());
        rowHeader.setCellRenderer(new RowHeaderRenderer(this.table));
        rowHeader.setBackground(this.getBackground());
        this.scrollTable = new JScrollPane(this.table);
        this.scrollTable.setRowHeaderView(rowHeader);
        this.scrollTable.getRowHeader().setOpaque(false);
        this.scrollTable.setOpaque(false);
        this.scrollTable.getViewport().setOpaque(false);
        this.setLayout(new BorderLayout());
        this.add((Component)this.scrollTable, "Center");
    }

    private class RowHeaderRenderer
    extends JLabel
    implements ListCellRenderer<String> {
        private static final long serialVersionUID = -1L;

        RowHeaderRenderer(JTable table) {
            JTableHeader header = table.getTableHeader();
            this.setOpaque(false);
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.setForeground(header.getForeground());
            this.setBackground(header.getBackground());
            this.setFont(Fonts.SMALL_FONT.deriveFont(9.0f));
            this.setHorizontalAlignment(2);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends String> list, String value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(value == null ? "" : value);
            return this;
        }
    }
}

