/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.imglib;

import java.util.ArrayList;
import java.util.List;
import net.imagej.Dataset;
import net.imagej.DatasetService;
import net.imagej.ImgPlus;
import net.imagej.axis.Axes;
import net.imagej.axis.Axis;
import net.imagej.axis.AxisType;
import net.imagej.axis.CalibratedAxis;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.cell.AbstractCellImg;
import net.imglib2.ops.operation.iterableinterval.unary.Resample;
import net.imglib2.type.numeric.RealType;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.command.ContextCommand;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, initializer="init", headless=true, menu={@Menu(label="Image", weight=2.0, mnemonic=105), @Menu(label="Adjust", mnemonic=97), @Menu(label="Resize...", mnemonic=114)}, attrs={@Attr(name="no-legacy")})
public class ResizeImage<T extends RealType<T>>
extends ContextCommand {
    private static final String LANCZOS = "Lanczos";
    private static final String LINEAR = "Linear";
    private static final String NEAREST_NEIGHBOR = "Nearest Neighbor";
    private static final String PERIODICAL = "Periodic";
    @Parameter(type=ItemIO.BOTH)
    private Dataset dataset;
    @Parameter(label="Dimensions", persist=false)
    private String dimensionsString;
    @Parameter(label="Interpolation", choices={"Linear", "Nearest Neighbor", "Lanczos", "Periodic"}, persist=false)
    private String method = "Linear";
    @Parameter(label="Constrain XY aspect ratio", persist=false)
    private boolean constrain;
    @Parameter
    private DatasetService datasetService;
    private String err = null;
    private List<Long> dimensions = new ArrayList<Long>();
    private int xAxis;
    private int yAxis;

    public void setDataset(Dataset ds) {
        this.dataset = ds;
        this.init();
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    public void setDimension(int d, long size) {
        if (d < 0 || d >= this.dimensions.size()) {
            throw new IllegalArgumentException("dimension " + d + " out of bounds (0," + (this.dimensions.size() - 1) + ")");
        }
        this.dimensions.set(d, size);
        if (this.constrain) {
            if (d == this.xAxis) {
                double sz = size;
                sz *= (double)this.dataset.dimension(this.yAxis);
                long ySize = Math.round(sz /= (double)this.dataset.dimension(this.xAxis));
                this.dimensions.set(this.yAxis, ySize);
            } else if (d == this.yAxis) {
                double sz = size;
                sz *= (double)this.dataset.dimension(this.xAxis);
                long xSize = Math.round(sz /= (double)this.dataset.dimension(this.yAxis));
                this.dimensions.set(this.xAxis, xSize);
            }
        }
        this.dimensionsString = this.dimensionsString();
    }

    public long getDimension(int d) {
        if (d < 0 || d >= this.dimensions.size()) {
            throw new IllegalArgumentException("dimension " + d + " out of bounds (0," + (this.dimensions.size() - 1) + ")");
        }
        return this.dimensions.get(d);
    }

    public void setInterpolationMethod(String str) {
        if (str.equals(PERIODICAL)) {
            this.method = PERIODICAL;
        } else if (str.equals(LINEAR)) {
            this.method = LINEAR;
        } else if (str.equals(NEAREST_NEIGHBOR)) {
            this.method = NEAREST_NEIGHBOR;
        } else if (str.equals(LANCZOS)) {
            this.method = LANCZOS;
        } else {
            throw new IllegalArgumentException("Unknown interpolation method: " + str);
        }
    }

    public String getInterpolationMethod() {
        return this.method;
    }

    public void setConstrainXY(Boolean val) {
        this.constrain = val;
    }

    public boolean getConstrainXY() {
        return this.constrain;
    }

    public String getError() {
        return this.err;
    }

    public void run() {
        List<Long> dims = this.parseDimensions(this.dataset, this.dimensionsString);
        if (dims == null) {
            this.cancel(this.err);
            return;
        }
        if (this.constrain) {
            this.constrain(dims);
        }
        this.resampleData(this.dataset, dims);
    }

    protected void init() {
        this.dimensions.clear();
        for (int i = 0; i < this.dataset.numDimensions(); ++i) {
            this.dimensions.add(this.dataset.dimension(i));
        }
        this.dimensionsString = this.dimensionsString();
        this.xAxis = this.dataset.dimensionIndex(Axes.X);
        this.yAxis = this.dataset.dimensionIndex(Axes.Y);
    }

    private List<Long> parseDimensions(Dataset ds, String spec) {
        int i;
        if (spec == null) {
            this.err = "Dimension specification string is null.";
            return null;
        }
        String[] terms = spec.split(",");
        if (terms.length == 0) {
            this.err = "Dimension specification string is empty.";
            return null;
        }
        ArrayList<Long> dims = new ArrayList<Long>();
        for (i = 0; i < ds.numDimensions(); ++i) {
            dims.add(ds.dimension(i));
        }
        for (i = 0; i < terms.length; ++i) {
            long size;
            int axisIndex;
            String term = terms[i].trim();
            String[] parts = term.split("=");
            if (parts.length != 2) {
                this.err = "Err in dimension specification string: each dimension must be two numbers separated by an '=' sign.";
                return null;
            }
            try {
                axisIndex = Integer.parseInt(parts[0].trim());
                size = Long.parseLong(parts[1].trim());
            }
            catch (NumberFormatException e) {
                this.err = "Err in dimension specification string: each dimension must be two numbers separated by an '=' sign.";
                return null;
            }
            if (axisIndex < 0 || axisIndex >= ds.numDimensions()) {
                this.err = "An axis index is outside dimensionality of input dataset.";
                return null;
            }
            if (size < 1L) {
                this.err = "Dimension " + i + " must be greater than 0";
                return null;
            }
            this.dimensions.set(axisIndex, size);
        }
        return this.dimensions;
    }

    private void constrain(List<Long> dims) {
        if (dims.get(this.xAxis).longValue() != this.dataset.dimension(this.xAxis)) {
            double sz = dims.get(this.xAxis).longValue();
            sz *= (double)this.dataset.dimension(this.yAxis);
            long ySize = Math.round(sz /= (double)this.dataset.dimension(this.xAxis));
            dims.set(this.yAxis, ySize);
        } else if (dims.get(this.yAxis).longValue() != this.dataset.dimension(this.yAxis)) {
            double sz = dims.get(this.yAxis).longValue();
            sz *= (double)this.dataset.dimension(this.xAxis);
            long xSize = Math.round(sz /= (double)this.dataset.dimension(this.yAxis));
            dims.set(this.xAxis, xSize);
        }
    }

    private void resampleData(Dataset ds, List<Long> dims) {
        ImgPlus origImgPlus = ds.getImgPlus();
        int numDims = origImgPlus.numDimensions();
        CalibratedAxis[] axes = new CalibratedAxis[numDims];
        ds.axes((Axis[])axes);
        AxisType[] axisTypes = new AxisType[numDims];
        for (int i = 0; i < numDims; ++i) {
            axisTypes[i] = axes[i].type();
        }
        Dataset newDs = this.newData(ds, dims);
        newDs.setAxes(axes);
        if (ds.getCompositeChannelCount() == this.numChannels(ds)) {
            newDs.setCompositeChannelCount(this.numChannels(newDs));
        }
        Resample resampleOp = new Resample(this.resampleMode());
        resampleOp.compute((RandomAccessibleInterval)origImgPlus, (RandomAccessibleInterval)newDs.getImgPlus());
        ds.setImgPlus(newDs.getImgPlus());
    }

    private String dimensionsString() {
        String str = "";
        for (int i = 0; i < this.dimensions.size(); ++i) {
            if (i != 0) {
                str = str + ", ";
            }
            str = str + i + "=" + this.dimensions.get(i);
        }
        return str;
    }

    private Dataset newData(Dataset origDs, List<Long> dims) {
        long[] newDims = this.newDims(origDs, dims);
        String name = origDs.getName();
        AxisType[] axisTypes = new AxisType[origDs.numDimensions()];
        for (int i = 0; i < axisTypes.length; ++i) {
            axisTypes[i] = ((CalibratedAxis)origDs.axis(i)).type();
        }
        int bitsPerPixel = ((RealType)origDs.getImgPlus().firstElement()).getBitsPerPixel();
        boolean signed = origDs.isSigned();
        boolean floating = !origDs.isInteger();
        boolean virtual = AbstractCellImg.class.isAssignableFrom(origDs.getImgPlus().getImg().getClass());
        return this.datasetService.create(newDims, name, axisTypes, bitsPerPixel, signed, floating, virtual);
    }

    private long[] newDims(Dataset ds, List<Long> dimsList) {
        long[] dims = new long[ds.numDimensions()];
        for (int i = 0; i < dims.length; ++i) {
            dims[i] = dimsList.get(i);
        }
        return dims;
    }

    private Resample.Mode resampleMode() {
        if (this.method.equals(LANCZOS)) {
            return Resample.Mode.LANCZOS;
        }
        if (this.method.equals(LINEAR)) {
            return Resample.Mode.LINEAR;
        }
        if (this.method.equals(NEAREST_NEIGHBOR)) {
            return Resample.Mode.NEAREST_NEIGHBOR;
        }
        if (this.method.equals(PERIODICAL)) {
            return Resample.Mode.PERIODICAL;
        }
        throw new IllegalArgumentException("Unknown interpolation method: " + this.method);
    }

    private int numChannels(Dataset ds) {
        int index = ds.dimensionIndex(Axes.CHANNEL);
        if (index < 0) {
            return 1;
        }
        return (int)ds.dimension(index);
    }
}

