/*
 * Decompiled with CFR 0.152.
 */
package ij3d;

import customnode.CustomLineMesh;
import customnode.CustomMesh;
import customnode.CustomMultiMesh;
import customnode.CustomPointMesh;
import customnode.CustomQuadMesh;
import customnode.CustomTriangleMesh;
import customnode.MeshLoader;
import customnode.MeshMaker;
import ij.IJ;
import ij.ImagePlus;
import ij.plugin.frame.Recorder;
import ij3d.Content;
import ij3d.ContentCreator;
import ij3d.DefaultAnimatableUniverse;
import ij3d.Executer;
import ij3d.Image3DMenubar;
import ij3d.ImageCanvas3D;
import ij3d.ImageWindow3D;
import ij3d.RegistrationMenubar;
import ij3d.SaveSession;
import ij3d.TimelapseListener;
import ij3d.UniverseSettings;
import ij3d.UniverseSynchronizer;
import ij3d.ViewAdjuster;
import ij3d.contextmenu.ContextMenu;
import ij3d.pointlist.PointListDialog;
import ij3d.shortcuts.ShortCuts;
import java.awt.CheckboxMenuItem;
import java.awt.GraphicsDevice;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import octree.VolumeOctree;
import org.jogamp.java3d.BranchGroup;
import org.jogamp.java3d.Node;
import org.jogamp.java3d.Transform3D;
import org.jogamp.vecmath.AxisAngle4d;
import org.jogamp.vecmath.Color3f;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Point3f;
import org.jogamp.vecmath.Tuple3d;
import org.jogamp.vecmath.Vector3d;
import view4d.Timeline;
import view4d.TimelineGUI;

public class Image3DUniverse
extends DefaultAnimatableUniverse {
    public static final String NO_CONTENT_MESSAGE = "Cannot adjust view as there is no content in this universe.";
    public static ArrayList<Image3DUniverse> universes = new ArrayList();
    private static final UniverseSynchronizer synchronizer = new UniverseSynchronizer();
    private int currentTimepoint = 0;
    private int startTime = 0;
    private int endTime = 0;
    private final Timeline timeline;
    private TimelineGUI timelineGUI;
    private Content selected;
    private final Hashtable<String, Content> contents = new Hashtable();
    private Image3DMenubar menubar;
    private RegistrationMenubar registrationMenubar;
    private ImageCanvas3D canvas;
    private Executer executer;
    private ShortCuts shortcuts;
    private ContextMenu contextmenu;
    private boolean autoAdjustView = true;
    private PointListDialog plDialog;
    private boolean fullscreen = false;
    private final ArrayList<TimelapseListener> timeListeners = new ArrayList();
    private final Object lock = new Object();
    private Rectangle lastNonFullscreenBounds;
    boolean timelineGUIVisible = false;
    @Deprecated
    private VolumeOctree octree = null;
    private float oldRange = 2.0f;
    private final ExecutorService adder = Executors.newFixedThreadPool(1);

    public Image3DUniverse() {
        this(UniverseSettings.startupWidth, UniverseSettings.startupHeight);
    }

    public Image3DUniverse(int width, int height) {
        super(width, height);
        this.canvas = (ImageCanvas3D)this.getCanvas();
        this.executer = new Executer(this);
        this.timeline = new Timeline(this);
        this.timelineGUI = new TimelineGUI(this.timeline);
        this.canvas.addKeyListener(this.timelineGUI);
        BranchGroup bg = new BranchGroup();
        this.scene.addChild((Node)bg);
        this.resetView();
        this.contextmenu = new ContextMenu(this);
        this.canvas.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                Content c = Image3DUniverse.this.picker.getPickedContent(e.getX(), e.getY());
                if (c != null) {
                    IJ.showStatus((String)c.getName());
                } else {
                    IJ.showStatus((String)"");
                }
            }
        });
        this.canvas.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.isConsumed()) {
                    return;
                }
                Image3DUniverse.this.select(Image3DUniverse.this.picker.getPickedContent(e.getX(), e.getY()));
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Image3DUniverse.this.contextmenu.showPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                Image3DUniverse.this.contextmenu.showPopup(e);
            }
        });
        universes.add(this);
    }

    @Override
    public void show() {
        this.init(new ImageWindow3D("ImageJ 3D Viewer", this));
        this.win.pack();
        this.win.setVisible(true);
    }

    public void init(ImageWindow3D window) {
        if (window.getUniverse() != this) {
            throw new RuntimeException("Incompatible universes! Go rethink the multiverse!");
        }
        this.win = window;
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        this.plDialog = new PointListDialog(this.win);
        this.plDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Image3DUniverse.this.hideAllLandmarks();
            }
        });
        this.menubar = new Image3DMenubar(this);
        this.registrationMenubar = new RegistrationMenubar(this);
        this.shortcuts = new ShortCuts(this.menubar);
        this.setMenubar(this.menubar);
    }

    public void setFullScreen(final boolean f) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Image3DUniverse.this.doSetFullScreen(f);
            }
        });
    }

    private void doSetFullScreen(boolean f) {
        if (this.win == null || f == this.fullscreen) {
            return;
        }
        if (f) {
            this.lastNonFullscreenBounds = this.win.getBounds();
        }
        GraphicsDevice dev = this.win.getGraphicsConfiguration().getDevice();
        this.win.quitImageUpdater();
        this.win.dispose();
        dev.setFullScreenWindow(null);
        this.win = new ImageWindow3D("ImageJ 3D Viewer", this);
        if (!f) {
            this.win.setUndecorated(false);
            this.win.setJMenuBar(this.menubar);
            this.fullscreen = false;
            this.win.setBounds(this.lastNonFullscreenBounds);
        } else {
            try {
                this.win.setUndecorated(true);
                this.win.setJMenuBar(null);
                dev.setFullScreenWindow(this.win);
                this.fullscreen = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.fullscreen = false;
                dev.setFullScreenWindow(null);
            }
        }
        this.win.setVisible(true);
        this.menubar.updateMenus();
    }

    public boolean isFullScreen() {
        return this.fullscreen;
    }

    @Override
    public void cleanup() {
        WindowListener[] ls;
        this.timeline.pause();
        this.removeAllContents();
        this.contents.clear();
        universes.remove(this);
        this.adder.shutdownNow();
        this.executer.flush();
        for (WindowListener l : ls = this.plDialog.getWindowListeners()) {
            this.plDialog.removeWindowListener(l);
        }
        this.plDialog.dispose();
        super.cleanup();
    }

    public void setStatus(String text) {
    }

    @Deprecated
    public void setMenubar(MenuBar mb) {
        JMenuBar jmb = new JMenuBar();
        int num = mb.getMenuCount();
        for (int i = 0; i < num; ++i) {
            jmb.add(this.menuToJMenu(mb.getMenu(i)));
        }
        this.setMenubar(jmb);
    }

    private JMenu menuToJMenu(Menu menu) {
        JMenu jm = new JMenu(menu.getLabel());
        int num = menu.getItemCount();
        for (int i = 0; i < num; ++i) {
            JMenuItem jitem;
            MenuItem item = menu.getItem(i);
            String label = item.getLabel();
            if (item instanceof Menu) {
                jitem = this.menuToJMenu((Menu)item);
            } else if (item instanceof CheckboxMenuItem) {
                jitem = new JCheckBoxMenuItem(label);
                ((JCheckBoxMenuItem)jitem).setState(((CheckboxMenuItem)item).getState());
                for (EventListener eventListener : ((CheckboxMenuItem)item).getItemListeners()) {
                    jitem.addItemListener((ItemListener)eventListener);
                }
            } else {
                if (label.equals("-")) {
                    jm.addSeparator();
                    continue;
                }
                jitem = new JMenuItem(label);
                for (EventListener eventListener : item.getActionListeners()) {
                    jitem.addActionListener((ActionListener)eventListener);
                }
            }
            jm.add(jitem);
        }
        return jm;
    }

    public void setMenubar(JMenuBar mb) {
        if (this.win != null) {
            this.win.setJMenuBar(mb);
        }
    }

    public JMenuBar getMenuBar() {
        return this.menubar;
    }

    public RegistrationMenubar getRegistrationMenuBar() {
        return this.registrationMenubar;
    }

    public Executer getExecuter() {
        return this.executer;
    }

    public ShortCuts getShortcuts() {
        return this.shortcuts;
    }

    public PointListDialog getPointListDialog() {
        return this.plDialog;
    }

    public void hideAllLandmarks() {
        for (Content c : this.contents.values()) {
            c.showPointList(false);
        }
        this.fireContentSelected(this.selected);
    }

    public void saveSession(String file) throws IOException {
        SaveSession.saveScene(this, file);
    }

    public void loadSession(String file) throws IOException {
        this.removeAllContents();
        SaveSession.loadScene(this, file);
    }

    public void addTimelapseListener(TimelapseListener l) {
        this.timeListeners.add(l);
    }

    public void removeTimelapseListener(TimelapseListener l) {
        this.timeListeners.remove(l);
    }

    private void fireTimepointChanged(int timepoint) {
        for (TimelapseListener l : this.timeListeners) {
            l.timepointChanged(timepoint);
        }
    }

    public Timeline getTimeline() {
        return this.timeline;
    }

    public void showTimepoint(int tp) {
        if (this.currentTimepoint == tp) {
            return;
        }
        this.currentTimepoint = tp;
        for (Content c : this.contents.values()) {
            c.showTimepoint(tp, false);
        }
        if (this.timelineGUIVisible) {
            this.timelineGUI.updateTimepoint(tp);
        }
        this.fireTimepointChanged(this.currentTimepoint);
    }

    public int getCurrentTimepoint() {
        return this.currentTimepoint;
    }

    public int getStartTime() {
        return this.startTime;
    }

    public int getEndTime() {
        return this.endTime;
    }

    public void updateStartAndEndTime(int st, int e) {
        this.startTime = st;
        this.endTime = e;
        this.updateTimelineGUI();
    }

    public void updateTimeline() {
        if (this.contents.size() == 0) {
            this.endTime = 0;
            this.startTime = 0;
        } else {
            this.startTime = Integer.MAX_VALUE;
            this.endTime = Integer.MIN_VALUE;
            for (Content c : this.contents.values()) {
                if (c.getStartTime() < this.startTime) {
                    this.startTime = c.getStartTime();
                }
                if (c.getEndTime() <= this.endTime) continue;
                this.endTime = c.getEndTime();
            }
        }
        if (this.currentTimepoint > this.endTime) {
            this.showTimepoint(this.endTime);
        } else if (this.currentTimepoint < this.startTime) {
            this.showTimepoint(this.startTime);
        }
        this.updateTimelineGUI();
    }

    public void updateTimelineGUI() {
        if (this.win == null) {
            return;
        }
        if (this.endTime != this.startTime && !this.timelineGUIVisible) {
            this.win.add(this.timelineGUI.getPanel(), "South", -1);
            this.timelineGUIVisible = true;
            this.win.pack();
        } else if (this.endTime == this.startTime && this.timelineGUIVisible) {
            this.win.remove(this.timelineGUI.getPanel());
            this.timelineGUIVisible = false;
            this.win.pack();
        }
        if (this.timelineGUIVisible) {
            this.timelineGUI.updateStartAndEnd(this.startTime, this.endTime);
        }
    }

    public void select(Content c) {
        if (this.selected != null) {
            this.selected.setSelected(false);
            this.selected = null;
        }
        if (c != null && c.isVisibleAt(this.currentTimepoint)) {
            c.setSelected(true);
            this.selected = c;
        }
        String st = c != null ? c.getName() : "none";
        IJ.showStatus((String)("selected: " + st));
        this.fireContentSelected(this.selected);
        if (c != null && Recorder.record) {
            Executer.record("select", c.getName());
        }
    }

    @Override
    public Content getSelected() {
        return this.selected;
    }

    public void clearSelection() {
        if (this.selected != null) {
            this.selected.setSelected(false);
        }
        this.selected = null;
        this.fireContentSelected(null);
    }

    public void setShowBoundingBoxUponSelection(boolean b) {
        UniverseSettings.showSelectionBox = b;
        if (this.selected != null) {
            this.selected.setSelected(false);
            this.selected.setSelected(true);
        }
    }

    public boolean getShowBoundingBoxUponSelection() {
        return UniverseSettings.showSelectionBox;
    }

    public void setAutoAdjustView(boolean b) {
        this.autoAdjustView = b;
    }

    public boolean getAutoAdjustView() {
        return this.autoAdjustView;
    }

    public void recalculateGlobalMinMax() {
        if (this.contents.isEmpty()) {
            return;
        }
        Point3d min = new Point3d();
        Point3d max = new Point3d();
        Iterator it = this.contents();
        Content c = (Content)it.next();
        c.getMin(min);
        c.getMax(max);
        this.globalMin.set((Tuple3d)min);
        this.globalMax.set((Tuple3d)max);
        while (it.hasNext()) {
            c = (Content)it.next();
            c.getMin(min);
            c.getMax(max);
            if (min.x < this.globalMin.x) {
                this.globalMin.x = min.x;
            }
            if (min.y < this.globalMin.y) {
                this.globalMin.y = min.y;
            }
            if (min.z < this.globalMin.z) {
                this.globalMin.z = min.z;
            }
            if (max.x > this.globalMax.x) {
                this.globalMax.x = max.x;
            }
            if (max.y > this.globalMax.y) {
                this.globalMax.y = max.y;
            }
            if (!(max.z > this.globalMax.z)) continue;
            this.globalMax.z = max.z;
        }
        this.globalCenter.x = this.globalMin.x + (this.globalMax.x - this.globalMin.x) / 2.0;
        this.globalCenter.y = this.globalMin.y + (this.globalMax.y - this.globalMin.y) / 2.0;
        this.globalCenter.z = this.globalMin.z + (this.globalMax.z - this.globalMin.z) / 2.0;
    }

    public void recalculateGlobalMinMax(Content c) {
        Point3d cmin = new Point3d();
        c.getMin(cmin);
        Point3d cmax = new Point3d();
        c.getMax(cmax);
        if (this.contents.size() == 1) {
            this.globalMin.set((Tuple3d)cmin);
            this.globalMax.set((Tuple3d)cmax);
        } else {
            if (cmin.x < this.globalMin.x) {
                this.globalMin.x = cmin.x;
            }
            if (cmin.y < this.globalMin.y) {
                this.globalMin.y = cmin.y;
            }
            if (cmin.z < this.globalMin.z) {
                this.globalMin.z = cmin.z;
            }
            if (cmax.x > this.globalMax.x) {
                this.globalMax.x = cmax.x;
            }
            if (cmax.y > this.globalMax.y) {
                this.globalMax.y = cmax.y;
            }
            if (cmax.z > this.globalMax.z) {
                this.globalMax.z = cmax.z;
            }
        }
        this.globalCenter.x = this.globalMin.x + (this.globalMax.x - this.globalMin.x) / 2.0;
        this.globalCenter.y = this.globalMin.y + (this.globalMax.y - this.globalMin.y) / 2.0;
        this.globalCenter.z = this.globalMin.z + (this.globalMax.z - this.globalMin.z) / 2.0;
    }

    public Point3d getGlobalCenterPoint() {
        return this.globalCenter;
    }

    public void getGlobalCenterPoint(Point3d p) {
        p.set((Tuple3d)this.globalCenter);
    }

    public void getGlobalMinPoint(Point3d p) {
        p.set((Tuple3d)this.globalMin);
    }

    public void getGlobalMaxPoint(Point3d p) {
        p.set((Tuple3d)this.globalMax);
    }

    @Deprecated
    public void updateOctree() {
    }

    @Deprecated
    public void cancelOctree() {
    }

    @Deprecated
    public void removeOctree() {
        if (this.octree != null) {
            this.removeUniverseListener(this.octree);
            this.scene.removeChild((Node)this.octree.getRootBranchGroup());
            this.octree = null;
        }
    }

    @Deprecated
    public VolumeOctree addOctree(String imageDir, String name) {
        if (this.octree != null) {
            IJ.error((String)"Only one large volume can be displayed a time.\nPlease remove previously displayed volumes first.");
            return null;
        }
        if (this.contents.containsKey(name)) {
            IJ.error((String)"Name exists already");
            return null;
        }
        try {
            this.octree = new VolumeOctree(imageDir, this.canvas);
            this.octree.displayInitial();
            this.octree.getRootBranchGroup().compile();
            this.scene.addChild((Node)this.octree.getRootBranchGroup());
            this.ensureScale(this.octree.realWorldXDim());
            this.addUniverseListener(this.octree);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.octree;
    }

    public Content addContent(ImagePlus image, Color3f color, String name, int thresh, boolean[] channels, int resf, int type) {
        if (this.contents.containsKey(name)) {
            IJ.error((String)("Content named '" + name + "' exists already"));
            return null;
        }
        Content c = ContentCreator.createContent(name, image, type, resf, 0, color, thresh, channels);
        return this.addContent(c);
    }

    public Content addContent(ImagePlus image, int type, int res) {
        int thr = Content.getDefaultThreshold(image, type);
        return this.addContent(image, null, image.getTitle(), thr, new boolean[]{true, true, true}, res, type);
    }

    public Content addContent(ImagePlus image, int type) {
        int res = Content.getDefaultResamplingFactor(image, type);
        int thr = Content.getDefaultThreshold(image, type);
        return this.addContent(image, null, image.getTitle(), thr, new boolean[]{true, true, true}, res, type);
    }

    public Content addVoltex(ImagePlus image) {
        return this.addContent(image, 0);
    }

    public Content addVoltex(ImagePlus image, int res) {
        return this.addContent(image, 0, res);
    }

    public Content addVoltex(ImagePlus image, Color3f color, String name, int thresh, boolean[] channels, int resamplingF) {
        return this.addContent(image, color, name, thresh, channels, resamplingF, 0);
    }

    public Content addOrthoslice(ImagePlus image) {
        return this.addContent(image, 1);
    }

    public Content addOrthoslice(ImagePlus image, int res) {
        return this.addContent(image, 1, res);
    }

    public Content addOrthoslice(ImagePlus image, Color3f color, String name, int thresh, boolean[] channels, int resamplingF) {
        return this.addContent(image, color, name, thresh, channels, resamplingF, 1);
    }

    public Content addSurfacePlot(ImagePlus image) {
        return this.addContent(image, 3);
    }

    public Content addSurfacePlot(ImagePlus image, int res) {
        return this.addContent(image, 3, res);
    }

    public Content addSurfacePlot(ImagePlus image, Color3f color, String name, int thresh, boolean[] channels, int resamplingF) {
        return this.addContent(image, color, name, thresh, channels, resamplingF, 3);
    }

    public Content addMesh(ImagePlus img) {
        return this.addContent(img, 2);
    }

    public Content addMesh(ImagePlus img, int res) {
        return this.addContent(img, 2, res);
    }

    public Content addMesh(ImagePlus image, Color3f color, String name, int threshold, boolean[] channels, int resamplingF) {
        return this.addContent(image, color, name, threshold, channels, resamplingF, 2);
    }

    public Content addCustomMesh(CustomMesh mesh, String name) {
        if (this.contents.containsKey(name)) {
            IJ.error((String)("Mesh named '" + name + "' exists already"));
            return null;
        }
        Content content = this.createContent(mesh, name);
        return this.addContent(content);
    }

    public Content addCustomMesh(CustomMultiMesh mesh, String name) {
        if (this.contents.containsKey(name)) {
            IJ.error((String)("Mesh named '" + name + "' exists already"));
            return null;
        }
        Content content = this.createContent(mesh, name);
        return this.addContent(content);
    }

    public Content createContent(CustomMesh mesh, String name) {
        return ContentCreator.createContent(mesh, name);
    }

    public Content createContent(CustomMultiMesh node, String name) {
        return ContentCreator.createContent(node, name);
    }

    public Content addLineMesh(List<Point3f> mesh, Color3f color, String name, boolean strips) {
        int mode = strips ? 1 : 0;
        CustomLineMesh lmesh = new CustomLineMesh(mesh, mode, color, 0.0f);
        return this.addCustomMesh(lmesh, name);
    }

    public Content addPointMesh(List<Point3f> mesh, Color3f color, String name) {
        CustomPointMesh tmesh = new CustomPointMesh(mesh, color, 0.0f);
        return this.addCustomMesh(tmesh, name);
    }

    public Content addPointMesh(List<Point3f> mesh, Color3f color, float ptsize, String name) {
        CustomPointMesh tmesh = new CustomPointMesh(mesh, color, 0.0f);
        tmesh.setPointSize(ptsize);
        return this.addCustomMesh(tmesh, name);
    }

    public Content addIcospheres(List<Point3f> points, Color3f color, int subdivisions, float radius, String name) {
        List<Point3f> ico = MeshMaker.createIcosahedron(subdivisions, radius);
        ArrayList<Point3f> mesh = new ArrayList<Point3f>();
        for (Point3f p : points) {
            mesh.addAll(MeshMaker.copyTranslated(ico, p.x, p.y, p.z));
        }
        return this.addCustomMesh(new CustomTriangleMesh(mesh, color, 0.0f), name);
    }

    public Content addQuadMesh(List<Point3f> mesh, Color3f color, String name) {
        CustomQuadMesh tmesh = new CustomQuadMesh(mesh, color, 0.0f);
        return this.addCustomMesh(tmesh, name);
    }

    public Content addTriangleMesh(List<Point3f> mesh, Color3f color, String name) {
        CustomTriangleMesh tmesh = new CustomTriangleMesh(mesh, color, 0.0f);
        return this.addCustomMesh(tmesh, name);
    }

    public Content addTriangleMesh(List<Point3f> mesh, List<Color3f> colors, String name) {
        CustomTriangleMesh tmesh = new CustomTriangleMesh(mesh);
        tmesh.setColor(colors);
        return this.addCustomMesh(tmesh, name);
    }

    @Deprecated
    public Content addMesh(List mesh, Color3f color, String name, float scale, int threshold) {
        Content c = this.addMesh(mesh, color, name, threshold);
        return c;
    }

    @Deprecated
    public Content addMesh(List<Point3f> mesh, Color3f color, String name, int threshold) {
        return this.addTriangleMesh(mesh, color, name);
    }

    public void removeAllContents() {
        String[] names = new String[this.contents.size()];
        this.contents.keySet().toArray(names);
        for (int i = 0; i < names.length; ++i) {
            this.removeContent(names[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContent(String name) {
        Object object = this.lock;
        synchronized (object) {
            Content content = this.contents.get(name);
            if (content == null) {
                return;
            }
            this.scene.removeChild((Node)content);
            this.contents.remove(name);
            if (this.selected == content) {
                this.clearSelection();
            }
            this.fireContentRemoved(content);
            this.removeUniverseListener(content);
            this.updateTimeline();
        }
    }

    @Override
    public Iterator contents() {
        return this.contents.values().iterator();
    }

    public Collection getContents() {
        if (this.contents == null) {
            return null;
        }
        return this.contents.values();
    }

    public boolean contains(String name) {
        return this.contents.containsKey(name);
    }

    public Content getContent(String name) {
        if (null == name) {
            return null;
        }
        return this.contents.get(name);
    }

    public void sync(boolean b) {
        if (b) {
            synchronizer.addUniverse(this);
        } else {
            synchronizer.removeUniverse(this);
        }
    }

    public void saveView(String file) throws IOException {
        SaveSession.saveView(this, file);
    }

    public void loadView(String file) throws IOException {
        SaveSession.loadView(this, file);
    }

    public void resetView() {
        this.fireTransformationStarted();
        Transform3D t = new Transform3D();
        AxisAngle4d aa = new AxisAngle4d(1.0, 0.0, 0.0, Math.PI);
        t.set(aa);
        this.getRotationTG().setTransform(t);
        t.setIdentity();
        this.getTranslateTG().setTransform(t);
        this.getZoomTG().setTransform(t);
        this.recalculateGlobalMinMax();
        this.getViewPlatformTransformer().centerAt(this.globalCenter);
        double d = (double)this.oldRange / Math.tan(0.39269908169872414);
        this.getViewPlatformTransformer().zoomTo(d);
        this.fireTransformationUpdated();
        this.fireTransformationFinished();
    }

    public void rotateUniverse(Vector3d axis, double angle) {
        this.viewTransformer.rotate(axis, angle);
    }

    public void rotateToNegativeXY() {
        this.fireTransformationStarted();
        this.getRotationTG().setTransform(new Transform3D());
        this.fireTransformationFinished();
    }

    public void rotateToPositiveXY() {
        this.fireTransformationStarted();
        this.getRotationTG().setTransform(new Transform3D());
        this.waitForNextFrame();
        this.rotateUniverse(new Vector3d(0.0, 1.0, 0.0), Math.PI);
    }

    public void rotateToNegativeXZ() {
        this.fireTransformationStarted();
        this.getRotationTG().setTransform(new Transform3D());
        this.waitForNextFrame();
        this.rotateUniverse(new Vector3d(1.0, 0.0, 0.0), 1.5707963267948966);
    }

    public void rotateToPositiveXZ() {
        this.fireTransformationStarted();
        this.getRotationTG().setTransform(new Transform3D());
        this.waitForNextFrame();
        this.rotateUniverse(new Vector3d(0.0, 1.0, 0.0), -1.5707963267948966);
    }

    public void rotateToNegativeYZ() {
        this.fireTransformationStarted();
        this.getRotationTG().setTransform(new Transform3D());
        this.waitForNextFrame();
        this.rotateUniverse(new Vector3d(0.0, 1.0, 0.0), 1.5707963267948966);
    }

    public void rotateToPositiveYZ() {
        this.fireTransformationStarted();
        this.getRotationTG().setTransform(new Transform3D());
        this.waitForNextFrame();
        this.rotateUniverse(new Vector3d(1.0, 0.0, 0.0), -1.5707963267948966);
    }

    public void centerSelected(Content c) {
        Point3d center = new Point3d();
        c.getContent().getCenter((Tuple3d)center);
        Transform3D localToVWorld = new Transform3D();
        c.getContent().getLocalToVworld(localToVWorld);
        localToVWorld.transform(center);
        this.getViewPlatformTransformer().centerAt(center);
    }

    public void centerAt(Point3d p) {
        this.getViewPlatformTransformer().centerAt(p);
    }

    public void adjustView() {
        this.adjustView(2);
    }

    public void adjustView(int dir) {
        if (this.contents.isEmpty()) {
            return;
        }
        ViewAdjuster adj = new ViewAdjuster(this, dir);
        adj.addCenterOf(this.contents.values());
        for (Content c : this.contents.values()) {
            adj.add(c);
        }
        adj.apply();
    }

    public void adjustView(Iterable<Content> contents) {
        if (!contents.iterator().hasNext()) {
            return;
        }
        this.adjustView(contents, 2);
    }

    public void adjustView(Iterable<Content> contents, int dir) {
        ViewAdjuster adj = new ViewAdjuster(this, dir);
        adj.addCenterOf(contents);
        for (Content c : contents) {
            adj.add(c);
        }
        adj.apply();
    }

    public void adjustView(Content c, int dir) {
        ViewAdjuster adj = new ViewAdjuster(this, dir);
        adj.add(c);
        adj.apply();
    }

    public void adjustView(Content c) {
        this.adjustView(c, 2);
    }

    private void ensureScale(float range) {
        this.oldRange = range;
        double d = (double)range / Math.tan(0.39269908169872414);
        this.getViewPlatformTransformer().zoomTo(d);
    }

    public String allContentsString() {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (String s : this.contents.keySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append("\"");
            sb.append(s);
            sb.append("\"");
        }
        return sb.toString();
    }

    public String getSafeContentName(String suggested) {
        String originalName = suggested;
        String attempt = suggested;
        int tryNumber = 2;
        while (this.contains(attempt)) {
            attempt = originalName + " (" + tryNumber + ")";
            ++tryNumber;
        }
        return attempt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addContentToScene(Content c) {
        Object object = this.lock;
        synchronized (object) {
            String name = c.getName();
            if (this.contents.containsKey(name)) {
                IJ.log((String)("Mesh named '" + name + "' exists already"));
                return false;
            }
            int st = this.startTime;
            int e = this.endTime;
            if (c.getStartTime() < this.startTime) {
                st = c.getStartTime();
            }
            if (c.getEndTime() > this.endTime) {
                e = c.getEndTime();
            }
            this.updateStartAndEndTime(st, e);
            this.scene.addChild((Node)c);
            this.contents.put(name, c);
            this.recalculateGlobalMinMax(c);
            c.setPointListDialog(this.plDialog);
            c.showTimepoint(this.currentTimepoint, true);
        }
        return true;
    }

    public Content addContent(Content c) {
        try {
            return this.addContentLater(c).get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public Future<Content> addContentLater(final Content c) {
        final Image3DUniverse univ = this;
        return this.adder.submit(new Callable<Content>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Content call() {
                Object object = Image3DUniverse.this.lock;
                synchronized (object) {
                    if (!Image3DUniverse.this.addContentToScene(c)) {
                        return null;
                    }
                    if (univ.autoAdjustView) {
                        univ.getViewPlatformTransformer().centerAt(univ.globalCenter);
                        float range = (float)(univ.globalMax.x - univ.globalMin.x);
                        univ.ensureScale(range);
                    }
                }
                univ.fireContentAdded(c);
                univ.addUniverseListener(c);
                univ.waitForNextFrame();
                univ.fireTransformationUpdated();
                return c;
            }
        });
    }

    public Collection<Future<Content>> addContentLater(String file) {
        Map<String, CustomMesh> meshes = MeshLoader.load(file);
        if (meshes == null) {
            return null;
        }
        ArrayList<Content> contents = new ArrayList<Content>();
        for (Map.Entry<String, CustomMesh> entry : meshes.entrySet()) {
            String name = entry.getKey();
            name = this.getSafeContentName(name);
            CustomMesh mesh = entry.getValue();
            Content content = this.createContent(mesh, name);
            contents.add(content);
        }
        return this.addContentLater(contents);
    }

    public Collection<Future<Content>> addContentLater(Collection<Content> cc) {
        final Image3DUniverse univ = this;
        ArrayList<Future<Content>> all = new ArrayList<Future<Content>>();
        for (final Content c : cc) {
            all.add(this.adder.submit(new Callable<Content>(){

                @Override
                public Content call() {
                    if (!Image3DUniverse.this.addContentToScene(c)) {
                        return null;
                    }
                    univ.fireContentAdded(c);
                    univ.addUniverseListener(c);
                    return c;
                }
            }));
        }
        this.adder.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() {
                if (univ.autoAdjustView) {
                    univ.getViewPlatformTransformer().centerAt(univ.globalCenter);
                    float range = (float)(univ.globalMax.x - univ.globalMin.x);
                    univ.ensureScale(range);
                }
                univ.waitForNextFrame();
                univ.fireTransformationUpdated();
                return true;
            }
        });
        return all;
    }

    static {
        UniverseSettings.load();
    }
}

