/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.launcher;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.scijava.launcher.Archives;
import org.scijava.launcher.ClassLauncher;
import org.scijava.launcher.ClassLoaders;
import org.scijava.launcher.Config;
import org.scijava.launcher.Dialogs;
import org.scijava.launcher.Downloader;
import org.scijava.launcher.Log;
import org.scijava.launcher.Splash;
import org.scijava.launcher.Versions;

public class Java {
    public static void check() throws IOException {
        Path good;
        Splash.update("Checking Java version...");
        if (!Java.isBelowRecommended()) {
            return;
        }
        String appName = ClassLauncher.appName("the application");
        String warnAboutOldJavaVersion = "The Java version currently in use, " + Java.currentVersion() + ", is below the " + (Java.isBelowMinimum() ? "<strong>required</strong> minimum of " + Java.minimumVersion() : "recommended minimum of " + Java.recommendedVersion()) + ".";
        String questionPrompt = "<br><br>How would you like to proceed?";
        String appMightNotWorkProperly = "<br>It is strongly recommended to upgrade it, or " + appName + " may not work properly.";
        String appMightCrash = "<br>If you continue the launch with this version of Java, " + appName + " might crash.";
        warnAboutOldJavaVersion = warnAboutOldJavaVersion + (Java.isBelowMinimum() ? appMightCrash : appMightNotWorkProperly);
        boolean warned = false;
        if (!Java.isManaged() && !Java.isBundled()) {
            String message = warnAboutOldJavaVersion + "<br>It looks like you have manually configured your Java installation.<br>You can convert to automated Java upgrades, or launch as normal.<br>" + questionPrompt;
            if (!Java.askIfAllowed("skipVersionWarning", message, "Convert", "Launch anyway", "Launch and never warn again")) {
                return;
            }
            warned = true;
        }
        if ((good = Java.goodInstallation()) != null) {
            String message;
            if (!warned && !Java.askIfAllowed("skipUpgradePrompt", message = warnAboutOldJavaVersion + "<br>It appears there is a good-enough version of Java already installed at " + good + "<br>Would you like to use it?", "Use it", "No, launch anyway", "No and never ask again")) {
                return;
            }
            Java.updateJavaPath(good);
            Java.notifyAndShutdown("<html>" + ClassLauncher.appName() + " has been successfully updated to use the newer Java.<br>Please restart " + ClassLauncher.appName() + " to apply the changes.");
        } else {
            String message;
            String javaLink = Java.getJavaLink();
            if (javaLink == null) {
                String message2 = warnAboutOldJavaVersion + "<br>Unfortunately we couldn't find a Java download for your platform.<br>URL checked: " + Java.sysProp("scijava.app.java-links") + "<br>Platform detected: " + Java.sysProp("scijava.app.java-platform") + "<br>Please report this failure on forum.image.sc.";
                Dialogs.ask(null, message2, "OK", null, null);
                return;
            }
            if (!warned && !Java.askIfAllowed("skipUpgradePrompt", message = warnAboutOldJavaVersion + "<br>Would you like to download and install a new version of Java?", "Upgrade", "No, launch anyway", "No and never ask again")) {
                return;
            }
            Java.upgrade();
        }
    }

    public static String currentVersion() {
        return Java.sysProp("java.version", "Cannot resolve current Java version");
    }

    public static String minimumVersion() {
        return Java.sysProp("scijava.app.java-version-minimum", "No minimum Java version specified");
    }

    public static String recommendedVersion() {
        return Java.sysProp("scijava.app.java-version-recommended", "No recommended Java version specified");
    }

    public static List<Path> installations() throws IOException {
        Path javaRoot = Java.root();
        if (javaRoot == null) {
            return Collections.emptyList();
        }
        try (Stream<Path> paths = Files.walk(javaRoot, 2, FileVisitOption.FOLLOW_LINKS);){
            List<Path> list = paths.filter(path -> path.getFileName().toString().equals("release")).filter(path -> path.getNameCount() == javaRoot.getNameCount() + 2).collect(Collectors.toList());
            return list;
        }
    }

    public static Path goodInstallation() throws IOException {
        String recommended = Java.recommendedVersion();
        for (Path javaHome : Java.installations()) {
            String v = Java.readVersion(javaHome);
            if (v == null || Versions.compare(v, recommended) < 0) continue;
            return javaHome;
        }
        return null;
    }

    public static boolean isBelowMinimum() {
        try {
            return Versions.compare(Java.currentVersion(), Java.minimumVersion()) < 0;
        }
        catch (IllegalStateException exc) {
            Log.debug(exc);
            return false;
        }
    }

    public static boolean isBelowRecommended() {
        try {
            return Versions.compare(Java.currentVersion(), Java.recommendedVersion()) < 0;
        }
        catch (IllegalStateException exc) {
            Log.debug(exc);
            return false;
        }
    }

    public static Path home() {
        String javaHomeValue = System.getProperty("java.home");
        if (javaHomeValue == null) {
            return null;
        }
        Path javaHome = Paths.get(javaHomeValue, new String[0]);
        return javaHome.toFile().exists() ? javaHome : null;
    }

    public static Path root() {
        return Java.root(false);
    }

    public static Path root(boolean create) {
        String javaDir = System.getProperty("scijava.app.java-root");
        if (javaDir == null || javaDir.isEmpty()) {
            return null;
        }
        Path javaDirPath = Paths.get(javaDir, new String[0]);
        File javaDirFile = javaDirPath.toFile();
        if (create && !javaDirFile.exists()) {
            javaDirFile.mkdirs();
        }
        return javaDirFile.exists() ? javaDirPath : null;
    }

    public static boolean isManaged() {
        Path javaHome = Java.home();
        Path javaRoot = Java.root();
        return Java.isNested(javaHome, javaRoot);
    }

    public static boolean isBundled() {
        Path javaHome = Java.home();
        Path appDir = ClassLauncher.appDir();
        return Java.isNested(javaHome, appDir);
    }

    public static boolean isHeadless() {
        return Boolean.getBoolean("java.awt.headless");
    }

    public static void upgrade() {
        Java.upgrade(Java.isHeadless());
    }

    public static void upgrade(boolean headless) {
        if (!headless) {
            Splash.show(false);
        }
        String upgradeComplete = "<html>Java has been updated successfully.<br>Please restart " + ClassLauncher.appName() + " to apply the changes.";
        try {
            if (headless) {
                String[] message = new String[]{""};
                Java.upgrade((s, fraction) -> {
                    String latest;
                    StringBuilder sb = new StringBuilder();
                    sb.append(s == null ? "Downloading Java" : s);
                    if (fraction != null) {
                        int p = (int)(100.0 * fraction);
                        sb.append(" [").append(p).append("]");
                    }
                    if (!(latest = sb.toString()).equals(message[0])) {
                        message[0] = latest;
                        System.out.println(message[0]);
                    }
                });
                upgradeComplete = "Java has been updated successfully.\nPlease restart " + ClassLauncher.appName() + " to apply the changes.";
            } else {
                Java.upgrade(Splash::update);
            }
        }
        catch (IOException e) {
            Log.error(e);
        }
        finally {
            if (!headless) {
                Splash.hide();
            }
        }
        Java.notifyAndShutdown(upgradeComplete, headless);
    }

    public static void upgrade(BiConsumer<String, Double> subscriber) throws IOException {
        File javaRootFile;
        Path javaRootPath = Java.root(true);
        File file = javaRootFile = javaRootPath == null ? null : javaRootPath.toFile();
        if (javaRootFile == null || !javaRootFile.isDirectory()) {
            throw new IOException("Invalid Java root directory");
        }
        subscriber.accept("Updating Java...", Double.NaN);
        String javaLink = Java.getJavaLink();
        if (javaLink == null) {
            Log.error("No Java download available for platform: " + Java.sysProp("scijava.app.java-platform"));
            return;
        }
        String prefix = Java.class.getName() + "-";
        Matcher m = Pattern.compile(".*?((\\.tar)?\\.[^.]*)$").matcher(javaLink);
        String suffix = m.matches() ? m.group(1) : null;
        File tmpArchive = Files.createTempFile(prefix, suffix, new FileAttribute[0]).toFile();
        tmpArchive.deleteOnExit();
        Java.waitForTask(Downloader.download(new URL(javaLink), tmpArchive, d -> subscriber.accept("Downloading Java...", (Double)d)));
        String[] dir = new String[]{null};
        Java.waitForTask(Archives.unpack(tmpArchive, javaRootFile, s -> {
            if (s != null && dir[0] == null && s.endsWith("/")) {
                dir[0] = s;
            }
            subscriber.accept("Unpacking " + s, Double.NaN);
        }));
        if (dir[0] != null) {
            Path newJavaPath = javaRootPath.resolve(dir[0]).normalize().toAbsolutePath();
            Java.updateJavaPath(newJavaPath);
        }
        subscriber.accept("Java update complete", Double.NaN);
    }

    private static void updateJavaPath(Path newJavaPath) throws IOException {
        String configFileValue = System.getProperty("scijava.app.config-file");
        if (configFileValue != null && !configFileValue.isEmpty()) {
            File configFile = new File(configFileValue);
            Path appDirPath = ClassLauncher.appDir();
            if (appDirPath != null) {
                try {
                    newJavaPath = appDirPath.relativize(newJavaPath);
                }
                catch (IllegalArgumentException exc) {
                    Log.debug(exc);
                }
            }
            Config.update(configFile, "jvm-dir", newJavaPath.toString());
        }
    }

    private static String getJavaLink() throws IOException {
        String javaLinks = Java.sysProp("scijava.app.java-links");
        List<String> lines = Downloader.downloadText(new URL(javaLinks));
        String javaPlatform = Java.sysProp("scijava.app.java-platform");
        return lines.stream().filter(line -> line.startsWith(javaPlatform + "=")).map(line -> line.substring(javaPlatform.length() + 1)).findFirst().orElse(null);
    }

    private static boolean isNested(Path test, Path root) {
        if (root == null || test == null) {
            return false;
        }
        return test.normalize().startsWith(root);
    }

    private static void notifyAndShutdown(String message) {
        Java.notifyAndShutdown(message, false);
    }

    private static void notifyAndShutdown(String message, boolean headless) {
        if (headless) {
            System.out.println(message);
        } else {
            Dialogs.ask(null, message, "OK", null, null);
        }
        System.exit(0);
    }

    private static String sysProp(String key) {
        return Java.sysProp(key, key + " is unset");
    }

    private static String sysProp(String key, String errorMessage) {
        String value = System.getProperty(key);
        if (value == null || value.isEmpty()) {
            throw new IllegalStateException(errorMessage);
        }
        return value;
    }

    private static String readVersion(Path releasePath) {
        try {
            String prefix = "JAVA_VERSION=";
            return Files.readAllLines(releasePath).stream().filter(line -> line.startsWith(prefix)).map(line -> line.substring(prefix.length()).replaceAll("\"", "")).findFirst().orElse(null);
        }
        catch (IOException e) {
            Log.debug(e);
            return null;
        }
    }

    private static boolean askIfAllowed(String prefKey, String message, String yes, String no, String never) {
        Preferences prefs = Preferences.userNodeForPackage(Java.class);
        boolean skipPrompt = prefs.getBoolean(prefKey, false);
        if (skipPrompt) {
            return false;
        }
        Dialogs.Result choice = Dialogs.ask(null, "<html>" + message, yes, no, never);
        switch (choice) {
            case YES: {
                return true;
            }
            case NEVER: {
                prefs.putBoolean(prefKey, true);
                return false;
            }
        }
        return false;
    }

    static void informAndMaybeUpgrade(UnsupportedClassVersionError e) {
        if (Java.isHeadless()) {
            throw e;
        }
        StringBuilder message = new StringBuilder("<html>");
        message.append("<p>").append(ClassLauncher.appName("The application")).append(" failed to launch because it requires a newer version of Java.").append("</p>");
        String currentVersion = System.getProperty("java.version");
        message.append("<ul><li>Current Java version: ").append(currentVersion).append("</li>");
        String classVersion = ClassLoaders.extractClassVersion(e);
        String neededVersion = classVersion == null ? "&lt;unknown&gt;" : Versions.classVersionToJavaVersion(classVersion);
        message.append("<li>Needed Java version: ").append(neededVersion).append("</li>");
        message.append("</ul><p>How would you like to proceed?</p>");
        Dialogs.Result choice = Dialogs.ask(null, message.toString(), "Upgrade Java", "Just quit", null);
        if (choice == Dialogs.Result.YES) {
            Java.upgrade();
        } else {
            System.exit(1);
        }
    }

    private static <T> T waitForTask(Future<T> task) throws IOException {
        try {
            return task.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IOException(e);
        }
    }
}

