/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe;

import com.amazonaws.services.s3.AmazonS3;
import java.net.URI;
import java.nio.file.FileSystems;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.janelia.saalfeldlab.googlecloud.GoogleCloudStorageURI;
import org.janelia.saalfeldlab.googlecloud.GoogleCloudUtils;
import org.janelia.saalfeldlab.n5.FileSystemKeyValueAccess;
import org.janelia.saalfeldlab.n5.HttpKeyValueAccess;
import org.janelia.saalfeldlab.n5.KeyValueAccess;
import org.janelia.saalfeldlab.n5.N5Exception;
import org.janelia.saalfeldlab.n5.googlecloud.GoogleCloudStorageKeyValueAccess;
import org.janelia.saalfeldlab.n5.s3.AmazonS3KeyValueAccess;
import org.janelia.saalfeldlab.n5.s3.AmazonS3Utils;
import org.janelia.saalfeldlab.n5.universe.N5Factory;

public enum KeyValueAccessBackend implements Predicate<URI>,
BiFunction<URI, N5Factory, KeyValueAccess>
{
    GOOGLE_CLOUD(uri -> {
        String scheme = uri.getScheme();
        boolean hasScheme = scheme != null;
        return hasScheme && GoogleCloudUtils.GS_SCHEME.asPredicate().test(scheme) || hasScheme && N5Factory.HTTPS_SCHEME.asPredicate().test(scheme) && uri.getHost() != null && GoogleCloudUtils.GS_HOST.asPredicate().test(uri.getHost());
    }, KeyValueAccessBackend::newGoogleCloudKeyValueAccess),
    AWS(uri -> {
        String scheme = uri.getScheme();
        boolean hasScheme = scheme != null;
        return hasScheme && AmazonS3Utils.S3_SCHEME.asPredicate().test(scheme) || uri.getHost() != null && hasScheme && N5Factory.HTTPS_SCHEME.asPredicate().test(scheme);
    }, KeyValueAccessBackend::newAmazonS3KeyValueAccess),
    HTTP(uri -> {
        String scheme = uri.getScheme();
        boolean hasScheme = scheme != null;
        return hasScheme && N5Factory.HTTPS_SCHEME.asPredicate().test(scheme);
    }, KeyValueAccessBackend::newHttpKeyValueAccess),
    FILE(uri -> {
        String scheme = uri.getScheme();
        boolean hasScheme = scheme != null;
        return !hasScheme || N5Factory.FILE_SCHEME.asPredicate().test(scheme);
    }, KeyValueAccessBackend::newFileSystemKeyValueAccess);

    private final Predicate<URI> backendTest;
    private final BiFunction<URI, N5Factory, KeyValueAccess> backendGenerator;

    private KeyValueAccessBackend(Predicate<URI> test, BiFunction<URI, N5Factory, KeyValueAccess> generator) {
        this.backendTest = test;
        this.backendGenerator = generator;
    }

    @Override
    public KeyValueAccess apply(URI uri, N5Factory factory) {
        return this.backendGenerator.apply(uri, factory);
    }

    @Override
    public boolean test(URI uri) {
        return this.backendTest.test(uri);
    }

    @Nullable
    public static KeyValueAccess getKeyValueAccess(URI uri) {
        return KeyValueAccessBackend.getKeyValueAccess(uri, N5Factory.FACTORY);
    }

    @Nullable
    static KeyValueAccess getKeyValueAccess(URI uri, N5Factory factory) {
        N5Exception.N5IOException testPassedButThrown = null;
        for (KeyValueAccessBackend backend : KeyValueAccessBackend.values()) {
            if (!backend.test(uri)) continue;
            try {
                return backend.apply(uri, factory);
            }
            catch (Exception e) {
                String reason = String.format("Inferred Backend was %s but could not create KeyValueAccess", backend);
                testPassedButThrown = new N5Exception.N5IOException(reason, e);
            }
        }
        if (testPassedButThrown != null) {
            throw testPassedButThrown;
        }
        return null;
    }

    private static GoogleCloudStorageKeyValueAccess newGoogleCloudKeyValueAccess(URI uri, N5Factory factory) {
        GoogleCloudStorageURI googleCloudUri = new GoogleCloudStorageURI(uri);
        return new GoogleCloudStorageKeyValueAccess(factory.createGoogleCloudStorage(), googleCloudUri, true);
    }

    private static AmazonS3KeyValueAccess newAmazonS3KeyValueAccess(URI uri, N5Factory factory) {
        String uriString = uri.toString();
        AmazonS3 s3 = factory.createS3(uriString);
        return new AmazonS3KeyValueAccess(s3, uri, true);
    }

    private static FileSystemKeyValueAccess newFileSystemKeyValueAccess(URI uri, N5Factory factory) {
        return new FileSystemKeyValueAccess(FileSystems.getDefault());
    }

    private static HttpKeyValueAccess newHttpKeyValueAccess(URI uri, N5Factory factory) {
        return new HttpKeyValueAccess();
    }
}

