/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe;

import com.google.gson.JsonElement;
import java.net.URI;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.UUID;
import net.imglib2.util.Pair;
import org.janelia.saalfeldlab.n5.CachedGsonKeyValueN5Reader;
import org.janelia.saalfeldlab.n5.N5KeyValueReader;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.N5Writer;
import org.janelia.saalfeldlab.n5.hdf5.N5HDF5Reader;
import org.janelia.saalfeldlab.n5.universe.N5Factory;
import org.janelia.saalfeldlab.n5.universe.StorageFormat;
import org.janelia.saalfeldlab.n5.zarr.ZarrKeyValueReader;

public class N5FactoryWithCache
extends N5Factory {
    private final HashMap<URI, N5Reader> readerCache = new HashMap();
    private final HashMap<URI, N5Writer> writerCache = new HashMap();

    @Override
    public N5Reader openReader(StorageFormat format, URI uri) {
        URI normalUri = N5FactoryWithCache.normalizeUri(uri);
        N5Reader reader = this.getReaderFromCache(format, normalUri);
        if (reader != null) {
            return reader;
        }
        return this.openAndCacheReader(format, normalUri);
    }

    @Override
    public N5Writer openWriter(StorageFormat format, URI uri) {
        URI normalUri = N5FactoryWithCache.normalizeUri(uri);
        N5Writer writer = this.getWriterFromCache(format, normalUri);
        if (writer != null) {
            return writer;
        }
        return this.openAndCacheWriter(format, normalUri);
    }

    private N5Reader openAndCacheReader(StorageFormat storageFormat, URI uri) {
        N5Reader reader = super.openReader(storageFormat, uri);
        if (reader == null) {
            return null;
        }
        this.readerCache.put(uri, reader);
        return reader;
    }

    protected synchronized N5Reader getReaderFromCache(StorageFormat format, URI uri) {
        N5Reader reader = this.readerCache.get(uri);
        if (reader == null) {
            return null;
        }
        if (!this.n5MatchesFormat(reader, format) || !this.canRead(reader)) {
            this.readerCache.remove(uri);
            return null;
        }
        return reader;
    }

    private boolean canRead(N5Reader reader) {
        try {
            if (reader instanceof CachedGsonKeyValueN5Reader) {
                ((CachedGsonKeyValueN5Reader)reader).getAttributesFromContainer("/", "/");
            } else {
                reader.getAttribute("/", "/", JsonElement.class);
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private N5Writer openAndCacheWriter(StorageFormat storageFormat, URI uri) {
        N5Writer writer = super.openWriter(storageFormat, uri);
        if (writer == null) {
            return null;
        }
        this.writerCache.put(uri, writer);
        return writer;
    }

    protected synchronized N5Writer getWriterFromCache(StorageFormat format, URI uri) {
        N5Writer writer = this.writerCache.get(uri);
        if (writer == null) {
            return null;
        }
        if (!this.n5MatchesFormat(writer, format) || !this.canWrite(writer)) {
            this.writerCache.remove(uri);
            return null;
        }
        return writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canWrite(N5Writer writer) {
        if (this.canRead(writer)) {
            return true;
        }
        String uuid = UUID.randomUUID().toString();
        try {
            writer.setAttribute("/", uuid, "CACHE_CHECK");
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                writer.removeAttribute("/", uuid);
            }
            catch (Exception exception) {}
        }
    }

    private boolean n5MatchesFormat(N5Reader reader, StorageFormat format) {
        if (format == null) {
            return true;
        }
        switch (format) {
            case N5: {
                return reader instanceof N5KeyValueReader;
            }
            case ZARR: {
                return reader instanceof ZarrKeyValueReader;
            }
            case HDF5: {
                return reader instanceof N5HDF5Reader;
            }
        }
        return true;
    }

    public void clear() {
        this.readerCache.clear();
        this.writerCache.clear();
    }

    public boolean remove(URI uri) {
        URI normalUri = N5FactoryWithCache.normalizeUri(uri);
        boolean removed = this.readerCache.remove(normalUri) != null;
        return removed |= this.writerCache.remove(normalUri) != null;
    }

    public boolean remove(String uri) {
        Pair<StorageFormat, URI> storageFormatURIPair = StorageFormat.parseUri(uri);
        return this.remove((URI)storageFormatURIPair.getB());
    }

    private static URI normalizeUri(URI uri) {
        if (uri.isAbsolute() && !uri.getScheme().equals("file")) {
            return uri.normalize();
        }
        URI uriFromPath = uri.isAbsolute() ? Paths.get(uri).normalize().toUri() : Paths.get(uri.getPath(), new String[0]).normalize().toUri();
        String uriWithoutTrailingSlash = uriFromPath.toString().replaceAll("/$", "");
        return URI.create(uriWithoutTrailingSlash).normalize();
    }
}

