/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe;

import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.janelia.saalfeldlab.n5.N5URI;
import org.janelia.saalfeldlab.n5.universe.metadata.N5DatasetMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.N5Metadata;

public class N5TreeNode {
    private final String path;
    private N5Metadata metadata;
    private final ArrayList<N5TreeNode> children;

    public N5TreeNode(String path) {
        this.path = path.trim();
        this.children = new ArrayList();
    }

    public static Stream<N5TreeNode> flattenN5Tree(N5TreeNode root) {
        return Stream.concat(Stream.of(root), root.childrenList().stream().flatMap(N5TreeNode::flattenN5Tree));
    }

    public String getNodeName() {
        return Paths.get(N5TreeNode.removeLeadingSlash(this.path), new String[0]).getFileName().toString();
    }

    public String getParentPath() {
        return Paths.get(N5TreeNode.removeLeadingSlash(this.path), new String[0]).getParent().toString();
    }

    public void add(N5TreeNode child) {
        this.children.add(child);
    }

    public void remove(N5TreeNode child) {
        this.children.remove(child);
    }

    public void removeAllChildren() {
        this.children.clear();
    }

    public List<N5TreeNode> childrenList() {
        return this.children;
    }

    public Optional<N5TreeNode> child(String name) {
        String childPath = N5URI.normalizeGroupPath(this.path + "/" + name);
        return this.children.stream().filter(x -> N5URI.normalizeGroupPath(x.getPath()).equals(childPath)).findFirst();
    }

    public Optional<N5TreeNode> getDescendant(String path) {
        return this.getDescendants(x -> N5URI.normalizeGroupPath(x.getPath()).equals(N5URI.normalizeGroupPath(path))).findFirst();
    }

    public N5TreeNode addPath(String path) {
        return this.addPath(path, x -> new N5TreeNode((String)x));
    }

    public N5TreeNode addPath(String path, Function<String, N5TreeNode> constructor) {
        String normPath = N5TreeNode.removeLeadingSlash(path);
        if (!this.getPath().isEmpty() && !normPath.startsWith(this.getPath())) {
            return null;
        }
        if (this.path.equals(normPath)) {
            return this;
        }
        String relativePath = N5TreeNode.removeLeadingSlash(normPath.replaceAll(this.path, ""));
        int sepIdx = relativePath.indexOf("/");
        String childName = sepIdx < 0 ? relativePath : relativePath.substring(0, sepIdx);
        N5TreeNode child = null;
        Stream<N5TreeNode> cs = this.children.stream().filter(n -> n.getNodeName().equals(childName));
        Optional<N5TreeNode> copt = cs.findFirst();
        if (copt.isPresent()) {
            child = copt.get();
        } else {
            child = constructor.apply(this.path.isEmpty() ? childName : this.path + "/" + childName);
            this.add(child);
        }
        return child.addPath(normPath);
    }

    public Stream<N5TreeNode> getDescendants(Predicate<N5TreeNode> filter) {
        return N5TreeNode.flattenN5Tree(this).filter(filter);
    }

    public boolean isDataset() {
        return Optional.ofNullable(this.getMetadata()).map(N5DatasetMetadata.class::isInstance).orElse(false);
    }

    public void setMetadata(N5Metadata metadata) {
        this.metadata = metadata;
    }

    public N5Metadata getMetadata() {
        return this.metadata;
    }

    public String getPath() {
        return this.path;
    }

    public String toString() {
        String nodeName = this.getNodeName();
        return nodeName.isEmpty() ? "/" : nodeName;
    }

    public boolean structureEquals(N5TreeNode other) {
        boolean samePath = this.getPath().equals(other.getPath());
        if (!samePath) {
            return false;
        }
        boolean childrenEqual = true;
        for (N5TreeNode c : this.childrenList()) {
            Optional<N5TreeNode> otherChildOpt = other.childrenList().stream().filter(x -> x.getNodeName().equals(c.getNodeName())).findFirst();
            if (childrenEqual = childrenEqual && otherChildOpt.map(x -> x.structureEquals(c)).orElse(false) != false) continue;
            break;
        }
        return childrenEqual;
    }

    public String printRecursive() {
        return N5TreeNode.printRecursiveHelper(this, "");
    }

    private static String printRecursiveHelper(N5TreeNode node, String prefix) {
        StringBuffer out = new StringBuffer();
        out.append(prefix + node.path + "\n");
        for (N5TreeNode c : node.childrenList()) {
            System.out.println(c.path);
            out.append(N5TreeNode.printRecursiveHelper(c, prefix + " "));
        }
        return out.toString();
    }

    public static N5TreeNode fromFlatList(String base, String[] pathList, String groupSeparator) {
        N5TreeNode root = new N5TreeNode(base);
        N5TreeNode.fromFlatList(root, pathList, groupSeparator);
        return root;
    }

    public static void fromFlatList(N5TreeNode root, String[] pathList, String groupSeparator) {
        HashMap<String, N5TreeNode> pathToNode = new HashMap<String, N5TreeNode>();
        String normalizedBase = N5TreeNode.normalDatasetName(root.getPath(), groupSeparator);
        pathToNode.put(normalizedBase, root);
        Arrays.sort(pathList);
        String prefix = normalizedBase == groupSeparator ? "" : normalizedBase;
        for (String datasetPath : pathList) {
            String fullPath = prefix + groupSeparator + datasetPath;
            N5TreeNode node = new N5TreeNode(fullPath);
            pathToNode.put(fullPath, node);
            String parentPath = fullPath.substring(0, fullPath.lastIndexOf(groupSeparator));
            N5TreeNode parent = (N5TreeNode)pathToNode.get(parentPath);
            if (parent == null) {
                parent = new N5TreeNode(parentPath);
                pathToNode.put(parentPath, parent);
            }
            if (parent.child(datasetPath).isPresent()) continue;
            parent.add(node);
        }
    }

    private static String normalDatasetName(String fullPath, String groupSeparator) {
        return fullPath.replaceAll("(^" + groupSeparator + "*)|(" + groupSeparator + "*$)", "");
    }

    protected static String removeLeadingSlash(String pathName) {
        return pathName.startsWith("/") || pathName.startsWith("\\") ? pathName.substring(1) : pathName;
    }
}

