/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe;

import java.io.File;
import java.net.URI;
import java.util.Arrays;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.imglib2.util.Pair;
import net.imglib2.util.ValuePair;
import org.janelia.saalfeldlab.n5.KeyValueAccess;
import org.janelia.saalfeldlab.n5.hdf5.HDF5Utils;
import org.janelia.saalfeldlab.n5.universe.N5Factory;

public enum StorageFormat {
    ZARR(Pattern.compile("zarr", 2), uri -> Pattern.compile("\\.zarr$", 2).matcher(new File(uri.getPath()).toString()).find()),
    N5(Pattern.compile("n5", 2), uri -> Pattern.compile("\\.n5$", 2).matcher(new File(uri.getPath()).toString()).find()),
    HDF5(Pattern.compile("h(df)?5", 2), uri -> {
        boolean hasHdf5Extension = Pattern.compile("\\.h(df)?5$", 2).matcher(uri.getPath()).find();
        return hasHdf5Extension || HDF5Utils.isHDF5((String)uri.getPath());
    });

    static final Pattern STORAGE_SCHEME_PATTERN;
    private static final String STORAGE_SCHEME_GROUP = "storageScheme";
    private static final String URI_GROUP = "uri";
    final Pattern schemePattern;
    private final Predicate<URI> uriTest;
    private static final String ZARRAY = ".zarray";
    private static final String ZGROUP = ".zgroup";
    private static final String ZATTRS = ".zattrs";
    private static final String[] ZARR2_KEYS;
    private static final String Z3ATTRS = ".zattrs";
    private static final String N5_ATTRIBUTES = "attributes.json";

    private StorageFormat(Pattern schemePattern, Predicate<URI> test) {
        this.schemePattern = schemePattern;
        this.uriTest = test;
    }

    public static StorageFormat guessStorageFromUri(URI uri) {
        for (StorageFormat format : StorageFormat.values()) {
            if (!format.uriTest.test(uri)) continue;
            return format;
        }
        return null;
    }

    public static Pair<StorageFormat, URI> parseUri(String uri) {
        Pair<StorageFormat, String> storageFromScheme = StorageFormat.getStorageFromNestedScheme(uri);
        URI asUri = N5Factory.parseUriFromString((String)storageFromScheme.getB());
        if (storageFromScheme.getA() != null) {
            return new ValuePair(storageFromScheme.getA(), (Object)asUri);
        }
        return new ValuePair((Object)StorageFormat.guessStorageFromUri(asUri), (Object)asUri);
    }

    public static Pair<StorageFormat, String> getStorageFromNestedScheme(String uri) {
        Matcher storageSchemeMatcher = STORAGE_SCHEME_PATTERN.matcher(uri);
        storageSchemeMatcher.matches();
        String storageFormatScheme = storageSchemeMatcher.group(STORAGE_SCHEME_GROUP);
        String uriGroup = storageSchemeMatcher.group(URI_GROUP);
        if (storageFormatScheme != null) {
            for (StorageFormat format : StorageFormat.values()) {
                if (!format.schemePattern.asPredicate().test(storageFormatScheme)) continue;
                return new ValuePair((Object)format, (Object)uriGroup);
            }
        }
        return new ValuePair(null, (Object)uriGroup);
    }

    @Nullable
    public static StorageFormat guessStorageFromKeys(URI root, KeyValueAccess kva) {
        URI uri = root.isAbsolute() ? root : URI.create("file://" + root);
        if (Arrays.stream(ZARR2_KEYS).anyMatch(it -> kva.exists(kva.compose(uri, (String)it)))) {
            return ZARR;
        }
        if (kva.exists(kva.compose(uri, N5_ATTRIBUTES))) {
            return N5;
        }
        return null;
    }

    static {
        STORAGE_SCHEME_PATTERN = Pattern.compile("^(\\s*(?<storageScheme>(n5|h(df)?5|zarr)):(//)?)?(?<uri>.*)$", 2);
        ZARR2_KEYS = new String[]{ZARRAY, ZGROUP, ".zattrs"};
    }
}

