/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe.metadata.canonical;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import net.thisptr.jackson.jq.BuiltinFunctionLoader;
import net.thisptr.jackson.jq.Expression;
import net.thisptr.jackson.jq.Function;
import net.thisptr.jackson.jq.JsonQuery;
import net.thisptr.jackson.jq.PathOutput;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.Version;
import net.thisptr.jackson.jq.Versions;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.internal.misc.Strings;
import net.thisptr.jackson.jq.path.Path;
import org.janelia.saalfeldlab.n5.Bzip2Compression;
import org.janelia.saalfeldlab.n5.Compression;
import org.janelia.saalfeldlab.n5.DataType;
import org.janelia.saalfeldlab.n5.DatasetAttributes;
import org.janelia.saalfeldlab.n5.GsonN5Reader;
import org.janelia.saalfeldlab.n5.GsonUtils;
import org.janelia.saalfeldlab.n5.GzipCompression;
import org.janelia.saalfeldlab.n5.Lz4Compression;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.RawCompression;
import org.janelia.saalfeldlab.n5.XzCompression;
import org.janelia.saalfeldlab.n5.universe.N5TreeNode;
import org.janelia.saalfeldlab.n5.universe.container.ContainerMetadataNode;
import org.janelia.saalfeldlab.n5.universe.metadata.N5Metadata;
import org.janelia.saalfeldlab.n5.universe.metadata.N5MetadataParser;

public abstract class AbstractMetadataTemplateParser<T extends N5Metadata>
implements N5MetadataParser<T> {
    private final String translation;
    private final Scope scope;
    private final Gson gson;
    private final ObjectMapper objMapper;

    public AbstractMetadataTemplateParser(Gson gson, String translation) {
        this.translation = translation;
        this.gson = gson;
        this.scope = AbstractMetadataTemplateParser.buildRootScope();
        this.objMapper = new ObjectMapper();
    }

    public String transform(String in) throws JsonMappingException, JsonProcessingException {
        JsonNode inJsonNode = this.objMapper.readTree(in);
        ArrayList out = new ArrayList();
        JsonQuery.compile((String)this.translation, (Version)Versions.JQ_1_6).apply(this.scope, inJsonNode, out::add);
        StringBuffer stringOutput = new StringBuffer();
        for (JsonNode n : out) {
            stringOutput.append(n.toString() + "\n");
        }
        return stringOutput.toString();
    }

    @Override
    public Optional<T> parseMetadata(N5Reader n5, N5TreeNode node) {
        if (!(n5 instanceof GsonN5Reader)) {
            return Optional.empty();
        }
        JsonElement elem = ((GsonN5Reader)n5).getAttributes(node.getPath());
        if (!elem.isJsonObject()) {
            return Optional.empty();
        }
        JsonObject attrs = elem.getAsJsonObject();
        if (attrs.isEmpty()) {
            System.err.println("could not parse attributes");
            return Optional.empty();
        }
        try {
            HashMap map;
            JsonNode in = this.objMapper.readTree(this.gson.toJson((JsonElement)attrs));
            ArrayList out = new ArrayList();
            JsonQuery.compile((String)this.translation, (Version)Versions.JQ_1_6).apply(this.scope, in, out::add);
            StringBuffer stringOutput = new StringBuffer();
            for (JsonNode n : out) {
                stringOutput.append(n.toString() + "\n");
            }
            Type mapType = new TypeToken<HashMap<String, JsonElement>>(){}.getType();
            HashMap tmpmap = (HashMap)this.gson.fromJson(stringOutput.toString(), mapType);
            HashMap hashMap = map = tmpmap == null ? new HashMap() : tmpmap;
            if (!map.containsKey("path")) {
                map.put("path", new JsonPrimitive(node.getPath()));
            }
            return this.parseFromMap(this.gson, map);
        }
        catch (Exception exception) {
            return Optional.empty();
        }
    }

    public <R extends GsonN5Reader> Optional<T> parseMetadataTree(R n5, N5TreeNode node) {
        ContainerMetadataNode treeNode;
        try {
            treeNode = ContainerMetadataNode.build(n5, n5.getGson());
        }
        catch (Exception e) {
            return Optional.empty();
        }
        try {
            HashMap map;
            JsonNode in = this.objMapper.readTree(this.gson.toJson((Object)treeNode));
            ArrayList out = new ArrayList();
            JsonQuery.compile((String)this.translation, (Version)Versions.JQ_1_6).apply(this.scope, in, out::add);
            StringBuffer stringOutput = new StringBuffer();
            for (JsonNode n : out) {
                stringOutput.append(n.toString() + "\n");
            }
            Type mapType = new TypeToken<HashMap<String, JsonElement>>(){}.getType();
            HashMap tmpmap = (HashMap)this.gson.fromJson(stringOutput.toString(), mapType);
            HashMap hashMap = map = tmpmap == null ? new HashMap() : tmpmap;
            if (!map.containsKey("path")) {
                map.put("path", new JsonPrimitive(node.getPath()));
            }
            return this.parseFromMap(this.gson, map);
        }
        catch (Exception exception) {
            return Optional.empty();
        }
    }

    public static <S> Optional<S> parseFromObj(Gson gson, JsonObject object, BiFunction<Gson, HashMap<String, JsonElement>, Optional<S>> fun) {
        Type mapType = new TypeToken<Map<String, JsonElement>>(){}.getType();
        return fun.apply(gson, (HashMap<String, JsonElement>)gson.fromJson((JsonElement)object, mapType));
    }

    public static <S> Optional<S> parseFromMap(Gson gson, HashMap<String, JsonElement> object, BiFunction<Gson, JsonElement, Optional<S>> fun) {
        return fun.apply(gson, gson.toJsonTree(object));
    }

    public abstract Optional<T> parseFromMap(Gson var1, HashMap<String, JsonElement> var2);

    public Optional<T> parse(Gson gson, JsonElement elem) {
        if (elem.isJsonObject()) {
            return this.parseFromMap(gson, (HashMap)gson.fromJson(elem, HashMap.class));
        }
        return Optional.empty();
    }

    public static Scope buildRootScope() {
        Scope rootScope = Scope.newEmptyScope();
        BuiltinFunctionLoader.getInstance().loadFunctions(Versions.JQ_1_6, rootScope);
        rootScope.addFunction("repeat", 1, new Function(){

            public void apply(Scope scope, List<Expression> args, JsonNode in, Path path, PathOutput output, Version version) throws JsonQueryException {
                args.get(0).apply(scope, in, time -> output.emit((JsonNode)new TextNode(Strings.repeat((String)in.asText(), (int)time.asInt())), null));
            }
        });
        return rootScope;
    }

    public static Optional<DatasetAttributes> datasetAttributes(Gson gson, JsonObject attributes) {
        try {
            Compression compression;
            long[] dimensions = GsonUtils.readAttribute((JsonElement)attributes, "dimensions", long[].class, gson);
            if (dimensions == null) {
                return Optional.empty();
            }
            DataType dataType = GsonUtils.readAttribute((JsonElement)attributes, "dataType", DataType.class, gson);
            if (dataType == null) {
                return Optional.empty();
            }
            int[] blockSize = GsonUtils.readAttribute((JsonElement)attributes, "blockSize", int[].class, gson);
            if (blockSize == null) {
                blockSize = Arrays.stream(dimensions).mapToInt(a -> (int)a).toArray();
            }
            if ((compression = GsonUtils.readAttribute((JsonElement)attributes, "compression", Compression.class, gson)) == null) {
                switch (GsonUtils.readAttribute((JsonElement)attributes, "compression", String.class, gson)) {
                    case "raw": {
                        compression = new RawCompression();
                        break;
                    }
                    case "gzip": {
                        compression = new GzipCompression();
                        break;
                    }
                    case "bzip2": {
                        compression = new Bzip2Compression();
                        break;
                    }
                    case "lz4": {
                        compression = new Lz4Compression();
                        break;
                    }
                    case "xz": {
                        compression = new XzCompression();
                    }
                }
            }
            return Optional.of(new DatasetAttributes(dimensions, blockSize, dataType, compression));
        }
        catch (Exception exception) {
            return Optional.empty();
        }
    }

    public static Optional<DatasetAttributes> datasetAttributes(JsonDeserializationContext context, JsonElement elem) {
        try {
            Compression compression;
            long[] dimensions = (long[])context.deserialize(elem.getAsJsonObject().get("dimensions"), long[].class);
            if (dimensions == null) {
                return Optional.empty();
            }
            DataType dataType = (DataType)((Object)context.deserialize(elem.getAsJsonObject().get("dataType"), DataType.class));
            if (dataType == null) {
                return Optional.empty();
            }
            int[] blockSize = (int[])context.deserialize(elem.getAsJsonObject().get("blockSize"), int[].class);
            if (blockSize == null) {
                blockSize = Arrays.stream(dimensions).mapToInt(a -> (int)a).toArray();
            }
            if ((compression = (Compression)context.deserialize(elem.getAsJsonObject().get("compression"), Compression.class)) == null) {
                switch (compression.getType()) {
                    case "raw": {
                        compression = new RawCompression();
                        break;
                    }
                    case "gzip": {
                        compression = new GzipCompression();
                        break;
                    }
                    case "bzip2": {
                        compression = new Bzip2Compression();
                        break;
                    }
                    case "lz4": {
                        compression = new Lz4Compression();
                        break;
                    }
                    case "xz": {
                        compression = new XzCompression();
                    }
                }
            }
            return Optional.of(new DatasetAttributes(dimensions, blockSize, dataType, compression));
        }
        catch (Exception exception) {
            return Optional.empty();
        }
    }
}

