/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v03;

import java.util.HashMap;
import java.util.Optional;
import org.janelia.saalfeldlab.n5.DatasetAttributes;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.N5Writer;
import org.janelia.saalfeldlab.n5.universe.N5TreeNode;
import org.janelia.saalfeldlab.n5.universe.metadata.MetadataUtils;
import org.janelia.saalfeldlab.n5.universe.metadata.N5DatasetMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.N5Metadata;
import org.janelia.saalfeldlab.n5.universe.metadata.N5MetadataParser;
import org.janelia.saalfeldlab.n5.universe.metadata.N5MetadataWriter;
import org.janelia.saalfeldlab.n5.universe.metadata.N5SingleScaleMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v03.OmeNgffMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v03.OmeNgffMultiScaleMetadata;

public class OmeNgffMetadataParser
implements N5MetadataParser<OmeNgffMetadata>,
N5MetadataWriter<OmeNgffMetadata> {
    @Override
    public Optional<OmeNgffMetadata> parseMetadata(N5Reader n5, N5TreeNode node) {
        OmeNgffMultiScaleMetadata[] multiscales;
        try {
            multiscales = n5.getAttribute(node.getPath(), "multiscales", OmeNgffMultiScaleMetadata[].class);
        }
        catch (Exception e) {
            return Optional.empty();
        }
        if (multiscales == null || multiscales.length == 0) {
            return Optional.empty();
        }
        int nd = -1;
        HashMap<String, N5TreeNode> scaleLevelNodes = new HashMap<String, N5TreeNode>();
        for (N5TreeNode childNode : node.childrenList()) {
            if (!childNode.isDataset() || childNode.getMetadata() == null) continue;
            scaleLevelNodes.put(childNode.getPath(), childNode);
            if (nd >= 0) continue;
            nd = ((N5DatasetMetadata)childNode.getMetadata()).getAttributes().getNumDimensions();
        }
        if (nd < 0) {
            return Optional.empty();
        }
        for (OmeNgffMultiScaleMetadata ms : multiscales) {
            ms.path = node.getPath();
            String[] paths = ms.getPaths();
            DatasetAttributes[] attrs = new DatasetAttributes[ms.getPaths().length];
            N5DatasetMetadata[] dsetMeta = new N5DatasetMetadata[paths.length];
            for (int i = 0; i < paths.length; ++i) {
                dsetMeta[i] = (N5DatasetMetadata)((N5TreeNode)scaleLevelNodes.get(MetadataUtils.canonicalPath(node, paths[i]))).getMetadata();
                attrs[i] = dsetMeta[i].getAttributes();
            }
            N5Metadata[] msChildrenMeta = ms.buildChildren(nd, attrs);
            MetadataUtils.updateChildrenMetadata(node, msChildrenMeta, false);
            ms.childrenMetadata = msChildrenMeta;
            ms.childrenAttributes = attrs;
        }
        return Optional.of(new OmeNgffMetadata(node.getPath(), multiscales));
    }

    @Override
    public void writeMetadata(OmeNgffMetadata t, N5Writer n5, String path) throws Exception {
        n5.setAttribute(path, "multiscales", t.getMultiscales());
        if (t.getMultiscales().length <= 0) {
            return;
        }
        for (int i = 0; i < t.getMultiscales().length; ++i) {
            OmeNgffMultiScaleMetadata ms = t.getMultiscales()[i];
            for (int j = 0; j < t.getMultiscales().length; ++j) {
                OmeNgffMultiScaleMetadata.OmeNgffDataset ds = ms.datasets[j];
                N5SingleScaleMetadata meta = ms.childrenMetadata[j];
                String string = path + "/" + ds.path;
            }
        }
    }
}

