/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;
import net.imglib2.EuclideanSpace;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealRandomAccessible;
import net.imglib2.cache.img.CachedCellImg;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.interpolation.randomaccess.NLinearInterpolatorFactory;
import net.imglib2.realtransform.AffineGet;
import net.imglib2.realtransform.AffineTransform;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.realtransform.RealTransform;
import net.imglib2.realtransform.RealTransformRandomAccessible;
import net.imglib2.realtransform.ScaleAndTranslation;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.util.Pair;
import net.imglib2.util.ValuePair;
import net.imglib2.view.Views;
import org.janelia.saalfeldlab.n5.N5Exception;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.N5URI;
import org.janelia.saalfeldlab.n5.imglib2.N5Utils;
import org.janelia.saalfeldlab.n5.universe.N5Factory;
import org.janelia.saalfeldlab.n5.universe.metadata.axes.Axis;
import org.janelia.saalfeldlab.n5.universe.metadata.axes.CoordinateSystem;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.SpacesTransforms;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.graph.TransformGraph;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.AffineCoordinateTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.AffineCoordinateTransformAdapter;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.CoordinateTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.CoordinateTransformAdapter;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.IdentityCoordinateTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.ReferencedCoordinateTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.SequenceCoordinateTransform;

public class Common {
    public static void main(String[] args) {
        double[] flatMtx = new double[]{1.0, 0.0, 0.0, 10.0, 0.0, 2.0, 0.0, 20.0, 0.0, 0.0, 3.0, 30.0};
        System.out.println(Arrays.toString(flatMtx));
        AffineTransform affine3 = new AffineTransform(flatMtx);
        System.out.println(Arrays.toString(affine3.getRowPackedCopy()));
        AffineGet affine2a = Common.removeDimension(0, (AffineGet)affine3);
        System.out.println(Arrays.toString(affine2a.getRowPackedCopy()));
        AffineGet affine2b = Common.removeDimension(1, (AffineGet)affine3);
        System.out.println(Arrays.toString(affine2b.getRowPackedCopy()));
        AffineGet affine2c = Common.removeDimension(2, (AffineGet)affine3);
        System.out.println(Arrays.toString(affine2c.getRowPackedCopy()));
    }

    public static AffineGet removeDimension(int dim, AffineGet in) {
        int nd = in.numSourceDimensions();
        int ndout = nd - 1;
        double[] outMtx = new double[ndout * (ndout + 1)];
        int k = 0;
        for (int i = 0; i < nd; ++i) {
            if (i == dim) continue;
            for (int j = 0; j < nd + 1; ++j) {
                if (j == dim) continue;
                outMtx[k++] = in.get(i, j);
            }
        }
        return new AffineTransform(outMtx);
    }

    public static AffineTransform3D toAffine3D(SequenceCoordinateTransform seq) {
        return Common.toAffine3D(Arrays.asList(seq.getTransformations()));
    }

    public static AffineTransform3D toAffine3D(Collection<CoordinateTransform<?>> transforms) {
        return Common.toAffine3D(null, transforms);
    }

    public static AffineTransform3D toAffine3D(N5Reader n5, Collection<CoordinateTransform<?>> transforms) {
        AffineTransform3D total = new AffineTransform3D();
        for (CoordinateTransform<?> ct : transforms) {
            Object t;
            if (ct instanceof IdentityCoordinateTransform) continue;
            if (ct instanceof SequenceCoordinateTransform) {
                t = Common.toAffine3D((SequenceCoordinateTransform)ct);
                if (t == null) {
                    return null;
                }
                Common.preConcatenate(total, (AffineGet)t);
                continue;
            }
            t = ct.getTransform(n5);
            if (t instanceof AffineGet) {
                Common.preConcatenate(total, (AffineGet)t);
                continue;
            }
            return null;
        }
        return total;
    }

    public static void preConcatenate(AffineTransform3D tgt, AffineGet concatenate) {
        if (concatenate.numTargetDimensions() >= 3) {
            tgt.preConcatenate(concatenate);
        } else if (concatenate.numTargetDimensions() == 2) {
            AffineTransform3D c = new AffineTransform3D();
            c.set(concatenate.get(0, 0), concatenate.get(0, 1), 0.0, concatenate.get(0, 2), concatenate.get(1, 0), concatenate.get(1, 1), 0.0, concatenate.get(1, 2), 0.0, 0.0, 1.0, 0.0);
            tgt.preConcatenate(c);
        } else if (concatenate.numTargetDimensions() == 1) {
            ScaleAndTranslation c = new ScaleAndTranslation(new double[]{1.0, 1.0, 1.0}, new double[]{0.0, 0.0, 0.0});
            tgt.preConcatenate((AffineGet)c);
        }
    }

    public static CoordinateSystem makeSpace(String name, String type, String unit, String ... labels) {
        return new CoordinateSystem(name, (Axis[])Arrays.stream(labels).map(x -> new Axis((String)x, type, unit)).toArray(Axis[]::new));
    }

    public static CoordinateSystem makeDfieldSpace(String name, String type, String unit, String ... labels) {
        Axis[] axes = (Axis[])Stream.concat(Stream.of(new Axis("d", "displacement", unit)), Arrays.stream(labels).map(x -> new Axis((String)x, type, unit))).toArray(Axis[]::new);
        return new CoordinateSystem(name, axes);
    }

    public static <T extends NativeType<T> & NumericType<T>> RandomAccessibleInterval<T> open(N5Reader n5, String dataset) throws IOException {
        CachedCellImg imgRaw = N5Utils.open((N5Reader)n5, (String)dataset);
        Object img = imgRaw.numDimensions() == 2 ? Views.addDimension((RandomAccessibleInterval)imgRaw, (long)0L, (long)0L) : imgRaw;
        return img;
    }

    public static <T extends NumericType<T> & NativeType<T>> RealRandomAccessible<T> transformImage(N5Reader n5, String imageDataset, String registrationDataset, String space) throws IOException {
        TransformGraph graph = Common.openGraph(n5, registrationDataset, imageDataset);
        Optional<RealTransform> t = graph.path(space, "").map(p -> p.totalTransform(n5));
        RandomAccessibleInterval<T> img = Common.open(n5, imageDataset);
        RealRandomAccessible rra = Views.interpolate((EuclideanSpace)Views.extendZero(img), (InterpolatorFactory)new NLinearInterpolatorFactory());
        if (t.isPresent()) {
            return new RealTransformRandomAccessible(rra, t.get());
        }
        return rra;
    }

    public static TransformGraph openGraph(String uri) {
        try {
            N5URI n5uri = new N5URI(uri);
            N5Reader n5 = new N5Factory().gsonBuilder(Common.gsonBuilder()).openReader(n5uri.getContainerPath());
            return Common.openGraph(n5, n5uri.getGroupPath());
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public static TransformGraph openGraph(N5Reader n5) {
        return Common.openGraph(n5, "/");
    }

    public static TransformGraph openGraph(N5Reader n5, String group) {
        int nd = 5;
        if (n5.datasetExists(group)) {
            nd = n5.getDatasetAttributes(group).getNumDimensions();
        }
        return Common.openGraph(n5, group, nd);
    }

    public static TransformGraph openGraph(N5Reader n5, String group, int nd) {
        CoordinateSystem[] spaces = n5.getAttribute(group, "coordinateSystems", CoordinateSystem[].class);
        if (spaces == null) {
            spaces = n5.getAttribute(group, "coordinateSystems", CoordinateSystem[].class);
        }
        if (spaces == null) {
            return Common.openGraphImpliedSpaces(n5, group, nd);
        }
        CoordinateTransform[] transforms = n5.getAttribute(group, "coordinateTransformations", CoordinateTransform[].class);
        if (transforms == null) {
            transforms = n5.getAttribute(group, "transformations", CoordinateTransform[].class);
        }
        return new SpacesTransforms(spaces, transforms).buildTransformGraph(group, nd);
    }

    protected static TransformGraph openGraphImpliedSpaces(N5Reader n5, String dataset, int nd) {
        CoordinateTransform[] transforms = n5.getAttribute(dataset, "coordinateTransformations", CoordinateTransform[].class);
        if (transforms == null) {
            transforms = n5.getAttribute(dataset, "transformations", CoordinateTransform[].class);
        }
        CoordinateSystem[] coordinateSystems = (CoordinateSystem[])Arrays.stream(transforms).flatMap(x -> Stream.of(new CoordinateSystem(x.getInput(), nd), new CoordinateSystem(x.getOutput(), nd))).toArray(CoordinateSystem[]::new);
        return new SpacesTransforms(coordinateSystems, transforms).buildTransformGraph(dataset, nd);
    }

    public static TransformGraph openGraph(N5Reader n5, String ... datasets) throws IOException {
        TransformGraph graph = null;
        for (String d : datasets) {
            if (graph == null) {
                graph = Common.openGraph(n5, d);
                continue;
            }
            graph.add(Common.openGraph(n5, d));
        }
        return graph;
    }

    public static double[] translation(Interval itvl, double[] centerPhysical) {
        int nd = itvl.numDimensions();
        double[] tParams = new double[nd];
        for (int i = 0; i < nd; ++i) {
            tParams[i] = centerPhysical[i] - (itvl.realMax(i) - itvl.realMin(i)) / 2.0;
        }
        return tParams;
    }

    public static double[] translation(Interval itvl, double[] centerPhysical, double[] resolution) {
        int nd = itvl.numDimensions();
        double[] tParams = new double[nd];
        for (int i = 0; i < nd; ++i) {
            tParams[i] = resolution[i] * (itvl.realMax(i) - itvl.realMin(i)) / 2.0 - centerPhysical[i];
        }
        return tParams;
    }

    public static Pair<CoordinateTransform<?>, N5Reader> openTransformN5(String url) {
        try {
            N5URI n5url = new N5URI(url);
            String loc = n5url.getContainerPath();
            if (loc.endsWith(".json")) {
                return new ValuePair(Common.openJson(url), null);
            }
            N5Reader n5 = new N5Factory().gsonBuilder(Common.gsonBuilder()).openReader(loc);
            String dataset = n5url.getGroupPath() != null ? n5url.getGroupPath() : "/";
            String attribute = n5url.getAttributePath();
            try {
                CoordinateTransform ct = n5.getAttribute(dataset, attribute, CoordinateTransform.class);
                return new ValuePair((Object)ct, (Object)n5);
            }
            catch (ClassCastException | N5Exception runtimeException) {
                try {
                    return Common.openReference(url, n5, dataset, attribute);
                }
                catch (ClassCastException | N5Exception runtimeException2) {
                }
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return null;
    }

    public static <T extends RealTransform> T open(N5Reader n5, String dataset, String input, String output) {
        TransformGraph g = Common.openGraph(n5, dataset);
        return (T)g.path(input, output).get().totalTransform(n5, g);
    }

    public static RealTransform open(String url) {
        Pair<CoordinateTransform<?>, N5Reader> pair = Common.openTransformN5(url);
        return ((CoordinateTransform)pair.getA()).getTransform((N5Reader)pair.getB());
    }

    public static Pair<CoordinateTransform<?>, N5Reader> openReference(String url, N5Reader n5, String dataset, String attribute) {
        ReferencedCoordinateTransform ref = n5.getAttribute(dataset, attribute, ReferencedCoordinateTransform.class);
        if (ref == null) {
            return null;
        }
        if (url != null && url.equals(ref.getUrl())) {
            return null;
        }
        return Common.openTransformN5(ref.getUrl());
    }

    public static CoordinateTransform<?> openJson(String url) {
        String string;
        Path path = Paths.get(url, new String[0]);
        try {
            string = new String(Files.readAllBytes(path));
        }
        catch (IOException e) {
            return null;
        }
        Gson gson = Common.gsonBuilder().create();
        JsonElement elem = (JsonElement)gson.fromJson(string, JsonElement.class);
        CoordinateTransform ct = (CoordinateTransform)gson.fromJson(elem, CoordinateTransform.class);
        if (ct != null) {
            CoordinateTransform<?> nct = CoordinateTransform.create(ct);
            return nct;
        }
        if (elem.isJsonObject()) {
            String refUrl = elem.getAsJsonObject().get("url").getAsString();
            if (url.equals(refUrl)) {
                return null;
            }
            return (CoordinateTransform)Common.openTransformN5(refUrl).getA();
        }
        return null;
    }

    public static GsonBuilder gsonBuilder() {
        GsonBuilder gb = new GsonBuilder();
        gb.registerTypeAdapter(AffineCoordinateTransform.class, (Object)new AffineCoordinateTransformAdapter());
        gb.registerTypeAdapter(CoordinateTransform.class, (Object)new CoordinateTransformAdapter());
        return gb;
    }
}

