/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe.translation;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.net.URI;
import java.util.Map;
import org.janelia.saalfeldlab.n5.DataBlock;
import org.janelia.saalfeldlab.n5.DatasetAttributes;
import org.janelia.saalfeldlab.n5.GsonN5Reader;
import org.janelia.saalfeldlab.n5.N5Exception;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.N5URI;
import org.janelia.saalfeldlab.n5.universe.container.ContainerMetadataNode;
import org.janelia.saalfeldlab.n5.universe.translation.InvertibleTreeTranslation;
import org.janelia.saalfeldlab.n5.universe.translation.JqUtils;

public class TranslatedN5Reader
implements GsonN5Reader {
    private final N5Reader n5;
    protected final InvertibleTreeTranslation translation;

    public TranslatedN5Reader(N5Reader n5Base, Gson gson, String fwdTranslation, String invTranslation) {
        this.n5 = n5Base;
        ContainerMetadataNode root = ContainerMetadataNode.build(n5Base, gson);
        root.addPathsRecursive();
        this.translation = new InvertibleTreeTranslation(root, gson, fwdTranslation, invTranslation);
    }

    public InvertibleTreeTranslation getTranslation() {
        return this.translation;
    }

    public TranslatedN5Reader(GsonN5Reader n5Base, String fwdTranslation, String invTranslation) {
        this(n5Base, JqUtils.buildGson(n5Base), fwdTranslation, invTranslation);
    }

    @Override
    public JsonElement getAttributes(String pathName) throws N5Exception.N5IOException {
        return this.translation.getTranslated().getAttributes(pathName);
    }

    public String originalPath(String pathName) {
        ContainerMetadataNode pathNode = new ContainerMetadataNode();
        pathNode.createGroup(pathName);
        pathNode.addPathsRecursive();
        ContainerMetadataNode translatedPathNode = (ContainerMetadataNode)this.translation.getInverseTranslationFunction().apply(pathNode);
        translatedPathNode.addPathsRecursive();
        String path = translatedPathNode.flattenLeaves().findFirst().get().getPath();
        return N5URI.normalizeGroupPath(path);
    }

    @Override
    public DataBlock<?> readBlock(String pathName, DatasetAttributes datasetAttributes, long ... gridPosition) {
        return this.n5.readBlock(this.originalPath(pathName), datasetAttributes, gridPosition);
    }

    @Override
    public boolean exists(String pathName) {
        return this.translation.getTranslated().exists(pathName);
    }

    @Override
    public String[] list(String pathName) {
        return this.translation.getTranslated().list(pathName);
    }

    @Override
    public Map<String, Class<?>> listAttributes(String pathName) {
        return this.translation.getTranslated().listAttributes(pathName);
    }

    @Override
    public String groupPath(String ... nodes) {
        return this.n5.groupPath(nodes);
    }

    @Override
    public URI getURI() {
        return this.n5.getURI();
    }

    @Override
    public Gson getGson() {
        return this.translation.getGson();
    }
}

