/*
 * Decompiled with CFR 0.152.
 */
package bdv.viewer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.util.HashMap;
import java.util.Map;

public class BigWarpViewerSettings {
    public static final String KEY_COLOR = "Color";
    public static final String KEY_INACTIVE_COLOR = "InactiveColor";
    public static final String KEY_UNMATCHED_COLOR = "InactiveColor";
    public static final String KEY_SPOTS_VISIBLE = "SpotsVisible";
    public static final String KEY_DISPLAY_SPOT_NAMES = "DisplaySpotNames";
    public static final String KEY_SPOT_RADIUS_RATIO = "SpotRadiusRatio";
    public static final String KEY_SPOT_SIZE = "SpotSize";
    public static final Color DEFAULT_SPOT_COLOR = new Color(1.0f, 0.2f, 1.0f, 0.75f);
    public static final Color DEFAULT_INACTIVE_SPOT_COLOR = new Color(0.3f, 0.0f, 1.0f, 0.75f);
    public static final Color DEFAULT_UNMATCHED_SPOT_COLOR = new Color(0.3f, 0.0f, 1.0f, 0.75f);
    public static final Stroke NORMAL_STROKE = new BasicStroke(1.0f);
    public static final Stroke HIGHLIGHT_STROKE = new BasicStroke(2.0f);
    public static final Color DEFAULT_HIGHLIGHT_COLOR = new Color(1.0f, 0.5f, 1.0f);
    public static final double DEFAULT_SPOT_SIZE = 8.0;
    protected Map<String, Object> displaySettings;
    protected Color currentSpotColor;
    protected Color currentInactiveSpotColor;
    public double currentSpotSize;
    public float fontSize = 12.0f;
    public double strokeWeight = 3.0;

    public BigWarpViewerSettings() {
        this.createDisplaySettings();
        this.currentSpotColor = DEFAULT_SPOT_COLOR;
        this.currentSpotSize = 8.0;
        this.currentInactiveSpotColor = new Color(this.currentSpotColor.getRed() / 2, this.currentSpotColor.getGreen() / 2, this.currentSpotColor.getBlue() / 2, this.currentSpotColor.getAlpha());
    }

    protected Map<String, Object> createDisplaySettings() {
        this.displaySettings = new HashMap<String, Object>();
        this.displaySettings.put(KEY_SPOT_SIZE, 8.0);
        this.displaySettings.put(KEY_COLOR, DEFAULT_SPOT_COLOR);
        this.displaySettings.put("InactiveColor", DEFAULT_INACTIVE_SPOT_COLOR);
        this.displaySettings.put(KEY_SPOTS_VISIBLE, true);
        this.displaySettings.put(KEY_DISPLAY_SPOT_NAMES, false);
        this.displaySettings.put(KEY_SPOT_RADIUS_RATIO, 1.0);
        return this.displaySettings;
    }

    public Boolean areLandmarksVisible() {
        return (Boolean)this.displaySettings.get(KEY_SPOTS_VISIBLE);
    }

    public void togglePointsVisible() {
        this.displaySettings.put(KEY_SPOTS_VISIBLE, (Boolean)this.displaySettings.get(KEY_SPOTS_VISIBLE) == false);
    }

    public void setSpotColor(Color c) {
        this.currentSpotColor = c;
        this.currentInactiveSpotColor = new Color(this.currentSpotColor.getRed() / 2, this.currentSpotColor.getGreen() / 2, this.currentSpotColor.getBlue() / 2, this.currentSpotColor.getAlpha());
    }

    public Color getSpotColor() {
        return this.currentSpotColor;
    }

    public Color getInactiveSpotColor() {
        return this.currentInactiveSpotColor;
    }

    public void setSpotSize(double size) {
        double r = size / this.currentSpotSize;
        this.currentSpotSize = size;
        this.strokeWeight = Math.ceil(this.currentSpotSize * 0.375);
        this.fontSize = (int)(8.0 + this.currentSpotSize * 0.5);
    }

    public double getSpotSize() {
        return this.currentSpotSize;
    }

    public Boolean areNamesVisible() {
        return (Boolean)this.displaySettings.get(KEY_DISPLAY_SPOT_NAMES);
    }

    public void toggleNamesVisible() {
        this.displaySettings.put(KEY_DISPLAY_SPOT_NAMES, (Boolean)this.displaySettings.get(KEY_DISPLAY_SPOT_NAMES) == false);
    }

    public Object get(String key) {
        return this.displaySettings.get(key);
    }
}

