/*
 * Decompiled with CFR 0.152.
 */
package bigwarp.util;

import net.imglib2.realtransform.AffineTransform2D;
import net.imglib2.realtransform.AffineTransform3D;

public class Rotation2DHelpers {
    public static final double PI = Math.PI;
    public static final double PIo2 = 1.5707963267948966;
    public static final double PIo2t3 = 4.71238898038469;
    public static final double PIt2 = Math.PI * 2;
    public static final double sqrt2 = Math.sqrt(2.0);
    public static final double eps = 0.001;

    public static void rotateByBasisRow(AffineTransform3D transform, int row, boolean clockwise, double[] tmpRow) {
        if (clockwise) {
            Rotation2DHelpers.rotateByBasisRowCW(transform, row, tmpRow);
        } else {
            Rotation2DHelpers.rotateByBasisRowCCW(transform, row, tmpRow);
        }
    }

    public static void rotateByBasisRowCCW(AffineTransform3D transform, int row, double[] tmpRow) {
        double angle = Rotation2DHelpers.angle2d(transform, row);
        double scale = Rotation2DHelpers.rowMag2d(transform, row);
        if (angle >= -0.001 && angle < 1.5697963267948967) {
            tmpRow[0] = 0.0;
            tmpRow[1] = scale;
        } else if (angle >= 1.5697963267948967 && angle < 3.1405926535897932) {
            tmpRow[0] = -scale;
            tmpRow[1] = 0.0;
        } else if (angle >= 3.1405926535897932 && angle < 4.711388980384689) {
            tmpRow[0] = 0.0;
            tmpRow[1] = -scale;
        } else {
            tmpRow[0] = scale;
            tmpRow[1] = 0.0;
        }
    }

    public static void rotateByBasisRowCW(AffineTransform3D transform, int row, double[] tmpRow) {
        double angle = Rotation2DHelpers.angle2d(transform, row);
        if (angle > Math.PI * 2) {
            angle -= Math.PI * 2;
        }
        double scale = Rotation2DHelpers.rowMag2d(transform, row);
        if (angle >= 0.001 && angle < 1.5717963267948964) {
            tmpRow[0] = scale;
            tmpRow[1] = 0.0;
        } else if (angle >= 1.5717963267948964 && angle < 3.142592653589793) {
            tmpRow[0] = 0.0;
            tmpRow[1] = scale;
        } else if (angle >= 3.142592653589793 && angle < 4.71338898038469) {
            tmpRow[0] = -scale;
            tmpRow[1] = 0.0;
        } else {
            tmpRow[0] = 0.0;
            tmpRow[1] = -scale;
        }
    }

    public static AffineTransform3D targetViewerTransform2d(AffineTransform3D currentView, boolean clockwise) {
        AffineTransform3D newView = currentView.copy();
        double[] xrow = new double[2];
        double[] yrow = new double[2];
        Rotation2DHelpers.rotateByBasisRow(newView, 0, clockwise, xrow);
        Rotation2DHelpers.rotateByBasisRow(newView, 1, clockwise, yrow);
        newView.set(xrow[0], xrow[1], currentView.get(0, 2), currentView.get(0, 3), yrow[0], yrow[1], currentView.get(1, 2), currentView.get(1, 3), currentView.get(2, 0), currentView.get(2, 1), currentView.get(2, 2), currentView.get(2, 3));
        return newView;
    }

    public static AffineTransform3D targetViewerTransform2dOld(AffineTransform3D currentView, boolean clockwise) {
        double angle = Rotation2DHelpers.angle2d(currentView, 0);
        double angleDiff = angle % 1.5707963267948966;
        AffineTransform3D newView = currentView.copy();
        if (clockwise) {
            newView.rotate(2, angleDiff * Math.PI);
        } else {
            newView.rotate(2, angleDiff);
        }
        return newView;
    }

    public static double angle2d(AffineTransform3D xfm, int r) {
        return Rotation2DHelpers.getAngle(xfm.get(r, 0), xfm.get(r, 1));
    }

    public static void compareCos(AffineTransform3D xfm, double trueAngle) {
        double cosAngle = Rotation2DHelpers.cosAngle2d(xfm);
        double trueCos = Math.cos(trueAngle);
        System.out.println("estimated cos: " + cosAngle);
        System.out.println("true cos     : " + trueCos);
        System.out.println("diff         : " + (cosAngle - trueCos));
    }

    public static double determinant2d(AffineTransform3D xfm) {
        return xfm.get(0, 0) * xfm.get(1, 1) - xfm.get(1, 0) * xfm.get(0, 1);
    }

    public static double cosAngle2d(AffineTransform3D xfm) {
        return xfm.get(0, 0) / Rotation2DHelpers.rowMag2d(xfm, 0);
    }

    public static double rowMag2d(AffineTransform3D xfm, int r) {
        return Math.sqrt(xfm.get(r, 0) * xfm.get(r, 0) + xfm.get(r, 1) * xfm.get(r, 1));
    }

    public static double determinant2d(AffineTransform2D xfm) {
        return xfm.get(0, 0) * xfm.get(1, 1) - xfm.get(1, 0) * xfm.get(0, 1);
    }

    public static double shorterAngleBetweenRotations(double angleStart, double angleEnd) {
        double tmpAngle = angleEnd - angleStart;
        if (tmpAngle > Math.PI) {
            return tmpAngle - Math.PI * 2;
        }
        if (tmpAngle < -Math.PI) {
            return Math.PI * 2 + tmpAngle;
        }
        return tmpAngle;
    }

    public static double extractScale(AffineTransform3D transform, int axis) {
        double sqSum = 0.0;
        int c = axis;
        for (int r = 0; r < 2; ++r) {
            double x = transform.get(r, c);
            sqSum += x * x;
        }
        return Math.sqrt(sqSum);
    }

    public static boolean isSimilarity(AffineTransform3D xfm) {
        double[] p = new double[]{1.0, 0.0, 0.0};
        double[] q = new double[3];
        xfm.apply(p, q);
        double sx = q[0] * q[0] + q[1] * q[1];
        p[0] = 0.0;
        p[1] = 1.0;
        xfm.apply(p, q);
        double sy = q[0] * q[0] + q[1] * q[1];
        return sx == sy;
    }

    public static double extractRotation(AffineTransform3D xfm) {
        double x = xfm.get(0, 0);
        double y = xfm.get(0, 1);
        double theta = Math.atan2(-y, x);
        return theta;
    }

    public static double getAngle(double x, double y) {
        double a = Math.atan2(x, y);
        if (a > Math.PI * 2) {
            a -= Math.PI * 2;
        }
        if (a >= 0.0 && a <= 1.5707963267948966) {
            a = 1.5707963267948966 - a;
        } else if (a < 0.0 && a >= -Math.PI) {
            a = 1.5707963267948966 - a;
        } else if (a > 1.5707963267948966 && a <= Math.PI) {
            a = 7.853981633974483 - a;
        }
        return a;
    }

    public static void angleMult(double[] pt, double[] res, double angle) {
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        Rotation2DHelpers.cosSinMult(pt, res, cos, sin);
    }

    public static void cosSinMult(double[] pt, double[] res, double cosAngle, double sinAngle) {
        res[0] = cosAngle * pt[0] - sinAngle * pt[1];
        res[1] = sinAngle * pt[0] + cosAngle * pt[1];
    }

    public static double[][] rotationToMatrixLeftHanded(double theta) {
        double cos = Math.cos(theta);
        double sin = Math.sin(theta);
        double[][] transform = new double[][]{{sin, cos, 0.0}, {cos, -sin, 0.0}, {0.0, 0.0, 1.0}};
        return transform;
    }

    public static double[][] rotationToMatrix(double theta) {
        return Rotation2DHelpers.rotationToMatrix(theta, false);
    }

    public static double[][] rotationToMatrix(double theta, boolean isZFlipped) {
        double cos = Math.cos(theta);
        double sin = Math.sin(theta);
        double[][] transform = isZFlipped ? new double[][]{{cos, -sin, 0.0}, {sin, cos, 0.0}, {0.0, 0.0, 1.0}} : new double[][]{{cos, -sin, 0.0}, {sin, cos, 0.0}, {0.0, 0.0, -1.0}};
        return transform;
    }

    public static AffineTransform3D rotationToTransform(double theta, AffineTransform3D transform) {
        double cos = Math.cos(theta);
        double sin = Math.sin(theta);
        transform.set(cos, -sin, 0.0, 0.0, sin, cos, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
        return transform;
    }

    public static AffineTransform3D rotationToTransform(double theta) {
        AffineTransform3D transform = new AffineTransform3D();
        return Rotation2DHelpers.rotationToTransform(theta, transform);
    }

    public static void printXfm2d(AffineTransform3D xfm) {
        System.out.println(String.format("%02f %02f", xfm.get(0, 0), xfm.get(0, 1)));
        System.out.println(String.format("%02f %02f", xfm.get(1, 0), xfm.get(1, 1)));
    }

    public static void printXfm(AffineTransform3D transform) {
        System.out.println(String.format("%02f, %02f, %02f, %02f,", transform.get(0, 0), transform.get(0, 1), transform.get(0, 2), transform.get(0, 3)));
        System.out.println(String.format("%02f, %02f, %02f, %02f,", transform.get(1, 0), transform.get(1, 1), transform.get(1, 2), transform.get(1, 3)));
        System.out.println(String.format("%02f, %02f, %02f, %02f", transform.get(2, 0), transform.get(2, 1), transform.get(2, 2), transform.get(2, 3)) + "\n");
    }

    public static void main(String[] args) {
        AffineTransform3D id = new AffineTransform3D();
        AffineTransform3D flipZ = new AffineTransform3D();
        flipZ.set(-1.0, 2, 2);
        double pi3 = 1.0471975511965976;
        double pi4 = 0.7853981633974483;
        double pi6 = 0.5235987755982988;
        double iniAngle = -pi4;
        System.out.println("iniAngle: " + iniAngle);
        AffineTransform3D newView = new AffineTransform3D();
        AffineTransform3D xfm = new AffineTransform3D();
        xfm.set(7.713925195605986E-15, 34.740430636495, -0.0, 9158.97224991679, 34.740430636495, -7.713925195605986E-15, 0.0, -23549.535244807274, 0.0, 0.0, -34.74043063649499, 0.0);
        System.out.println("xfm angle 0 : " + Rotation2DHelpers.angle2d(xfm, 0) / Math.PI);
        System.out.println("xfm angle 1 : " + Rotation2DHelpers.angle2d(xfm, 1) / Math.PI);
        newView = Rotation2DHelpers.targetViewerTransform2d(xfm, true);
        System.out.println("newView : " + newView);
        System.out.println("newView angle 0 : " + Rotation2DHelpers.angle2d(newView, 0) / Math.PI);
        System.out.println("newView angle 1 : " + Rotation2DHelpers.angle2d(newView, 1) / Math.PI);
        System.out.println("done");
    }
}

