/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.compat;

import ij.IJ;
import ij.Menus;
import ij.plugin.PlugIn;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuContainer;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.scijava.util.FileUtils;

public class FijiTools {
    private static Field menuEntry2jarFile;
    private static Field menuInstance;

    public static String getImageJDir() {
        String path = System.getProperty("ij.dir");
        if (path != null) {
            return path;
        }
        String prefix = "file:";
        String suffix = "/jars/fiji-compat.jar!/fiji/FijiTools.class";
        path = FijiTools.class.getResource("FijiTools.class").getPath();
        if (path.startsWith("file:")) {
            path = path.substring("file:".length());
        }
        if (path.endsWith("/jars/fiji-compat.jar!/fiji/FijiTools.class")) {
            path = path.substring(0, path.length() - "/jars/fiji-compat.jar!/fiji/FijiTools.class".length());
        }
        return path;
    }

    public static boolean openFijiEditor(final String title, final String body) {
        try {
            Class<?> textEditor = IJ.getClassLoader().loadClass("fiji.scripting.TextEditor");
            final Constructor<?> ctor = textEditor.getConstructor(String.class, String.class);
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    try {
                        Frame frame = (Frame)ctor.newInstance(title, body);
                        if (frame == null) {
                            Thread.currentThread().interrupt();
                        }
                        frame.setVisible(true);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Thread.currentThread().interrupt();
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                run.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(run);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }
            return true;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
    }

    public static boolean openIJ1Editor(String title, String body) {
        try {
            Class<?> clazz = IJ.getClassLoader().loadClass("ij.plugin.frame.Editor");
            Constructor<?> ctor = clazz.getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            Object ed = ctor.newInstance(16, 60, 0, 3);
            Method method = clazz.getMethod(title.endsWith(".ijm") ? "createMacro" : "create", String.class, String.class);
            method.invoke(ed, title, body);
            return true;
        }
        catch (Exception e) {
            IJ.handleException((Throwable)e);
            return false;
        }
    }

    public static boolean openEditor(String title, String body) {
        if (FijiTools.openFijiEditor(title, body)) {
            return true;
        }
        return FijiTools.openIJ1Editor(title, body);
    }

    public static boolean maybeOpenEditor(String path) {
        try {
            Class<?> textEditor = IJ.getClassLoader().loadClass("fiji.scripting.TextEditor");
            if (!(path.indexOf("://") >= 0 || FileUtils.getExtension((String)path).equals("") || ((Boolean)textEditor.getMethod("isBinary", String.class).invoke(null, path)).booleanValue() || FijiTools.stackTraceContains("fiji.scripting.TextEditor.open(") || IJ.runPlugIn((String)"fiji.scripting.Script_Editor", (String)path) == null)) {
                return true;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return false;
    }

    public static boolean openFijiEditor(final File file) {
        try {
            Class<?> textEditor = IJ.getClassLoader().loadClass("fiji.scripting.TextEditor");
            final Constructor<?> ctor = textEditor.getConstructor(String.class);
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    try {
                        Frame frame = (Frame)ctor.newInstance(file.getAbsolutePath());
                        if (frame == null) {
                            Thread.currentThread().interrupt();
                        }
                        frame.setVisible(true);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Thread.currentThread().interrupt();
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                run.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(run);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }
            return true;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
    }

    public static boolean stackTraceContains(String needle) {
        StringWriter writer = new StringWriter();
        PrintWriter out = new PrintWriter(writer);
        new Exception().printStackTrace(out);
        out.close();
        return writer.toString().indexOf(needle) >= 0;
    }

    public static MenuItem getMenuItem(String menuPath) {
        return FijiTools.getMenuItem(Menus.getMenuBar(), menuPath, false);
    }

    public static MenuItem getMenuItem(MenuContainer container, String menuPath, boolean createMenuIfNecessary) {
        Menu menu;
        MenuBar menuBar = container instanceof MenuBar ? (MenuBar)container : null;
        Menu menu2 = menu = container instanceof Menu ? (Menu)container : null;
        while (menuPath.endsWith(">")) {
            menuPath = menuPath.substring(0, menuPath.length() - 1);
        }
        while (menuPath != null && menuPath.length() > 0) {
            String name;
            int croc = menuPath.indexOf(62);
            if (croc < 0) {
                name = menuPath;
                menuPath = null;
            } else {
                name = menuPath.substring(0, croc);
                menuPath = menuPath.substring(croc + 1);
            }
            MenuItem current = FijiTools.getMenuItem(menuBar, menu, name, createMenuIfNecessary);
            if (current == null || menuPath == null) {
                return current;
            }
            menuBar = null;
            menu = (Menu)current;
        }
        return null;
    }

    protected static MenuItem getMenuItem(MenuBar menuBar, Menu menu, String name, boolean createIfNecessary) {
        if (menuBar == null && menu == null) {
            return null;
        }
        if (menuBar != null && name.equals("Help")) {
            menu = menuBar.getHelpMenu();
            if (menu == null && createIfNecessary) {
                menu = new PopupMenu("Help");
                menuBar.setHelpMenu(menu);
            }
            return menu;
        }
        int count = menuBar != null ? menuBar.getMenuCount() : menu.getItemCount();
        for (int i = 0; i < count; ++i) {
            MenuItem current;
            MenuItem menuItem = current = menuBar != null ? menuBar.getMenu(i) : menu.getItem(i);
            if (!name.equals(current.getLabel())) continue;
            return current;
        }
        if (createIfNecessary) {
            PopupMenu newMenu = new PopupMenu(name);
            if (menuBar != null) {
                menuBar.add(newMenu);
            } else {
                menu.add(newMenu);
            }
            return newMenu;
        }
        return null;
    }

    public static MenuItem installPlugin(String menuPath, String name, String command) {
        return FijiTools.installPlugin(menuPath, name, command, null);
    }

    public static MenuItem installPlugin(String menuPath, String name, String command, File jarFile) {
        if (Menus.getCommands().get(name) != null) {
            IJ.log((String)("The user plugin " + name + (jarFile == null ? "" : " (in " + jarFile + ")") + " would override an existing command!"));
            return null;
        }
        MenuItem item = null;
        if (IJ.getInstance() != null) {
            Menu menu = FijiTools.getMenu(menuPath);
            item = new MenuItem(name);
            menu.add(item);
            item.addActionListener((ActionListener)IJ.getInstance());
        }
        Menus.getCommands().put(name, command);
        if (jarFile != null) {
            if (menuEntry2jarFile == null) {
                try {
                    Field instanceField = Menus.class.getDeclaredField("instance");
                    instanceField.setAccessible(true);
                    Field field = Menus.class.getDeclaredField("menuEntry2jarFile");
                    field.setAccessible(true);
                    menuInstance = instanceField;
                    menuEntry2jarFile = field;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            if (menuEntry2jarFile != null) {
                try {
                    Map map = (Map)menuEntry2jarFile.get(menuInstance.get(null));
                    map.put(name, jarFile.getPath());
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
        return item;
    }

    public static Menu getMenu(String menuPath) {
        return (Menu)FijiTools.getMenuItem(Menus.getMenuBar(), menuPath, true);
    }

    public static void runPlugInGently(String className, String arg) {
        try {
            Class<?> clazz = IJ.getClassLoader().loadClass(className);
            if (clazz != null) {
                PlugIn plugin = (PlugIn)clazz.newInstance();
                plugin.run(arg);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    public static void runUpdater() {
        System.setProperty("fiji.main.checksUpdaterAtStartup", "true");
        FijiTools.runPlugInGently("fiji.updater.UptodateCheck", "quick");
    }

    public static void runGently(String menuLabel, String arg) {
        String className = (String)Menus.getCommands().get(menuLabel);
        if (className != null) {
            IJ.runPlugIn((String)className, null);
        }
    }

    public static void runGently(String menuLabel) {
        FijiTools.runGently(menuLabel, "");
    }
}

