/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.ij;

import ij.IJ;
import ij.ImagePlus;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import net.imagej.ImgPlus;
import net.imglib2.Dimensions;
import net.imglib2.EuclideanSpace;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealRandomAccessible;
import net.imglib2.algorithm.blocks.BlockAlgoUtils;
import net.imglib2.algorithm.blocks.BlockSupplier;
import net.imglib2.algorithm.blocks.downsample.Downsample;
import net.imglib2.img.VirtualStackAdapter;
import net.imglib2.img.display.imagej.ImageJFunctions;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.interpolation.randomaccess.NLinearInterpolatorFactory;
import net.imglib2.realtransform.AffineGet;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.realtransform.InvertibleRealTransform;
import net.imglib2.realtransform.RealViews;
import net.imglib2.realtransform.ScaleAndTranslation;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Intervals;
import net.imglib2.util.Util;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;
import net.imglib2.view.fluent.RandomAccessibleIntervalView;
import org.janelia.saalfeldlab.n5.Compression;
import org.janelia.saalfeldlab.n5.DatasetAttributes;
import org.janelia.saalfeldlab.n5.GzipCompression;
import org.janelia.saalfeldlab.n5.Lz4Compression;
import org.janelia.saalfeldlab.n5.N5Exception;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.N5URI;
import org.janelia.saalfeldlab.n5.N5Writer;
import org.janelia.saalfeldlab.n5.RawCompression;
import org.janelia.saalfeldlab.n5.XzCompression;
import org.janelia.saalfeldlab.n5.blosc.BloscCompression;
import org.janelia.saalfeldlab.n5.ij.N5IJUtils;
import org.janelia.saalfeldlab.n5.imglib2.N5Utils;
import org.janelia.saalfeldlab.n5.metadata.imagej.CosemToImagePlus;
import org.janelia.saalfeldlab.n5.metadata.imagej.ImagePlusLegacyMetadataParser;
import org.janelia.saalfeldlab.n5.metadata.imagej.ImagePlusMetadataTemplate;
import org.janelia.saalfeldlab.n5.metadata.imagej.ImageplusMetadata;
import org.janelia.saalfeldlab.n5.metadata.imagej.MetadataTemplateMapper;
import org.janelia.saalfeldlab.n5.metadata.imagej.N5ImagePlusMetadata;
import org.janelia.saalfeldlab.n5.metadata.imagej.N5ViewerToImagePlus;
import org.janelia.saalfeldlab.n5.metadata.imagej.NgffToImagePlus;
import org.janelia.saalfeldlab.n5.ui.N5MetadataSpecDialog;
import org.janelia.saalfeldlab.n5.universe.N5Factory;
import org.janelia.saalfeldlab.n5.universe.StorageFormat;
import org.janelia.saalfeldlab.n5.universe.metadata.AbstractN5DatasetMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.MetadataUtils;
import org.janelia.saalfeldlab.n5.universe.metadata.N5CosemMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.N5CosemMetadataParser;
import org.janelia.saalfeldlab.n5.universe.metadata.N5DatasetMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.N5Metadata;
import org.janelia.saalfeldlab.n5.universe.metadata.N5MetadataWriter;
import org.janelia.saalfeldlab.n5.universe.metadata.N5SingleScaleMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.N5SingleScaleMetadataParser;
import org.janelia.saalfeldlab.n5.universe.metadata.N5SpatialDatasetMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.SpatialMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.SpatialMetadataGroup;
import org.janelia.saalfeldlab.n5.universe.metadata.axes.Axis;
import org.janelia.saalfeldlab.n5.universe.metadata.axes.AxisMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.axes.AxisUtils;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v04.NgffSingleScaleAxesMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v04.OmeNgffMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v04.OmeNgffMetadataParser;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v04.OmeNgffMetadataSingleScaleParser;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v04.OmeNgffMultiScaleMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v04.OmeNgffMultiScaleMetadataMutable;
import org.janelia.scicomp.n5.zstandard.ZstandardCompression;
import org.scijava.app.StatusService;
import org.scijava.command.Command;
import org.scijava.command.ContextCommand;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.prefs.PrefService;
import org.scijava.ui.ApplicationFrame;
import org.scijava.ui.UIService;
import org.scijava.widget.UIComponent;

@Plugin(type=Command.class, menuPath="File>Save As>HDF5/N5/Zarr/OME-NGFF ...", description="Save the current image as a new dataset or multi-scale pyramid.")
public class N5ScalePyramidExporter
extends ContextCommand
implements WindowListener {
    public static final String GZIP_COMPRESSION = "gzip";
    public static final String RAW_COMPRESSION = "raw";
    public static final String LZ4_COMPRESSION = "lz4";
    public static final String XZ_COMPRESSION = "xz";
    public static final String BLOSC_COMPRESSION = "blosc";
    public static final String ZSTD_COMPRESSION = "zstd";
    public static final String AUTO_FORMAT = "Auto";
    public static final String HDF5_FORMAT = "HDF5";
    public static final String N5_FORMAT = "N5";
    public static final String ZARR_FORMAT = "Zarr";
    public static final String IJ_PROPERTY_DOWNSAMPLE_POLICY = "N5-DOWNSAMPLE-POLICY";
    private static final String IJ_PROPERTY_DO_NOT_WARN = "N5-SKIP-OVERWRITE-SKIP-WARNING";
    public static final DOWNSAMPLE_POLICY DEFAULT_POLICY = DOWNSAMPLE_POLICY.Aggressive;
    public static final String DOWN_SAMPLE = "Sample";
    public static final String DOWN_AVERAGE = "Average";
    public static final String NONE = "None";
    @Parameter
    private LogService log;
    @Parameter
    private PrefService prefs;
    @Parameter
    private StatusService status;
    @Parameter
    private UIService ui;
    @Parameter(label="Image")
    private ImagePlus image;
    @Parameter(label="Root url", description="The location of the container that will store the data. May be a folder on your filesystem,\nan HDF5 file, or a url to cloud storage. The storage type is inferred\nfrom the extension of the url (use \".h5\", \".n5\", or \".zarr\").")
    private String containerRoot;
    @Parameter(label="Dataset", required=false, persist=false, initializer="initializeDataset", description="The location in the container to write data.\nIf a pyramid is requested, arrays will be written to\nchild paths of the given dataset, with particulars depending\non the selected metadata type.")
    private String dataset;
    @Parameter(label="Format", style="listBox", description="The storage format.", choices={"Auto", "HDF5", "N5", "Zarr"})
    private String storageFormat = "Auto";
    @Parameter(label="Chunk size", description="The size of chunks. Comma separated, for example: \"64,32,16\".\n ImageJ's axis order is X,Y,C,Z,T. The chunk size must be specified in this order.\nYou must skip any axis whose size is 1, e.g. a 2D time-series without channels\nmay have a chunk size of 1024,1024,1 (X,Y,T).\nYou may provide fewer values than the data dimension. In that case, the size will\nbe expanded to necessary size with the last value, for example \"64\", will expand\nto \"64,64,64\" for 3D data.")
    private String chunkSizeArg;
    @Parameter(label="Create Pyramid (if possible)", description="Writes multiple resolutions if allowed by the choice of metadata (ImageJ and None do not).")
    private boolean createPyramidIfPossible = true;
    @Parameter(label="Downsampling method", style="listBox", choices={"Sample", "Average"})
    private String downsampleMethod = "Sample";
    @Parameter(label="Compression", style="listBox", choices={"gzip", "raw", "lz4", "xz", "blosc", "zstd"})
    private String compressionArg = "gzip";
    @Parameter(label="metadata type", style="listBox", description="The style for metadata to be stored in the exported N5.", choices={"OME-NGFF", "ImageJ", "N5Viewer", "COSEM", "Custom", "None"})
    private String metadataStyle = "OME-NGFF";
    @Parameter(label="Thread count", required=true, min="1", max="999")
    private int nThreads = 1;
    @Parameter(label="Overwrite", description="When selected, this plugin will, WITHOUT WARNING, delete and overwrite any existing data\nbefore writing this image.", required=false)
    private boolean overwrite = false;
    private boolean overwriteSet = false;
    private int[] chunkSize;
    private long[] currentAbsoluteDownsampling;
    private double[] currentTranslation;
    private N5DatasetMetadata currentChannelMetadata;
    private RandomAccessibleInterval<?> previousScaleImg;
    private ImageplusMetadata<?> impMeta;
    private N5MetadataSpecDialog metaSpecDialog;
    private final HashMap<Class<?>, ImageplusMetadata<?>> impMetaWriterTypes;
    private final Map<String, N5MetadataWriter<?>> styles = new HashMap();
    private final HashMap<Class<?>, N5MetadataWriter<?>> metadataWriters;
    private ThreadPoolExecutor threadPool;

    public N5ScalePyramidExporter() {
        this.styles.put("OME-NGFF", (N5MetadataWriter<?>)new OmeNgffMetadataParser());
        this.styles.put("N5Viewer", (N5MetadataWriter<?>)new N5SingleScaleMetadataParser());
        this.styles.put("COSEM", (N5MetadataWriter<?>)new N5CosemMetadataParser());
        this.styles.put("ImageJ", new ImagePlusLegacyMetadataParser());
        this.metadataWriters = new HashMap();
        this.metadataWriters.put(OmeNgffMetadata.class, (N5MetadataWriter<?>)new OmeNgffMetadataParser());
        this.metadataWriters.put(N5SingleScaleMetadata.class, (N5MetadataWriter<?>)new N5SingleScaleMetadataParser());
        this.metadataWriters.put(N5CosemMetadata.class, (N5MetadataWriter<?>)new N5CosemMetadataParser());
        this.metadataWriters.put(NgffSingleScaleAxesMetadata.class, (N5MetadataWriter<?>)new OmeNgffMetadataSingleScaleParser());
        this.metadataWriters.put(N5ImagePlusMetadata.class, new ImagePlusLegacyMetadataParser());
        this.impMetaWriterTypes = new HashMap();
        this.impMetaWriterTypes.put(ImagePlusLegacyMetadataParser.class, new ImagePlusLegacyMetadataParser());
        this.impMetaWriterTypes.put(N5CosemMetadataParser.class, new CosemToImagePlus());
        this.impMetaWriterTypes.put(N5SingleScaleMetadataParser.class, new N5ViewerToImagePlus());
        this.impMetaWriterTypes.put(OmeNgffMetadataParser.class, new NgffToImagePlus());
    }

    public N5ScalePyramidExporter(ImagePlus image, String n5RootLocation, String n5Dataset, String storageFormat, String chunkSizeArg, boolean pyramidIfPossible, String downsampleMethod, String metadataStyle, String compression) {
        this();
        this.setOptions(image, n5RootLocation, n5Dataset, storageFormat, chunkSizeArg, pyramidIfPossible, downsampleMethod, metadataStyle, compression);
    }

    public N5ScalePyramidExporter(ImagePlus image, String n5RootLocation, String n5Dataset, String storageFormat, String chunkSizeArg, boolean pyramidIfPossible, DOWNSAMPLE_METHOD downsampleMethod, String metadataStyle, String compression) {
        this();
        this.setOptions(image, n5RootLocation, n5Dataset, storageFormat, chunkSizeArg, pyramidIfPossible, downsampleMethod.name(), metadataStyle, compression);
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
        this.overwriteSet = true;
    }

    public void clearOverwrite() {
        this.overwriteSet = false;
    }

    public void setOptions(ImagePlus image, String containerRoot, String dataset, String chunkSizeArg, boolean pyramidIfPossible, String downsampleMethod, String metadataStyle, String compression) {
        this.setOptions(image, containerRoot, dataset, AUTO_FORMAT, chunkSizeArg, pyramidIfPossible, downsampleMethod, metadataStyle, compression);
    }

    public void setOptions(ImagePlus image, String containerRoot, String dataset, String storageFormat, String chunkSizeArg, boolean pyramidIfPossible, String downsampleMethod, String metadataStyle, String compression) {
        this.image = image;
        this.containerRoot = containerRoot;
        this.storageFormat = storageFormat;
        this.dataset = MetadataUtils.normalizeGroupPath((String)dataset);
        this.chunkSizeArg = chunkSizeArg;
        this.createPyramidIfPossible = pyramidIfPossible;
        this.downsampleMethod = downsampleMethod;
        this.metadataStyle = metadataStyle;
        this.compressionArg = compression;
    }

    public void setNumThreads(int nThreads) {
        this.nThreads = nThreads;
    }

    public void setMetadataMapper(MetadataTemplateMapper metadataMapper) {
        this.styles.put("Custom", metadataMapper);
        this.impMetaWriterTypes.put(MetadataTemplateMapper.class, new ImagePlusMetadataTemplate());
    }

    public static int[] parseBlockSize(String chunkSizeArg, long[] dims) {
        int i;
        int nd = dims.length;
        String[] chunkArgList = chunkSizeArg.split(",");
        int[] chunkSize = new int[nd];
        for (i = 0; i < chunkArgList.length && i < nd; ++i) {
            chunkSize[i] = Integer.parseInt(chunkArgList[i]);
        }
        int N = chunkArgList.length - 1;
        while (i < nd) {
            chunkSize[i] = (long)chunkSize[N] > dims[i] ? (int)dims[i] : chunkSize[N];
            ++i;
        }
        return chunkSize;
    }

    public void parseBlockSize(long[] dims) {
        this.chunkSize = N5ScalePyramidExporter.parseBlockSize(this.chunkSizeArg, dims);
    }

    public void parseBlockSize() {
        this.parseBlockSize(Intervals.dimensionsAsLongArray((Dimensions)ImageJFunctions.wrap((ImagePlus)this.image)));
    }

    public static String containerRootWithFormatPrefix(String containerRoot, String storageFormat, boolean showWarning) {
        StorageFormat uriFormat = (StorageFormat)StorageFormat.getStorageFromNestedScheme((String)containerRoot).getA();
        if (storageFormat.equals(AUTO_FORMAT)) {
            return containerRoot;
        }
        StorageFormat dropdownFormat = StorageFormat.valueOf((String)storageFormat.toUpperCase());
        if (uriFormat == null) {
            return dropdownFormat.toString().toLowerCase() + ":" + containerRoot;
        }
        if (uriFormat != null && !storageFormat.equals(AUTO_FORMAT) && uriFormat != dropdownFormat) {
            if (showWarning) {
                IJ.showMessage((String)"Warning", (String)String.format("Selected format (%s) does not match format from url (%s)!", dropdownFormat.toString(), uriFormat.toString()));
            }
            return null;
        }
        return containerRoot;
    }

    public <T extends RealType<T> & NativeType<T>, M extends N5DatasetMetadata, N extends SpatialMetadataGroup<?>> void processMultiscale() throws IOException, InterruptedException, ExecutionException {
        if (this.promptHomeDirectoryWarning(this.containerRoot)) {
            return;
        }
        String rootWithFormatPrefix = N5ScalePyramidExporter.containerRootWithFormatPrefix(this.containerRoot, this.storageFormat, true);
        if (rootWithFormatPrefix == null) {
            return;
        }
        boolean doGroupExistsWarning = true;
        if (N5URI.normalizeGroupPath((String)this.dataset).isEmpty()) {
            try {
                N5Reader n5Reader = new N5Factory().zarrDimensionSeparator("/").openReader(rootWithFormatPrefix);
                doGroupExistsWarning = n5Reader.exists("");
            }
            catch (N5Exception e) {
                doGroupExistsWarning = false;
            }
        }
        N5Writer n5 = new N5Factory().zarrDimensionSeparator("/").s3UseCredentials().openWriter(rootWithFormatPrefix);
        Compression compression = this.getCompression();
        if (!this.promptOverwriteAndDelete(n5, this.dataset, doGroupExistsWarning)) {
            return;
        }
        boolean computeScales = this.createPyramidIfPossible && this.metadataSupportsScales();
        N5MetadataWriter<?> metadataWriter = null;
        if (!this.metadataStyle.equals(NONE) && (metadataWriter = this.styles.get(this.metadataStyle)) != null) {
            this.impMeta = this.impMetaWriterTypes.get(metadataWriter.getClass());
        }
        RandomAccessibleInterval<T> baseImg = this.getBaseImage();
        M baseMetadata = this.initializeBaseMetadata();
        this.currentChannelMetadata = this.copyMetadata(baseMetadata);
        List<RandomAccessibleInterval<T>> channelImgs = this.splitChannels(this.currentChannelMetadata, baseImg);
        for (int c = 0; c < channelImgs.size(); ++c) {
            N5DatasetMetadata currentMetadata = this.copyMetadata(this.currentChannelMetadata);
            String channelDataset = this.getChannelDatasetName(c);
            RandomAccessibleInterval<T> currentChannelImg = channelImgs.get(c);
            int nd = currentChannelImg.numDimensions();
            double[] baseResolution = new double[nd];
            this.fillResolution(baseMetadata, baseResolution);
            this.currentAbsoluteDownsampling = new long[nd];
            Arrays.fill(this.currentAbsoluteDownsampling, 1L);
            double[] currentResolution = new double[nd];
            System.arraycopy(baseResolution, 0, currentResolution, 0, nd);
            N multiscaleMetadata = this.initializeMultiscaleMetadata(currentMetadata, channelDataset);
            this.currentTranslation = new double[nd];
            int maxNumScales = computeScales ? 99 : 1;
            boolean anyScalesWritten = false;
            for (int s = 0; s < maxNumScales; ++s) {
                String dset = this.getScaleDatasetName(c, s);
                long[] relativeFactors = new long[nd];
                Arrays.fill(relativeFactors, 1L);
                if (s > 0) {
                    relativeFactors = this.getRelativeDownsampleFactors((M)currentMetadata, (Interval)currentChannelImg, s, this.currentAbsoluteDownsampling);
                    for (int i2 = 0; i2 < nd; ++i2) {
                        int n = i2;
                        this.currentAbsoluteDownsampling[n] = this.currentAbsoluteDownsampling[n] * relativeFactors[i2];
                    }
                    currentChannelImg = this.downsampleMethod(this.getPreviousScaleImage(c, s), relativeFactors);
                    Arrays.setAll(currentResolution, i -> (double)this.currentAbsoluteDownsampling[i] * baseResolution[i]);
                    if (this.downsampleMethod.equals(DOWN_AVERAGE)) {
                        Arrays.setAll(this.currentTranslation, i -> {
                            if (this.currentAbsoluteDownsampling[i] > 1L) {
                                return baseResolution[i] * (0.5 * (double)this.currentAbsoluteDownsampling[i] - 0.5);
                            }
                            return 0.0;
                        });
                    }
                }
                if (!this.write(currentChannelImg, n5, dset, compression, currentMetadata = this.metadataForThisScale(dset, currentMetadata, this.downsampleMethod, baseResolution, this.currentAbsoluteDownsampling, currentResolution, this.currentTranslation))) continue;
                this.storeScaleReference(c, s, currentChannelImg);
                this.updateMultiscaleMetadata(multiscaleMetadata, (M)currentMetadata);
                anyScalesWritten = true;
                if (this.lastScale(this.chunkSize, (Interval)currentChannelImg, (M)currentMetadata)) break;
            }
            if (!anyScalesWritten) continue;
            this.writeMetadata((M)this.finalizeMultiscaleMetadata(channelDataset, multiscaleMetadata), n5, channelDataset);
        }
        n5.close();
    }

    protected <M extends N5DatasetMetadata> M initializeBaseMetadata() {
        NgffSingleScaleAxesMetadata baseMetadata = null;
        if (this.impMeta != null) {
            try {
                baseMetadata = (NgffSingleScaleAxesMetadata)this.impMeta.readMetadata(this.image);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.impMeta instanceof NgffToImagePlus) {
            baseMetadata = this.permuteAxesForNgff(baseMetadata);
        }
        return (M)baseMetadata;
    }

    protected NgffSingleScaleAxesMetadata permuteAxesForNgff(NgffSingleScaleAxesMetadata metadata) {
        Axis[] axes = metadata.getAxes();
        boolean hasC = false;
        boolean hasZ = false;
        boolean hasT = false;
        for (int i = 0; i < axes.length; ++i) {
            hasC = hasC || axes[i].getName().equals("c");
            hasZ = hasZ || axes[i].getName().equals("z");
            hasT = hasT || axes[i].getName().equals("t");
        }
        if (hasC && hasZ) {
            double[] newTranslation;
            double[] newScale;
            Axis[] newAxes;
            double[] scale = metadata.getScale();
            double[] translation = metadata.getTranslation();
            if (hasT) {
                newAxes = new Axis[]{axes[0], axes[1], axes[3], axes[2], axes[4]};
                newScale = new double[]{scale[0], scale[1], scale[3], scale[2], scale[4]};
                newTranslation = new double[]{translation[0], translation[1], translation[3], translation[2], translation[4]};
            } else {
                newAxes = new Axis[]{axes[0], axes[1], axes[3], axes[2]};
                newScale = new double[]{scale[0], scale[1], scale[3], scale[2]};
                newTranslation = new double[]{translation[0], translation[1], translation[3], translation[2]};
            }
            return new NgffSingleScaleAxesMetadata(metadata.getPath(), newScale, newTranslation, newAxes, metadata.getAttributes());
        }
        return metadata;
    }

    protected void initializeDataset() {
        this.dataset = this.image.getShortTitle();
    }

    protected boolean validateDataset() {
        if (this.dataset.isEmpty()) {
            this.cancel("Please provide a name for the dataset");
            return false;
        }
        return true;
    }

    protected int numNonChannelDimensions(ImagePlus imp) {
        int nd = 2;
        if (imp.getNSlices() > 1) {
            ++nd;
        }
        if (imp.getNFrames() > 1) {
            ++nd;
        }
        return nd;
    }

    protected boolean metadataSupportsScales() {
        return this.metadataStyle.equals("N5Viewer") || this.metadataStyle.equals("COSEM") || this.metadataStyle.equals("OME-NGFF");
    }

    protected <M extends N5DatasetMetadata> M defaultMetadata(ImagePlus imp) {
        return (M)new AbstractN5DatasetMetadata("", null){};
    }

    protected void storeScaleReference(int channel, int scale, RandomAccessibleInterval<?> img) {
        this.previousScaleImg = img;
    }

    protected <T extends RealType<T> & NativeType<T>> RandomAccessibleInterval<T> getPreviousScaleImage(int channel, int scale) {
        return this.previousScaleImg;
    }

    protected <M extends N5DatasetMetadata, N extends SpatialMetadataGroup<?>> N initializeMultiscaleMetadata(M baseMetadata, String path) {
        if (!this.metadataStyle.equals("OME-NGFF")) {
            return null;
        }
        return (N)new OmeNgffMultiScaleMetadataMutable(path);
    }

    protected <M extends N5DatasetMetadata, N extends SpatialMetadataGroup<?>> void updateMultiscaleMetadata(N multiscaleMetadata, M scaleMetadata) {
        if (!this.metadataStyle.equals("OME-NGFF")) {
            return;
        }
        if (multiscaleMetadata instanceof OmeNgffMultiScaleMetadataMutable && scaleMetadata instanceof NgffSingleScaleAxesMetadata) {
            OmeNgffMultiScaleMetadataMutable ngffMs = (OmeNgffMultiScaleMetadataMutable)multiscaleMetadata;
            ngffMs.addChild((NgffSingleScaleAxesMetadata)scaleMetadata);
        }
    }

    protected <N extends SpatialMetadataGroup<?>> N finalizeMultiscaleMetadata(String path, N multiscaleMetadata) {
        if (!this.metadataStyle.equals("OME-NGFF")) {
            return multiscaleMetadata;
        }
        if (multiscaleMetadata instanceof OmeNgffMultiScaleMetadataMutable) {
            OmeNgffMultiScaleMetadataMutable ms = (OmeNgffMultiScaleMetadataMutable)multiscaleMetadata;
            OmeNgffMultiScaleMetadata meta = new OmeNgffMultiScaleMetadata(ms.getAxes().length, path, path, this.downsampleMethod, "0.4", ms.getAxes(), ms.getDatasets(), null, ms.coordinateTransformations, ms.metadata, true);
            return (N)new OmeNgffMetadata(path, new OmeNgffMultiScaleMetadata[]{meta});
        }
        return multiscaleMetadata;
    }

    protected <M extends N5Metadata> boolean lastScale(int[] chunkSize, Interval imageDimensions, M metadata) {
        String downsamplePolicy = this.prefs != null ? this.prefs.get(this.getClass(), IJ_PROPERTY_DOWNSAMPLE_POLICY, DEFAULT_POLICY.toString()) : DEFAULT_POLICY.toString();
        switch (DOWNSAMPLE_POLICY.valueOf(downsamplePolicy)) {
            case Aggressive: {
                return this.lastScaleAggressive(chunkSize, imageDimensions, metadata);
            }
        }
        return this.lastScaleConservative(chunkSize, imageDimensions, metadata);
    }

    protected <M extends N5Metadata> boolean lastScaleAggressive(int[] chunkSize, Interval imageDimensions, M metadata) {
        Axis[] axes = this.getAxes(metadata, imageDimensions.numDimensions());
        int nd = axes.length;
        for (int i = 0; i < nd; ++i) {
            if (!axes[i].getType().equals("space") || imageDimensions.dimension(i) <= (long)chunkSize[i]) continue;
            return false;
        }
        return true;
    }

    protected <M extends N5Metadata> boolean lastScaleConservative(int[] chunkSize, Interval imageDimensions, M metadata) {
        Axis[] axes = this.getAxes(metadata, imageDimensions.numDimensions());
        int nd = axes.length;
        for (int i = 0; i < nd; ++i) {
            if (!axes[i].getType().equals("space") || imageDimensions.dimension(i) > (long)chunkSize[i]) continue;
            return true;
        }
        return false;
    }

    protected <M extends N5DatasetMetadata> void fillResolution(M baseMetadata, double[] resolution) {
        if (baseMetadata == null) {
            Arrays.fill(resolution, 1.0);
            return;
        }
        if (baseMetadata.getClass().equals(N5SingleScaleMetadata.class)) {
            double[] res = ((N5SingleScaleMetadata)baseMetadata).getPixelResolution();
            int nd = res.length < resolution.length ? res.length : resolution.length;
            System.arraycopy(res, 0, resolution, 0, nd);
        } else if (baseMetadata instanceof N5CosemMetadata) {
            double[] res = ((N5CosemMetadata)baseMetadata).getCosemTransform().scale;
            int nd = res.length < resolution.length ? res.length : resolution.length;
            System.arraycopy(res, 0, resolution, 0, nd);
        } else if (baseMetadata instanceof NgffSingleScaleAxesMetadata) {
            double[] res = ((NgffSingleScaleAxesMetadata)baseMetadata).getScale();
            int nd = res.length < resolution.length ? res.length : resolution.length;
            System.arraycopy(res, 0, resolution, 0, nd);
        } else if (baseMetadata instanceof SpatialMetadata) {
            AffineGet affine = ((SpatialMetadata)baseMetadata).spatialTransform();
            int nd = affine.numTargetDimensions();
            for (int i = 0; i < nd; ++i) {
                resolution[i] = affine.get(i, i);
            }
        } else {
            Arrays.fill(resolution, 1.0);
        }
    }

    protected <M extends N5DatasetMetadata> M metadataForThisScale(String newPath, M baseMetadata, String downsampleMethod, double[] baseResolution, long[] absoluteDownsamplingFactors, double[] scale, double[] translation) {
        return this.metadataForThisScale(newPath, baseMetadata, downsampleMethod, baseResolution, Arrays.stream(absoluteDownsamplingFactors).mapToDouble(x -> x).toArray(), scale, translation);
    }

    protected <M extends N5DatasetMetadata> M metadataForThisScale(String newPath, M baseMetadata, String downsampleMethod, double[] baseResolution, double[] absoluteDownsamplingFactors, double[] absoluteScale, double[] absoluteTranslation) {
        if (baseMetadata == null) {
            return null;
        }
        if (baseMetadata.getClass().equals(N5SingleScaleMetadata.class)) {
            return (M)this.buildN5VMetadata(newPath, (N5SingleScaleMetadata)baseMetadata, downsampleMethod, baseResolution, absoluteDownsamplingFactors);
        }
        if (baseMetadata instanceof N5CosemMetadata) {
            return (M)this.buildCosemMetadata(newPath, (N5CosemMetadata)baseMetadata, absoluteScale, absoluteTranslation);
        }
        if (baseMetadata instanceof NgffSingleScaleAxesMetadata) {
            return (M)this.buildNgffMetadata(newPath, (NgffSingleScaleAxesMetadata)baseMetadata, absoluteScale, absoluteTranslation);
        }
        return baseMetadata;
    }

    protected <T extends RealType<T> & NativeType<T>> RandomAccessibleInterval<T> downsampleMethod(RandomAccessibleInterval<T> img, long[] factors) {
        if (this.downsampleMethod.equals(DOWN_AVERAGE)) {
            return N5ScalePyramidExporter.downsampleAvgBy2(img, factors);
        }
        return N5ScalePyramidExporter.downsample(img, factors);
    }

    protected <M extends N5Metadata> String getChannelDatasetName(int channelIndex) {
        if (this.metadataStyle.equals("N5Viewer") || this.image.getNChannels() > 1 && this.metadataStyle.equals("COSEM")) {
            return MetadataUtils.normalizeGroupPath((String)(this.dataset + String.format("/c%d", channelIndex)));
        }
        return this.dataset;
    }

    protected <M extends N5Metadata> String getScaleDatasetName(int channelIndex, int scale) {
        if (this.metadataSupportsScales()) {
            return this.getChannelDatasetName(channelIndex) + String.format("/s%d", scale);
        }
        return this.getChannelDatasetName(channelIndex);
    }

    protected long[] initDownsampleFactors(int nd) {
        long[] factors = new long[nd];
        Arrays.fill(factors, 1L);
        return factors;
    }

    protected <M extends N5Metadata> long[] getDownsampleFactors(M metadata, int nd, int scale, long[] downsampleFactors) {
        Axis[] axes = this.getAxes(metadata, nd);
        long[] factors = new long[axes.length];
        for (int i = 0; i < nd; ++i) {
            factors[i] = axes[i].getType().equals("space") ? (long)(1 << scale) : 1L;
        }
        return factors;
    }

    protected <M extends N5Metadata> long[] getRelativeDownsampleFactors(M metadata, Interval img, int scale, long[] downsampleFactors) {
        int nd = img.numDimensions();
        Axis[] axes = this.getAxes(metadata, nd);
        long[] factors = new long[axes.length];
        for (int i = 0; i < nd; ++i) {
            factors[i] = axes[i].getType().equals("space") && img.dimension(i) > 1L ? 2L : 1L;
        }
        return factors;
    }

    protected <M extends N5Metadata> Axis[] getAxes(M metadata, int nd) {
        if (metadata instanceof AxisMetadata) {
            return ((AxisMetadata)metadata).getAxes();
        }
        if (metadata instanceof N5SingleScaleMetadata) {
            return AxisUtils.defaultN5ViewerAxes((N5SpatialDatasetMetadata)((N5SingleScaleMetadata)metadata)).getAxes();
        }
        return AxisUtils.defaultAxes((int)nd);
    }

    protected <T extends NumericType<T>> RandomAccessibleInterval<T> getBaseImage() {
        ImgPlus baseImg = this.image.getType() == 4 ? N5IJUtils.wrapRgbAsInt(this.image) : VirtualStackAdapter.wrap((ImagePlus)this.image);
        return baseImg;
    }

    protected <T extends RealType<T> & NativeType<T>, M extends N5DatasetMetadata> List<RandomAccessibleInterval<T>> splitChannels(M metadata, RandomAccessibleInterval<T> img) {
        if (this.metadataStyle.equals(NONE) || this.metadataStyle.equals("Custom") || this.metadataStyle.equals("ImageJ")) {
            return Collections.singletonList(img);
        }
        if (this.metadataStyle.equals("OME-NGFF")) {
            if (this.image.getNChannels() > 1 && this.image.getNSlices() > 1) {
                return Collections.singletonList(Views.permute(img, (int)2, (int)3));
            }
            return Collections.singletonList(img);
        }
        ArrayList<RandomAccessibleInterval<T>> channels = new ArrayList<RandomAccessibleInterval<T>>();
        boolean slicedChannels = false;
        for (int c = 0; c < this.image.getNChannels(); ++c) {
            IntervalView channelImg;
            if (this.image.getNChannels() > 1) {
                channelImg = Views.hyperSlice(img, (int)2, (long)c);
                slicedChannels = true;
            } else {
                channelImg = img;
            }
            if (this.metadataStyle.equals("N5Viewer") && this.image.getNFrames() > 1 && this.image.getNSlices() == 1) {
                channelImg = Views.permute((RandomAccessibleInterval)Views.addDimension((RandomAccessibleInterval)channelImg, (long)0L, (long)0L), (int)2, (int)3);
            }
            channels.add((RandomAccessibleInterval<T>)channelImg);
        }
        if (slicedChannels) {
            this.currentChannelMetadata = this.sliceMetadata(metadata, 2);
        }
        return channels;
    }

    protected <M extends N5DatasetMetadata> M copyMetadata(M metadata) {
        if (metadata == null) {
            return metadata;
        }
        if (metadata instanceof N5CosemMetadata) {
            return (M)new N5CosemMetadata(metadata.getPath(), ((N5CosemMetadata)metadata).getCosemTransform(), metadata.getAttributes());
        }
        if (metadata instanceof N5SingleScaleMetadata) {
            N5SingleScaleMetadata ssm = (N5SingleScaleMetadata)metadata;
            return (M)new N5SingleScaleMetadata(ssm.getPath(), ssm.spatialTransform3d(), ssm.getDownsamplingFactors(), ssm.getPixelResolution(), ssm.getOffset(), ssm.unit(), metadata.getAttributes(), Double.valueOf(ssm.minIntensity()), Double.valueOf(ssm.maxIntensity()), ssm.isLabelMultiset());
        }
        if (metadata instanceof NgffSingleScaleAxesMetadata) {
            NgffSingleScaleAxesMetadata ngffMeta = (NgffSingleScaleAxesMetadata)metadata;
            return (M)new NgffSingleScaleAxesMetadata(ngffMeta.getPath(), ngffMeta.getScale(), ngffMeta.getTranslation(), ngffMeta.getAxes(), ngffMeta.getAttributes());
        }
        if (metadata instanceof N5ImagePlusMetadata) {
            N5ImagePlusMetadata ijmeta = (N5ImagePlusMetadata)metadata;
            return (M)((Object)new N5ImagePlusMetadata(ijmeta.getPath(), ijmeta.getAttributes(), ijmeta.getName(), ijmeta.fps, ijmeta.frameInterval, ijmeta.unit, ijmeta.pixelWidth, ijmeta.pixelHeight, ijmeta.pixelDepth, ijmeta.xOrigin, ijmeta.yOrigin, ijmeta.zOrigin, ijmeta.numChannels, ijmeta.numSlices, ijmeta.numFrames, ijmeta.type, ijmeta.properties));
        }
        System.err.println("Encountered metadata of unexpected type.");
        return metadata;
    }

    protected <M extends N5DatasetMetadata> M sliceMetadata(M metadata, int i) {
        if (metadata instanceof N5CosemMetadata) {
            return (M)new N5CosemMetadata(metadata.getPath(), ((N5CosemMetadata)metadata).getCosemTransform(), this.removeDimension(metadata.getAttributes(), i));
        }
        if (metadata instanceof N5SingleScaleMetadata) {
            N5SingleScaleMetadata ssm = (N5SingleScaleMetadata)metadata;
            return (M)new N5SingleScaleMetadata(ssm.getPath(), ssm.spatialTransform3d(), ssm.getDownsamplingFactors(), ssm.getPixelResolution(), ssm.getOffset(), ssm.unit(), this.removeDimension(metadata.getAttributes(), i), Double.valueOf(ssm.minIntensity()), Double.valueOf(ssm.maxIntensity()), ssm.isLabelMultiset());
        }
        if (metadata instanceof NgffSingleScaleAxesMetadata) {
            NgffSingleScaleAxesMetadata ngffMeta = (NgffSingleScaleAxesMetadata)metadata;
            return (M)new NgffSingleScaleAxesMetadata(ngffMeta.getPath(), ngffMeta.getScale(), ngffMeta.getTranslation(), this.removeDimension(ngffMeta.getAttributes(), i));
        }
        return metadata;
    }

    protected DatasetAttributes removeDimension(DatasetAttributes attributes, int i) {
        return new DatasetAttributes(N5ScalePyramidExporter.removeElement(attributes.getDimensions(), i), N5ScalePyramidExporter.removeElement(attributes.getBlockSize(), i), attributes.getDataType(), attributes.getCompression());
    }

    protected <M extends N5Metadata> void writeMetadata(M metadata, N5Writer n5, String dataset) {
        N5MetadataWriter<?> writer;
        if (metadata != null && (writer = this.metadataWriters.get(metadata.getClass())) != null) {
            try {
                writer.writeMetadata(metadata, n5, dataset);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected N5SingleScaleMetadata buildN5VMetadata(String path, N5SingleScaleMetadata baseMetadata, String downsampleMethod, double[] baseResolution, double[] downsamplingFactors) {
        int nd = baseResolution.length > 3 ? 3 : baseResolution.length;
        double[] resolution = new double[nd];
        double[] factors = new double[nd];
        if (downsampleMethod.equals(DOWN_AVERAGE)) {
            System.arraycopy(baseResolution, 0, resolution, 0, nd);
            System.arraycopy(downsamplingFactors, 0, factors, 0, nd);
        } else {
            for (int i = 0; i < nd; ++i) {
                resolution[i] = baseResolution[i] * downsamplingFactors[i];
            }
            Arrays.fill(factors, 1.0);
        }
        AffineTransform3D transform = new AffineTransform3D();
        for (int i = 0; i < nd; ++i) {
            transform.set(resolution[i], i, i);
        }
        return new N5SingleScaleMetadata(path, transform, factors, resolution, baseMetadata.getOffset(), baseMetadata.unit(), baseMetadata.getAttributes(), Double.valueOf(baseMetadata.minIntensity()), Double.valueOf(baseMetadata.maxIntensity()), baseMetadata.isLabelMultiset());
    }

    protected N5CosemMetadata buildCosemMetadata(String path, N5CosemMetadata baseMetadata, double[] absoluteResolution, double[] absoluteTranslation) {
        double[] resolution = new double[absoluteResolution.length];
        System.arraycopy(absoluteResolution, 0, resolution, 0, absoluteResolution.length);
        double[] translation = new double[absoluteTranslation.length];
        System.arraycopy(absoluteTranslation, 0, translation, 0, absoluteTranslation.length);
        return new N5CosemMetadata(path, new N5CosemMetadata.CosemTransform(baseMetadata.getCosemTransform().axes, resolution, translation, baseMetadata.getCosemTransform().units), baseMetadata.getAttributes());
    }

    protected NgffSingleScaleAxesMetadata buildNgffMetadata(String path, NgffSingleScaleAxesMetadata baseMetadata, double[] absoluteResolution, double[] absoluteTranslation) {
        double[] resolution = new double[absoluteResolution.length];
        System.arraycopy(absoluteResolution, 0, resolution, 0, absoluteResolution.length);
        double[] translation = new double[absoluteTranslation.length];
        System.arraycopy(absoluteTranslation, 0, translation, 0, absoluteTranslation.length);
        return new NgffSingleScaleAxesMetadata(path, resolution, translation, baseMetadata.getAxes(), baseMetadata.getAttributes());
    }

    protected boolean promptOverwriteAndDelete(N5Writer n5, String dataset, boolean doGroupExistsWarning) {
        String deleteThisPathToOverwrite = N5ScalePyramidExporter.needOverwrite((N5Reader)n5, dataset, doGroupExistsWarning);
        if (deleteThisPathToOverwrite != null) {
            if (!this.overwrite && !this.overwriteSet) {
                this.overwrite = this.ui != null ? this.promptOverwrite(deleteThisPathToOverwrite) : this.promptOverwrite(deleteThisPathToOverwrite);
            }
            if (this.overwrite) {
                this.overwrite = this.promptOverwriteWarning(n5, this.containerRoot, deleteThisPathToOverwrite);
            }
            if (this.overwrite) {
                n5.remove(deleteThisPathToOverwrite);
            } else {
                return false;
            }
        }
        return true;
    }

    public ExecutorService getExecutorService() {
        return this.threadPool;
    }

    private <T extends RealType & NativeType, M extends N5Metadata> boolean write(RandomAccessibleInterval<T> image, N5Writer n5, String dataset, Compression compression, M metadata) throws IOException, InterruptedException, ExecutionException {
        this.parseBlockSize(image.dimensionsAsLongArray());
        this.threadPool = new ThreadPoolExecutor(this.nThreads, this.nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        this.progressMonitor(this.threadPool);
        N5Utils.save(image, (N5Writer)n5, (String)dataset, (int[])this.chunkSize, (Compression)compression, (ExecutorService)this.threadPool);
        this.threadPool.shutdown();
        this.writeMetadata(metadata, n5, dataset);
        return true;
    }

    private static String needOverwrite(N5Reader n5, String path, boolean checkGroupExists) {
        String[] children;
        String[] parts;
        if (checkGroupExists && n5.exists(path)) {
            return path;
        }
        String currentPath = "";
        if (n5.datasetExists(currentPath)) {
            return "";
        }
        for (String p : parts = path.split("/")) {
            if (!n5.datasetExists(currentPath = currentPath + "/" + p)) continue;
            return currentPath;
        }
        if (n5.exists(path) && (children = n5.list(path)).length > 0) {
            return path;
        }
        return null;
    }

    private static <T extends NumericType<T>> RandomAccessibleInterval<T> downsample(RandomAccessibleInterval<T> img, long[] downsampleFactors) {
        return Views.subsample(img, (long[])downsampleFactors);
    }

    private static <T extends NumericType<T>> RandomAccessibleInterval<T> downsampleAvgBy2(RandomAccessibleInterval<T> img, long[] downsampleFactors) {
        assert (Arrays.stream(downsampleFactors).allMatch(x -> x == 1L || x == 2L));
        int nd = downsampleFactors.length;
        double[] scale = new double[nd];
        double[] translation = new double[nd];
        long[] dims = new long[nd];
        for (int i = 0; i < nd; ++i) {
            if (downsampleFactors[i] == 2L) {
                scale[i] = 0.5;
                translation[i] = -0.25;
                dims[i] = (long)Math.ceil(img.dimension(i) / 2L);
                continue;
            }
            scale[i] = 1.0;
            translation[i] = 0.0;
            dims[i] = img.dimension(i);
        }
        if (img.getType() instanceof NativeType) {
            return N5ScalePyramidExporter.downsampleAvgBy2NativeType(img, Util.long2int((long[])downsampleFactors), dims);
        }
        RealRandomAccessible imgE = Views.interpolate((EuclideanSpace)Views.extendBorder(img), (InterpolatorFactory)new NLinearInterpolatorFactory());
        return Views.interval((RandomAccessible)RealViews.transform((RealRandomAccessible)imgE, (InvertibleRealTransform)new ScaleAndTranslation(scale, translation)), (Interval)new FinalInterval(dims));
    }

    private static <T extends NativeType<T>> RandomAccessibleInterval<T> downsampleAvgBy2NativeType(RandomAccessibleInterval<T> img, int[] downsampleFactors, long[] dimensions) {
        int[] cellDimensions = new int[]{32};
        BlockSupplier blocks = BlockSupplier.of((RandomAccessible)img.view().extend(RandomAccessibleIntervalView.Extension.border())).andThen(Downsample.downsample((int[])downsampleFactors));
        return BlockAlgoUtils.cellImg((BlockSupplier)blocks, (long[])dimensions, (int[])cellDimensions);
    }

    private static int[] removeElement(int[] arr, int excludeIndex) {
        int[] out = new int[arr.length - 1];
        int j = 0;
        for (int i = 0; i < arr.length; ++i) {
            if (i == excludeIndex) continue;
            out[j] = arr[i];
            ++j;
        }
        return out;
    }

    private static long[] removeElement(long[] arr, int excludeIndex) {
        long[] out = new long[arr.length - 1];
        int j = 0;
        for (int i = 0; i < arr.length; ++i) {
            if (i == excludeIndex) continue;
            out[j] = arr[i];
            ++j;
        }
        return out;
    }

    public void run() {
        if (this.metadataStyle.equals("Custom")) {
            this.metaSpecDialog = new N5MetadataSpecDialog(this);
            this.metaSpecDialog.show("{\n\"resolution\" : [.xResolution, .yResolution, .zResolution ]\n}");
        } else {
            try {
                this.processMultiscale();
            }
            catch (IOException | InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        }
    }

    private void progressMonitor(final ThreadPoolExecutor exec) {
        new Thread(){

            @Override
            public void run() {
                IJ.showProgress((double)0.01);
                try {
                    Thread.sleep(333L);
                    boolean done = false;
                    while (!done && !exec.isShutdown()) {
                        long N;
                        long i = exec.getCompletedTaskCount();
                        done = i == (N = exec.getTaskCount());
                        IJ.showProgress((double)((double)i / (double)N));
                        Thread.sleep(333L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                IJ.showProgress((double)1.0);
            }
        }.start();
    }

    private Compression getCompression() {
        return N5ScalePyramidExporter.getCompression(this.compressionArg);
    }

    private final boolean promptHomeDirectoryWarning(String root) {
        try {
            String f = new File(System.getProperty("user.home")).getCanonicalPath();
            String rootPathCanonical = new File(root).getCanonicalPath();
            if (f.equals(rootPathCanonical)) {
                JOptionPane.showMessageDialog(null, "You have chosen your home directory as the container root.\nThis is not allowed. Please choose a different path.\nWe strongly suggest creating an empty directory.", "Warning", 2);
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private final boolean promptOverwrite(String dataset) {
        return JOptionPane.showConfirmDialog(null, String.format("Group or dataset %s already exists. Completely remove that data and overwrite?", dataset), "Warning", 0, 2) == 0;
    }

    private final boolean promptOverwriteWarning(N5Writer n5, String root, String dataset) {
        return this.promptOverwriteWarning(n5, root, dataset, true);
    }

    private final boolean promptOverwriteWarning(N5Writer n5, String root, String dataset, boolean checkPrefs) {
        if (this.prefs == null) {
            return true;
        }
        boolean skipWarning = this.prefs.getBoolean(this.getClass(), IJ_PROPERTY_DO_NOT_WARN, false);
        if (skipWarning) {
            return true;
        }
        Frame parentFrame = this.getParentFrame();
        if (parentFrame == null) {
            return true;
        }
        DetailedOverwriteWarningDialog warningDialog = new DetailedOverwriteWarningDialog(parentFrame, root, dataset);
        warningDialog.setVisible(true);
        this.prefs.put(this.getClass(), IJ_PROPERTY_DO_NOT_WARN, warningDialog.skipWarningCheckbox());
        parentFrame = null;
        return warningDialog.doDelete();
    }

    private Frame getParentFrame() {
        Object uic;
        Object parentFrame = null;
        ApplicationFrame appFrame = this.ui.getDefaultUI().getApplicationFrame();
        Frame frame = null;
        if (appFrame instanceof Frame) {
            frame = (Frame)appFrame;
        } else if (appFrame instanceof UIComponent && (uic = ((UIComponent)appFrame).getComponent()) instanceof Frame) {
            frame = (Frame)uic;
        }
        return frame == null ? new JFrame() : frame;
    }

    public static Compression getCompression(String compressionArg) {
        switch (compressionArg) {
            case "gzip": {
                return new GzipCompression();
            }
            case "lz4": {
                return new Lz4Compression();
            }
            case "xz": {
                return new XzCompression();
            }
            case "raw": {
                return new RawCompression();
            }
            case "blosc": {
                return new BloscCompression();
            }
            case "zstd": {
                return new ZstandardCompression();
            }
        }
        return new RawCompression();
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.styles.put("Custom", this.metaSpecDialog.getMapper());
        this.impMetaWriterTypes.put(MetadataTemplateMapper.class, new ImagePlusMetadataTemplate());
        try {
            this.processMultiscale();
        }
        catch (IOException | InterruptedException | ExecutionException e1) {
            e1.printStackTrace();
        }
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    private static class DetailedOverwriteWarningDialog
    extends JDialog {
        private static final long serialVersionUID = 4515617981904344864L;
        private static int SML = 4;
        private static int MED = 8;
        private static int BIG = 16;
        private static int VBIG = 32;
        private boolean skipWarning = false;
        private boolean doDelete = false;

        public DetailedOverwriteWarningDialog(Frame parent, String root, String dataset) {
            super(parent, "WARNING", true);
            this.initComponents(root, dataset);
            this.setResizable(false);
            this.setLocationRelativeTo(null);
        }

        public boolean skipWarningCheckbox() {
            return this.skipWarning;
        }

        public boolean doDelete() {
            return this.doDelete;
        }

        private void initComponents(String root, String dataset) {
            JPanel panel = new JPanel(false);
            panel.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            panel.setLayout(new GridBagLayout());
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.anchor = 22;
            gbc.fill = 0;
            gbc.insets = new Insets(SML, VBIG, MED, SML);
            gbc.ipadx = 10;
            gbc.ipady = 10;
            Icon warningIcon = UIManager.getIcon("OptionPane.warningIcon");
            panel.add((Component)new JLabel(warningIcon), gbc);
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.gridx = 2;
            gbc.gridy = 0;
            gbc.gridwidth = 4;
            gbc.gridheight = 1;
            gbc.anchor = 10;
            gbc.fill = 2;
            gbc.insets = new Insets(SML, SML, MED, VBIG);
            gbc.ipadx = 10;
            gbc.ipady = 10;
            panel.add((Component)new JLabel("<html><b>Warning: data will be deleted</b></html>"), gbc);
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 0.2;
            gbc.gridwidth = 5;
            gbc.gridheight = 1;
            gbc.anchor = 10;
            gbc.fill = 1;
            gbc.insets = new Insets(MED, VBIG, SML, VBIG);
            JTextPane warningText = new JTextPane();
            warningText.setContentType("text/html");
            warningText.setText(String.format("<html>This operation <b>WILL REMOVE ALL FILES AND ALL DATA</b> in:<br><br><tt>%s/%s</tt><br><br>Do you want to proceed?<br></html>", root, dataset));
            warningText.setEditable(false);
            warningText.setBackground(new Color(0, 0, 0, 0));
            panel.add((Component)warningText, gbc);
            JCheckBox doNotWarnAgainCheckbox = new JCheckBox();
            doNotWarnAgainCheckbox.setText("Do not show this warning again");
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.gridheight = 1;
            gbc.gridwidth = 3;
            gbc.anchor = 21;
            gbc.fill = 0;
            gbc.ipadx = 50;
            doNotWarnAgainCheckbox.addItemListener(e -> {
                this.skipWarning = doNotWarnAgainCheckbox.isSelected();
            });
            panel.add((Component)doNotWarnAgainCheckbox, gbc);
            JButton deleteBtn = new JButton("Delete");
            gbc.gridx = 3;
            gbc.gridheight = 1;
            gbc.gridwidth = 1;
            gbc.anchor = 13;
            gbc.fill = 0;
            gbc.insets = new Insets(MED, BIG, MED, MED);
            gbc.ipadx = 10;
            deleteBtn.addActionListener(e -> {
                this.doDelete = true;
                this.setVisible(false);
            });
            panel.add((Component)deleteBtn, gbc);
            JButton cancelBtn = new JButton("Cancel");
            gbc.gridx = 4;
            gbc.anchor = 17;
            gbc.insets = new Insets(MED, SML, MED, BIG);
            panel.add((Component)cancelBtn, gbc);
            cancelBtn.addActionListener(e -> {
                this.doDelete = false;
                this.setVisible(false);
            });
            this.add(panel);
            this.pack();
        }
    }

    public static enum DOWNSAMPLE_METHOD {
        Sample,
        Average;

    }

    public static enum DOWNSAMPLE_POLICY {
        Conservative,
        Aggressive;

    }
}

