/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart;

import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.knowm.xchart.CategoryChartBuilder;
import org.knowm.xchart.CategorySeries;
import org.knowm.xchart.internal.Utils;
import org.knowm.xchart.internal.chartpart.AxisPair;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.internal.chartpart.Legend_Marker;
import org.knowm.xchart.internal.chartpart.Plot_Category;
import org.knowm.xchart.internal.series.AxesChartSeriesCategory;
import org.knowm.xchart.internal.series.Series;
import org.knowm.xchart.internal.style.SeriesColorMarkerLineStyle;
import org.knowm.xchart.internal.style.SeriesColorMarkerLineStyleCycler;
import org.knowm.xchart.style.CategoryStyler;
import org.knowm.xchart.style.Styler;
import org.knowm.xchart.style.Theme;

public class CategoryChart
extends Chart<CategoryStyler, CategorySeries> {
    public CategoryChart(int width, int height) {
        super(width, height, new CategoryStyler());
        this.axisPair = new AxisPair<CategoryStyler, CategorySeries>(this);
        this.plot = new Plot_Category<CategoryStyler, CategorySeries>(this);
        this.legend = new Legend_Marker<CategoryStyler, CategorySeries>(this);
    }

    public CategoryChart(int width, int height, Theme theme) {
        this(width, height);
        ((CategoryStyler)this.styler).setTheme(theme);
    }

    public CategoryChart(int width, int height, Styler.ChartTheme chartTheme) {
        this(width, height, chartTheme.newInstance(chartTheme));
    }

    public CategoryChart(CategoryChartBuilder chartBuilder) {
        this(chartBuilder.width, chartBuilder.height, chartBuilder.chartTheme);
        this.setTitle(chartBuilder.title);
        this.setXAxisTitle(chartBuilder.xAxisTitle);
        this.setYAxisTitle(chartBuilder.yAxisTitle);
    }

    public CategorySeries addSeries(String seriesName, double[] xData, double[] yData) {
        return this.addSeries(seriesName, xData, yData, null);
    }

    public CategorySeries addSeries(String seriesName, double[] xData, double[] yData, double[] errorBars) {
        return this.addSeries(seriesName, Utils.getNumberListFromDoubleArray(xData), Utils.getNumberListFromDoubleArray(yData), Utils.getNumberListFromDoubleArray(errorBars));
    }

    public CategorySeries addSeries(String seriesName, int[] xData, int[] yData) {
        return this.addSeries(seriesName, xData, yData, (int[])null);
    }

    public CategorySeries addSeries(String seriesName, int[] xData, int[] yData, int[] errorBars) {
        return this.addSeries(seriesName, Utils.getNumberListFromIntArray(xData), Utils.getNumberListFromIntArray(yData), Utils.getNumberListFromIntArray(errorBars));
    }

    public CategorySeries addSeries(String seriesName, List<?> xData, List<? extends Number> yData) {
        return this.addSeries(seriesName, xData, yData, null);
    }

    public CategorySeries addSeries(String seriesName, List<?> xData, List<? extends Number> yData, List<? extends Number> errorBars) {
        CategorySeries series;
        this.sanityCheck(seriesName, xData, yData, errorBars);
        if (xData != null) {
            if (xData.size() != yData.size()) {
                throw new IllegalArgumentException("X and Y-Axis sizes are not the same!!!");
            }
            series = new CategorySeries(seriesName, xData, yData, errorBars, this.getDataType(xData));
        } else {
            xData = Utils.getGeneratedDataAsList(yData.size());
            series = new CategorySeries(seriesName, xData, yData, errorBars, this.getDataType(xData));
        }
        this.seriesMap.put(seriesName, series);
        return series;
    }

    private Series.DataType getDataType(List<?> data) {
        Series.DataType axisType;
        Iterator<?> itr = data.iterator();
        Object dataPoint = itr.next();
        if (dataPoint instanceof Number) {
            axisType = Series.DataType.Number;
        } else if (dataPoint instanceof Date) {
            axisType = Series.DataType.Date;
        } else if (dataPoint instanceof String) {
            axisType = Series.DataType.String;
        } else {
            throw new IllegalArgumentException("Series data must be either Number, Date or String type!!!");
        }
        return axisType;
    }

    public CategorySeries updateCategorySeries(String seriesName, List<?> newXData, List<? extends Number> newYData, List<? extends Number> newErrorBarData) {
        Map seriesMap = this.getSeriesMap();
        CategorySeries series = (CategorySeries)seriesMap.get(seriesName);
        if (series == null) {
            throw new IllegalArgumentException("Series name >" + seriesName + "< not found!!!");
        }
        if (newXData == null) {
            ArrayList<Integer> generatedXData = new ArrayList<Integer>();
            for (int i = 1; i <= newYData.size(); ++i) {
                generatedXData.add(i);
            }
            series.replaceData(generatedXData, newYData, newErrorBarData);
        } else {
            series.replaceData(newXData, newYData, newErrorBarData);
        }
        return series;
    }

    public CategorySeries updateCategorySeries(String seriesName, double[] newXData, double[] newYData, double[] newErrorBarData) {
        return this.updateCategorySeries(seriesName, Utils.getNumberListFromDoubleArray(newXData), Utils.getNumberListFromDoubleArray(newYData), Utils.getNumberListFromDoubleArray(newErrorBarData));
    }

    private void sanityCheck(String seriesName, List<?> xData, List<? extends Number> yData, List<? extends Number> errorBars) {
        if (this.seriesMap.keySet().contains(seriesName)) {
            throw new IllegalArgumentException("Series name >" + seriesName + "< has already been used. Use unique names for each series!!!");
        }
        if (yData == null) {
            throw new IllegalArgumentException("Y-Axis data cannot be null!!!");
        }
        if (yData.size() == 0) {
            throw new IllegalArgumentException("Y-Axis data cannot be empty!!!");
        }
        if (xData != null && xData.size() == 0) {
            throw new IllegalArgumentException("X-Axis data cannot be empty!!!");
        }
        if (errorBars != null && errorBars.size() != yData.size()) {
            throw new IllegalArgumentException("Error bars and Y-Axis sizes are not the same!!!");
        }
    }

    @Override
    public void paint(Graphics2D g, int width, int height) {
        this.setWidth(width);
        this.setHeight(height);
        for (CategorySeries seriesCategory : this.getSeriesMap().values()) {
            CategorySeries.CategorySeriesRenderStyle seriesType = seriesCategory.getChartCategorySeriesRenderStyle();
            if (seriesType != null) continue;
            seriesCategory.setChartCategorySeriesRenderStyle(((CategoryStyler)this.getStyler()).getDefaultSeriesRenderStyle());
        }
        this.setSeriesStyles();
        this.paintBackground(g);
        this.axisPair.paint(g);
        this.plot.paint(g);
        this.chartTitle.paint(g);
        this.legend.paint(g);
    }

    private void setSeriesStyles() {
        SeriesColorMarkerLineStyleCycler seriesColorMarkerLineStyleCycler = new SeriesColorMarkerLineStyleCycler(((CategoryStyler)this.getStyler()).getSeriesColors(), ((CategoryStyler)this.getStyler()).getSeriesMarkers(), ((CategoryStyler)this.getStyler()).getSeriesLines());
        for (CategorySeries series : this.getSeriesMap().values()) {
            SeriesColorMarkerLineStyle seriesColorMarkerLineStyle = seriesColorMarkerLineStyleCycler.getNextSeriesColorMarkerLineStyle();
            if (series.getLineStyle() == null) {
                series.setLineStyle(seriesColorMarkerLineStyle.getStroke());
            }
            if (series.getLineColor() == null) {
                series.setLineColor(seriesColorMarkerLineStyle.getColor());
            }
            if (series.getFillColor() == null) {
                series.setFillColor(seriesColorMarkerLineStyle.getColor());
            }
            if (series.getMarker() == null) {
                series.setMarker(seriesColorMarkerLineStyle.getMarker());
            }
            if (series.getMarkerColor() != null) continue;
            series.setMarkerColor(seriesColorMarkerLineStyle.getColor());
        }
    }

    public void setCustomCategoryLabels(Map<Object, Object> customCategoryLabels) {
        AxesChartSeriesCategory axesChartSeries = (AxesChartSeriesCategory)this.getSeriesMap().values().iterator().next();
        List categories = (List)axesChartSeries.getXData();
        LinkedHashMap<Double, Object> axisTickValueLabelMap = new LinkedHashMap<Double, Object>();
        for (Map.Entry<Object, Object> entry : customCategoryLabels.entrySet()) {
            int index = categories.indexOf(entry.getKey());
            if (index == -1) {
                throw new IllegalArgumentException("Could not find category index for " + entry.getKey());
            }
            axisTickValueLabelMap.put(Double.valueOf(index), entry.getValue());
        }
        this.setXAxisLabelOverrideMap(axisTickValueLabelMap);
    }
}

