/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.internal.chartpart;

import java.awt.Graphics2D;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import org.knowm.xchart.OHLCSeries;
import org.knowm.xchart.internal.Utils;
import org.knowm.xchart.internal.chartpart.Axis;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.internal.chartpart.PlotContent_;
import org.knowm.xchart.style.AxesChartStyler;
import org.knowm.xchart.style.Styler;
import org.knowm.xchart.style.lines.SeriesLines;

public class PlotContent_OHLC<ST extends AxesChartStyler, S extends OHLCSeries>
extends PlotContent_<ST, S> {
    private final ST ohlcStyler;

    PlotContent_OHLC(Chart<ST, S> chart) {
        super(chart);
        this.ohlcStyler = (AxesChartStyler)chart.getStyler();
    }

    @Override
    public void doPaint(Graphics2D g) {
        double xTickSpace = ((Styler)this.ohlcStyler).getPlotContentSize() * this.getBounds().getWidth();
        double xLeftMargin = Utils.getTickStartOffset((int)this.getBounds().getWidth(), xTickSpace);
        double yTickSpace = ((Styler)this.ohlcStyler).getPlotContentSize() * this.getBounds().getHeight();
        double yTopMargin = Utils.getTickStartOffset((int)this.getBounds().getHeight(), yTickSpace);
        double xMin = this.chart.getXAxis().getMin();
        double xMax = this.chart.getXAxis().getMax();
        Line2D.Double line = new Line2D.Double();
        Rectangle2D.Double rect = new Rectangle2D.Double();
        if (((AxesChartStyler)this.ohlcStyler).isXAxisLogarithmic()) {
            xMin = Math.log10(xMin);
            xMax = Math.log10(xMax);
        }
        Map map = this.chart.getSeriesMap();
        boolean toolTipsEnabled = ((AxesChartStyler)this.chart.getStyler()).isToolTipsEnabled();
        for (OHLCSeries series : map.values()) {
            if (!series.isEnabled()) continue;
            String[] toolTips = series.getToolTips();
            boolean hasCustomToolTips = toolTips != null;
            Axis yAxis = this.chart.getYAxis(series.getYAxisGroup());
            double yMin = yAxis.getMin();
            double yMax = yAxis.getMax();
            if (((AxesChartStyler)this.ohlcStyler).isYAxisLogarithmic()) {
                yMin = Math.log10(yMin);
                yMax = Math.log10(yMax);
            }
            double[] xData = series.getXData();
            double[] openData = series.getOpenData();
            double[] highData = series.getHighData();
            double[] lowData = series.getLowData();
            double[] closeData = series.getCloseData();
            double candleHalfWidth = Math.max(3.0, xTickSpace / (double)xData.length / 2.0 - (double)((AxesChartStyler)this.ohlcStyler).getAxisTickPadding());
            float lineWidth = Math.max(2.0f, series.getLineStyle().getLineWidth());
            for (int i = 0; i < xData.length; ++i) {
                double closeY;
                double lowY;
                double highY;
                double openY;
                double x = xData[i];
                if (((AxesChartStyler)this.ohlcStyler).isXAxisLogarithmic()) {
                    x = Math.log10(x);
                }
                if (Double.isNaN(closeData[i])) continue;
                double openOrig = openData[i];
                double highOrig = highData[i];
                double lowOrig = lowData[i];
                double closeOrig = closeData[i];
                if (((AxesChartStyler)this.ohlcStyler).isYAxisLogarithmic()) {
                    openY = Math.log10(openOrig);
                    highY = Math.log10(highOrig);
                    lowY = Math.log10(lowOrig);
                    closeY = Math.log10(closeOrig);
                } else {
                    openY = openOrig;
                    highY = highOrig;
                    lowY = lowOrig;
                    closeY = closeOrig;
                }
                double xTransform = xLeftMargin + (x - xMin) / (xMax - xMin) * xTickSpace;
                double openTransform = this.getBounds().getHeight() - (yTopMargin + (openY - yMin) / (yMax - yMin) * yTickSpace);
                double highTransform = this.getBounds().getHeight() - (yTopMargin + (highY - yMin) / (yMax - yMin) * yTickSpace);
                double lowTransform = this.getBounds().getHeight() - (yTopMargin + (lowY - yMin) / (yMax - yMin) * yTickSpace);
                double closeTransform = this.getBounds().getHeight() - (yTopMargin + (closeY - yMin) / (yMax - yMin) * yTickSpace);
                if (Math.abs(xMax - xMin) / 5.0 == 0.0) {
                    xTransform = this.getBounds().getWidth() / 2.0;
                }
                if (Math.abs(yMax - yMin) / 5.0 == 0.0) {
                    openTransform = this.getBounds().getHeight() / 2.0;
                    highTransform = this.getBounds().getHeight() / 2.0;
                    lowTransform = this.getBounds().getHeight() / 2.0;
                    closeTransform = this.getBounds().getHeight() / 2.0;
                }
                double xOffset = this.getBounds().getX() + xTransform;
                double openOffset = this.getBounds().getY() + openTransform;
                double highOffset = this.getBounds().getY() + highTransform;
                double lowOffset = this.getBounds().getY() + lowTransform;
                double closeOffset = this.getBounds().getY() + closeTransform;
                Area toolTipArea = null;
                if (series.getLineStyle() != SeriesLines.NONE && xOffset != -1.7976931348623157E308 && openOffset != -1.7976931348623157E308 && highOffset != -1.7976931348623157E308 && lowOffset != -1.7976931348623157E308 && closeOffset != -1.7976931348623157E308) {
                    g.setColor(series.getLineColor());
                    g.setStroke(series.getLineStyle());
                    line.setLine(xOffset, highOffset, xOffset, lowOffset);
                    g.draw(line);
                    double xStart = xOffset - candleHalfWidth;
                    double xEnd = xOffset + candleHalfWidth;
                    if (toolTipsEnabled) {
                        rect.setRect(xOffset - (double)(lineWidth / 2.0f), highOffset, lineWidth, lowOffset - highOffset);
                        toolTipArea = new Area(rect);
                    }
                    if (series.getOhlcSeriesRenderStyle() == OHLCSeries.OHLCSeriesRenderStyle.Candle) {
                        if (closeOrig > openOrig) {
                            g.setPaint(series.getUpColor());
                        } else {
                            g.setPaint(series.getDownColor());
                        }
                        rect.setRect(xStart, Math.min(openOffset, closeOffset), xEnd - xStart, Math.abs(closeOffset - openOffset));
                        g.fill(rect);
                        if (toolTipsEnabled) {
                            toolTipArea.add(new Area(rect));
                        }
                    } else {
                        line.setLine(xStart, openOffset, xOffset, openOffset);
                        g.draw(line);
                        line.setLine(xOffset, closeOffset, xEnd, closeOffset);
                        g.draw(line);
                        if (toolTipsEnabled) {
                            rect.setRect(xStart, openOffset - (double)(lineWidth / 2.0f), xOffset - xStart, lineWidth);
                            toolTipArea.add(new Area(rect));
                            rect.setRect(xOffset, closeOffset - (double)(lineWidth / 2.0f), xEnd - xOffset, lineWidth);
                            toolTipArea.add(new Area(rect));
                        }
                    }
                }
                if (!toolTipsEnabled) continue;
                if (hasCustomToolTips) {
                    String tt = toolTips[i];
                    if (tt == null) continue;
                    this.chart.toolTips.addData(toolTipArea, xOffset, highOffset, candleHalfWidth * 2.0, tt);
                    continue;
                }
                this.chart.toolTips.addData(toolTipArea, xOffset, highOffset, candleHalfWidth * 2.0, this.chart.getXAxisFormat().format(x), this.chart.getYAxisFormat().format(openOrig) + ':' + this.chart.getYAxisFormat().format(highOrig) + ':' + this.chart.getYAxisFormat().format(lowOrig) + ':' + this.chart.getYAxisFormat().format(closeOrig));
            }
            g.setColor(series.getFillColor());
        }
    }
}

