/*
 * Decompiled with CFR 0.152.
 */
package QuickPALM;

import QuickPALM.MyDialogs;
import QuickPALM.MyFunctions;
import QuickPALM.MyIO;
import QuickPALM.ParticleSaver;
import ij.IJ;
import ij.ImagePlus;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;

public class Load_particles_tableFromImg
implements PlugIn {
    MyDialogs dg = new MyDialogs();
    MyFunctions f = new MyFunctions();
    MyIO io = new MyIO();
    ParticleSaver psaver = new ParticleSaver();
    ImagePlus imp;
    ImageProcessor ip;

    public void run(String arg) {
        this.imp = IJ.openImage();
        this.ip = this.imp.getProcessor();
        this.f.ptable.reset();
        IJ.showStatus((String)"Loading Particles Table...");
        int nParticles = this.ip.getHeight();
        for (int n = 0; n < nParticles; ++n) {
            IJ.showProgress((int)n, (int)nParticles);
            this.f.ptable.incrementCounter();
            this.f.ptable.addValue("Intensity", (double)this.ip.getf(0, n));
            this.f.ptable.addValue("X (px)", (double)this.ip.getf(1, n));
            this.f.ptable.addValue("Y (px)", (double)this.ip.getf(2, n));
            this.f.ptable.addValue("X (nm)", (double)(this.ip.getf(3, n) * 1000.0f));
            this.f.ptable.addValue("Y (nm)", (double)(this.ip.getf(4, n) * 1000.0f));
            this.f.ptable.addValue("Z (nm)", (double)(this.ip.getf(5, n) * 1000.0f));
            this.f.ptable.addValue("Left-StdDev (px)", (double)this.ip.getf(6, n));
            this.f.ptable.addValue("Right-StdDev (px)", (double)this.ip.getf(7, n));
            this.f.ptable.addValue("Up-StdDev (px)", (double)this.ip.getf(8, n));
            this.f.ptable.addValue("Down-StdDev (px)", (double)this.ip.getf(9, n));
            this.f.ptable.addValue("X Symmetry (%)", (double)this.ip.getf(10, n));
            this.f.ptable.addValue("Y Symmetry (%)", (double)this.ip.getf(11, n));
            this.f.ptable.addValue("Width minus Height (px)", (double)this.ip.getf(12, n));
            this.f.ptable.addValue("Frame Number", (double)(this.ip.getf(13, n) * 1000000.0f));
        }
        this.imp.close();
        if (this.f.ptable.getCounter() < 5000000) {
            IJ.showStatus((String)"Creating particle table, this should take a few seconds...");
            this.f.ptable.show("Results");
        } else {
            IJ.showMessage((String)"Warning", (String)"Results table has too many particles, they will not be shown but the data still exists within it\nyou can still use all the plugin functionality or save table changes though the 'Save Particle Table' command.");
        }
    }
}

