/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d;

import org.scijava.java3d.IndexedGeometryStripArray;
import org.scijava.java3d.IndexedTriangleStripArrayRetained;
import org.scijava.java3d.J3dI18N;
import org.scijava.java3d.NodeComponent;

public class IndexedTriangleStripArray
extends IndexedGeometryStripArray {
    IndexedTriangleStripArray() {
    }

    public IndexedTriangleStripArray(int vertexCount, int vertexFormat, int indexCount, int[] stripIndexCounts) {
        super(vertexCount, vertexFormat, indexCount, stripIndexCounts);
        if (vertexCount < 1) {
            throw new IllegalArgumentException(J3dI18N.getString("IndexedTriangleStripArray0"));
        }
        if (indexCount < 3) {
            throw new IllegalArgumentException(J3dI18N.getString("IndexedTriangleStripArray1"));
        }
    }

    public IndexedTriangleStripArray(int vertexCount, int vertexFormat, int texCoordSetCount, int[] texCoordSetMap, int indexCount, int[] stripIndexCounts) {
        super(vertexCount, vertexFormat, texCoordSetCount, texCoordSetMap, indexCount, stripIndexCounts);
        if (vertexCount < 1) {
            throw new IllegalArgumentException(J3dI18N.getString("IndexedTriangleStripArray0"));
        }
        if (indexCount < 3) {
            throw new IllegalArgumentException(J3dI18N.getString("IndexedTriangleStripArray1"));
        }
    }

    public IndexedTriangleStripArray(int vertexCount, int vertexFormat, int texCoordSetCount, int[] texCoordSetMap, int vertexAttrCount, int[] vertexAttrSizes, int indexCount, int[] stripIndexCounts) {
        super(vertexCount, vertexFormat, texCoordSetCount, texCoordSetMap, vertexAttrCount, vertexAttrSizes, indexCount, stripIndexCounts);
        if (vertexCount < 1) {
            throw new IllegalArgumentException(J3dI18N.getString("IndexedTriangleStripArray0"));
        }
        if (indexCount < 3) {
            throw new IllegalArgumentException(J3dI18N.getString("IndexedTriangleStripArray1"));
        }
    }

    @Override
    void createRetained() {
        this.retained = new IndexedTriangleStripArrayRetained();
        this.retained.setSource(this);
    }

    @Override
    public NodeComponent cloneNodeComponent() {
        IndexedTriangleStripArrayRetained rt = (IndexedTriangleStripArrayRetained)this.retained;
        int[] stripIndexCounts = new int[rt.getNumStrips()];
        rt.getStripIndexCounts(stripIndexCounts);
        int texSetCount = rt.getTexCoordSetCount();
        int[] texMap = null;
        int vertexAttrCount = rt.getVertexAttrCount();
        int[] vertexAttrSizes = null;
        if (texSetCount > 0) {
            texMap = new int[rt.getTexCoordSetMapLength()];
            rt.getTexCoordSetMap(texMap);
        }
        if (vertexAttrCount > 0) {
            vertexAttrSizes = new int[vertexAttrCount];
            rt.getVertexAttrSizes(vertexAttrSizes);
        }
        IndexedTriangleStripArray t = new IndexedTriangleStripArray(rt.getVertexCount(), rt.getVertexFormat(), texSetCount, texMap, vertexAttrCount, vertexAttrSizes, rt.getIndexCount(), stripIndexCounts);
        t.duplicateNodeComponent(this);
        return t;
    }
}

