/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d;

import java.util.ArrayList;
import java.util.Vector;
import org.scijava.java3d.BackgroundRetained;
import org.scijava.java3d.BoundingBox;
import org.scijava.java3d.Bounds;
import org.scijava.java3d.BranchGroupRetained;
import org.scijava.java3d.CompileState;
import org.scijava.java3d.GroupRetained;
import org.scijava.java3d.HashKey;
import org.scijava.java3d.IllegalSharingException;
import org.scijava.java3d.J3dI18N;
import org.scijava.java3d.Locale;
import org.scijava.java3d.NnuId;
import org.scijava.java3d.NnuIdManager;
import org.scijava.java3d.Node;
import org.scijava.java3d.SceneGraphObjectRetained;
import org.scijava.java3d.SceneGraphPath;
import org.scijava.java3d.SetLiveState;
import org.scijava.java3d.SharedGroupRetained;
import org.scijava.java3d.Transform3D;
import org.scijava.java3d.TransformGroupRetained;
import org.scijava.java3d.UnorderList;
import org.scijava.java3d.View;
import org.scijava.java3d.VirtualUniverse;

abstract class NodeRetained
extends SceneGraphObjectRetained
implements NnuId {
    static final int BACKGROUND = 1;
    static final int CLIP = 2;
    static final int LINEARFOG = 3;
    static final int EXPONENTIALFOG = 4;
    static final int AMBIENTLIGHT = 5;
    static final int DIRECTIONALLIGHT = 6;
    static final int POINTLIGHT = 7;
    static final int SPOTLIGHT = 8;
    static final int LINK = 9;
    static final int MORPH = 10;
    static final int SHAPE = 11;
    static final int BACKGROUNDSOUND = 12;
    static final int POINTSOUND = 13;
    static final int CONESOUND = 14;
    static final int SOUNDSCAPE = 15;
    static final int VIEWPLATFORM = 16;
    static final int BEHAVIOR = 17;
    static final int SWITCH = 18;
    static final int BRANCHGROUP = 19;
    static final int ORDEREDGROUP = 20;
    static final int DECALGROUP = 21;
    static final int SHAREDGROUP = 22;
    static final int GROUP = 23;
    static final int TRANSFORMGROUP = 24;
    static final int BOUNDINGLEAF = 25;
    static final int MODELCLIP = 26;
    static final int ALTERNATEAPPEARANCE = 27;
    static final int ORIENTEDSHAPE3D = 28;
    static final int VIEWSPECIFICGROUP = 29;
    static final int NUMNODES = 29;
    static final int CONTAINS_VIEWPLATFORM = 1;
    VirtualUniverse universe = null;
    Locale locale = null;
    NodeRetained parent = null;
    String nodeId = null;
    int nodeType;
    int refCount = 0;
    int childIndex = -1;
    boolean inSharedGroup = false;
    boolean pickable = true;
    boolean collidable = true;
    Transform3D[][] localToVworld = null;
    int[][] localToVworldIndex = null;
    static final int LAST_LOCAL_TO_VWORLD = 0;
    static final int CURRENT_LOCAL_TO_VWORLD = 1;
    HashKey[] localToVworldKeys = null;
    boolean boundsAutoCompute = true;
    Bounds localBounds;
    Bounds apiBounds;
    protected Bounds cachedBounds = null;
    protected boolean validCachedBounds = false;
    ArrayList<BranchGroupRetained[]> branchGroupPaths = new ArrayList(1);
    BackgroundRetained geometryBackground = null;
    GroupRetained parentTransformLink = null;
    GroupRetained parentSwitchLink = null;
    TransformGroupRetained staticTransform = null;
    Integer orderedId = null;
    int nnuId = NnuIdManager.getId();

    NodeRetained() {
        this.localBounds = new BoundingBox((Bounds)null);
    }

    @Override
    public int getId() {
        return this.nnuId;
    }

    @Override
    public int equal(NnuId obj) {
        int keyId = obj.getId();
        if (this.nnuId < keyId) {
            return -1;
        }
        if (this.nnuId > keyId) {
            return 1;
        }
        return 0;
    }

    Bounds getLocalBounds(Bounds bounds) {
        return (Bounds)bounds.clone();
    }

    void setBounds(Bounds bounds) {
        this.apiBounds = bounds;
        if (this.source.isLive()) {
            if (!this.boundsAutoCompute) {
                if (bounds != null) {
                    this.localBounds = this.getLocalBounds(bounds);
                    if (this.staticTransform != null) {
                        this.localBounds.transform(this.staticTransform.transform);
                    }
                } else if (this.localBounds != null) {
                    this.localBounds.set(null);
                } else {
                    this.localBounds = new BoundingBox((Bounds)null);
                }
            }
        } else if (bounds != null) {
            this.localBounds = this.getLocalBounds(bounds);
            if (this.staticTransform != null) {
                this.localBounds.transform(this.staticTransform.transform);
            }
        } else if (this.localBounds != null) {
            this.localBounds.set(null);
        } else {
            this.localBounds = new BoundingBox((Bounds)null);
        }
    }

    Bounds getEffectiveBounds() {
        Bounds b = null;
        if (this.localBounds != null && !this.localBounds.isEmpty()) {
            b = (Bounds)this.localBounds.clone();
            if (this.staticTransform != null) {
                Transform3D invTransform = this.staticTransform.getInvTransform();
                b.transform(invTransform);
            }
        }
        return b;
    }

    Bounds getBounds() {
        return this.apiBounds;
    }

    void computeCombineBounds(Bounds bounds) {
    }

    void setBoundsAutoCompute(boolean autoCompute) {
        if (this.boundsAutoCompute == autoCompute) {
            return;
        }
        this.boundsAutoCompute = autoCompute;
        this.dirtyBoundsCache();
    }

    boolean getBoundsAutoCompute() {
        return this.boundsAutoCompute;
    }

    void setParent(NodeRetained parent) {
        this.parent = parent;
    }

    NodeRetained getParent() {
        return this.parent;
    }

    void transformBounds(SceneGraphPath path, Bounds bound) {
        if (!((NodeRetained)path.item.retained).inSharedGroup) {
            bound.transform(this.getCurrentLocalToVworld());
        } else {
            HashKey key = new HashKey("");
            path.getHashKey(key);
            bound.transform(this.getCurrentLocalToVworld(key));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void computeLocalToVworld(NodeRetained caller, NodeRetained nodeR, HashKey key, Transform3D l2Vw) {
        if (nodeR instanceof SharedGroupRetained) {
            String nodeId = key.getLastNodeId();
            SharedGroupRetained sgRetained = (SharedGroupRetained)nodeR;
            for (int i = 0; i < sgRetained.parents.size(); ++i) {
                if (!nodeId.equals(sgRetained.parents.get((int)i).nodeId)) continue;
                this.computeLocalToVworld(caller, sgRetained.parents.get(i), key, l2Vw);
                return;
            }
            throw new RuntimeException(J3dI18N.getString("NodeRetained4"));
        }
        NodeRetained nodeParentR = nodeR.getParent();
        if (nodeParentR == null) {
            if (((BranchGroupRetained)nodeR).locale == null) throw new RuntimeException(J3dI18N.getString("NodeRetained5"));
            l2Vw.setIdentity();
        } else {
            this.computeLocalToVworld(caller, nodeParentR, key, l2Vw);
        }
        if (nodeR instanceof TransformGroupRetained && nodeR != caller) {
            Transform3D t1 = new Transform3D();
            ((TransformGroupRetained)nodeR).transform.getWithLock(t1);
            l2Vw.mul(t1);
            return;
        } else {
            if (nodeR != caller || this.staticTransform == null) return;
            l2Vw.mul(this.staticTransform.transform);
        }
    }

    void computeNonLiveLocalToVworld(Transform3D t, Node caller) {
        NodeRetained n = this.getParent();
        if (n == null) {
            t.setIdentity();
        } else {
            n.computeNonLiveLocalToVworld(t, caller);
        }
        if (this instanceof TransformGroupRetained && this.source != caller) {
            Transform3D trans = new Transform3D();
            ((TransformGroupRetained)this).getTransform(trans);
            t.mul(trans);
        }
    }

    void getLocalToVworld(Transform3D t) {
        if (this.inSharedGroup) {
            throw new IllegalSharingException(J3dI18N.getString("NodeRetained0"));
        }
        if (this.localToVworld == null) {
            t.setIdentity();
        } else {
            this.computeLocalToVworld(this, this, null, t);
        }
    }

    void getLocalToVworld(SceneGraphPath path, Transform3D t) {
        HashKey key = new HashKey("");
        if (!this.inSharedGroup) {
            throw new IllegalSharingException(J3dI18N.getString("NodeRetained1"));
        }
        path.validate(key);
        this.computeLocalToVworld(this, this, key, t);
    }

    void getLocalToVworld(Transform3D t, HashKey key) {
        HashKey newKey = new HashKey(key);
        this.computeLocalToVworld(this, this, newKey, t);
    }

    Locale getLocale() {
        if (this.inSharedGroup) {
            throw new IllegalSharingException(J3dI18N.getString("NodeRetained0"));
        }
        return this.locale;
    }

    Transform3D getCurrentLocalToVworld() {
        if (this.localToVworld != null) {
            return this.localToVworld[0][this.localToVworldIndex[0][1]];
        }
        return new Transform3D();
    }

    Transform3D getCurrentLocalToVworld(int index) {
        return this.localToVworld[index][this.localToVworldIndex[index][1]];
    }

    Transform3D getCurrentLocalToVworld(HashKey key) {
        if (this.localToVworld != null) {
            if (!this.inSharedGroup) {
                return this.localToVworld[0][this.localToVworldIndex[0][1]];
            }
            int i = key.equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
            if (i >= 0) {
                return this.localToVworld[i][this.localToVworldIndex[i][1]];
            }
        }
        return new Transform3D();
    }

    Transform3D getLastLocalToVworld() {
        if (this.localToVworld != null) {
            return this.localToVworld[0][this.localToVworldIndex[0][0]];
        }
        return new Transform3D();
    }

    Transform3D getLastLocalToVworld(int index) {
        return this.localToVworld[index][this.localToVworldIndex[index][0]];
    }

    Transform3D getLastLocalToVworld(HashKey key) {
        if (this.localToVworld != null) {
            if (!this.inSharedGroup) {
                return this.localToVworld[0][this.localToVworldIndex[0][0]];
            }
            int i = key.equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
            if (i >= 0) {
                return this.localToVworld[i][this.localToVworldIndex[i][0]];
            }
        }
        return new Transform3D();
    }

    void setAuxData(SetLiveState s, int index, int hkIndex) {
    }

    void setNodeData(SetLiveState s) {
        this.localToVworld = s.localToVworld;
        this.localToVworldIndex = s.localToVworldIndex;
        this.localToVworldKeys = s.localToVworldKeys;
        this.branchGroupPaths = s.parentBranchGroupPaths;
        this.parentTransformLink = s.parentTransformLink;
        this.parentSwitchLink = s.parentSwitchLink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setPickable(boolean pickable) {
        if (this.pickable == pickable) {
            return;
        }
        this.pickable = pickable;
        if (this.source.isLive()) {
            Object object = this.universe.sceneGraphLock;
            synchronized (object) {
                boolean[] pick = !this.inSharedGroup ? new boolean[1] : new boolean[this.localToVworldKeys.length];
                this.findPickableFlags(pick);
                this.updatePickable(this.localToVworldKeys, pick);
            }
        }
    }

    void updatePickable(HashKey[] pickKeys, boolean[] pick) {
        for (int i = 0; i < pick.length; ++i) {
            if (this.pickable) continue;
            pick[i] = false;
        }
    }

    boolean getPickable() {
        return this.pickable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCollidable(boolean collidable) {
        if (this.collidable == collidable) {
            return;
        }
        this.collidable = collidable;
        if (this.source.isLive()) {
            Object object = this.universe.sceneGraphLock;
            synchronized (object) {
                boolean[] collide = !this.inSharedGroup ? new boolean[1] : new boolean[this.localToVworldKeys.length];
                this.findCollidableFlags(collide);
                this.updateCollidable(this.localToVworldKeys, collide);
            }
        }
    }

    boolean getCollidable() {
        return this.collidable;
    }

    void updateCollidable(HashKey[] keys, boolean[] collide) {
        for (int i = 0; i < collide.length; ++i) {
            if (this.collidable) continue;
            collide[i] = false;
        }
    }

    void notifySceneGraphChanged(boolean globalTraverse) {
    }

    void recombineAbove() {
    }

    synchronized void updateLocalToVworld() {
    }

    @Override
    void setLive(SetLiveState s) {
        int oldrefCount = this.refCount;
        this.doSetLive(s);
        if (oldrefCount <= 0) {
            super.markAsLive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void doSetLive(SetLiveState s) {
        int oldrefCount = this.refCount;
        this.refCount += s.refCount;
        if (this.locale != null && this.universe != s.universe) {
            throw new IllegalSharingException(J3dI18N.getString("NodeRetained3"));
        }
        if (s.locale == null) {
            System.err.println("NodeRetained.setLive() locale is null");
        }
        this.locale = s.locale;
        this.inSharedGroup = s.inSharedGroup;
        if (oldrefCount <= 0) {
            if (this.listIdx == null) {
                this.universe = s.universe;
            } else if (s.universe != this.universe) {
                NodeRetained nodeRetained = this;
                synchronized (nodeRetained) {
                    this.universe = s.universe;
                    this.incIdxUsed();
                }
            }
        }
        ++s.universe.numNodes;
        for (int i = 0; i < s.pickable.length; ++i) {
            if (!this.pickable) {
                s.pickable[i] = false;
            }
            if (this.collidable) continue;
            s.collidable[i] = false;
        }
        if (oldrefCount <= 0) {
            super.doSetLive(s);
        }
        if (this.inBackgroundGroup) {
            this.geometryBackground = s.geometryBackground;
        }
        this.setNodeData(s);
    }

    void removeNodeData(SetLiveState s) {
        if (this.refCount <= 0) {
            this.localToVworld = null;
            this.localToVworldIndex = null;
            this.localToVworldKeys = null;
            this.branchGroupPaths = new ArrayList(1);
            this.parentTransformLink = null;
            this.parentSwitchLink = null;
        } else {
            this.localToVworld = s.localToVworld;
            this.localToVworldIndex = s.localToVworldIndex;
            this.localToVworldKeys = s.localToVworldKeys;
        }
    }

    void clearLive(SetLiveState s) {
        this.refCount -= s.refCount;
        if (this.refCount <= 0) {
            super.clearLive();
            if (this.nodeId != null) {
                this.universe.nodeIdFreeList.addElement(this.nodeId);
                this.nodeId = null;
            }
        }
        --this.universe.numNodes;
        this.removeNodeData(s);
        if (this.refCount <= 0) {
            this.locale = null;
            this.geometryBackground = null;
        }
    }

    void findPickableFlags(boolean[] pick) {
        NodeRetained nodeR = this;
        if (!this.inSharedGroup) {
            pick[0] = true;
            nodeR = nodeR.parent;
            while (nodeR != null) {
                if (!nodeR.pickable) {
                    pick[0] = false;
                    break;
                }
                nodeR = nodeR.parent;
            }
        } else {
            block1: for (int i = 0; i < pick.length; ++i) {
                nodeR = this;
                pick[i] = true;
                HashKey key = new HashKey(this.localToVworldKeys[i]);
                do {
                    if (nodeR instanceof SharedGroupRetained) {
                        String nodeId = key.getLastNodeId();
                        Vector<NodeRetained> parents = ((SharedGroupRetained)nodeR).parents;
                        int sz = parents.size();
                        NodeRetained prevNodeR = nodeR;
                        for (int j = 0; j < sz; ++j) {
                            NodeRetained linkR = parents.get(j);
                            if (!linkR.nodeId.equals(nodeId)) continue;
                            nodeR = linkR;
                            break;
                        }
                        if (prevNodeR == nodeR) {
                            return;
                        }
                    } else {
                        nodeR = nodeR.parent;
                    }
                    if (nodeR == null) continue block1;
                } while (nodeR.pickable);
                pick[i] = false;
            }
        }
    }

    void findCollidableFlags(boolean[] collide) {
        NodeRetained nodeR = this;
        if (!this.inSharedGroup) {
            collide[0] = true;
            nodeR = nodeR.parent;
            while (nodeR != null) {
                if (!nodeR.collidable) {
                    collide[0] = false;
                    break;
                }
                nodeR = nodeR.parent;
            }
        } else {
            block1: for (int i = 0; i < collide.length; ++i) {
                nodeR = this;
                collide[i] = true;
                HashKey key = new HashKey(this.localToVworldKeys[i]);
                do {
                    if (nodeR instanceof SharedGroupRetained) {
                        String nodeId = key.getLastNodeId();
                        Vector<NodeRetained> parents = ((SharedGroupRetained)nodeR).parents;
                        int sz = parents.size();
                        NodeRetained prevNodeR = nodeR;
                        for (int j = 0; j < sz; ++j) {
                            NodeRetained linkR = parents.get(j);
                            if (!linkR.nodeId.equals(nodeId)) continue;
                            nodeR = linkR;
                            break;
                        }
                        if (nodeR == prevNodeR) {
                            return;
                        }
                    } else {
                        nodeR = nodeR.parent;
                    }
                    if (nodeR == null) continue block1;
                } while (nodeR.collidable);
                collide[i] = false;
            }
        }
    }

    void findTransformLevels(int[] transformLevels) {
        NodeRetained nodeR = this;
        if (!this.inSharedGroup) {
            transformLevels[0] = -1;
            while (nodeR != null) {
                if (nodeR.nodeType == 24) {
                    TransformGroupRetained tg = (TransformGroupRetained)nodeR;
                    transformLevels[0] = tg.transformLevels[0];
                    break;
                }
                nodeR = nodeR.parent;
            }
        } else {
            block1: for (int i = 0; i < transformLevels.length; ++i) {
                nodeR = this;
                transformLevels[i] = -1;
                HashKey key = new HashKey(this.localToVworldKeys[i]);
                while (nodeR != null) {
                    int j;
                    if (nodeR instanceof SharedGroupRetained) {
                        String nodeId = key.getLastNodeId();
                        Vector<NodeRetained> parents = ((SharedGroupRetained)nodeR).parents;
                        int sz = parents.size();
                        NodeRetained prevNodeR = nodeR;
                        for (j = 0; j < sz; ++j) {
                            NodeRetained linkR = parents.get(j);
                            if (!linkR.nodeId.equals(nodeId)) continue;
                            nodeR = linkR;
                            break;
                        }
                        if (prevNodeR == nodeR) {
                            return;
                        }
                    } else if (nodeR.nodeType == 24) {
                        TransformGroupRetained tg = (TransformGroupRetained)nodeR;
                        if (tg.inSharedGroup) {
                            j = key.equals(tg.localToVworldKeys, 0, tg.localToVworldKeys.length);
                            transformLevels[i] = tg.transformLevels[j];
                            continue block1;
                        }
                        transformLevels[i] = tg.transformLevels[0];
                        continue block1;
                    }
                    nodeR = nodeR.parent;
                }
            }
        }
    }

    @Override
    boolean isStatic() {
        return !this.source.getCapability(11) && !this.source.getCapability(46) && !this.source.getCapability(1) && !this.source.getCapability(0) && !this.source.getCapability(3) && !this.source.getCapability(4) && !this.source.getCapability(5) && !this.source.getCapability(6) && !this.source.getCapability(7) && !this.source.getCapability(8) && !this.source.getCapability(9) && !this.source.getCapability(10);
    }

    @Override
    void merge(CompileState compState) {
        this.staticTransform = compState.staticTransform;
        if (compState.parentGroup != null) {
            compState.parentGroup.compiledChildrenList.add(this);
        }
        this.parent = compState.parentGroup;
        if (this.staticTransform != null) {
            this.mergeTransform(this.staticTransform);
        }
    }

    @Override
    void mergeTransform(TransformGroupRetained xform) {
        if (this.localBounds != null) {
            this.localBounds.transform(xform.transform);
        }
    }

    int[] processViewSpecificInfo(int mode, HashKey k, View v, ArrayList vsgList, int[] keyList, ArrayList leafList) {
        return keyList;
    }

    @Override
    VirtualUniverse getVirtualUniverse() {
        return this.universe;
    }

    void searchGeometryAtoms(UnorderList list) {
    }

    void dirtyBoundsCache() {
        if (VirtualUniverse.mc.cacheAutoComputedBounds) {
            this.validCachedBounds = false;
            if (this.parent != null) {
                this.parent.dirtyBoundsCache();
            }
        }
    }
}

