/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d;

import org.scijava.java3d.CapabilityNotSetException;
import org.scijava.java3d.J3dI18N;
import org.scijava.java3d.Light;
import org.scijava.java3d.Node;
import org.scijava.java3d.PointLightRetained;
import org.scijava.vecmath.Color3f;
import org.scijava.vecmath.Point3f;

public class PointLight
extends Light {
    public static final int ALLOW_POSITION_READ = 18;
    public static final int ALLOW_POSITION_WRITE = 19;
    public static final int ALLOW_ATTENUATION_READ = 20;
    public static final int ALLOW_ATTENUATION_WRITE = 21;
    private static final int[] readCapabilities = new int[]{18, 20};

    public PointLight() {
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public PointLight(Color3f color, Point3f position, Point3f attenuation) {
        super(color);
        this.setDefaultReadCapabilities(readCapabilities);
        ((PointLightRetained)this.retained).initPosition(position);
        ((PointLightRetained)this.retained).initAttenuation(attenuation);
    }

    public PointLight(boolean lightOn, Color3f color, Point3f position, Point3f attenuation) {
        super(lightOn, color);
        this.setDefaultReadCapabilities(readCapabilities);
        ((PointLightRetained)this.retained).initPosition(position);
        ((PointLightRetained)this.retained).initAttenuation(attenuation);
    }

    @Override
    void createRetained() {
        this.retained = new PointLightRetained();
        this.retained.setSource(this);
    }

    public void setPosition(Point3f position) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("PointLight0"));
        }
        if (this.isLive()) {
            ((PointLightRetained)this.retained).setPosition(position);
        } else {
            ((PointLightRetained)this.retained).initPosition(position);
        }
    }

    public void setPosition(float x, float y, float z) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("PointLight1"));
        }
        if (this.isLive()) {
            ((PointLightRetained)this.retained).setPosition(x, y, z);
        } else {
            ((PointLightRetained)this.retained).initPosition(x, y, z);
        }
    }

    public void getPosition(Point3f position) {
        if (this.isLiveOrCompiled() && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("PointLight2"));
        }
        ((PointLightRetained)this.retained).getPosition(position);
    }

    public void setAttenuation(Point3f attenuation) {
        if (this.isLiveOrCompiled() && !this.getCapability(21)) {
            throw new CapabilityNotSetException(J3dI18N.getString("PointLight3"));
        }
        if (this.isLive()) {
            ((PointLightRetained)this.retained).setAttenuation(attenuation);
        } else {
            ((PointLightRetained)this.retained).initAttenuation(attenuation);
        }
    }

    public void setAttenuation(float constant, float linear, float quadratic) {
        if (this.isLiveOrCompiled() && !this.getCapability(21)) {
            throw new CapabilityNotSetException(J3dI18N.getString("PointLight3"));
        }
        if (this.isLive()) {
            ((PointLightRetained)this.retained).setAttenuation(constant, linear, quadratic);
        } else {
            ((PointLightRetained)this.retained).initAttenuation(constant, linear, quadratic);
        }
    }

    public void getAttenuation(Point3f attenuation) {
        if (this.isLiveOrCompiled() && !this.getCapability(20)) {
            throw new CapabilityNotSetException(J3dI18N.getString("PointLight5"));
        }
        ((PointLightRetained)this.retained).getAttenuation(attenuation);
    }

    @Override
    public Node cloneNode(boolean forceDuplicate) {
        PointLight p = new PointLight();
        p.duplicateNode(this, forceDuplicate);
        return p;
    }

    @Override
    void duplicateAttributes(Node originalNode, boolean forceDuplicate) {
        super.duplicateAttributes(originalNode, forceDuplicate);
        PointLightRetained attr = (PointLightRetained)originalNode.retained;
        PointLightRetained rt = (PointLightRetained)this.retained;
        Point3f p = new Point3f();
        attr.getPosition(p);
        rt.initPosition(p);
        attr.getAttenuation(p);
        rt.initAttenuation(p);
    }
}

