/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d;

import java.util.Hashtable;
import org.scijava.java3d.CapabilityNotSetException;
import org.scijava.java3d.ImageComponent;
import org.scijava.java3d.J3dI18N;
import org.scijava.java3d.NodeComponent;
import org.scijava.java3d.TextureRetained;
import org.scijava.vecmath.Color4f;
import org.scijava.vecmath.Point2f;
import org.scijava.vecmath.Point3f;
import org.scijava.vecmath.Tuple3f;

public abstract class Texture
extends NodeComponent {
    public static final int ALLOW_ENABLE_READ = 0;
    public static final int ALLOW_ENABLE_WRITE = 1;
    public static final int ALLOW_BOUNDARY_MODE_READ = 2;
    public static final int ALLOW_FILTER_READ = 3;
    public static final int ALLOW_IMAGE_READ = 4;
    public static final int ALLOW_IMAGE_WRITE = 7;
    public static final int ALLOW_FORMAT_READ = 9;
    public static final int ALLOW_SIZE_READ = 8;
    public static final int ALLOW_MIPMAP_MODE_READ = 5;
    public static final int ALLOW_BOUNDARY_COLOR_READ = 6;
    public static final int ALLOW_LOD_RANGE_READ = 10;
    public static final int ALLOW_LOD_RANGE_WRITE = 11;
    public static final int ALLOW_ANISOTROPIC_FILTER_READ = 12;
    public static final int ALLOW_SHARPEN_TEXTURE_READ = 13;
    public static final int ALLOW_FILTER4_READ = 14;
    public static final int FASTEST = 0;
    public static final int NICEST = 1;
    public static final int BASE_LEVEL_POINT = 2;
    public static final int BASE_LEVEL_LINEAR = 3;
    public static final int MULTI_LEVEL_POINT = 4;
    public static final int MULTI_LEVEL_LINEAR = 5;
    public static final int LINEAR_SHARPEN = 9;
    public static final int LINEAR_SHARPEN_RGB = 10;
    public static final int LINEAR_SHARPEN_ALPHA = 11;
    public static final int FILTER4 = 12;
    public static final int CLAMP = 2;
    public static final int WRAP = 3;
    public static final int CLAMP_TO_EDGE = 4;
    public static final int CLAMP_TO_BOUNDARY = 5;
    public static final int BASE_LEVEL = 1;
    public static final int MULTI_LEVEL_MIPMAP = 2;
    public static final int INTENSITY = 1;
    public static final int LUMINANCE = 2;
    public static final int ALPHA = 3;
    public static final int LUMINANCE_ALPHA = 4;
    public static final int RGB = 5;
    public static final int RGBA = 6;
    public static final int ANISOTROPIC_NONE = 0;
    public static final int ANISOTROPIC_SINGLE_VALUE = 1;
    private static final int[] readCapabilities = new int[]{12, 6, 2, 0, 14, 3, 9, 4, 10, 5, 13, 8};

    public Texture() {
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public Texture(int mipMapMode, int format, int width, int height) {
        this.setDefaultReadCapabilities(readCapabilities);
        if (mipMapMode != 1 && mipMapMode != 2) {
            throw new IllegalArgumentException(J3dI18N.getString("Texture0"));
        }
        if (format != 1 && format != 2 && format != 3 && format != 4 && format != 5 && format != 6) {
            throw new IllegalArgumentException(J3dI18N.getString("Texture1"));
        }
        if (width < 1) {
            throw new IllegalArgumentException(J3dI18N.getString("Texture46"));
        }
        if (height < 1) {
            throw new IllegalArgumentException(J3dI18N.getString("Texture47"));
        }
        int widthLevels = Texture.getLevelsNPOT(width);
        int heightLevels = Texture.getLevelsNPOT(height);
        ((TextureRetained)this.retained).initialize(format, width, widthLevels, height, heightLevels, mipMapMode, 0);
    }

    public Texture(int mipMapMode, int format, int width, int height, int boundaryWidth) {
        this.setDefaultReadCapabilities(readCapabilities);
        if (mipMapMode != 1 && mipMapMode != 2) {
            throw new IllegalArgumentException(J3dI18N.getString("Texture0"));
        }
        if (format != 1 && format != 2 && format != 3 && format != 4 && format != 5 && format != 6) {
            throw new IllegalArgumentException(J3dI18N.getString("Texture1"));
        }
        if (width < 1) {
            throw new IllegalArgumentException(J3dI18N.getString("Texture46"));
        }
        if (height < 1) {
            throw new IllegalArgumentException(J3dI18N.getString("Texture47"));
        }
        int widthLevels = Texture.getLevelsNPOT(width);
        int heightLevels = Texture.getLevelsNPOT(height);
        if (boundaryWidth < 0 || boundaryWidth > 1) {
            throw new IllegalArgumentException(J3dI18N.getString("Texture30"));
        }
        ((TextureRetained)this.retained).initialize(format, width, widthLevels, height, heightLevels, mipMapMode, boundaryWidth);
    }

    public void setBoundaryModeS(int boundaryModeS) {
        this.checkForLiveOrCompiled();
        switch (boundaryModeS) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                throw new IllegalArgumentException(J3dI18N.getString("Texture31"));
            }
        }
        ((TextureRetained)this.retained).initBoundaryModeS(boundaryModeS);
    }

    public int getBoundaryModeS() {
        if (this.isLiveOrCompiled() && !this.getCapability(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture4"));
        }
        return ((TextureRetained)this.retained).getBoundaryModeS();
    }

    public void setBoundaryModeT(int boundaryModeT) {
        this.checkForLiveOrCompiled();
        switch (boundaryModeT) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                throw new IllegalArgumentException(J3dI18N.getString("Texture31"));
            }
        }
        ((TextureRetained)this.retained).initBoundaryModeT(boundaryModeT);
    }

    public int getBoundaryModeT() {
        if (this.isLiveOrCompiled() && !this.getCapability(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture4"));
        }
        return ((TextureRetained)this.retained).getBoundaryModeT();
    }

    public void setMinFilter(int minFilter) {
        this.checkForLiveOrCompiled();
        switch (minFilter) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 12: {
                break;
            }
            default: {
                throw new IllegalArgumentException(J3dI18N.getString("Texture28"));
            }
        }
        ((TextureRetained)this.retained).initMinFilter(minFilter);
    }

    public int getMinFilter() {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture6"));
        }
        return ((TextureRetained)this.retained).getMinFilter();
    }

    public void setMagFilter(int magFilter) {
        this.checkForLiveOrCompiled();
        switch (magFilter) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            default: {
                throw new IllegalArgumentException(J3dI18N.getString("Texture29"));
            }
        }
        ((TextureRetained)this.retained).initMagFilter(magFilter);
    }

    public int getMagFilter() {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture6"));
        }
        return ((TextureRetained)this.retained).getMagFilter();
    }

    public void setImage(int level, ImageComponent image) {
        if (this.isLiveOrCompiled() && !this.getCapability(7)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture15"));
        }
        this.validateImageIllegalSharing(image);
        if (this.isLive()) {
            ((TextureRetained)this.retained).setImage(level, image);
        } else {
            ((TextureRetained)this.retained).initImage(level, image);
        }
    }

    public ImageComponent getImage(int level) {
        if (this.isLiveOrCompiled() && !this.getCapability(4)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture9"));
        }
        return ((TextureRetained)this.retained).getImage(level);
    }

    public void setImages(ImageComponent[] images) {
        if (this.isLiveOrCompiled() && !this.getCapability(7)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture15"));
        }
        for (int i = 0; i < images.length; ++i) {
            this.validateImageIllegalSharing(images[i]);
        }
        if (images == null) {
            throw new IllegalArgumentException(J3dI18N.getString("Texture20"));
        }
        if (this.isLive()) {
            ((TextureRetained)this.retained).setImages(images);
        } else {
            ((TextureRetained)this.retained).initImages(images);
        }
    }

    public ImageComponent[] getImages() {
        if (this.isLiveOrCompiled() && !this.getCapability(4)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture9"));
        }
        return ((TextureRetained)this.retained).getImages();
    }

    public int getFormat() {
        if (this.isLiveOrCompiled() && !this.getCapability(9)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture19"));
        }
        return ((TextureRetained)this.retained).getFormat();
    }

    public int getWidth() {
        if (this.isLiveOrCompiled() && !this.getCapability(8)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture16"));
        }
        return ((TextureRetained)this.retained).getWidth();
    }

    public int getHeight() {
        if (this.isLiveOrCompiled() && !this.getCapability(8)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture17"));
        }
        return ((TextureRetained)this.retained).getHeight();
    }

    public int getBoundaryWidth() {
        if (this.isLiveOrCompiled() && !this.getCapability(8)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture17"));
        }
        return ((TextureRetained)this.retained).getBoundaryWidth();
    }

    public int numMipMapLevels() {
        if (this.isLiveOrCompiled() && !this.getCapability(8)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture18"));
        }
        return ((TextureRetained)this.retained).numMipMapLevels();
    }

    public void setMipMapMode(int mipMapMode) {
        this.checkForLiveOrCompiled();
        ((TextureRetained)this.retained).initMipMapMode(mipMapMode);
    }

    public int getMipMapMode() {
        if (this.isLiveOrCompiled() && !this.getCapability(5)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture10"));
        }
        return ((TextureRetained)this.retained).getMipMapMode();
    }

    public void setEnable(boolean state) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture11"));
        }
        if (this.isLive()) {
            ((TextureRetained)this.retained).setEnable(state);
        } else {
            ((TextureRetained)this.retained).initEnable(state);
        }
    }

    public boolean getEnable() {
        if (this.isLiveOrCompiled() && !this.getCapability(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture12"));
        }
        return ((TextureRetained)this.retained).getEnable();
    }

    static int getPowerOf2(int num) {
        if (num < 1) {
            return -1;
        }
        int tmp = num;
        for (int i = 0; i < 32; ++i) {
            if ((tmp & Integer.MIN_VALUE) != 0) {
                if ((tmp & Integer.MAX_VALUE) == 0) {
                    return 31 - i;
                }
                return -1;
            }
            tmp <<= 1;
        }
        return -1;
    }

    static int getLevelsNPOT(int num) {
        int levels = 0;
        int tmp = num;
        while (tmp > 1) {
            tmp /= 2;
            ++levels;
        }
        return levels;
    }

    public void setBoundaryColor(Color4f boundaryColor) {
        this.checkForLiveOrCompiled();
        ((TextureRetained)this.retained).initBoundaryColor(boundaryColor);
    }

    public void setBoundaryColor(float r, float g, float b, float a) {
        this.checkForLiveOrCompiled();
        ((TextureRetained)this.retained).initBoundaryColor(r, g, b, a);
    }

    public void getBoundaryColor(Color4f boundaryColor) {
        if (this.isLiveOrCompiled() && !this.getCapability(6)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture13"));
        }
        ((TextureRetained)this.retained).getBoundaryColor(boundaryColor);
    }

    public void setBaseLevel(int baseLevel) {
        if (this.isLiveOrCompiled() && !this.getCapability(11)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture32"));
        }
        if (this.isLive()) {
            ((TextureRetained)this.retained).setBaseLevel(baseLevel);
        } else {
            ((TextureRetained)this.retained).initBaseLevel(baseLevel);
        }
    }

    public int getBaseLevel() {
        if (this.isLiveOrCompiled() && !this.getCapability(10)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture34"));
        }
        return ((TextureRetained)this.retained).getBaseLevel();
    }

    public void setMaximumLevel(int maximumLevel) {
        if (this.isLiveOrCompiled() && !this.getCapability(11)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture33"));
        }
        if (this.isLive()) {
            ((TextureRetained)this.retained).setMaximumLevel(maximumLevel);
        } else {
            ((TextureRetained)this.retained).initMaximumLevel(maximumLevel);
        }
    }

    public int getMaximumLevel() {
        if (this.isLiveOrCompiled() && !this.getCapability(10)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture35"));
        }
        return ((TextureRetained)this.retained).getMaximumLevel();
    }

    public void setMinimumLOD(float minimumLod) {
        if (this.isLiveOrCompiled() && !this.getCapability(11)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture38"));
        }
        if (this.isLive()) {
            ((TextureRetained)this.retained).setMinimumLOD(minimumLod);
        } else {
            ((TextureRetained)this.retained).initMinimumLOD(minimumLod);
        }
    }

    public float getMinimumLOD() {
        if (this.isLiveOrCompiled() && !this.getCapability(10)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture40"));
        }
        return ((TextureRetained)this.retained).getMinimumLOD();
    }

    public void setMaximumLOD(float maximumLod) {
        if (this.isLiveOrCompiled() && !this.getCapability(11)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture39"));
        }
        if (this.isLive()) {
            ((TextureRetained)this.retained).setMaximumLOD(maximumLod);
        } else {
            ((TextureRetained)this.retained).initMaximumLOD(maximumLod);
        }
    }

    public float getMaximumLOD() {
        if (this.isLiveOrCompiled() && !this.getCapability(10)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture41"));
        }
        return ((TextureRetained)this.retained).getMaximumLOD();
    }

    public void setLodOffset(float s, float t, float r) {
        if (this.isLiveOrCompiled() && !this.getCapability(11)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture44"));
        }
        if (this.isLive()) {
            ((TextureRetained)this.retained).setLodOffset(s, t, r);
        } else {
            ((TextureRetained)this.retained).initLodOffset(s, t, r);
        }
    }

    public void setLodOffset(Tuple3f offset) {
        if (this.isLiveOrCompiled() && !this.getCapability(11)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture44"));
        }
        if (this.isLive()) {
            ((TextureRetained)this.retained).setLodOffset(offset.x, offset.y, offset.z);
        } else {
            ((TextureRetained)this.retained).initLodOffset(offset.x, offset.y, offset.z);
        }
    }

    public void getLodOffset(Tuple3f offset) {
        if (this.isLiveOrCompiled() && !this.getCapability(10)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture45"));
        }
        ((TextureRetained)this.retained).getLodOffset(offset);
    }

    public void setAnisotropicFilterMode(int mode) {
        this.checkForLiveOrCompiled();
        if (mode != 0 && mode != 1) {
            throw new IllegalArgumentException(J3dI18N.getString("Texture25"));
        }
        ((TextureRetained)this.retained).initAnisotropicFilterMode(mode);
    }

    public int getAnisotropicFilterMode() {
        if (this.isLiveOrCompiled() && !this.getCapability(12)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture26"));
        }
        return ((TextureRetained)this.retained).getAnisotropicFilterMode();
    }

    public void setAnisotropicFilterDegree(float degree) {
        this.checkForLiveOrCompiled();
        if ((double)degree < 1.0) {
            throw new IllegalArgumentException(J3dI18N.getString("Texture27"));
        }
        ((TextureRetained)this.retained).initAnisotropicFilterDegree(degree);
    }

    public float getAnisotropicFilterDegree() {
        if (this.isLiveOrCompiled() && !this.getCapability(12)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture26"));
        }
        return ((TextureRetained)this.retained).getAnisotropicFilterDegree();
    }

    public void setSharpenTextureFunc(float[] lod, float[] pts) {
        this.checkForLiveOrCompiled();
        if (!(lod != null && pts != null && lod.length == pts.length || lod == null && pts == null)) {
            throw new IllegalStateException(J3dI18N.getString("Texture22"));
        }
        ((TextureRetained)this.retained).initSharpenTextureFunc(lod, pts);
    }

    public void setSharpenTextureFunc(Point2f[] pts) {
        this.checkForLiveOrCompiled();
        ((TextureRetained)this.retained).initSharpenTextureFunc(pts);
    }

    public int getSharpenTextureFuncPointsCount() {
        if (this.isLiveOrCompiled() && !this.getCapability(13)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture21"));
        }
        return ((TextureRetained)this.retained).getSharpenTextureFuncPointsCount();
    }

    public void getSharpenTextureFunc(float[] lod, float[] pts) {
        if (this.isLiveOrCompiled() && !this.getCapability(13)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture21"));
        }
        ((TextureRetained)this.retained).getSharpenTextureFunc(lod, pts);
    }

    public void getSharpenTextureFunc(Point2f[] pts) {
        if (this.isLiveOrCompiled() && !this.getCapability(13)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture21"));
        }
        ((TextureRetained)this.retained).getSharpenTextureFunc(pts);
    }

    public void setFilter4Func(float[] weights) {
        this.checkForLiveOrCompiled();
        if (weights == null || weights.length < 4) {
            throw new IllegalArgumentException(J3dI18N.getString("Texture24"));
        }
        ((TextureRetained)this.retained).initFilter4Func(weights);
    }

    public int getFilter4FuncPointsCount() {
        if (this.isLiveOrCompiled() && !this.getCapability(14)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture23"));
        }
        return ((TextureRetained)this.retained).getFilter4FuncPointsCount();
    }

    public void getFilter4Func(float[] weights) {
        if (this.isLiveOrCompiled() && !this.getCapability(14)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture23"));
        }
        ((TextureRetained)this.retained).getFilter4Func(weights);
    }

    @Override
    void duplicateAttributes(NodeComponent originalNodeComponent, boolean forceDuplicate) {
        super.duplicateAttributes(originalNodeComponent, forceDuplicate);
        Hashtable hashtable = originalNodeComponent.nodeHashtable;
        TextureRetained tex = (TextureRetained)originalNodeComponent.retained;
        TextureRetained rt = (TextureRetained)this.retained;
        rt.initBoundaryModeS(tex.getBoundaryModeS());
        rt.initBoundaryModeT(tex.getBoundaryModeT());
        rt.initMinFilter(tex.getMinFilter());
        rt.initMagFilter(tex.getMagFilter());
        rt.initMipMapMode(tex.getMipMapMode());
        rt.initEnable(tex.getEnable());
        rt.initAnisotropicFilterMode(tex.getAnisotropicFilterMode());
        rt.initAnisotropicFilterDegree(tex.getAnisotropicFilterDegree());
        rt.initSharpenTextureFunc(tex.getSharpenTextureFunc());
        rt.initFilter4Func(tex.getFilter4Func());
        rt.initBaseLevel(tex.getBaseLevel());
        rt.initMaximumLevel(tex.getMaximumLevel());
        rt.initMinimumLOD(tex.getMinimumLOD());
        rt.initMaximumLOD(tex.getMaximumLOD());
        Point3f offset = new Point3f();
        tex.getLodOffset((Tuple3f)offset);
        rt.initLodOffset(offset.x, offset.y, offset.z);
        Color4f c = new Color4f();
        tex.getBoundaryColor(c);
        rt.initBoundaryColor(c);
        for (int i = tex.maxLevels - 1; i >= 0; --i) {
            ImageComponent image = (ImageComponent)this.getNodeComponent(tex.getImage(i), forceDuplicate, hashtable);
            if (image == null) continue;
            rt.initImage(i, image);
        }
    }

    @Override
    boolean duplicateChild() {
        if (this.getDuplicateOnCloneTree()) {
            return true;
        }
        int level = ((TextureRetained)this.retained).maxLevels;
        TextureRetained rt = (TextureRetained)this.retained;
        for (int i = 0; i < level; ++i) {
            ImageComponent img = rt.getImage(i);
            if (img == null || !img.getDuplicateOnCloneTree()) continue;
            return true;
        }
        return false;
    }
}

