/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d;

import java.util.ArrayList;
import org.scijava.java3d.BadTransformException;
import org.scijava.java3d.BoundingBox;
import org.scijava.java3d.BoundingSphere;
import org.scijava.java3d.Bounds;
import org.scijava.java3d.CachedTargets;
import org.scijava.java3d.CompileState;
import org.scijava.java3d.GroupRetained;
import org.scijava.java3d.HashKey;
import org.scijava.java3d.J3dDebug;
import org.scijava.java3d.J3dI18N;
import org.scijava.java3d.J3dMessage;
import org.scijava.java3d.LinkRetained;
import org.scijava.java3d.MasterControl;
import org.scijava.java3d.NodeRetained;
import org.scijava.java3d.SceneGraphPath;
import org.scijava.java3d.SetLiveState;
import org.scijava.java3d.SharedGroupRetained;
import org.scijava.java3d.SwitchState;
import org.scijava.java3d.Targets;
import org.scijava.java3d.TargetsInterface;
import org.scijava.java3d.Transform3D;
import org.scijava.java3d.TransformGroupData;
import org.scijava.java3d.UpdateTargets;
import org.scijava.java3d.VirtualUniverse;
import org.scijava.java3d.WakeupIndexedList;
import org.scijava.java3d.WakeupOnTransformChange;

class TransformGroupRetained
extends GroupRetained
implements TargetsInterface {
    Transform3D transform = new Transform3D();
    Transform3D invTransform = null;
    Transform3D normalTransform = null;
    Transform3D currentTransform = new Transform3D();
    Transform3D[][] childLocalToVworld = null;
    int[][] childLocalToVworldIndex = null;
    Transform3D[][] childTrans = null;
    int[][] childTransIndex = null;
    int localTargetThreads = 0;
    int targetThreads = 0;
    WakeupIndexedList transformChange = null;
    ArrayList<NodeRetained> childTransformLinks = new ArrayList(1);
    boolean needNormalsTransform = false;
    HashKey currentKey = new HashKey();
    boolean aboveAViewPlatform = false;
    int maxTransformLevel = -1;
    int[] transformLevels = null;
    CachedTargets[] j3dCTs = null;
    CachedTargets[] cachedTargets = null;
    TransformGroupData[] perPathData = null;

    TransformGroupRetained() {
        this.nodeType = 24;
    }

    void setTransform(Transform3D t1) {
        J3dMessage tchangeMessage = null;
        Transform3D trans = null;
        if (this.staticTransform != null) {
            trans = new Transform3D(this.staticTransform.transform);
            trans.mul(t1);
            this.transform.setWithLock(trans);
        } else {
            trans = new Transform3D(t1);
            this.transform.setWithLock(t1);
        }
        if (this.transformChange != null) {
            this.notifyConditions();
        }
        if (this.source.isLive()) {
            if (this.aboveAViewPlatform && !t1.isCongruent()) {
                throw new BadTransformException(J3dI18N.getString("ViewPlatformRetained0"));
            }
            tchangeMessage = new J3dMessage();
            tchangeMessage.type = 3;
            tchangeMessage.threads = this.targetThreads;
            tchangeMessage.args[1] = this;
            tchangeMessage.args[2] = trans;
            tchangeMessage.universe = this.universe;
            VirtualUniverse.mc.processMessage(tchangeMessage);
        }
        this.dirtyBoundsCache();
    }

    void getTransform(Transform3D t1) {
        this.transform.getWithLock(t1);
        if (this.staticTransform != null) {
            Transform3D invTransform = this.staticTransform.getInvTransform();
            t1.mul(invTransform, t1);
        }
    }

    Transform3D getInvTransform() {
        if (this.invTransform == null) {
            this.invTransform = new Transform3D(this.transform);
            this.invTransform.invert();
        }
        return this.invTransform;
    }

    Transform3D getNormalTransform() {
        if (this.normalTransform == null) {
            this.normalTransform = new Transform3D(this.transform);
            this.normalTransform.invert();
            this.normalTransform.transpose();
        }
        return this.normalTransform;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    synchronized void setNodeData(SetLiveState s) {
        int i;
        super.setNodeData(s);
        this.childTrans = new Transform3D[s.currentTransforms.length][2];
        this.childTransIndex = new int[s.currentTransforms.length][2];
        for (i = 0; i < s.currentTransforms.length; ++i) {
            this.childTrans[i][0] = new Transform3D();
            this.childTrans[i][0].mul(s.currentTransforms[i][s.currentTransformsIndex[i][1]], this.currentTransform);
            this.childTrans[i][1] = new Transform3D(this.childTrans[i][0]);
            this.childTransIndex[i][0] = 0;
            this.childTransIndex[i][1] = 0;
        }
        if (!s.inSharedGroup) {
            s.transformLevels[0] = s.transformLevels[0] + 1;
            this.maxTransformLevel = s.transformLevels[0];
        } else {
            for (i = 0; i < s.keys.length; ++i) {
                int n = i;
                s.transformLevels[n] = s.transformLevels[n] + 1;
                if (s.transformLevels[i] <= this.maxTransformLevel) continue;
                this.maxTransformLevel = s.transformLevels[i];
            }
        }
        if (!this.inSharedGroup) {
            if (this.childLocalToVworld == null) {
                this.childLocalToVworld = new Transform3D[1][];
                this.childLocalToVworldIndex = new int[1][];
                this.transformLevels = new int[1];
                this.cachedTargets = new CachedTargets[1];
                this.perPathData = new TransformGroupData[1];
            }
            this.childLocalToVworld[0] = this.childTrans[0];
            this.childLocalToVworldIndex[0] = this.childTransIndex[0];
            this.transformLevels[0] = s.transformLevels[0];
            this.setAuxData(s, 0, 0);
        } else {
            int len;
            if (this.childLocalToVworld == null) {
                this.childLocalToVworld = new Transform3D[s.keys.length][];
                this.childLocalToVworldIndex = new int[s.keys.length][];
                this.transformLevels = new int[s.keys.length];
                this.cachedTargets = new CachedTargets[s.keys.length];
                this.perPathData = new TransformGroupData[s.keys.length];
                len = 0;
            } else {
                len = this.localToVworld.length - s.keys.length;
                int newLen = this.localToVworld.length;
                Transform3D[][] newChildTList = new Transform3D[newLen][];
                int[][] newChildIndexList = new int[newLen][];
                int[] newTransformLevels = new int[newLen];
                CachedTargets[] newTargets = new CachedTargets[newLen];
                TransformGroupData[] newPerPathData = new TransformGroupData[newLen];
                System.arraycopy(this.childLocalToVworld, 0, newChildTList, 0, this.childLocalToVworld.length);
                System.arraycopy(this.childLocalToVworldIndex, 0, newChildIndexList, 0, this.childLocalToVworldIndex.length);
                System.arraycopy(this.transformLevels, 0, newTransformLevels, 0, this.transformLevels.length);
                System.arraycopy(this.cachedTargets, 0, newTargets, 0, this.cachedTargets.length);
                System.arraycopy(this.perPathData, 0, newPerPathData, 0, this.perPathData.length);
                this.childLocalToVworld = newChildTList;
                this.childLocalToVworldIndex = newChildIndexList;
                this.transformLevels = newTransformLevels;
                this.cachedTargets = newTargets;
                this.perPathData = newPerPathData;
            }
            i = len;
            int j = 0;
            while (i < this.localToVworld.length) {
                int hkIndex = s.keys[j].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                if (hkIndex < 0) {
                    MasterControl.getCoreLogger().severe("Can't Find matching hashKey in setNodeData.");
                    break;
                }
                if (hkIndex >= i) {
                    this.childLocalToVworld[i] = this.childTrans[j];
                    this.childLocalToVworldIndex[i] = this.childTransIndex[j];
                    this.transformLevels[i] = s.transformLevels[j];
                } else {
                    int hkIndexPlus1 = hkIndex + 1;
                    int blkSize = i - hkIndex;
                    System.arraycopy(this.childLocalToVworld, hkIndex, this.childLocalToVworld, hkIndexPlus1, blkSize);
                    System.arraycopy(this.childLocalToVworldIndex, hkIndex, this.childLocalToVworldIndex, hkIndexPlus1, blkSize);
                    System.arraycopy(this.transformLevels, hkIndex, this.transformLevels, hkIndexPlus1, blkSize);
                    System.arraycopy(this.cachedTargets, hkIndex, this.cachedTargets, hkIndexPlus1, blkSize);
                    System.arraycopy(this.perPathData, hkIndex, this.perPathData, hkIndexPlus1, blkSize);
                    this.childLocalToVworld[hkIndex] = this.childTrans[j];
                    this.childLocalToVworldIndex[hkIndex] = this.childTransIndex[j];
                    this.transformLevels[hkIndex] = s.transformLevels[j];
                }
                this.setAuxData(s, j, hkIndex);
                ++i;
                ++j;
            }
        }
        if (s.childTransformLinks != null) {
            ArrayList<NodeRetained> arrayList = s.childTransformLinks;
            synchronized (arrayList) {
                if (!this.inSharedGroup || !s.childTransformLinks.contains(this)) {
                    s.childTransformLinks.add(this);
                }
            }
        }
        s.localToVworld = this.childLocalToVworld;
        s.localToVworldIndex = this.childLocalToVworldIndex;
        s.currentTransforms = this.childTrans;
        s.currentTransformsIndex = this.childTransIndex;
        s.childTransformLinks = this.childTransformLinks;
        s.parentTransformLink = this;
    }

    @Override
    void setAuxData(SetLiveState s, int index, int hkIndex) {
        super.setAuxData(s, index, hkIndex);
        this.perPathData[hkIndex] = new TransformGroupData();
        this.perPathData[hkIndex].switchState = s.switchStates.get(hkIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeCondition(WakeupOnTransformChange wakeup) {
        WakeupIndexedList wakeupIndexedList = this.transformChange;
        synchronized (wakeupIndexedList) {
            this.transformChange.remove(wakeup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addCondition(WakeupOnTransformChange wakeup) {
        WakeupIndexedList wakeupIndexedList = this.transformChange;
        synchronized (wakeupIndexedList) {
            this.transformChange.add(wakeup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyConditions() {
        WakeupIndexedList wakeupIndexedList = this.transformChange;
        synchronized (wakeupIndexedList) {
            WakeupOnTransformChange[] list = (WakeupOnTransformChange[])this.transformChange.toArray(false);
            for (int i = this.transformChange.size() - 1; i >= 0; --i) {
                list[i].setTriggered();
            }
        }
    }

    @Override
    boolean isStatic() {
        return super.isStatic() && !this.source.getCapability(17) && !this.source.getCapability(18);
    }

    @Override
    void mergeTransform(TransformGroupRetained xform) {
        super.mergeTransform(xform);
        this.transform.mul(xform.transform, this.transform);
    }

    @Override
    void traverse(boolean sameLevel, int level) {
        System.err.println();
        for (int i = 0; i < level; ++i) {
            System.err.print(".");
        }
        System.err.print(this);
        if (this.isStatic()) {
            System.err.print(" (s)");
        } else {
            System.err.print(" (w)");
        }
        System.err.println();
        System.err.println(this.transform.toString());
        super.traverse(true, level);
    }

    @Override
    void compile(CompileState compState) {
        boolean saveKeepTG = compState.keepTG;
        compState.keepTG = false;
        boolean saveNeedNormalsTransform = compState.needNormalsTransform;
        compState.needNormalsTransform = false;
        super.compile(compState);
        if (compState.keepTG) {
            this.mergeFlag = 0;
        }
        if (J3dDebug.debug) {
            ++compState.numTransformGroups;
            if (this.isStatic()) {
                ++compState.numStaticTransformGroups;
            }
            if (this.mergeFlag == 1) {
                ++compState.numMergedTransformGroups;
            }
        }
        if (this.mergeFlag == 0) {
            compState.staticTransform = null;
            compState.parentGroup = null;
            super.merge(compState);
        } else {
            this.mergeFlag = 1;
        }
        compState.keepTG = saveKeepTG;
        this.needNormalsTransform = compState.needNormalsTransform;
        compState.needNormalsTransform = saveNeedNormalsTransform;
    }

    @Override
    void merge(CompileState compState) {
        Transform3D normalXform;
        if (compState.staticTransform != null) {
            this.staticTransform = compState.staticTransform;
            this.mergeTransform(compState.staticTransform);
        }
        if (this.mergeFlag == 1 && this.needNormalsTransform && !(normalXform = this.getNormalTransform()).isCongruent()) {
            this.mergeFlag = 0;
        }
        if (this.mergeFlag == 1) {
            TransformGroupRetained saveStaticTransform = compState.staticTransform;
            compState.staticTransform = this;
            super.merge(compState);
            compState.staticTransform = saveStaticTransform;
        } else {
            compState.parentGroup.compiledChildrenList.add(this);
            this.parent = compState.parentGroup;
        }
        this.mergeFlag = 2;
    }

    @Override
    void setLive(SetLiveState s) {
        int i;
        Transform3D trans = null;
        Targets[] newTargets = null;
        Targets[] savedTransformTargets = null;
        int oldTraverseFlags = 0;
        oldTraverseFlags = s.traverseFlags;
        savedTransformTargets = s.transformTargets;
        int numPaths = s.inSharedGroup ? s.keys.length : 1;
        newTargets = new Targets[numPaths];
        for (i = 0; i < numPaths; ++i) {
            newTargets[i] = new Targets();
        }
        s.transformTargets = newTargets;
        s.traverseFlags = 0;
        this.inSharedGroup = s.inSharedGroup;
        trans = new Transform3D();
        this.transform.getWithLock(trans);
        this.currentTransform.set(trans);
        ArrayList<NodeRetained> savedChildTransformLinks = s.childTransformLinks;
        GroupRetained savedParentTransformLink = s.parentTransformLink;
        Transform3D[][] oldCurrentList = s.currentTransforms;
        int[][] oldCurrentIndexList = s.currentTransformsIndex;
        super.doSetLive(s);
        if (!this.inSharedGroup) {
            if (s.transformTargets[0] != null) {
                this.cachedTargets[0] = s.transformTargets[0].snapShotInit();
            }
            if (s.switchTargets != null && s.switchTargets[0] != null) {
                s.switchTargets[0].addNode(this, 6);
            }
        } else {
            for (i = 0; i < numPaths; ++i) {
                if (s.transformTargets[i] != null) {
                    int hkIndex = s.keys[i].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                    this.cachedTargets[hkIndex] = s.transformTargets[i].snapShotInit();
                }
                if (s.switchTargets == null || s.switchTargets[i] == null) continue;
                s.switchTargets[i].addNode(this, 6);
            }
        }
        this.j3dCTs = new CachedTargets[this.cachedTargets.length];
        this.copyCachedTargets(0, this.j3dCTs);
        this.computeTargetThreads(0, this.cachedTargets);
        s.localToVworld = this.localToVworld;
        s.localToVworldIndex = this.localToVworldIndex;
        s.currentTransforms = oldCurrentList;
        s.currentTransformsIndex = oldCurrentIndexList;
        s.childTransformLinks = savedChildTransformLinks;
        s.parentTransformLink = savedParentTransformLink;
        s.transformTargets = savedTransformTargets;
        if (!s.inSharedGroup) {
            s.transformLevels[0] = s.transformLevels[0] - 1;
        } else {
            i = 0;
            while (i < s.keys.length) {
                int n = i++;
                s.transformLevels[n] = s.transformLevels[n] - 1;
            }
        }
        if ((s.traverseFlags & 1) != 0) {
            this.aboveAViewPlatform = true;
        }
        s.traverseFlags |= oldTraverseFlags;
        if (this.aboveAViewPlatform && !trans.isCongruent()) {
            throw new BadTransformException(J3dI18N.getString("ViewPlatformRetained0"));
        }
        super.markAsLive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void removeNodeData(SetLiveState s) {
        TransformGroupRetained transformGroupRetained = this;
        synchronized (transformGroupRetained) {
            if (this.refCount <= 0) {
                this.childLocalToVworld = null;
                this.childLocalToVworldIndex = null;
                this.transformLevels = null;
                this.cachedTargets = null;
                this.perPathData = null;
                this.targetThreads = 0;
                if (this.parentTransformLink != null) {
                    ArrayList<NodeRetained> obj = this.parentTransformLink instanceof TransformGroupRetained ? ((TransformGroupRetained)this.parentTransformLink).childTransformLinks : ((SharedGroupRetained)this.parentTransformLink).childTransformLinks;
                    ArrayList<NodeRetained> arrayList = obj;
                    synchronized (arrayList) {
                        obj.remove(this);
                    }
                }
                this.aboveAViewPlatform = false;
            } else {
                int len;
                int newLen = this.localToVworld.length - s.keys.length;
                Transform3D[][] newChildTList = new Transform3D[newLen][];
                int[][] newChildIndexList = new int[newLen][];
                int[] newTransformLevels = new int[newLen];
                ArrayList[] newChildPTG = new ArrayList[newLen];
                CachedTargets[] newTargets = new CachedTargets[newLen];
                TransformGroupData[] newPerPathData = new TransformGroupData[newLen];
                int[] tempIndex = new int[s.keys.length];
                int curStart = 0;
                int newStart = 0;
                boolean found = false;
                for (int i = 0; i < s.keys.length; ++i) {
                    int index;
                    tempIndex[i] = index = s.keys[i].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                    if (index >= 0) {
                        found = true;
                        if (index == curStart) {
                            ++curStart;
                            continue;
                        }
                        len = index - curStart;
                        System.arraycopy(this.childLocalToVworld, curStart, newChildTList, newStart, len);
                        System.arraycopy(this.childLocalToVworldIndex, curStart, newChildIndexList, newStart, len);
                        System.arraycopy(this.transformLevels, curStart, newTransformLevels, newStart, len);
                        System.arraycopy(this.cachedTargets, curStart, newTargets, newStart, len);
                        System.arraycopy(this.perPathData, curStart, newPerPathData, newStart, len);
                        curStart = index + 1;
                        newStart += len;
                        continue;
                    }
                    found = false;
                    MasterControl.getCoreLogger().severe("TG.removeNodeData-Can't find matching hashKey.");
                }
                if (found && curStart < this.localToVworld.length) {
                    len = this.localToVworld.length - curStart;
                    System.arraycopy(this.childLocalToVworld, curStart, newChildTList, newStart, len);
                    System.arraycopy(this.childLocalToVworldIndex, curStart, newChildIndexList, newStart, len);
                    System.arraycopy(this.transformLevels, curStart, newTransformLevels, newStart, len);
                    System.arraycopy(this.cachedTargets, curStart, newTargets, newStart, len);
                    System.arraycopy(this.perPathData, curStart, newPerPathData, newStart, len);
                }
                this.childLocalToVworld = newChildTList;
                this.childLocalToVworldIndex = newChildIndexList;
                this.transformLevels = newTransformLevels;
                this.cachedTargets = newTargets;
                this.perPathData = newPerPathData;
            }
            super.removeNodeData(s);
            s.localToVworld = this.childLocalToVworld;
            s.localToVworldIndex = this.childLocalToVworldIndex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void clearLive(SetLiveState s) {
        Targets[] savedTransformTargets = null;
        savedTransformTargets = s.transformTargets;
        s.transformTargets = null;
        super.clearLive(s);
        s.localToVworld = this.localToVworld;
        s.localToVworldIndex = this.localToVworldIndex;
        s.transformTargets = savedTransformTargets;
        TransformGroupRetained transformGroupRetained = this;
        synchronized (transformGroupRetained) {
            if (this.inSharedGroup) {
                int i;
                if (this.transformLevels != null) {
                    this.maxTransformLevel = this.transformLevels[0];
                    for (i = 1; i < this.transformLevels.length; ++i) {
                        if (this.transformLevels[i] <= this.maxTransformLevel) continue;
                        this.maxTransformLevel = this.transformLevels[i];
                    }
                } else {
                    this.maxTransformLevel = -1;
                }
                if (s.switchTargets != null) {
                    for (i = 0; i < s.switchTargets.length; ++i) {
                        if (s.switchTargets[i] == null) continue;
                        s.switchTargets[i].addNode(this, 6);
                    }
                }
            } else {
                this.maxTransformLevel = -1;
                if (s.switchTargets != null && s.switchTargets[0] != null) {
                    s.switchTargets[0].addNode(this, 6);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void computeCombineBounds(Bounds bounds) {
        if (this.validCachedBounds && this.boundsAutoCompute) {
            Bounds b = (Bounds)this.cachedBounds.clone();
            Transform3D transform3D = this.transform;
            synchronized (transform3D) {
                b.transform(this.transform);
            }
            bounds.combine(b);
            return;
        }
        Bounds boundingObject = null;
        boundingObject = VirtualUniverse.mc.useBoxForGroupBounds ? new BoundingBox((Bounds)null) : new BoundingSphere((Bounds)null);
        if (this.boundsAutoCompute) {
            for (int i = this.children.size() - 1; i >= 0; --i) {
                NodeRetained child = (NodeRetained)this.children.get(i);
                if (child == null) continue;
                child.computeCombineBounds(boundingObject);
            }
            if (VirtualUniverse.mc.cacheAutoComputedBounds) {
                this.cachedBounds = (Bounds)boundingObject.clone();
            }
        } else {
            Bounds bounds2 = this.localBounds;
            synchronized (bounds2) {
                boundingObject.set(this.localBounds);
            }
        }
        Transform3D transform3D = this.transform;
        synchronized (transform3D) {
            boundingObject.transform(this.transform);
        }
        bounds.combine(boundingObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processChildLocalToVworld(ArrayList<TransformGroupRetained> dirtyTransformGroups, ArrayList keySet, UpdateTargets targets, ArrayList blUsers) {
        TransformGroupRetained transformGroupRetained = this;
        synchronized (transformGroupRetained) {
            if (this.inSharedGroup) {
                if (this.localToVworldKeys != null) {
                    for (int j = 0; j < this.localToVworldKeys.length; ++j) {
                        if (!this.perPathData[j].markedDirty) continue;
                        this.updateChildLocalToVworld(this.localToVworldKeys[j], j, dirtyTransformGroups, keySet, targets, blUsers);
                    }
                }
            } else if (this.perPathData != null && this.perPathData[0].markedDirty) {
                this.updateChildLocalToVworld(dirtyTransformGroups, keySet, targets, blUsers);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateChildLocalToVworld(HashKey key, int index, ArrayList<TransformGroupRetained> dirtyTransformGroups, ArrayList keySet, UpdateTargets targets, ArrayList blUsers) {
        TransformGroupRetained transformGroupRetained = this;
        synchronized (transformGroupRetained) {
            if (this.localToVworld != null) {
                this.perPathData[index].markedDirty = false;
                if (this.perPathData[index].switchState.currentSwitchOn) {
                    Transform3D lToVw = this.getCurrentLocalToVworld(index);
                    Transform3D childLToVw = this.getUpdateChildLocalToVworld(index);
                    childLToVw.mul(lToVw, this.currentTransform);
                    dirtyTransformGroups.add(this);
                    keySet.add(key);
                    CachedTargets ct = this.j3dCTs[index];
                    if (ct != null) {
                        targets.addCachedTargets(ct);
                        if (ct.targetArr[5] != null) {
                            TransformGroupRetained.gatherBlUsers(blUsers, ct.targetArr[5]);
                        }
                    }
                } else {
                    this.perPathData[index].switchDirty = true;
                }
                ArrayList<NodeRetained> arrayList = this.childTransformLinks;
                synchronized (arrayList) {
                    for (int i = 0; i < this.childTransformLinks.size(); ++i) {
                        NodeRetained obj = this.childTransformLinks.get(i);
                        if (obj instanceof TransformGroupRetained) {
                            TransformGroupRetained tg = (TransformGroupRetained)obj;
                            tg.updateChildLocalToVworld(tg.localToVworldKeys[index], index, dirtyTransformGroups, keySet, targets, blUsers);
                            continue;
                        }
                        LinkRetained ln = (LinkRetained)obj;
                        this.currentKey.set(this.localToVworldKeys[index]);
                        this.currentKey.append(LinkRetained.plus).append(ln.nodeId);
                        if (ln.sharedGroup == null || ln.sharedGroup.localToVworldKeys == null) continue;
                        int j = this.currentKey.equals(ln.sharedGroup.localToVworldKeys, 0, ln.sharedGroup.localToVworldKeys.length);
                        if (j < 0) {
                            System.err.println("TransformGroupRetained : Can't find hashKey");
                        }
                        if (j >= ln.sharedGroup.localToVworldKeys.length) continue;
                        ln.sharedGroup.updateChildLocalToVworld(ln.sharedGroup.localToVworldKeys[j], j, dirtyTransformGroups, keySet, targets, blUsers);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateChildLocalToVworld(ArrayList<TransformGroupRetained> dirtyTransformGroups, ArrayList keySet, UpdateTargets targets, ArrayList blUsers) {
        TransformGroupRetained transformGroupRetained = this;
        synchronized (transformGroupRetained) {
            if (this.localToVworld != null) {
                this.perPathData[0].markedDirty = false;
                if (this.perPathData[0].switchState.currentSwitchOn) {
                    Transform3D lToVw = this.getCurrentLocalToVworld(0);
                    Transform3D childLToVw = this.getUpdateChildLocalToVworld(0);
                    childLToVw.mul(lToVw, this.currentTransform);
                    dirtyTransformGroups.add(this);
                    CachedTargets ct = this.j3dCTs[0];
                    if (ct != null) {
                        targets.addCachedTargets(ct);
                        if (ct.targetArr[5] != null) {
                            TransformGroupRetained.gatherBlUsers(blUsers, ct.targetArr[5]);
                        }
                    }
                } else {
                    this.perPathData[0].switchDirty = true;
                }
                ArrayList<NodeRetained> arrayList = this.childTransformLinks;
                synchronized (arrayList) {
                    for (int i = 0; i < this.childTransformLinks.size(); ++i) {
                        NodeRetained obj = this.childTransformLinks.get(i);
                        if (obj instanceof TransformGroupRetained) {
                            TransformGroupRetained tg = (TransformGroupRetained)obj;
                            tg.updateChildLocalToVworld(dirtyTransformGroups, keySet, targets, blUsers);
                            continue;
                        }
                        LinkRetained ln = (LinkRetained)obj;
                        this.currentKey.reset();
                        this.currentKey.append(this.locale.nodeId);
                        this.currentKey.append(LinkRetained.plus).append(ln.nodeId);
                        if (ln.sharedGroup == null || ln.sharedGroup.localToVworldKeys == null) continue;
                        int j = this.currentKey.equals(ln.sharedGroup.localToVworldKeys, 0, ln.sharedGroup.localToVworldKeys.length);
                        if (j < 0) {
                            System.err.println("TransformGroupRetained : Can't find hashKey");
                        }
                        if (j >= ln.sharedGroup.localToVworldKeys.length) continue;
                        ln.sharedGroup.updateChildLocalToVworld(ln.sharedGroup.localToVworldKeys[j], j, dirtyTransformGroups, keySet, targets, blUsers);
                    }
                }
            }
        }
    }

    @Override
    void transformBounds(SceneGraphPath path, Bounds bound) {
        if (!((NodeRetained)path.item.retained).inSharedGroup) {
            bound.transform(this.getCurrentChildLocalToVworld());
        } else {
            HashKey key = new HashKey("");
            path.getHashKey(key);
            bound.transform(this.getCurrentChildLocalToVworld(key));
        }
    }

    Transform3D getUpdateChildLocalToVworld(int index) {
        int currentIndex = this.childLocalToVworldIndex[index][1];
        if (currentIndex == this.childLocalToVworldIndex[index][0]) {
            this.childLocalToVworldIndex[index][1] = currentIndex ^= 1;
        }
        return this.childLocalToVworld[index][currentIndex];
    }

    Transform3D getCurrentChildLocalToVworld() {
        return this.getCurrentChildLocalToVworld(0);
    }

    Transform3D getCurrentChildLocalToVworld(int index) {
        return this.childLocalToVworld[index][this.childLocalToVworldIndex[index][1]];
    }

    Transform3D getCurrentChildLocalToVworld(HashKey key) {
        if (!this.inSharedGroup) {
            return this.childLocalToVworld[0][this.childLocalToVworldIndex[0][1]];
        }
        int i = key.equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
        if (i >= 0) {
            return this.childLocalToVworld[i][this.childLocalToVworldIndex[i][1]];
        }
        return new Transform3D();
    }

    Transform3D getLastChildLocalToVworld(HashKey key) {
        if (!this.inSharedGroup) {
            return this.childLocalToVworld[0][this.childLocalToVworldIndex[0][0]];
        }
        int i = key.equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
        if (i >= 0) {
            return this.childLocalToVworld[i][this.childLocalToVworldIndex[i][0]];
        }
        return new Transform3D();
    }

    @Override
    public int getTargetThreads(int type) {
        if (type == 0) {
            return this.targetThreads;
        }
        System.err.println("getTargetsThreads: wrong arguments");
        return -1;
    }

    @Override
    public CachedTargets getCachedTargets(int type, int index, int child) {
        if (type == 0) {
            return this.cachedTargets[index];
        }
        System.err.println("getCachedTargets: wrong arguments");
        return null;
    }

    @Override
    TargetsInterface getClosestTargetsInterface(int type) {
        return type == 0 ? this : (TargetsInterface)((Object)this.parentSwitchLink);
    }

    @Override
    public void computeTargetThreads(int type, CachedTargets[] newCachedTargets) {
        if (type == 0) {
            this.localTargetThreads = 8192;
            for (int i = 0; i < newCachedTargets.length; ++i) {
                if (newCachedTargets[i] == null) continue;
                this.localTargetThreads |= newCachedTargets[i].computeTargetThreads();
            }
            this.targetThreads = this.localTargetThreads;
            int numLinks = this.childTransformLinks.size();
            for (int i = 0; i < numLinks; ++i) {
                NodeRetained node = this.childTransformLinks.get(i);
                TargetsInterface childLink = node.nodeType == 9 ? ((LinkRetained)node).sharedGroup : (TargetsInterface)((Object)node);
                if (childLink == null) continue;
                this.targetThreads |= childLink.getTargetThreads(0);
            }
        } else {
            System.err.println("computeTargetsThreads: wrong arguments");
        }
    }

    @Override
    public void updateTargetThreads(int type, CachedTargets[] newCachedTargets) {
        if (type == 0) {
            this.computeTargetThreads(type, newCachedTargets);
            if (this.parentTransformLink != null) {
                TargetsInterface pti = (TargetsInterface)((Object)this.parentTransformLink);
                pti.propagateTargetThreads(0, this.targetThreads);
            }
        } else {
            System.err.println("updateTargetThreads: wrong arguments");
        }
    }

    @Override
    public void propagateTargetThreads(int type, int childTargetThreads) {
        if (type == 0) {
            this.targetThreads |= childTargetThreads;
            if (this.parentTransformLink != null) {
                TargetsInterface pti = (TargetsInterface)((Object)this.parentTransformLink);
                pti.propagateTargetThreads(0, this.targetThreads);
            }
        } else {
            System.err.println("propagateTargetThreads: wrong arguments");
        }
    }

    @Override
    public void updateCachedTargets(int type, CachedTargets[] newCt) {
        if (type == 0) {
            this.j3dCTs = newCt;
        } else {
            System.err.println("updateCachedTargets: wrong arguments");
        }
    }

    @Override
    public void copyCachedTargets(int type, CachedTargets[] newCt) {
        if (type == 0) {
            for (CachedTargets newCt[i] : this.cachedTargets) {
            }
        } else {
            System.err.println("copyCachedTargets: wrong arguments");
        }
    }

    @Override
    public void resetCachedTargets(int type, CachedTargets[] newCtArr, int child) {
        if (type == 0) {
            this.cachedTargets = newCtArr;
        } else {
            System.err.println("resetCachedTargets: wrong arguments");
        }
    }

    @Override
    public ArrayList<SwitchState> getTargetsData(int type, int index) {
        return null;
    }

    @Override
    void childCheckSetLive(NodeRetained child, int childIndex, SetLiveState s, NodeRetained linkNode) {
        s.currentTransforms = this.childLocalToVworld;
        s.currentTransformsIndex = this.childLocalToVworldIndex;
        s.parentTransformLink = this;
        s.childTransformLinks = this.childTransformLinks;
        s.localToVworld = s.currentTransforms;
        s.localToVworldIndex = s.currentTransformsIndex;
        child.setLive(s);
    }
}

