/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d;

import org.scijava.java3d.CachedTargets;
import org.scijava.java3d.UnorderList;

class UpdateTargets {
    static int[] updateSwitchThreads = new int[]{4288, 4224, 256, 514, 898, 4992, 0};
    UnorderList[] targetList = new UnorderList[7];

    UpdateTargets() {
    }

    int computeSwitchThreads() {
        int switchThreads = 0;
        for (int i = 0; i < 7; ++i) {
            if (this.targetList[i] == null) continue;
            switchThreads |= updateSwitchThreads[i];
        }
        return switchThreads | 0x2000;
    }

    void addNode(Object node, int targetType) {
        if (this.targetList[targetType] == null) {
            this.targetList[targetType] = new UnorderList(1);
        }
        this.targetList[targetType].add(node);
    }

    void addNodeArray(Object[] nodeArr, int targetType) {
        if (this.targetList[targetType] == null) {
            this.targetList[targetType] = new UnorderList(1);
        }
        this.targetList[targetType].add(nodeArr);
    }

    void clearNodes() {
        for (int i = 0; i < 7; ++i) {
            if (this.targetList[i] == null) continue;
            this.targetList[i].clear();
        }
    }

    void addCachedTargets(CachedTargets cachedTargets) {
        for (int i = 0; i < 7; ++i) {
            if (cachedTargets.targetArr[i] == null) continue;
            this.addNodeArray(cachedTargets.targetArr[i], i);
        }
    }

    void dump() {
        for (int i = 0; i < 7; ++i) {
            if (this.targetList[i] == null) continue;
            System.err.println("  " + CachedTargets.typeString[i]);
            for (int j = 0; j < this.targetList[i].size(); ++j) {
                System.err.println("  " + this.targetList[i].get(j));
            }
        }
    }
}

