/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d;

import java.util.ArrayList;
import org.scijava.java3d.BoundingBox;
import org.scijava.java3d.BoundingSphere;
import org.scijava.java3d.Bounds;
import org.scijava.java3d.CompileState;
import org.scijava.java3d.IllegalSceneGraphException;
import org.scijava.java3d.IllegalSharingException;
import org.scijava.java3d.IndexedUnorderSet;
import org.scijava.java3d.J3dI18N;
import org.scijava.java3d.J3dMessage;
import org.scijava.java3d.LeafRetained;
import org.scijava.java3d.Locale;
import org.scijava.java3d.NodeRetained;
import org.scijava.java3d.SetLiveState;
import org.scijava.java3d.Transform3D;
import org.scijava.java3d.TransformGroupRetained;
import org.scijava.java3d.View;
import org.scijava.java3d.VirtualUniverse;
import org.scijava.vecmath.Point3d;

class ViewPlatformRetained
extends LeafRetained {
    static final int VP_IN_BS_LIST = 0;
    static final int TOTAL_INDEXED_UNORDER_SET_TYPES = 1;
    int viewAttachPolicy = 0;
    private ArrayList<View> viewList = new ArrayList();
    private View[] views = null;
    Locale locale = null;
    boolean viewListDirty = true;
    Transform3D vworldToVpc = null;
    Transform3D vpcToVworld = new Transform3D();
    BoundingSphere sphere = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 62.0);
    BoundingSphere schedSphere;
    Point3d center = new Point3d();
    static final Point3d zeroPoint = new Point3d();
    int vprDirtyMask = 196608;
    static final Object[] emptyObj = new Object[0];
    static final Transform3D identity = new Transform3D();

    ViewPlatformRetained() {
        this.nodeType = 16;
        this.localBounds = new BoundingBox((Bounds)null);
        IndexedUnorderSet.init(this, 1);
        this.schedSphere = (BoundingSphere)this.sphere.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setViewAttachPolicy(int policy) {
        ViewPlatformRetained viewPlatformRetained = this;
        synchronized (viewPlatformRetained) {
            this.viewAttachPolicy = policy;
            this.vprDirtyMask |= 0x10000;
        }
        if (this.source != null && this.source.isLive()) {
            this.repaint();
        }
    }

    void repaint() {
        View[] views = this.getViewList();
        for (int i = views.length - 1; i >= 0; --i) {
            views[i].repaint();
        }
    }

    int getViewAttachPolicy() {
        return this.viewAttachPolicy;
    }

    void setActivationRadius(float activationRadius) {
        this.sphere.setRadius(activationRadius);
        if (this.source != null && this.source.isLive()) {
            this.repaint();
        }
        if (this.source.isLive()) {
            J3dMessage message = new J3dMessage();
            message.type = 48;
            message.threads = 384;
            message.universe = this.universe;
            message.args[0] = this;
            message.args[1] = new Float(activationRadius);
            VirtualUniverse.mc.processMessage(message);
        } else {
            this.schedSphere.setRadius(activationRadius);
        }
    }

    float getActivationRadius() {
        return (float)this.sphere.getRadius();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setView(View v) {
        ArrayList<View> arrayList = this.viewList;
        synchronized (arrayList) {
            if (!this.viewList.contains(v)) {
                this.viewList.add(v);
                this.viewListDirty = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeView(View v) {
        ArrayList<View> arrayList = this.viewList;
        synchronized (arrayList) {
            if (this.viewList.remove(v)) {
                this.viewListDirty = true;
            }
        }
    }

    Transform3D getVworldToVpc() {
        if (this.vworldToVpc == null) {
            this.vworldToVpc = new Transform3D();
        }
        this.vworldToVpc.set(this.getCurrentLocalToVworld(null));
        this.vworldToVpc.invert();
        return this.vworldToVpc;
    }

    Transform3D getVpcToVworld() {
        this.vpcToVworld.set(this.getCurrentLocalToVworld(null));
        return this.vpcToVworld;
    }

    void evaluateViewPlatformTransform() {
        this.vworldToVpc = null;
    }

    void evaluateInitViewPlatformTransform(NodeRetained node, Transform3D trans) {
        NodeRetained parent;
        if (node instanceof TransformGroupRetained) {
            Transform3D tmpTrans = new Transform3D();
            TransformGroupRetained tgr = (TransformGroupRetained)node;
            tgr.transform.getWithLock(tmpTrans);
            trans.mul(tmpTrans, trans);
        }
        if ((parent = node.getParent()) != null) {
            this.evaluateInitViewPlatformTransform(parent, trans);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void evaluateInitViewPlatformTransform() {
        ViewPlatformRetained viewPlatformRetained = this;
        synchronized (viewPlatformRetained) {
            Transform3D lastLocalToVworld = this.getLastLocalToVworld();
            if (lastLocalToVworld.equals(identity)) {
                this.evaluateInitViewPlatformTransform(this, lastLocalToVworld);
            }
        }
    }

    void updateActivationRadius(float radius) {
        this.schedSphere.setCenter(zeroPoint);
        this.schedSphere.setRadius(radius);
        this.schedSphere.transform(this.getCurrentLocalToVworld(null));
    }

    void updateTransformRegion() {
        Transform3D tr = this.getCurrentLocalToVworld(null);
        this.schedSphere.setCenter(zeroPoint);
        this.schedSphere.transform(tr);
        tr.transform(zeroPoint, this.center);
    }

    @Override
    void setLive(SetLiveState s) {
        int i;
        View[] views = this.getViewList();
        for (i = views.length - 1; i >= 0; --i) {
            views[i].checkView();
        }
        super.doSetLive(s);
        if (this.inBackgroundGroup) {
            throw new IllegalSceneGraphException(J3dI18N.getString("ViewPlatformRetained1"));
        }
        if (this.inSharedGroup) {
            throw new IllegalSharingException(J3dI18N.getString("ViewPlatformRetained2"));
        }
        if (s.viewLists != null) {
            throw new IllegalSceneGraphException(J3dI18N.getString("ViewPlatformRetained3"));
        }
        this.locale = s.locale;
        if (s.transformTargets != null && s.transformTargets[0] != null) {
            s.transformTargets[0].addNode(this, 4);
            s.notifyThreads |= 0x2000;
        }
        if (s.switchTargets != null && s.switchTargets[0] != null) {
            s.switchTargets[0].addNode(this, 4);
        }
        this.switchState = s.switchStates.get(0);
        s.nodeList.add(this);
        s.notifyThreads |= 0x100;
        super.markAsLive();
        for (i = views.length - 1; i >= 0; --i) {
            views[i].setUniverse(s.universe);
            views[i].evaluateActive();
        }
        this.universe.addViewPlatform(this);
        s.traverseFlags |= 1;
    }

    @Override
    void clearLive(SetLiveState s) {
        super.clearLive(s);
        if (s.switchTargets != null && s.switchTargets[0] != null) {
            s.switchTargets[0].addNode(this, 4);
        }
        View[] views = this.getViewList();
        for (int i = views.length - 1; i >= 0; --i) {
            views[i].evaluateActive();
        }
        s.nodeList.add(this);
        if (s.transformTargets != null && s.transformTargets[0] != null) {
            s.transformTargets[0].addNode(this, 4);
            s.notifyThreads |= 0x2000;
        }
        s.notifyThreads |= 0x102;
        this.universe.removeViewPlatform(this);
    }

    void reEvaluateView() {
        View[] views = this.getViewList();
        for (int i = views.length - 1; i >= 0; --i) {
            views[i].evaluateActive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    View[] getViewList() {
        ArrayList<View> arrayList = this.viewList;
        synchronized (arrayList) {
            if (this.viewListDirty) {
                this.views = this.viewList.toArray(new View[this.viewList.size()]);
                this.viewListDirty = false;
            }
            return this.views;
        }
    }

    boolean isActiveViewPlatform() {
        View[] v = this.getViewList();
        for (int i = 0; i < v.length; ++i) {
            if (!v[i].active) continue;
            return true;
        }
        return false;
    }

    void processSwitchChanged() {
        this.reEvaluateView();
    }

    @Override
    void compile(CompileState compState) {
        super.compile(compState);
        compState.keepTG = true;
    }
}

