/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.multiKymograph;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Macro;
import ij.WindowManager;
import ij.plugin.PlugIn;
import java.awt.image.ColorModel;

public class WalkingAverage_
implements PlugIn {
    final String makroString = Macro.getOptions();

    public void run(String arg) {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            IJ.noImage();
            return;
        }
        IJ.run((String)"8-bit");
        int numStacks = imp.getStackSize();
        int average = 1;
        if (numStacks == 1) {
            IJ.error((String)"Must call this plugin on image stack.");
            return;
        }
        if (this.makroString != null) {
            int start = this.makroString.indexOf("average=");
            int end = this.makroString.length() - 1;
            average = Integer.parseInt(this.makroString.substring(start + 8, end));
        }
        if (this.makroString == null) {
            String sPrompt = "Number of frames to average ";
            average = (int)IJ.getNumber((String)sPrompt, (double)4.0);
        }
        if (average == Integer.MIN_VALUE) {
            return;
        }
        if (average >= numStacks) {
            IJ.error((String)"Sorry. This is not possible");
            return;
        }
        if (!imp.lock()) {
            return;
        }
        this.walkav(imp, numStacks, average);
        imp.unlock();
    }

    protected void walkav(ImagePlus imp, int numImages, int numSubStacks) {
        ImageStack stack = imp.getStack();
        ColorModel cm = imp.createLut().getColorModel();
        ImageStack ims = new ImageStack(stack.getWidth(), stack.getHeight(), cm);
        String sStackName = "walkAv";
        int dimension = stack.getWidth() * stack.getHeight();
        int[] sum = new int[dimension];
        int stop = stack.getSize();
        for (int s = 0; s <= stop - numSubStacks; ++s) {
            int j;
            for (int j2 = 0; j2 < dimension; ++j2) {
                sum[j2] = 0;
            }
            for (int i = 1 + s; i <= numSubStacks + s; ++i) {
                byte[] pixels = (byte[])stack.getPixels(i);
                for (j = 0; j < dimension; ++j) {
                    int n = j;
                    sum[n] = sum[n] + (0xFF & pixels[j]);
                }
            }
            byte[] average = new byte[dimension];
            for (j = 0; j < dimension; ++j) {
                average[j] = (byte)(sum[j] / numSubStacks & 0xFF);
            }
            ims.addSlice("RollAverage" + s, (Object)average);
        }
        ImagePlus nimp = new ImagePlus(sStackName, ims);
        nimp.setStack(sStackName, ims);
        nimp.show();
    }
}

