/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.plugins.scripting.groovy;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.scijava.util.ClassUtils;
import org.scijava.util.Types;

public class ImportRetainer
extends CompilationCustomizer {
    private final List<ImportNode> priorImports = new ArrayList<ImportNode>();
    private final List<ImportNode> priorStarImports = new ArrayList<ImportNode>();
    private final List<ImportNode> priorStaticImports = new ArrayList<ImportNode>();
    private final List<ImportNode> priorStaticStarImports = new ArrayList<ImportNode>();

    public ImportRetainer() {
        super(CompilePhase.CONVERSION);
    }

    public void retainImport(ImportNode node) {
        this.priorImports.add(node);
    }

    public void retainStarImport(ImportNode node) {
        this.priorStarImports.add(node);
    }

    public void retainStaticImport(ImportNode node) {
        this.priorStaticImports.add(node);
    }

    public void retainStaticStarImport(ImportNode node) {
        this.priorStaticStarImports.add(node);
    }

    private <T> T fieldValue(String name, Object instance) {
        return (T)ClassUtils.getValue((Field)Types.field(ModuleNode.class, (String)name), (Object)instance);
    }

    public void call(SourceUnit source, GeneratorContext context, ClassNode classNode) {
        ModuleNode ast = source.getAST();
        List imports = (List)this.fieldValue("imports", ast);
        List starImports = (List)this.fieldValue("starImports", ast);
        Map staticImports = (Map)this.fieldValue("staticImports", ast);
        Map staticStarImports = (Map)this.fieldValue("staticStarImports", ast);
        if (!classNode.getName().equals(ast.getMainClassName())) {
            return;
        }
        ast.addImport(null, classNode);
        for (ImportNode node : this.priorImports) {
            imports.add(node);
            this.storeLastAddedImportNode(ast, node);
        }
        for (ImportNode node : this.priorStarImports) {
            starImports.add(node);
            this.storeLastAddedImportNode(ast, node);
        }
        for (ImportNode node : this.priorStaticImports) {
            String alias = node.getAlias();
            ImportNode prev = staticImports.put(alias, node);
            if (prev != null) {
                staticImports.put(prev.toString(), prev);
                staticImports.put(alias, staticImports.remove(alias));
            }
            this.storeLastAddedImportNode(ast, node);
        }
        for (ImportNode node : this.priorStaticStarImports) {
            staticStarImports.put(node.getAlias(), node);
            this.storeLastAddedImportNode(ast, node);
        }
    }

    private void storeLastAddedImportNode(ModuleNode ast, ImportNode node) {
        if (ast.getNodeMetaData(ImportNode.class) == ImportNode.class) {
            ast.putNodeMetaData(ImportNode.class, (Object)node);
        }
    }
}

