/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate;

import fiji.plugin.trackmate.detection.DetectionUtils;
import fiji.plugin.trackmate.detection.SpotDetectorFactoryBase;
import fiji.plugin.trackmate.features.FeatureAnalyzer;
import fiji.plugin.trackmate.features.FeatureFilter;
import fiji.plugin.trackmate.features.edges.EdgeAnalyzer;
import fiji.plugin.trackmate.features.spot.SpotAnalyzerFactory;
import fiji.plugin.trackmate.features.spot.SpotAnalyzerFactoryBase;
import fiji.plugin.trackmate.features.track.TrackAnalyzer;
import fiji.plugin.trackmate.providers.EdgeAnalyzerProvider;
import fiji.plugin.trackmate.providers.SpotAnalyzerProvider;
import fiji.plugin.trackmate.providers.SpotMorphologyAnalyzerProvider;
import fiji.plugin.trackmate.providers.TrackAnalyzerProvider;
import fiji.plugin.trackmate.tracking.SpotTrackerFactory;
import ij.ImagePlus;
import ij.gui.Roi;
import ij.io.FileInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Settings {
    public final ImagePlus imp;
    public double dt;
    public double dx;
    public double dy;
    public double dz;
    public int width;
    public int height;
    public int nslices;
    public int nframes;
    public String imageFolder;
    public String imageFileName;
    private Roi roi;
    public int tstart;
    public int tend;
    public int zstart;
    public int zend;
    public SpotDetectorFactoryBase<?> detectorFactory;
    public SpotTrackerFactory trackerFactory;
    public Map<String, Object> detectorSettings = new HashMap<String, Object>();
    public Map<String, Object> trackerSettings = new HashMap<String, Object>();
    protected List<FeatureFilter> spotFilters = new ArrayList<FeatureFilter>();
    public Double initialSpotFilterValue = 0.0;
    protected List<FeatureFilter> trackFilters = new ArrayList<FeatureFilter>();
    protected String errorMessage;
    protected List<SpotAnalyzerFactoryBase<?>> spotAnalyzerFactories = new ArrayList();
    protected List<EdgeAnalyzer> edgeAnalyzers = new ArrayList<EdgeAnalyzer>();
    protected List<TrackAnalyzer> trackAnalyzers = new ArrayList<TrackAnalyzer>();

    public Settings() {
        this(null);
    }

    public Settings(ImagePlus imp) {
        this.imp = imp;
        if (null == imp) {
            this.dx = 1.0;
            this.dy = 1.0;
            this.dz = 1.0;
            this.dt = 1.0;
            this.width = 0;
            this.height = 0;
            this.imageFileName = "";
            this.imageFolder = "";
            this.nframes = 0;
            this.nslices = 0;
            return;
        }
        FileInfo fileInfo = imp.getOriginalFileInfo();
        if (null != fileInfo) {
            this.imageFileName = fileInfo.fileName;
            this.imageFolder = fileInfo.directory;
        } else {
            this.imageFileName = imp.getShortTitle();
            this.imageFolder = "";
        }
        this.width = imp.getWidth();
        this.height = imp.getHeight();
        this.nslices = imp.getNSlices();
        this.nframes = imp.getNFrames();
        this.dx = imp.getCalibration().pixelWidth;
        this.dy = imp.getCalibration().pixelHeight;
        this.dz = imp.getCalibration().pixelDepth;
        double ldt = imp.getCalibration().frameInterval;
        this.dt = ldt == 0.0 ? 1.0 : ldt;
        this.zstart = 0;
        this.zend = imp.getNSlices() - 1;
        this.tstart = 0;
        this.tend = imp.getNFrames() - 1;
        this.setRoi(imp.getRoi());
    }

    public Roi getRoi() {
        return this.roi;
    }

    public void setRoi(Roi roi) {
        this.roi = roi;
    }

    public int getXstart() {
        return this.roi == null ? 0 : this.roi.getBounds().x;
    }

    public int getXend() {
        return this.roi == null ? this.width - 1 : this.roi.getBounds().x + this.roi.getBounds().width;
    }

    public int getYstart() {
        return this.roi == null ? 0 : this.roi.getBounds().y;
    }

    public int getYend() {
        return this.roi == null ? this.height - 1 : this.roi.getBounds().y + this.roi.getBounds().height;
    }

    public Settings copyOn(ImagePlus newImp) {
        Settings newSettings = new Settings(newImp);
        if (this.detectorFactory != null) {
            newSettings.detectorFactory = this.detectorFactory.copy();
        }
        newSettings.detectorSettings = new HashMap<String, Object>(this.detectorSettings);
        if (this.trackerFactory != null) {
            newSettings.trackerFactory = this.trackerFactory.copy();
        }
        newSettings.trackerSettings = new HashMap<String, Object>(this.trackerSettings);
        newSettings.initialSpotFilterValue = this.initialSpotFilterValue;
        newSettings.spotFilters = new ArrayList<FeatureFilter>();
        for (FeatureFilter filter : this.spotFilters) {
            newSettings.spotFilters.add(new FeatureFilter(filter.feature, filter.value, filter.isAbove));
        }
        newSettings.trackFilters = new ArrayList<FeatureFilter>();
        for (FeatureFilter filter : this.trackFilters) {
            newSettings.trackFilters.add(new FeatureFilter(filter.feature, filter.value, filter.isAbove));
        }
        newSettings.addAllAnalyzers();
        return newSettings;
    }

    public String toStringImageInfo() {
        StringBuilder str = new StringBuilder();
        str.append("Image data:\n");
        if (null == this.imp) {
            str.append("Source image not set.\n");
        } else {
            str.append("For the image named: " + this.imp.getTitle() + ".\n");
        }
        if (this.imageFileName == null || this.imageFileName == "") {
            str.append("Not matching any file.\n");
        } else {
            str.append("Matching file " + this.imageFileName + " ");
            if (this.imageFolder == null || this.imageFolder == "") {
                str.append("in current folder.\n");
            } else {
                str.append("in folder: " + this.imageFolder + "\n");
            }
        }
        str.append("Geometry:\n");
        str.append(String.format("  X = %4d - %4d, dx = %g\n", this.getXstart(), this.getXend(), this.dx));
        str.append(String.format("  Y = %4d - %4d, dy = %g\n", this.getYstart(), this.getYend(), this.dy));
        str.append(String.format("  Z = %4d - %4d, dz = %g\n", this.zstart, this.zend, this.dz));
        str.append(String.format("  T = %4d - %4d, dt = %g\n", this.tstart, this.tend, this.dt));
        return str.toString();
    }

    public String toStringFeatureAnalyzersInfo() {
        StringBuilder str = new StringBuilder();
        if (this.spotAnalyzerFactories.isEmpty()) {
            str.append("No spot feature analyzers.\n");
        } else {
            str.append("Spot feature analyzers:\n");
            Settings.prettyPrintFeatureAnalyzer(this.spotAnalyzerFactories, str);
        }
        if (this.edgeAnalyzers.isEmpty()) {
            str.append("No edge feature analyzers.\n");
        } else {
            str.append("Edge feature analyzers:\n");
            Settings.prettyPrintFeatureAnalyzer(this.edgeAnalyzers, str);
        }
        if (this.trackAnalyzers.isEmpty()) {
            str.append("No track feature analyzers.\n");
        } else {
            str.append("Track feature analyzers:\n");
            Settings.prettyPrintFeatureAnalyzer(this.trackAnalyzers, str);
        }
        return str.toString();
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(this.toStringImageInfo());
        str.append('\n');
        str.append("Spot detection:\n");
        if (null == this.detectorFactory) {
            str.append("No detector factory set.\n");
        } else {
            str.append("Detector: " + this.detectorFactory.toString() + ".\n");
            if (null == this.detectorSettings) {
                str.append("No detector settings found.\n");
            } else {
                str.append("Detector settings:\n");
                str.append(this.detectorSettings);
                str.append('\n');
            }
        }
        str.append('\n');
        str.append(this.toStringFeatureAnalyzersInfo());
        str.append('\n');
        str.append("Initial spot filter:\n");
        if (null == this.initialSpotFilterValue) {
            str.append("No initial quality filter.\n");
        } else {
            str.append("Initial quality filter value: " + this.initialSpotFilterValue + ".\n");
        }
        str.append('\n');
        str.append("Spot feature filters:\n");
        if (this.spotFilters == null || this.spotFilters.size() == 0) {
            str.append("No spot feature filters.\n");
        } else {
            str.append("Set with " + this.spotFilters.size() + " spot feature filters:\n");
            for (FeatureFilter featureFilter : this.spotFilters) {
                str.append(" - " + featureFilter + "\n");
            }
        }
        str.append('\n');
        str.append("Particle linking:\n");
        if (null == this.trackerFactory) {
            str.append("No spot tracker set.\n");
        } else {
            str.append("Tracker: " + this.trackerFactory.toString() + ".\n");
            if (null == this.trackerSettings) {
                str.append("No tracker settings found.\n");
            } else {
                str.append("Tracker settings:\n");
                str.append(this.trackerSettings);
                str.append('\n');
            }
        }
        str.append('\n');
        str.append("Track feature filters:\n");
        if (this.trackFilters == null || this.trackFilters.size() == 0) {
            str.append("No track feature filters.\n");
        } else {
            str.append("Set with " + this.trackFilters.size() + " track feature filters:\n");
            for (FeatureFilter featureFilter : this.trackFilters) {
                str.append(" - " + featureFilter + "\n");
            }
        }
        return str.toString();
    }

    public boolean checkValidity() {
        if (null == this.imp) {
            this.errorMessage = "The source image is null.\n";
            return false;
        }
        if (null == this.detectorFactory) {
            this.errorMessage = "The detector factory is null.\n";
            return false;
        }
        if (null == this.detectorSettings) {
            this.errorMessage = "The detector settings is null.\n";
            return false;
        }
        if (null == this.initialSpotFilterValue) {
            this.errorMessage = "Initial spot quality threshold is not set.\n";
            return false;
        }
        if (null == this.trackerFactory) {
            this.errorMessage = "The tracker factory is null.\n";
            return false;
        }
        if (!this.trackerFactory.checkSettingsValidity(this.trackerSettings)) {
            this.errorMessage = "The tracker has invalid input:\n" + this.trackerFactory.getErrorMessage();
            return false;
        }
        return true;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void addAllAnalyzers() {
        SpotAnalyzerProvider spotAnalyzerProvider = new SpotAnalyzerProvider(this.imp == null ? 1 : this.imp.getNChannels());
        List<String> spotAnalyzerKeys = spotAnalyzerProvider.getKeys();
        for (String key : spotAnalyzerKeys) {
            this.addSpotAnalyzerFactory(spotAnalyzerProvider.getFactory(key));
        }
        if (this.imp != null && DetectionUtils.is2D(this.imp) && this.detectorFactory != null && this.detectorFactory.has2Dsegmentation()) {
            SpotMorphologyAnalyzerProvider spotMorphologyAnalyzerProvider = new SpotMorphologyAnalyzerProvider(this.imp.getNChannels());
            List<String> spotMorphologyAnaylyzerKeys = spotMorphologyAnalyzerProvider.getKeys();
            for (String key : spotMorphologyAnaylyzerKeys) {
                this.addSpotAnalyzerFactory(spotMorphologyAnalyzerProvider.getFactory(key));
            }
        }
        EdgeAnalyzerProvider edgeAnalyzerProvider = new EdgeAnalyzerProvider();
        List<String> edgeAnalyzerKeys = edgeAnalyzerProvider.getKeys();
        for (String key : edgeAnalyzerKeys) {
            this.addEdgeAnalyzer((EdgeAnalyzer)edgeAnalyzerProvider.getFactory(key));
        }
        TrackAnalyzerProvider trackAnalyzerProvider = new TrackAnalyzerProvider();
        List<String> trackAnalyzerKeys = trackAnalyzerProvider.getKeys();
        for (String key : trackAnalyzerKeys) {
            this.addTrackAnalyzer((TrackAnalyzer)trackAnalyzerProvider.getFactory(key));
        }
    }

    public void clearSpotAnalyzerFactories() {
        this.spotAnalyzerFactories.clear();
    }

    public List<SpotAnalyzerFactoryBase<?>> getSpotAnalyzerFactories() {
        return new ArrayList(this.spotAnalyzerFactories);
    }

    public void addSpotAnalyzerFactory(SpotAnalyzerFactoryBase<?> spotAnalyzer) {
        if (this.contains(spotAnalyzer)) {
            return;
        }
        this.spotAnalyzerFactories.add(spotAnalyzer);
    }

    public void addSpotAnalyzerFactory(int index, SpotAnalyzerFactory<?> spotAnalyzer) {
        if (this.contains(spotAnalyzer)) {
            return;
        }
        this.spotAnalyzerFactories.add(index, spotAnalyzer);
    }

    public boolean removeSpotAnalyzerFactory(SpotAnalyzerFactory<?> spotAnalyzer) {
        return this.spotAnalyzerFactories.remove(spotAnalyzer);
    }

    private boolean contains(SpotAnalyzerFactoryBase<?> spotAnalyzer) {
        for (SpotAnalyzerFactoryBase<?> saf : this.spotAnalyzerFactories) {
            if (!saf.getKey().equals(spotAnalyzer.getKey())) continue;
            return true;
        }
        return false;
    }

    public void clearEdgeAnalyzers() {
        this.edgeAnalyzers.clear();
    }

    public List<EdgeAnalyzer> getEdgeAnalyzers() {
        return new ArrayList<EdgeAnalyzer>(this.edgeAnalyzers);
    }

    public void addEdgeAnalyzer(EdgeAnalyzer edgeAnalyzer) {
        if (this.contains(edgeAnalyzer)) {
            return;
        }
        this.edgeAnalyzers.add(edgeAnalyzer);
    }

    public void addEdgeAnalyzer(int index, EdgeAnalyzer edgeAnalyzer) {
        if (this.contains(edgeAnalyzer)) {
            return;
        }
        this.edgeAnalyzers.add(index, edgeAnalyzer);
    }

    public boolean removeEdgeAnalyzer(EdgeAnalyzer edgeAnalyzer) {
        return this.edgeAnalyzers.remove(edgeAnalyzer);
    }

    private boolean contains(EdgeAnalyzer edgeAnalyzer) {
        for (EdgeAnalyzer ea : this.edgeAnalyzers) {
            if (!ea.getKey().equals(edgeAnalyzer.getKey())) continue;
            return true;
        }
        return false;
    }

    public void clearTrackAnalyzers() {
        this.trackAnalyzers.clear();
    }

    public List<TrackAnalyzer> getTrackAnalyzers() {
        return new ArrayList<TrackAnalyzer>(this.trackAnalyzers);
    }

    public void addTrackAnalyzer(TrackAnalyzer trackAnalyzer) {
        if (this.contains(trackAnalyzer)) {
            return;
        }
        this.trackAnalyzers.add(trackAnalyzer);
    }

    public void addTrackAnalyzer(int index, TrackAnalyzer trackAnalyzer) {
        if (this.contains(trackAnalyzer)) {
            return;
        }
        this.trackAnalyzers.add(index, trackAnalyzer);
    }

    public boolean removeTrackAnalyzer(TrackAnalyzer trackAnalyzer) {
        return this.trackAnalyzers.remove(trackAnalyzer);
    }

    private boolean contains(TrackAnalyzer trackAnalyzer) {
        for (TrackAnalyzer ta : this.trackAnalyzers) {
            if (!ta.getKey().equals(trackAnalyzer.getKey())) continue;
            return true;
        }
        return false;
    }

    public void addSpotFilter(FeatureFilter filter) {
        this.spotFilters.add(filter);
    }

    public void removeSpotFilter(FeatureFilter filter) {
        this.spotFilters.remove(filter);
    }

    public void clearSpotFilters() {
        this.spotFilters.clear();
    }

    public List<FeatureFilter> getSpotFilters() {
        return this.spotFilters;
    }

    public void setSpotFilters(List<FeatureFilter> spotFilters) {
        this.spotFilters = spotFilters;
    }

    public void addTrackFilter(FeatureFilter filter) {
        this.trackFilters.add(filter);
    }

    public void removeTrackFilter(FeatureFilter filter) {
        this.trackFilters.remove(filter);
    }

    public void clearTrackFilters() {
        this.trackFilters.clear();
    }

    public List<FeatureFilter> getTrackFilters() {
        return this.trackFilters;
    }

    public void setTrackFilters(List<FeatureFilter> trackFilters) {
        this.trackFilters = trackFilters;
    }

    public static final void prettyPrintFeatureAnalyzer(List<? extends FeatureAnalyzer> analyzers, StringBuilder str) {
        for (FeatureAnalyzer featureAnalyzer : analyzers) {
            str.append(" - " + featureAnalyzer.getName() + " provides: ");
            for (String feature : featureAnalyzer.getFeatures()) {
                str.append(featureAnalyzer.getFeatureShortNames().get(feature) + ", ");
            }
            str.deleteCharAt(str.length() - 1);
            str.deleteCharAt(str.length() - 1);
            if (str.charAt(str.length() - 1) != '.') {
                str.append('.');
            }
            if (featureAnalyzer.isManualFeature()) {
                str.deleteCharAt(str.length() - 1);
                str.append("; is manual.");
            }
            str.append('\n');
        }
    }
}

