/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.action;

import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.SelectionModel;
import fiji.plugin.trackmate.TrackMate;
import fiji.plugin.trackmate.action.AbstractTMAction;
import fiji.plugin.trackmate.action.TrackMateAction;
import fiji.plugin.trackmate.action.TrackMateActionFactory;
import fiji.plugin.trackmate.gui.Icons;
import fiji.plugin.trackmate.gui.displaysettings.DisplaySettings;
import fiji.plugin.trackmate.util.TMUtils;
import fiji.plugin.trackmate.visualization.table.AllSpotsTableView;
import java.awt.Frame;
import javax.swing.ImageIcon;
import org.scijava.plugin.Plugin;

public class ExportAllSpotsStatsAction
extends AbstractTMAction {
    public static final String NAME = "Export all spots statistics";
    public static final String KEY = "EXPORT_ALL_SPOTS_STATS";
    public static final String INFO_TEXT = "<html>Export the statistics of all spots to a table. The numerical features of all visible spots are exported, regardless of whether they are in a track or not.</html>";

    @Override
    public void execute(TrackMate trackmate, SelectionModel selectionModel, DisplaySettings displaySettings, Frame parent) {
        ExportAllSpotsStatsAction.createSpotsTable(trackmate.getModel(), selectionModel, displaySettings, TMUtils.getImagePathWithoutExtension(trackmate.getSettings())).render();
    }

    public static final AllSpotsTableView createSpotsTable(Model model, SelectionModel selectionModel, DisplaySettings displaySettings, String imageFileName) {
        return new AllSpotsTableView(model, selectionModel, displaySettings, imageFileName);
    }

    @Plugin(type=TrackMateActionFactory.class, visible=false)
    public static class Factory
    implements TrackMateActionFactory {
        @Override
        public String getInfoText() {
            return ExportAllSpotsStatsAction.INFO_TEXT;
        }

        @Override
        public String getKey() {
            return ExportAllSpotsStatsAction.KEY;
        }

        @Override
        public TrackMateAction create() {
            return new ExportAllSpotsStatsAction();
        }

        @Override
        public ImageIcon getIcon() {
            return Icons.CALCULATOR_ICON;
        }

        @Override
        public String getName() {
            return ExportAllSpotsStatsAction.NAME;
        }
    }
}

