/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.action;

import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.SelectionModel;
import fiji.plugin.trackmate.Settings;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.TrackMate;
import fiji.plugin.trackmate.TrackModel;
import fiji.plugin.trackmate.action.AbstractTMAction;
import fiji.plugin.trackmate.action.TrackMateAction;
import fiji.plugin.trackmate.action.TrackMateActionFactory;
import fiji.plugin.trackmate.gui.Icons;
import fiji.plugin.trackmate.gui.displaysettings.DisplaySettings;
import fiji.plugin.trackmate.gui.displaysettings.DisplaySettingsIO;
import fiji.plugin.trackmate.io.TmXmlReader;
import ij.ImageJ;
import ij.ImagePlus;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.File;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import org.scijava.plugin.Plugin;

public class MotilityLabExporter
extends AbstractTMAction {
    public static final String NAME = "Export to MotilityLab spreadsheet";
    public static final String KEY = "MOTILITYLAB_EXPORTER";
    public static final String INFO_TEXT = "<html>Display the visible tracks in a spreadsheet that can be copy-pasted directly into the <a url=\"http://www.motilitylab.net/import/data-import.php\"> MotilityLab website</a> for further track analysis.";
    private static final int ROW_HEIGHT = 22;
    private static final List<String> HEADERS = Arrays.asList("Tracking ID", "Timepoint", "Time (sec)", "X pos (\u00b5m)", "Y pos (\u00b5m)", "Z pos (\u00b5m)");
    private static final List<Class<?>> CLASSES = Arrays.asList(Integer.class, Integer.class, Double.class, Double.class, Double.class, Double.class);

    @Override
    public void execute(TrackMate trackmate, SelectionModel selectionModel, DisplaySettings displaySettings, Frame parent) {
        JPanel panel = this.createSpotTable(trackmate.getModel());
        JFrame frame = new JFrame("TrackMate MotilityLab table export");
        frame.setIconImage(Icons.TRACK_TABLES_ICON.getImage());
        frame.getContentPane().add(panel);
        frame.setLocationRelativeTo(parent);
        frame.pack();
        frame.setVisible(true);
    }

    private final JPanel createSpotTable(Model model) {
        ArrayList<Spot> spots = new ArrayList<Spot>(model.getTrackModel().vertexSet());
        MyTableModel tableModel = new MyTableModel(spots, model.getTrackModel());
        JTable table = new JTable(tableModel);
        MyTableCellRenderer cellRenderer = new MyTableCellRenderer();
        for (int c = 0; c < table.getColumnModel().getColumnCount(); ++c) {
            TableColumn column = table.getColumnModel().getColumn(c);
            column.setCellRenderer(cellRenderer);
        }
        table.setRowHeight(22);
        table.getSelectionModel().setSelectionMode(2);
        table.setGridColor(table.getTableHeader().getBackground());
        table.getTableHeader().setPreferredSize(new Dimension(100, 33));
        TableRowSorter<MyTableModel> sorter = new TableRowSorter<MyTableModel>(tableModel);
        for (int c = 0; c < CLASSES.size(); ++c) {
            if (CLASSES.get(c).equals(Integer.class)) {
                sorter.setComparator(c, (i1, i2) -> Integer.compare((Integer)i1, (Integer)i2));
                continue;
            }
            if (CLASSES.get(c).equals(Double.class)) {
                sorter.setComparator(c, (d1, d2) -> Double.compare((Double)d1, (Double)d2));
                continue;
            }
            if (CLASSES.get(c).equals(Color.class)) {
                sorter.setComparator(c, (c1, c2) -> c1.toString().compareTo(c2.toString()));
                continue;
            }
            sorter.setComparator(c, Comparator.naturalOrder());
        }
        table.setRowSorter(sorter);
        sorter.setSortKeys(Arrays.asList(new RowSorter.SortKey(0, SortOrder.ASCENDING), new RowSorter.SortKey(1, SortOrder.ASCENDING)));
        sorter.sort();
        JScrollPane scrollPane = new JScrollPane(table, 20, 30);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)scrollPane, "Center");
        return panel;
    }

    public static void main(String[] args) {
        ImageJ.main((String[])args);
        TmXmlReader reader = new TmXmlReader(new File("samples/MAX_Merged.xml"));
        Model model = reader.getModel();
        ImagePlus imp = reader.readImage();
        Settings settings = reader.readSettings(imp);
        new MotilityLabExporter().execute(new TrackMate(model, settings), new SelectionModel(model), DisplaySettingsIO.readUserDefault(), null);
    }

    @Plugin(type=TrackMateActionFactory.class, enabled=true)
    public static class Factory
    implements TrackMateActionFactory {
        @Override
        public String getInfoText() {
            return MotilityLabExporter.INFO_TEXT;
        }

        @Override
        public String getName() {
            return MotilityLabExporter.NAME;
        }

        @Override
        public String getKey() {
            return MotilityLabExporter.KEY;
        }

        @Override
        public TrackMateAction create() {
            return new MotilityLabExporter();
        }

        @Override
        public ImageIcon getIcon() {
            return Icons.TRACK_TABLES_ICON;
        }
    }

    private class MyTableCellRenderer
    extends DefaultTableCellRenderer {
        private final DecimalFormat nf = new DecimalFormat();
        private static final long serialVersionUID = 1L;

        public MyTableCellRenderer() {
            DecimalFormatSymbols formatSymbols = new DecimalFormatSymbols();
            formatSymbols.setNaN("NaN");
            this.nf.setDecimalFormatSymbols(formatSymbols);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel c = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof Double) {
                this.setHorizontalAlignment(4);
                Double doubleValue = (Double)value;
                this.setText(this.nf.format(doubleValue));
            } else if (value instanceof Number) {
                this.setHorizontalAlignment(4);
            } else {
                this.setHorizontalAlignment(2);
            }
            return c;
        }
    }

    private class MyTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private final List<Spot> spots;
        private final TrackModel trackModel;

        public MyTableModel(List<Spot> spots, TrackModel trackModel) {
            this.spots = spots;
            this.trackModel = trackModel;
        }

        @Override
        public int getRowCount() {
            return this.spots.size();
        }

        @Override
        public int getColumnCount() {
            return 6;
        }

        @Override
        public String getColumnName(int column) {
            return (String)HEADERS.get(column);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (rowIndex < 0 || rowIndex >= this.spots.size()) {
                return null;
            }
            Spot spot = this.spots.get(rowIndex);
            if (null == spot) {
                return null;
            }
            switch (columnIndex) {
                case 0: {
                    return this.trackModel.trackIDOf(spot);
                }
                case 1: {
                    return spot.getFeature("FRAME").intValue();
                }
                case 2: {
                    return spot.getFeature("POSITION_T");
                }
                case 3: {
                    return spot.getFeature("POSITION_X");
                }
                case 4: {
                    return spot.getFeature("POSITION_Y");
                }
                case 5: {
                    return spot.getFeature("POSITION_Z");
                }
            }
            throw new IllegalArgumentException("Undefined column index: " + columnIndex);
        }
    }
}

