/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.action.autonaming;

import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.TrackModel;
import fiji.plugin.trackmate.action.autonaming.AutoNamingRule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DefaultAutoNamingRule
implements AutoNamingRule {
    private final String suffixSeparator;
    private final String branchSeparator;
    private final boolean incrementSuffix;
    private final Pattern branchPattern;

    public DefaultAutoNamingRule() {
        this(".", "", true);
    }

    public DefaultAutoNamingRule(String suffixSeparator, String branchSeparator, boolean incrementSuffix) {
        this.suffixSeparator = suffixSeparator;
        this.branchSeparator = branchSeparator;
        this.incrementSuffix = incrementSuffix;
        this.branchPattern = Pattern.compile("^([a-z](?:" + Pattern.quote(branchSeparator) + "[a-z])*)$");
    }

    @Override
    public void nameRoot(Spot root, TrackModel model) {
        Integer id = model.trackIDOf(root);
        String trackName = model.name(id);
        String rootName = this.incrementSuffix ? trackName + this.suffixSeparator + "1" : trackName;
        root.setName(rootName);
    }

    @Override
    public void nameBranches(Spot mother, Collection<Spot> siblings) {
        char bname;
        ArrayList<Spot> spots = new ArrayList<Spot>(siblings);
        spots.sort(Comparator.comparing(s -> s.getDoublePosition(0)));
        String motherName = mother.getName();
        String[] tokens = motherName.split(Pattern.quote(this.suffixSeparator));
        int branchTokenIndex = -1;
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            Matcher matcher = this.branchPattern.matcher(token);
            if (!matcher.matches()) continue;
            branchTokenIndex = i;
            break;
        }
        if (branchTokenIndex < 0) {
            if (!this.incrementSuffix) {
                bname = 'a';
                for (Spot spot : spots) {
                    spot.setName(motherName + this.suffixSeparator + bname);
                    bname = (char)(bname + '\u0001');
                }
            } else {
                bname = 'a';
                for (Spot spot : spots) {
                    CharSequence[] newTokens = new String[tokens.length + 1];
                    for (int i = 0; i < tokens.length; ++i) {
                        newTokens[i] = tokens[i];
                    }
                    newTokens[tokens.length - 1] = "" + bname;
                    newTokens[tokens.length] = "1";
                    String branchName = String.join((CharSequence)this.suffixSeparator, newTokens);
                    spot.setName(branchName);
                    bname = (char)(bname + '\u0001');
                }
            }
            return;
        }
        bname = 'a';
        for (Spot spot : spots) {
            CharSequence[] newTokens = new String[tokens.length];
            for (int i = 0; i < tokens.length; ++i) {
                newTokens[i] = tokens[i];
            }
            if (!this.incrementSuffix) {
                int n = newTokens.length - 1;
                newTokens[n] = newTokens[n] + this.branchSeparator + bname;
            } else {
                int n = newTokens.length - 2;
                newTokens[n] = newTokens[n] + this.branchSeparator + bname;
                newTokens[newTokens.length - 1] = "1";
            }
            String branchName = String.join((CharSequence)this.suffixSeparator, newTokens);
            spot.setName(branchName);
            bname = (char)(bname + '\u0001');
        }
    }

    @Override
    public void nameSpot(Spot current, Spot predecessor) {
        if (this.incrementSuffix) {
            String name = predecessor.getName();
            CharSequence[] tokens = name.split(Pattern.quote(this.suffixSeparator));
            String idstr = tokens[tokens.length - 1];
            try {
                Integer id = Integer.valueOf(idstr);
                tokens[tokens.length - 1] = Integer.toString(id + 1);
                String name2 = String.join((CharSequence)this.suffixSeparator, tokens);
                current.setName(name2);
            }
            catch (NumberFormatException e) {
                AutoNamingRule.super.nameSpot(current, predecessor);
            }
        } else {
            AutoNamingRule.super.nameSpot(current, predecessor);
        }
    }

    public String toString() {
        if (this.incrementSuffix) {
            return "Append 'a', 'b' for each branch and increment spot index";
        }
        return "Append 'a', 'b' for each branch";
    }

    @Override
    public String getInfoText() {
        StringBuilder str = new StringBuilder();
        str.append("<html>");
        str.append("Rename all the spots in a model giving to daughter branches a name derived from the mother branch. The daughter branch names are determined following simple rules based on the X position of spots:");
        str.append("<ul>");
        str.append("<li>The root (first spot) of a track takes the name of the track it belongs to.</li>");
        str.append("<li>The subsequent branches are named from the mother branch they split from. Their name is suffixed by 'a', 'b', ... depending on the relative X position of the sibbling spots just after division.</li>");
        if (!this.branchSeparator.isEmpty()) {
            str.append("<li>Each of the branch character is separated from others by the character '" + this.branchSeparator + "'</li>");
        }
        if (!this.suffixSeparator.isEmpty()) {
            str.append("<li>The branch suffix ('a' ...) is separated from the root name by the character '" + this.suffixSeparator + "'</li>");
        }
        if (this.incrementSuffix) {
            str.append("<li>Inside a branch, the individual spots are suffixed by a supplemental index ('1', '2', ...), indicating their order in the branch.</li>");
        }
        str.append("</ul>");
        str.append("<p>");
        str.append("For instance, the 3rd spot of the branch following two divisions, first one emerging from the leftmost sibling and second one emerging from the rightmost sibbling, in  the track named 'Track_23' will be named: <br>");
        String example = "Track_23" + this.suffixSeparator + "a" + this.branchSeparator + "b";
        if (this.incrementSuffix) {
            example = example + this.suffixSeparator + "3";
        }
        str.append("<div style='text-align: center;'>" + example + "<br>");
        str.append("The results are undefined if a track is not a tree (if it has merge points).");
        str.append("</html>");
        return str.toString();
    }
}

